/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration for Utilization metrics.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MetricsConfig implements SdkPojo, Serializable, ToCopyableBuilder<MetricsConfig.Builder, MetricsConfig> {
    private static final SdkField<Boolean> ENABLE_ENHANCED_METRICS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableEnhancedMetrics").getter(getter(MetricsConfig::enableEnhancedMetrics))
            .setter(setter(Builder::enableEnhancedMetrics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableEnhancedMetrics").build())
            .build();

    private static final SdkField<Integer> METRIC_PUBLISH_FREQUENCY_IN_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("MetricPublishFrequencyInSeconds")
            .getter(getter(MetricsConfig::metricPublishFrequencyInSeconds))
            .setter(setter(Builder::metricPublishFrequencyInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricPublishFrequencyInSeconds")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLE_ENHANCED_METRICS_FIELD,
            METRIC_PUBLISH_FREQUENCY_IN_SECONDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean enableEnhancedMetrics;

    private final Integer metricPublishFrequencyInSeconds;

    private MetricsConfig(BuilderImpl builder) {
        this.enableEnhancedMetrics = builder.enableEnhancedMetrics;
        this.metricPublishFrequencyInSeconds = builder.metricPublishFrequencyInSeconds;
    }

    /**
     * <p>
     * Specifies whether to enable enhanced metrics for the endpoint. Enhanced metrics provide utilization data at
     * instance and container granularity. Container granularity is supported for Inference Components. The default is
     * <code>False</code>.
     * </p>
     * 
     * @return Specifies whether to enable enhanced metrics for the endpoint. Enhanced metrics provide utilization data
     *         at instance and container granularity. Container granularity is supported for Inference Components. The
     *         default is <code>False</code>.
     */
    public final Boolean enableEnhancedMetrics() {
        return enableEnhancedMetrics;
    }

    /**
     * <p>
     * The frequency, in seconds, at which utilization metrics are published to Amazon CloudWatch. The default is
     * <code>60</code> seconds.
     * </p>
     * 
     * @return The frequency, in seconds, at which utilization metrics are published to Amazon CloudWatch. The default
     *         is <code>60</code> seconds.
     */
    public final Integer metricPublishFrequencyInSeconds() {
        return metricPublishFrequencyInSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enableEnhancedMetrics());
        hashCode = 31 * hashCode + Objects.hashCode(metricPublishFrequencyInSeconds());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricsConfig)) {
            return false;
        }
        MetricsConfig other = (MetricsConfig) obj;
        return Objects.equals(enableEnhancedMetrics(), other.enableEnhancedMetrics())
                && Objects.equals(metricPublishFrequencyInSeconds(), other.metricPublishFrequencyInSeconds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MetricsConfig").add("EnableEnhancedMetrics", enableEnhancedMetrics())
                .add("MetricPublishFrequencyInSeconds", metricPublishFrequencyInSeconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EnableEnhancedMetrics":
            return Optional.ofNullable(clazz.cast(enableEnhancedMetrics()));
        case "MetricPublishFrequencyInSeconds":
            return Optional.ofNullable(clazz.cast(metricPublishFrequencyInSeconds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EnableEnhancedMetrics", ENABLE_ENHANCED_METRICS_FIELD);
        map.put("MetricPublishFrequencyInSeconds", METRIC_PUBLISH_FREQUENCY_IN_SECONDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MetricsConfig, T> g) {
        return obj -> g.apply((MetricsConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MetricsConfig> {
        /**
         * <p>
         * Specifies whether to enable enhanced metrics for the endpoint. Enhanced metrics provide utilization data at
         * instance and container granularity. Container granularity is supported for Inference Components. The default
         * is <code>False</code>.
         * </p>
         * 
         * @param enableEnhancedMetrics
         *        Specifies whether to enable enhanced metrics for the endpoint. Enhanced metrics provide utilization
         *        data at instance and container granularity. Container granularity is supported for Inference
         *        Components. The default is <code>False</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableEnhancedMetrics(Boolean enableEnhancedMetrics);

        /**
         * <p>
         * The frequency, in seconds, at which utilization metrics are published to Amazon CloudWatch. The default is
         * <code>60</code> seconds.
         * </p>
         * 
         * @param metricPublishFrequencyInSeconds
         *        The frequency, in seconds, at which utilization metrics are published to Amazon CloudWatch. The
         *        default is <code>60</code> seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricPublishFrequencyInSeconds(Integer metricPublishFrequencyInSeconds);
    }

    static final class BuilderImpl implements Builder {
        private Boolean enableEnhancedMetrics;

        private Integer metricPublishFrequencyInSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(MetricsConfig model) {
            enableEnhancedMetrics(model.enableEnhancedMetrics);
            metricPublishFrequencyInSeconds(model.metricPublishFrequencyInSeconds);
        }

        public final Boolean getEnableEnhancedMetrics() {
            return enableEnhancedMetrics;
        }

        public final void setEnableEnhancedMetrics(Boolean enableEnhancedMetrics) {
            this.enableEnhancedMetrics = enableEnhancedMetrics;
        }

        @Override
        public final Builder enableEnhancedMetrics(Boolean enableEnhancedMetrics) {
            this.enableEnhancedMetrics = enableEnhancedMetrics;
            return this;
        }

        public final Integer getMetricPublishFrequencyInSeconds() {
            return metricPublishFrequencyInSeconds;
        }

        public final void setMetricPublishFrequencyInSeconds(Integer metricPublishFrequencyInSeconds) {
            this.metricPublishFrequencyInSeconds = metricPublishFrequencyInSeconds;
        }

        @Override
        public final Builder metricPublishFrequencyInSeconds(Integer metricPublishFrequencyInSeconds) {
            this.metricPublishFrequencyInSeconds = metricPublishFrequencyInSeconds;
            return this;
        }

        @Override
        public MetricsConfig build() {
            return new MetricsConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
