/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a node that was successfully added to the cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NodeAdditionResult implements SdkPojo, Serializable,
        ToCopyableBuilder<NodeAdditionResult.Builder, NodeAdditionResult> {
    private static final SdkField<String> NODE_LOGICAL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NodeLogicalId").getter(getter(NodeAdditionResult::nodeLogicalId)).setter(setter(Builder::nodeLogicalId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeLogicalId").build()).build();

    private static final SdkField<String> INSTANCE_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceGroupName").getter(getter(NodeAdditionResult::instanceGroupName))
            .setter(setter(Builder::instanceGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceGroupName").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(NodeAdditionResult::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NODE_LOGICAL_ID_FIELD,
            INSTANCE_GROUP_NAME_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String nodeLogicalId;

    private final String instanceGroupName;

    private final String status;

    private NodeAdditionResult(BuilderImpl builder) {
        this.nodeLogicalId = builder.nodeLogicalId;
        this.instanceGroupName = builder.instanceGroupName;
        this.status = builder.status;
    }

    /**
     * <p>
     * A unique identifier assigned to the node that can be used to track its provisioning status through the
     * <code>DescribeClusterNode</code> operation.
     * </p>
     * 
     * @return A unique identifier assigned to the node that can be used to track its provisioning status through the
     *         <code>DescribeClusterNode</code> operation.
     */
    public final String nodeLogicalId() {
        return nodeLogicalId;
    }

    /**
     * <p>
     * The name of the instance group to which the node was added.
     * </p>
     * 
     * @return The name of the instance group to which the node was added.
     */
    public final String instanceGroupName() {
        return instanceGroupName;
    }

    /**
     * <p>
     * The current status of the node. Possible values include <code>Pending</code>, <code>Running</code>,
     * <code>Failed</code>, <code>ShuttingDown</code>, <code>SystemUpdating</code>,
     * <code>DeepHealthCheckInProgress</code>, and <code>NotFound</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ClusterInstanceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the node. Possible values include <code>Pending</code>, <code>Running</code>,
     *         <code>Failed</code>, <code>ShuttingDown</code>, <code>SystemUpdating</code>,
     *         <code>DeepHealthCheckInProgress</code>, and <code>NotFound</code>.
     * @see ClusterInstanceStatus
     */
    public final ClusterInstanceStatus status() {
        return ClusterInstanceStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the node. Possible values include <code>Pending</code>, <code>Running</code>,
     * <code>Failed</code>, <code>ShuttingDown</code>, <code>SystemUpdating</code>,
     * <code>DeepHealthCheckInProgress</code>, and <code>NotFound</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ClusterInstanceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the node. Possible values include <code>Pending</code>, <code>Running</code>,
     *         <code>Failed</code>, <code>ShuttingDown</code>, <code>SystemUpdating</code>,
     *         <code>DeepHealthCheckInProgress</code>, and <code>NotFound</code>.
     * @see ClusterInstanceStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nodeLogicalId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodeAdditionResult)) {
            return false;
        }
        NodeAdditionResult other = (NodeAdditionResult) obj;
        return Objects.equals(nodeLogicalId(), other.nodeLogicalId())
                && Objects.equals(instanceGroupName(), other.instanceGroupName())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NodeAdditionResult").add("NodeLogicalId", nodeLogicalId())
                .add("InstanceGroupName", instanceGroupName()).add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NodeLogicalId":
            return Optional.ofNullable(clazz.cast(nodeLogicalId()));
        case "InstanceGroupName":
            return Optional.ofNullable(clazz.cast(instanceGroupName()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NodeLogicalId", NODE_LOGICAL_ID_FIELD);
        map.put("InstanceGroupName", INSTANCE_GROUP_NAME_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NodeAdditionResult, T> g) {
        return obj -> g.apply((NodeAdditionResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NodeAdditionResult> {
        /**
         * <p>
         * A unique identifier assigned to the node that can be used to track its provisioning status through the
         * <code>DescribeClusterNode</code> operation.
         * </p>
         * 
         * @param nodeLogicalId
         *        A unique identifier assigned to the node that can be used to track its provisioning status through the
         *        <code>DescribeClusterNode</code> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeLogicalId(String nodeLogicalId);

        /**
         * <p>
         * The name of the instance group to which the node was added.
         * </p>
         * 
         * @param instanceGroupName
         *        The name of the instance group to which the node was added.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceGroupName(String instanceGroupName);

        /**
         * <p>
         * The current status of the node. Possible values include <code>Pending</code>, <code>Running</code>,
         * <code>Failed</code>, <code>ShuttingDown</code>, <code>SystemUpdating</code>,
         * <code>DeepHealthCheckInProgress</code>, and <code>NotFound</code>.
         * </p>
         * 
         * @param status
         *        The current status of the node. Possible values include <code>Pending</code>, <code>Running</code>,
         *        <code>Failed</code>, <code>ShuttingDown</code>, <code>SystemUpdating</code>,
         *        <code>DeepHealthCheckInProgress</code>, and <code>NotFound</code>.
         * @see ClusterInstanceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClusterInstanceStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the node. Possible values include <code>Pending</code>, <code>Running</code>,
         * <code>Failed</code>, <code>ShuttingDown</code>, <code>SystemUpdating</code>,
         * <code>DeepHealthCheckInProgress</code>, and <code>NotFound</code>.
         * </p>
         * 
         * @param status
         *        The current status of the node. Possible values include <code>Pending</code>, <code>Running</code>,
         *        <code>Failed</code>, <code>ShuttingDown</code>, <code>SystemUpdating</code>,
         *        <code>DeepHealthCheckInProgress</code>, and <code>NotFound</code>.
         * @see ClusterInstanceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClusterInstanceStatus
         */
        Builder status(ClusterInstanceStatus status);
    }

    static final class BuilderImpl implements Builder {
        private String nodeLogicalId;

        private String instanceGroupName;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(NodeAdditionResult model) {
            nodeLogicalId(model.nodeLogicalId);
            instanceGroupName(model.instanceGroupName);
            status(model.status);
        }

        public final String getNodeLogicalId() {
            return nodeLogicalId;
        }

        public final void setNodeLogicalId(String nodeLogicalId) {
            this.nodeLogicalId = nodeLogicalId;
        }

        @Override
        public final Builder nodeLogicalId(String nodeLogicalId) {
            this.nodeLogicalId = nodeLogicalId;
            return this;
        }

        public final String getInstanceGroupName() {
            return instanceGroupName;
        }

        public final void setInstanceGroupName(String instanceGroupName) {
            this.instanceGroupName = instanceGroupName;
        }

        @Override
        public final Builder instanceGroupName(String instanceGroupName) {
            this.instanceGroupName = instanceGroupName;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ClusterInstanceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public NodeAdditionResult build() {
            return new NodeAdditionResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
