/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details for where to store the optimized model that you create with the optimization job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OptimizationJobOutputConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<OptimizationJobOutputConfig.Builder, OptimizationJobOutputConfig> {
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(OptimizationJobOutputConfig::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final SdkField<String> S3_OUTPUT_LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3OutputLocation").getter(getter(OptimizationJobOutputConfig::s3OutputLocation))
            .setter(setter(Builder::s3OutputLocation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3OutputLocation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KMS_KEY_ID_FIELD,
            S3_OUTPUT_LOCATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String kmsKeyId;

    private final String s3OutputLocation;

    private OptimizationJobOutputConfig(BuilderImpl builder) {
        this.kmsKeyId = builder.kmsKeyId;
        this.s3OutputLocation = builder.s3OutputLocation;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of a key in Amazon Web Services KMS. SageMaker uses they key to encrypt the
     * artifacts of the optimized model when SageMaker uploads the model to Amazon S3.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of a key in Amazon Web Services KMS. SageMaker uses they key to encrypt
     *         the artifacts of the optimized model when SageMaker uploads the model to Amazon S3.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * The Amazon S3 URI for where to store the optimized model that you create with an optimization job.
     * </p>
     * 
     * @return The Amazon S3 URI for where to store the optimized model that you create with an optimization job.
     */
    public final String s3OutputLocation() {
        return s3OutputLocation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(s3OutputLocation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OptimizationJobOutputConfig)) {
            return false;
        }
        OptimizationJobOutputConfig other = (OptimizationJobOutputConfig) obj;
        return Objects.equals(kmsKeyId(), other.kmsKeyId()) && Objects.equals(s3OutputLocation(), other.s3OutputLocation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OptimizationJobOutputConfig").add("KmsKeyId", kmsKeyId())
                .add("S3OutputLocation", s3OutputLocation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "S3OutputLocation":
            return Optional.ofNullable(clazz.cast(s3OutputLocation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("KmsKeyId", KMS_KEY_ID_FIELD);
        map.put("S3OutputLocation", S3_OUTPUT_LOCATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OptimizationJobOutputConfig, T> g) {
        return obj -> g.apply((OptimizationJobOutputConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OptimizationJobOutputConfig> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of a key in Amazon Web Services KMS. SageMaker uses they key to encrypt the
         * artifacts of the optimized model when SageMaker uploads the model to Amazon S3.
         * </p>
         * 
         * @param kmsKeyId
         *        The Amazon Resource Name (ARN) of a key in Amazon Web Services KMS. SageMaker uses they key to encrypt
         *        the artifacts of the optimized model when SageMaker uploads the model to Amazon S3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * The Amazon S3 URI for where to store the optimized model that you create with an optimization job.
         * </p>
         * 
         * @param s3OutputLocation
         *        The Amazon S3 URI for where to store the optimized model that you create with an optimization job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3OutputLocation(String s3OutputLocation);
    }

    static final class BuilderImpl implements Builder {
        private String kmsKeyId;

        private String s3OutputLocation;

        private BuilderImpl() {
        }

        private BuilderImpl(OptimizationJobOutputConfig model) {
            kmsKeyId(model.kmsKeyId);
            s3OutputLocation(model.s3OutputLocation);
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getS3OutputLocation() {
            return s3OutputLocation;
        }

        public final void setS3OutputLocation(String s3OutputLocation) {
            this.s3OutputLocation = s3OutputLocation;
        }

        @Override
        public final Builder s3OutputLocation(String s3OutputLocation) {
            this.s3OutputLocation = s3OutputLocation;
            return this;
        }

        @Override
        public OptimizationJobOutputConfig build() {
            return new OptimizationJobOutputConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
