/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The version of the pipeline.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PipelineVersion implements SdkPojo, Serializable, ToCopyableBuilder<PipelineVersion.Builder, PipelineVersion> {
    private static final SdkField<String> PIPELINE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PipelineArn").getter(getter(PipelineVersion::pipelineArn)).setter(setter(Builder::pipelineArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineArn").build()).build();

    private static final SdkField<Long> PIPELINE_VERSION_ID_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("PipelineVersionId").getter(getter(PipelineVersion::pipelineVersionId))
            .setter(setter(Builder::pipelineVersionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineVersionId").build()).build();

    private static final SdkField<String> PIPELINE_VERSION_DISPLAY_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PipelineVersionDisplayName")
            .getter(getter(PipelineVersion::pipelineVersionDisplayName))
            .setter(setter(Builder::pipelineVersionDisplayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineVersionDisplayName").build())
            .build();

    private static final SdkField<String> PIPELINE_VERSION_DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PipelineVersionDescription")
            .getter(getter(PipelineVersion::pipelineVersionDescription))
            .setter(setter(Builder::pipelineVersionDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineVersionDescription").build())
            .build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(PipelineVersion::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(PipelineVersion::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<UserContext> CREATED_BY_FIELD = SdkField.<UserContext> builder(MarshallingType.SDK_POJO)
            .memberName("CreatedBy").getter(getter(PipelineVersion::createdBy)).setter(setter(Builder::createdBy))
            .constructor(UserContext::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()).build();

    private static final SdkField<UserContext> LAST_MODIFIED_BY_FIELD = SdkField.<UserContext> builder(MarshallingType.SDK_POJO)
            .memberName("LastModifiedBy").getter(getter(PipelineVersion::lastModifiedBy)).setter(setter(Builder::lastModifiedBy))
            .constructor(UserContext::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedBy").build()).build();

    private static final SdkField<String> LAST_EXECUTED_PIPELINE_EXECUTION_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LastExecutedPipelineExecutionArn")
            .getter(getter(PipelineVersion::lastExecutedPipelineExecutionArn))
            .setter(setter(Builder::lastExecutedPipelineExecutionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastExecutedPipelineExecutionArn")
                    .build()).build();

    private static final SdkField<String> LAST_EXECUTED_PIPELINE_EXECUTION_DISPLAY_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LastExecutedPipelineExecutionDisplayName")
            .getter(getter(PipelineVersion::lastExecutedPipelineExecutionDisplayName))
            .setter(setter(Builder::lastExecutedPipelineExecutionDisplayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("LastExecutedPipelineExecutionDisplayName").build()).build();

    private static final SdkField<String> LAST_EXECUTED_PIPELINE_EXECUTION_STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LastExecutedPipelineExecutionStatus")
            .getter(getter(PipelineVersion::lastExecutedPipelineExecutionStatusAsString))
            .setter(setter(Builder::lastExecutedPipelineExecutionStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("LastExecutedPipelineExecutionStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_ARN_FIELD,
            PIPELINE_VERSION_ID_FIELD, PIPELINE_VERSION_DISPLAY_NAME_FIELD, PIPELINE_VERSION_DESCRIPTION_FIELD,
            CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, CREATED_BY_FIELD, LAST_MODIFIED_BY_FIELD,
            LAST_EXECUTED_PIPELINE_EXECUTION_ARN_FIELD, LAST_EXECUTED_PIPELINE_EXECUTION_DISPLAY_NAME_FIELD,
            LAST_EXECUTED_PIPELINE_EXECUTION_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String pipelineArn;

    private final Long pipelineVersionId;

    private final String pipelineVersionDisplayName;

    private final String pipelineVersionDescription;

    private final Instant creationTime;

    private final Instant lastModifiedTime;

    private final UserContext createdBy;

    private final UserContext lastModifiedBy;

    private final String lastExecutedPipelineExecutionArn;

    private final String lastExecutedPipelineExecutionDisplayName;

    private final String lastExecutedPipelineExecutionStatus;

    private PipelineVersion(BuilderImpl builder) {
        this.pipelineArn = builder.pipelineArn;
        this.pipelineVersionId = builder.pipelineVersionId;
        this.pipelineVersionDisplayName = builder.pipelineVersionDisplayName;
        this.pipelineVersionDescription = builder.pipelineVersionDescription;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.createdBy = builder.createdBy;
        this.lastModifiedBy = builder.lastModifiedBy;
        this.lastExecutedPipelineExecutionArn = builder.lastExecutedPipelineExecutionArn;
        this.lastExecutedPipelineExecutionDisplayName = builder.lastExecutedPipelineExecutionDisplayName;
        this.lastExecutedPipelineExecutionStatus = builder.lastExecutedPipelineExecutionStatus;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the pipeline.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the pipeline.
     */
    public final String pipelineArn() {
        return pipelineArn;
    }

    /**
     * <p>
     * The ID of the pipeline version.
     * </p>
     * 
     * @return The ID of the pipeline version.
     */
    public final Long pipelineVersionId() {
        return pipelineVersionId;
    }

    /**
     * <p>
     * The display name of the pipeline version.
     * </p>
     * 
     * @return The display name of the pipeline version.
     */
    public final String pipelineVersionDisplayName() {
        return pipelineVersionDisplayName;
    }

    /**
     * <p>
     * The description of the pipeline version.
     * </p>
     * 
     * @return The description of the pipeline version.
     */
    public final String pipelineVersionDescription() {
        return pipelineVersionDescription;
    }

    /**
     * <p>
     * The creation time of the pipeline version.
     * </p>
     * 
     * @return The creation time of the pipeline version.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The time when the pipeline version was last modified.
     * </p>
     * 
     * @return The time when the pipeline version was last modified.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * Returns the value of the CreatedBy property for this object.
     * 
     * @return The value of the CreatedBy property for this object.
     */
    public final UserContext createdBy() {
        return createdBy;
    }

    /**
     * Returns the value of the LastModifiedBy property for this object.
     * 
     * @return The value of the LastModifiedBy property for this object.
     */
    public final UserContext lastModifiedBy() {
        return lastModifiedBy;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the most recent pipeline execution created from this pipeline version.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the most recent pipeline execution created from this pipeline version.
     */
    public final String lastExecutedPipelineExecutionArn() {
        return lastExecutedPipelineExecutionArn;
    }

    /**
     * <p>
     * The display name of the most recent pipeline execution created from this pipeline version.
     * </p>
     * 
     * @return The display name of the most recent pipeline execution created from this pipeline version.
     */
    public final String lastExecutedPipelineExecutionDisplayName() {
        return lastExecutedPipelineExecutionDisplayName;
    }

    /**
     * <p>
     * The status of the most recent pipeline execution created from this pipeline version.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #lastExecutedPipelineExecutionStatus} will return {@link PipelineExecutionStatus#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #lastExecutedPipelineExecutionStatusAsString}.
     * </p>
     * 
     * @return The status of the most recent pipeline execution created from this pipeline version.
     * @see PipelineExecutionStatus
     */
    public final PipelineExecutionStatus lastExecutedPipelineExecutionStatus() {
        return PipelineExecutionStatus.fromValue(lastExecutedPipelineExecutionStatus);
    }

    /**
     * <p>
     * The status of the most recent pipeline execution created from this pipeline version.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #lastExecutedPipelineExecutionStatus} will return {@link PipelineExecutionStatus#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #lastExecutedPipelineExecutionStatusAsString}.
     * </p>
     * 
     * @return The status of the most recent pipeline execution created from this pipeline version.
     * @see PipelineExecutionStatus
     */
    public final String lastExecutedPipelineExecutionStatusAsString() {
        return lastExecutedPipelineExecutionStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(pipelineArn());
        hashCode = 31 * hashCode + Objects.hashCode(pipelineVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(pipelineVersionDisplayName());
        hashCode = 31 * hashCode + Objects.hashCode(pipelineVersionDescription());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedBy());
        hashCode = 31 * hashCode + Objects.hashCode(lastExecutedPipelineExecutionArn());
        hashCode = 31 * hashCode + Objects.hashCode(lastExecutedPipelineExecutionDisplayName());
        hashCode = 31 * hashCode + Objects.hashCode(lastExecutedPipelineExecutionStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PipelineVersion)) {
            return false;
        }
        PipelineVersion other = (PipelineVersion) obj;
        return Objects.equals(pipelineArn(), other.pipelineArn())
                && Objects.equals(pipelineVersionId(), other.pipelineVersionId())
                && Objects.equals(pipelineVersionDisplayName(), other.pipelineVersionDisplayName())
                && Objects.equals(pipelineVersionDescription(), other.pipelineVersionDescription())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(createdBy(), other.createdBy())
                && Objects.equals(lastModifiedBy(), other.lastModifiedBy())
                && Objects.equals(lastExecutedPipelineExecutionArn(), other.lastExecutedPipelineExecutionArn())
                && Objects.equals(lastExecutedPipelineExecutionDisplayName(), other.lastExecutedPipelineExecutionDisplayName())
                && Objects.equals(lastExecutedPipelineExecutionStatusAsString(),
                        other.lastExecutedPipelineExecutionStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PipelineVersion").add("PipelineArn", pipelineArn())
                .add("PipelineVersionId", pipelineVersionId()).add("PipelineVersionDisplayName", pipelineVersionDisplayName())
                .add("PipelineVersionDescription", pipelineVersionDescription()).add("CreationTime", creationTime())
                .add("LastModifiedTime", lastModifiedTime()).add("CreatedBy", createdBy())
                .add("LastModifiedBy", lastModifiedBy())
                .add("LastExecutedPipelineExecutionArn", lastExecutedPipelineExecutionArn())
                .add("LastExecutedPipelineExecutionDisplayName", lastExecutedPipelineExecutionDisplayName())
                .add("LastExecutedPipelineExecutionStatus", lastExecutedPipelineExecutionStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PipelineArn":
            return Optional.ofNullable(clazz.cast(pipelineArn()));
        case "PipelineVersionId":
            return Optional.ofNullable(clazz.cast(pipelineVersionId()));
        case "PipelineVersionDisplayName":
            return Optional.ofNullable(clazz.cast(pipelineVersionDisplayName()));
        case "PipelineVersionDescription":
            return Optional.ofNullable(clazz.cast(pipelineVersionDescription()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "CreatedBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "LastModifiedBy":
            return Optional.ofNullable(clazz.cast(lastModifiedBy()));
        case "LastExecutedPipelineExecutionArn":
            return Optional.ofNullable(clazz.cast(lastExecutedPipelineExecutionArn()));
        case "LastExecutedPipelineExecutionDisplayName":
            return Optional.ofNullable(clazz.cast(lastExecutedPipelineExecutionDisplayName()));
        case "LastExecutedPipelineExecutionStatus":
            return Optional.ofNullable(clazz.cast(lastExecutedPipelineExecutionStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PipelineArn", PIPELINE_ARN_FIELD);
        map.put("PipelineVersionId", PIPELINE_VERSION_ID_FIELD);
        map.put("PipelineVersionDisplayName", PIPELINE_VERSION_DISPLAY_NAME_FIELD);
        map.put("PipelineVersionDescription", PIPELINE_VERSION_DESCRIPTION_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("CreatedBy", CREATED_BY_FIELD);
        map.put("LastModifiedBy", LAST_MODIFIED_BY_FIELD);
        map.put("LastExecutedPipelineExecutionArn", LAST_EXECUTED_PIPELINE_EXECUTION_ARN_FIELD);
        map.put("LastExecutedPipelineExecutionDisplayName", LAST_EXECUTED_PIPELINE_EXECUTION_DISPLAY_NAME_FIELD);
        map.put("LastExecutedPipelineExecutionStatus", LAST_EXECUTED_PIPELINE_EXECUTION_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PipelineVersion, T> g) {
        return obj -> g.apply((PipelineVersion) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PipelineVersion> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the pipeline.
         * </p>
         * 
         * @param pipelineArn
         *        The Amazon Resource Name (ARN) of the pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineArn(String pipelineArn);

        /**
         * <p>
         * The ID of the pipeline version.
         * </p>
         * 
         * @param pipelineVersionId
         *        The ID of the pipeline version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineVersionId(Long pipelineVersionId);

        /**
         * <p>
         * The display name of the pipeline version.
         * </p>
         * 
         * @param pipelineVersionDisplayName
         *        The display name of the pipeline version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineVersionDisplayName(String pipelineVersionDisplayName);

        /**
         * <p>
         * The description of the pipeline version.
         * </p>
         * 
         * @param pipelineVersionDescription
         *        The description of the pipeline version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineVersionDescription(String pipelineVersionDescription);

        /**
         * <p>
         * The creation time of the pipeline version.
         * </p>
         * 
         * @param creationTime
         *        The creation time of the pipeline version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The time when the pipeline version was last modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        The time when the pipeline version was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * Sets the value of the CreatedBy property for this object.
         *
         * @param createdBy
         *        The new value for the CreatedBy property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(UserContext createdBy);

        /**
         * Sets the value of the CreatedBy property for this object.
         *
         * This is a convenience method that creates an instance of the {@link UserContext.Builder} avoiding the need to
         * create one manually via {@link UserContext#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UserContext.Builder#build()} is called immediately and its result
         * is passed to {@link #createdBy(UserContext)}.
         * 
         * @param createdBy
         *        a consumer that will call methods on {@link UserContext.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #createdBy(UserContext)
         */
        default Builder createdBy(Consumer<UserContext.Builder> createdBy) {
            return createdBy(UserContext.builder().applyMutation(createdBy).build());
        }

        /**
         * Sets the value of the LastModifiedBy property for this object.
         *
         * @param lastModifiedBy
         *        The new value for the LastModifiedBy property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedBy(UserContext lastModifiedBy);

        /**
         * Sets the value of the LastModifiedBy property for this object.
         *
         * This is a convenience method that creates an instance of the {@link UserContext.Builder} avoiding the need to
         * create one manually via {@link UserContext#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UserContext.Builder#build()} is called immediately and its result
         * is passed to {@link #lastModifiedBy(UserContext)}.
         * 
         * @param lastModifiedBy
         *        a consumer that will call methods on {@link UserContext.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lastModifiedBy(UserContext)
         */
        default Builder lastModifiedBy(Consumer<UserContext.Builder> lastModifiedBy) {
            return lastModifiedBy(UserContext.builder().applyMutation(lastModifiedBy).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the most recent pipeline execution created from this pipeline version.
         * </p>
         * 
         * @param lastExecutedPipelineExecutionArn
         *        The Amazon Resource Name (ARN) of the most recent pipeline execution created from this pipeline
         *        version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastExecutedPipelineExecutionArn(String lastExecutedPipelineExecutionArn);

        /**
         * <p>
         * The display name of the most recent pipeline execution created from this pipeline version.
         * </p>
         * 
         * @param lastExecutedPipelineExecutionDisplayName
         *        The display name of the most recent pipeline execution created from this pipeline version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastExecutedPipelineExecutionDisplayName(String lastExecutedPipelineExecutionDisplayName);

        /**
         * <p>
         * The status of the most recent pipeline execution created from this pipeline version.
         * </p>
         * 
         * @param lastExecutedPipelineExecutionStatus
         *        The status of the most recent pipeline execution created from this pipeline version.
         * @see PipelineExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PipelineExecutionStatus
         */
        Builder lastExecutedPipelineExecutionStatus(String lastExecutedPipelineExecutionStatus);

        /**
         * <p>
         * The status of the most recent pipeline execution created from this pipeline version.
         * </p>
         * 
         * @param lastExecutedPipelineExecutionStatus
         *        The status of the most recent pipeline execution created from this pipeline version.
         * @see PipelineExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PipelineExecutionStatus
         */
        Builder lastExecutedPipelineExecutionStatus(PipelineExecutionStatus lastExecutedPipelineExecutionStatus);
    }

    static final class BuilderImpl implements Builder {
        private String pipelineArn;

        private Long pipelineVersionId;

        private String pipelineVersionDisplayName;

        private String pipelineVersionDescription;

        private Instant creationTime;

        private Instant lastModifiedTime;

        private UserContext createdBy;

        private UserContext lastModifiedBy;

        private String lastExecutedPipelineExecutionArn;

        private String lastExecutedPipelineExecutionDisplayName;

        private String lastExecutedPipelineExecutionStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(PipelineVersion model) {
            pipelineArn(model.pipelineArn);
            pipelineVersionId(model.pipelineVersionId);
            pipelineVersionDisplayName(model.pipelineVersionDisplayName);
            pipelineVersionDescription(model.pipelineVersionDescription);
            creationTime(model.creationTime);
            lastModifiedTime(model.lastModifiedTime);
            createdBy(model.createdBy);
            lastModifiedBy(model.lastModifiedBy);
            lastExecutedPipelineExecutionArn(model.lastExecutedPipelineExecutionArn);
            lastExecutedPipelineExecutionDisplayName(model.lastExecutedPipelineExecutionDisplayName);
            lastExecutedPipelineExecutionStatus(model.lastExecutedPipelineExecutionStatus);
        }

        public final String getPipelineArn() {
            return pipelineArn;
        }

        public final void setPipelineArn(String pipelineArn) {
            this.pipelineArn = pipelineArn;
        }

        @Override
        public final Builder pipelineArn(String pipelineArn) {
            this.pipelineArn = pipelineArn;
            return this;
        }

        public final Long getPipelineVersionId() {
            return pipelineVersionId;
        }

        public final void setPipelineVersionId(Long pipelineVersionId) {
            this.pipelineVersionId = pipelineVersionId;
        }

        @Override
        public final Builder pipelineVersionId(Long pipelineVersionId) {
            this.pipelineVersionId = pipelineVersionId;
            return this;
        }

        public final String getPipelineVersionDisplayName() {
            return pipelineVersionDisplayName;
        }

        public final void setPipelineVersionDisplayName(String pipelineVersionDisplayName) {
            this.pipelineVersionDisplayName = pipelineVersionDisplayName;
        }

        @Override
        public final Builder pipelineVersionDisplayName(String pipelineVersionDisplayName) {
            this.pipelineVersionDisplayName = pipelineVersionDisplayName;
            return this;
        }

        public final String getPipelineVersionDescription() {
            return pipelineVersionDescription;
        }

        public final void setPipelineVersionDescription(String pipelineVersionDescription) {
            this.pipelineVersionDescription = pipelineVersionDescription;
        }

        @Override
        public final Builder pipelineVersionDescription(String pipelineVersionDescription) {
            this.pipelineVersionDescription = pipelineVersionDescription;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final UserContext.Builder getCreatedBy() {
            return createdBy != null ? createdBy.toBuilder() : null;
        }

        public final void setCreatedBy(UserContext.BuilderImpl createdBy) {
            this.createdBy = createdBy != null ? createdBy.build() : null;
        }

        @Override
        public final Builder createdBy(UserContext createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final UserContext.Builder getLastModifiedBy() {
            return lastModifiedBy != null ? lastModifiedBy.toBuilder() : null;
        }

        public final void setLastModifiedBy(UserContext.BuilderImpl lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy != null ? lastModifiedBy.build() : null;
        }

        @Override
        public final Builder lastModifiedBy(UserContext lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            return this;
        }

        public final String getLastExecutedPipelineExecutionArn() {
            return lastExecutedPipelineExecutionArn;
        }

        public final void setLastExecutedPipelineExecutionArn(String lastExecutedPipelineExecutionArn) {
            this.lastExecutedPipelineExecutionArn = lastExecutedPipelineExecutionArn;
        }

        @Override
        public final Builder lastExecutedPipelineExecutionArn(String lastExecutedPipelineExecutionArn) {
            this.lastExecutedPipelineExecutionArn = lastExecutedPipelineExecutionArn;
            return this;
        }

        public final String getLastExecutedPipelineExecutionDisplayName() {
            return lastExecutedPipelineExecutionDisplayName;
        }

        public final void setLastExecutedPipelineExecutionDisplayName(String lastExecutedPipelineExecutionDisplayName) {
            this.lastExecutedPipelineExecutionDisplayName = lastExecutedPipelineExecutionDisplayName;
        }

        @Override
        public final Builder lastExecutedPipelineExecutionDisplayName(String lastExecutedPipelineExecutionDisplayName) {
            this.lastExecutedPipelineExecutionDisplayName = lastExecutedPipelineExecutionDisplayName;
            return this;
        }

        public final String getLastExecutedPipelineExecutionStatus() {
            return lastExecutedPipelineExecutionStatus;
        }

        public final void setLastExecutedPipelineExecutionStatus(String lastExecutedPipelineExecutionStatus) {
            this.lastExecutedPipelineExecutionStatus = lastExecutedPipelineExecutionStatus;
        }

        @Override
        public final Builder lastExecutedPipelineExecutionStatus(String lastExecutedPipelineExecutionStatus) {
            this.lastExecutedPipelineExecutionStatus = lastExecutedPipelineExecutionStatus;
            return this;
        }

        @Override
        public final Builder lastExecutedPipelineExecutionStatus(PipelineExecutionStatus lastExecutedPipelineExecutionStatus) {
            this.lastExecutedPipelineExecutionStatus(lastExecutedPipelineExecutionStatus == null ? null
                    : lastExecutedPipelineExecutionStatus.toString());
            return this;
        }

        @Override
        public PipelineVersion build() {
            return new PipelineVersion(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
