/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The summary of the pipeline version.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PipelineVersionSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<PipelineVersionSummary.Builder, PipelineVersionSummary> {
    private static final SdkField<String> PIPELINE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PipelineArn").getter(getter(PipelineVersionSummary::pipelineArn)).setter(setter(Builder::pipelineArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineArn").build()).build();

    private static final SdkField<Long> PIPELINE_VERSION_ID_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("PipelineVersionId").getter(getter(PipelineVersionSummary::pipelineVersionId))
            .setter(setter(Builder::pipelineVersionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineVersionId").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(PipelineVersionSummary::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<String> PIPELINE_VERSION_DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PipelineVersionDescription")
            .getter(getter(PipelineVersionSummary::pipelineVersionDescription))
            .setter(setter(Builder::pipelineVersionDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineVersionDescription").build())
            .build();

    private static final SdkField<String> PIPELINE_VERSION_DISPLAY_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PipelineVersionDisplayName")
            .getter(getter(PipelineVersionSummary::pipelineVersionDisplayName))
            .setter(setter(Builder::pipelineVersionDisplayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineVersionDisplayName").build())
            .build();

    private static final SdkField<String> LAST_EXECUTION_PIPELINE_EXECUTION_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LastExecutionPipelineExecutionArn")
            .getter(getter(PipelineVersionSummary::lastExecutionPipelineExecutionArn))
            .setter(setter(Builder::lastExecutionPipelineExecutionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastExecutionPipelineExecutionArn")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_ARN_FIELD,
            PIPELINE_VERSION_ID_FIELD, CREATION_TIME_FIELD, PIPELINE_VERSION_DESCRIPTION_FIELD,
            PIPELINE_VERSION_DISPLAY_NAME_FIELD, LAST_EXECUTION_PIPELINE_EXECUTION_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String pipelineArn;

    private final Long pipelineVersionId;

    private final Instant creationTime;

    private final String pipelineVersionDescription;

    private final String pipelineVersionDisplayName;

    private final String lastExecutionPipelineExecutionArn;

    private PipelineVersionSummary(BuilderImpl builder) {
        this.pipelineArn = builder.pipelineArn;
        this.pipelineVersionId = builder.pipelineVersionId;
        this.creationTime = builder.creationTime;
        this.pipelineVersionDescription = builder.pipelineVersionDescription;
        this.pipelineVersionDisplayName = builder.pipelineVersionDisplayName;
        this.lastExecutionPipelineExecutionArn = builder.lastExecutionPipelineExecutionArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the pipeline.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the pipeline.
     */
    public final String pipelineArn() {
        return pipelineArn;
    }

    /**
     * <p>
     * The ID of the pipeline version.
     * </p>
     * 
     * @return The ID of the pipeline version.
     */
    public final Long pipelineVersionId() {
        return pipelineVersionId;
    }

    /**
     * <p>
     * The creation time of the pipeline version.
     * </p>
     * 
     * @return The creation time of the pipeline version.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The description of the pipeline version.
     * </p>
     * 
     * @return The description of the pipeline version.
     */
    public final String pipelineVersionDescription() {
        return pipelineVersionDescription;
    }

    /**
     * <p>
     * The display name of the pipeline version.
     * </p>
     * 
     * @return The display name of the pipeline version.
     */
    public final String pipelineVersionDisplayName() {
        return pipelineVersionDisplayName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the most recent pipeline execution created from this pipeline version.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the most recent pipeline execution created from this pipeline version.
     */
    public final String lastExecutionPipelineExecutionArn() {
        return lastExecutionPipelineExecutionArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(pipelineArn());
        hashCode = 31 * hashCode + Objects.hashCode(pipelineVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(pipelineVersionDescription());
        hashCode = 31 * hashCode + Objects.hashCode(pipelineVersionDisplayName());
        hashCode = 31 * hashCode + Objects.hashCode(lastExecutionPipelineExecutionArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PipelineVersionSummary)) {
            return false;
        }
        PipelineVersionSummary other = (PipelineVersionSummary) obj;
        return Objects.equals(pipelineArn(), other.pipelineArn())
                && Objects.equals(pipelineVersionId(), other.pipelineVersionId())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(pipelineVersionDescription(), other.pipelineVersionDescription())
                && Objects.equals(pipelineVersionDisplayName(), other.pipelineVersionDisplayName())
                && Objects.equals(lastExecutionPipelineExecutionArn(), other.lastExecutionPipelineExecutionArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PipelineVersionSummary").add("PipelineArn", pipelineArn())
                .add("PipelineVersionId", pipelineVersionId()).add("CreationTime", creationTime())
                .add("PipelineVersionDescription", pipelineVersionDescription())
                .add("PipelineVersionDisplayName", pipelineVersionDisplayName())
                .add("LastExecutionPipelineExecutionArn", lastExecutionPipelineExecutionArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PipelineArn":
            return Optional.ofNullable(clazz.cast(pipelineArn()));
        case "PipelineVersionId":
            return Optional.ofNullable(clazz.cast(pipelineVersionId()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "PipelineVersionDescription":
            return Optional.ofNullable(clazz.cast(pipelineVersionDescription()));
        case "PipelineVersionDisplayName":
            return Optional.ofNullable(clazz.cast(pipelineVersionDisplayName()));
        case "LastExecutionPipelineExecutionArn":
            return Optional.ofNullable(clazz.cast(lastExecutionPipelineExecutionArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PipelineArn", PIPELINE_ARN_FIELD);
        map.put("PipelineVersionId", PIPELINE_VERSION_ID_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("PipelineVersionDescription", PIPELINE_VERSION_DESCRIPTION_FIELD);
        map.put("PipelineVersionDisplayName", PIPELINE_VERSION_DISPLAY_NAME_FIELD);
        map.put("LastExecutionPipelineExecutionArn", LAST_EXECUTION_PIPELINE_EXECUTION_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PipelineVersionSummary, T> g) {
        return obj -> g.apply((PipelineVersionSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PipelineVersionSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the pipeline.
         * </p>
         * 
         * @param pipelineArn
         *        The Amazon Resource Name (ARN) of the pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineArn(String pipelineArn);

        /**
         * <p>
         * The ID of the pipeline version.
         * </p>
         * 
         * @param pipelineVersionId
         *        The ID of the pipeline version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineVersionId(Long pipelineVersionId);

        /**
         * <p>
         * The creation time of the pipeline version.
         * </p>
         * 
         * @param creationTime
         *        The creation time of the pipeline version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The description of the pipeline version.
         * </p>
         * 
         * @param pipelineVersionDescription
         *        The description of the pipeline version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineVersionDescription(String pipelineVersionDescription);

        /**
         * <p>
         * The display name of the pipeline version.
         * </p>
         * 
         * @param pipelineVersionDisplayName
         *        The display name of the pipeline version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineVersionDisplayName(String pipelineVersionDisplayName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the most recent pipeline execution created from this pipeline version.
         * </p>
         * 
         * @param lastExecutionPipelineExecutionArn
         *        The Amazon Resource Name (ARN) of the most recent pipeline execution created from this pipeline
         *        version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastExecutionPipelineExecutionArn(String lastExecutionPipelineExecutionArn);
    }

    static final class BuilderImpl implements Builder {
        private String pipelineArn;

        private Long pipelineVersionId;

        private Instant creationTime;

        private String pipelineVersionDescription;

        private String pipelineVersionDisplayName;

        private String lastExecutionPipelineExecutionArn;

        private BuilderImpl() {
        }

        private BuilderImpl(PipelineVersionSummary model) {
            pipelineArn(model.pipelineArn);
            pipelineVersionId(model.pipelineVersionId);
            creationTime(model.creationTime);
            pipelineVersionDescription(model.pipelineVersionDescription);
            pipelineVersionDisplayName(model.pipelineVersionDisplayName);
            lastExecutionPipelineExecutionArn(model.lastExecutionPipelineExecutionArn);
        }

        public final String getPipelineArn() {
            return pipelineArn;
        }

        public final void setPipelineArn(String pipelineArn) {
            this.pipelineArn = pipelineArn;
        }

        @Override
        public final Builder pipelineArn(String pipelineArn) {
            this.pipelineArn = pipelineArn;
            return this;
        }

        public final Long getPipelineVersionId() {
            return pipelineVersionId;
        }

        public final void setPipelineVersionId(Long pipelineVersionId) {
            this.pipelineVersionId = pipelineVersionId;
        }

        @Override
        public final Builder pipelineVersionId(Long pipelineVersionId) {
            this.pipelineVersionId = pipelineVersionId;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getPipelineVersionDescription() {
            return pipelineVersionDescription;
        }

        public final void setPipelineVersionDescription(String pipelineVersionDescription) {
            this.pipelineVersionDescription = pipelineVersionDescription;
        }

        @Override
        public final Builder pipelineVersionDescription(String pipelineVersionDescription) {
            this.pipelineVersionDescription = pipelineVersionDescription;
            return this;
        }

        public final String getPipelineVersionDisplayName() {
            return pipelineVersionDisplayName;
        }

        public final void setPipelineVersionDisplayName(String pipelineVersionDisplayName) {
            this.pipelineVersionDisplayName = pipelineVersionDisplayName;
        }

        @Override
        public final Builder pipelineVersionDisplayName(String pipelineVersionDisplayName) {
            this.pipelineVersionDisplayName = pipelineVersionDisplayName;
            return this;
        }

        public final String getLastExecutionPipelineExecutionArn() {
            return lastExecutionPipelineExecutionArn;
        }

        public final void setLastExecutionPipelineExecutionArn(String lastExecutionPipelineExecutionArn) {
            this.lastExecutionPipelineExecutionArn = lastExecutionPipelineExecutionArn;
        }

        @Override
        public final Builder lastExecutionPipelineExecutionArn(String lastExecutionPipelineExecutionArn) {
            this.lastExecutionPipelineExecutionArn = lastExecutionPipelineExecutionArn;
            return this;
        }

        @Override
        public PipelineVersionSummary build() {
            return new PipelineVersionSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
