/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration for accessing hub content through presigned URLs, including license agreement acceptance and URL
 * validation settings.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PresignedUrlAccessConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<PresignedUrlAccessConfig.Builder, PresignedUrlAccessConfig> {
    private static final SdkField<Boolean> ACCEPT_EULA_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AcceptEula").getter(getter(PresignedUrlAccessConfig::acceptEula)).setter(setter(Builder::acceptEula))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceptEula").build()).build();

    private static final SdkField<String> EXPECTED_S3_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExpectedS3Url").getter(getter(PresignedUrlAccessConfig::expectedS3Url))
            .setter(setter(Builder::expectedS3Url))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpectedS3Url").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCEPT_EULA_FIELD,
            EXPECTED_S3_URL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean acceptEula;

    private final String expectedS3Url;

    private PresignedUrlAccessConfig(BuilderImpl builder) {
        this.acceptEula = builder.acceptEula;
        this.expectedS3Url = builder.expectedS3Url;
    }

    /**
     * <p>
     * Indicates acceptance of the End User License Agreement (EULA) for gated models. Set to true to acknowledge
     * acceptance of the license terms required for accessing gated content.
     * </p>
     * 
     * @return Indicates acceptance of the End User License Agreement (EULA) for gated models. Set to true to
     *         acknowledge acceptance of the license terms required for accessing gated content.
     */
    public final Boolean acceptEula() {
        return acceptEula;
    }

    /**
     * <p>
     * The expected S3 URL prefix for validation purposes. This parameter helps ensure consistency between the resolved
     * S3 URIs and the deployment configuration, reducing potential compatibility issues.
     * </p>
     * 
     * @return The expected S3 URL prefix for validation purposes. This parameter helps ensure consistency between the
     *         resolved S3 URIs and the deployment configuration, reducing potential compatibility issues.
     */
    public final String expectedS3Url() {
        return expectedS3Url;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(acceptEula());
        hashCode = 31 * hashCode + Objects.hashCode(expectedS3Url());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PresignedUrlAccessConfig)) {
            return false;
        }
        PresignedUrlAccessConfig other = (PresignedUrlAccessConfig) obj;
        return Objects.equals(acceptEula(), other.acceptEula()) && Objects.equals(expectedS3Url(), other.expectedS3Url());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PresignedUrlAccessConfig").add("AcceptEula", acceptEula()).add("ExpectedS3Url", expectedS3Url())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AcceptEula":
            return Optional.ofNullable(clazz.cast(acceptEula()));
        case "ExpectedS3Url":
            return Optional.ofNullable(clazz.cast(expectedS3Url()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AcceptEula", ACCEPT_EULA_FIELD);
        map.put("ExpectedS3Url", EXPECTED_S3_URL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PresignedUrlAccessConfig, T> g) {
        return obj -> g.apply((PresignedUrlAccessConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PresignedUrlAccessConfig> {
        /**
         * <p>
         * Indicates acceptance of the End User License Agreement (EULA) for gated models. Set to true to acknowledge
         * acceptance of the license terms required for accessing gated content.
         * </p>
         * 
         * @param acceptEula
         *        Indicates acceptance of the End User License Agreement (EULA) for gated models. Set to true to
         *        acknowledge acceptance of the license terms required for accessing gated content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceptEula(Boolean acceptEula);

        /**
         * <p>
         * The expected S3 URL prefix for validation purposes. This parameter helps ensure consistency between the
         * resolved S3 URIs and the deployment configuration, reducing potential compatibility issues.
         * </p>
         * 
         * @param expectedS3Url
         *        The expected S3 URL prefix for validation purposes. This parameter helps ensure consistency between
         *        the resolved S3 URIs and the deployment configuration, reducing potential compatibility issues.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expectedS3Url(String expectedS3Url);
    }

    static final class BuilderImpl implements Builder {
        private Boolean acceptEula;

        private String expectedS3Url;

        private BuilderImpl() {
        }

        private BuilderImpl(PresignedUrlAccessConfig model) {
            acceptEula(model.acceptEula);
            expectedS3Url(model.expectedS3Url);
        }

        public final Boolean getAcceptEula() {
            return acceptEula;
        }

        public final void setAcceptEula(Boolean acceptEula) {
            this.acceptEula = acceptEula;
        }

        @Override
        public final Builder acceptEula(Boolean acceptEula) {
            this.acceptEula = acceptEula;
            return this;
        }

        public final String getExpectedS3Url() {
            return expectedS3Url;
        }

        public final void setExpectedS3Url(String expectedS3Url) {
            this.expectedS3Url = expectedS3Url;
        }

        @Override
        public final Builder expectedS3Url(String expectedS3Url) {
            this.expectedS3Url = expectedS3Url;
            return this;
        }

        @Override
        public PresignedUrlAccessConfig build() {
            return new PresignedUrlAccessConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
