/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about a reserved capacity offering for a training plan offering.
 * </p>
 * <p>
 * For more information about how to reserve GPU capacity for your SageMaker HyperPod clusters using Amazon SageMaker
 * Training Plan, see
 * <code> <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateTrainingPlan.html">CreateTrainingPlan</a> </code>
 * .
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReservedCapacityOffering implements SdkPojo, Serializable,
        ToCopyableBuilder<ReservedCapacityOffering.Builder, ReservedCapacityOffering> {
    private static final SdkField<String> RESERVED_CAPACITY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReservedCapacityType").getter(getter(ReservedCapacityOffering::reservedCapacityTypeAsString))
            .setter(setter(Builder::reservedCapacityType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedCapacityType").build())
            .build();

    private static final SdkField<String> ULTRA_SERVER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UltraServerType").getter(getter(ReservedCapacityOffering::ultraServerType))
            .setter(setter(Builder::ultraServerType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UltraServerType").build()).build();

    private static final SdkField<Integer> ULTRA_SERVER_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("UltraServerCount").getter(getter(ReservedCapacityOffering::ultraServerCount))
            .setter(setter(Builder::ultraServerCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UltraServerCount").build()).build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceType").getter(getter(ReservedCapacityOffering::instanceTypeAsString))
            .setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()).build();

    private static final SdkField<Integer> INSTANCE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("InstanceCount").getter(getter(ReservedCapacityOffering::instanceCount))
            .setter(setter(Builder::instanceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceCount").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZone").getter(getter(ReservedCapacityOffering::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()).build();

    private static final SdkField<Long> DURATION_HOURS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("DurationHours").getter(getter(ReservedCapacityOffering::durationHours))
            .setter(setter(Builder::durationHours))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DurationHours").build()).build();

    private static final SdkField<Long> DURATION_MINUTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("DurationMinutes").getter(getter(ReservedCapacityOffering::durationMinutes))
            .setter(setter(Builder::durationMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DurationMinutes").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(ReservedCapacityOffering::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTime").getter(getter(ReservedCapacityOffering::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESERVED_CAPACITY_TYPE_FIELD,
            ULTRA_SERVER_TYPE_FIELD, ULTRA_SERVER_COUNT_FIELD, INSTANCE_TYPE_FIELD, INSTANCE_COUNT_FIELD,
            AVAILABILITY_ZONE_FIELD, DURATION_HOURS_FIELD, DURATION_MINUTES_FIELD, START_TIME_FIELD, END_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String reservedCapacityType;

    private final String ultraServerType;

    private final Integer ultraServerCount;

    private final String instanceType;

    private final Integer instanceCount;

    private final String availabilityZone;

    private final Long durationHours;

    private final Long durationMinutes;

    private final Instant startTime;

    private final Instant endTime;

    private ReservedCapacityOffering(BuilderImpl builder) {
        this.reservedCapacityType = builder.reservedCapacityType;
        this.ultraServerType = builder.ultraServerType;
        this.ultraServerCount = builder.ultraServerCount;
        this.instanceType = builder.instanceType;
        this.instanceCount = builder.instanceCount;
        this.availabilityZone = builder.availabilityZone;
        this.durationHours = builder.durationHours;
        this.durationMinutes = builder.durationMinutes;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
    }

    /**
     * <p>
     * The type of reserved capacity offering.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #reservedCapacityType} will return {@link ReservedCapacityType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #reservedCapacityTypeAsString}.
     * </p>
     * 
     * @return The type of reserved capacity offering.
     * @see ReservedCapacityType
     */
    public final ReservedCapacityType reservedCapacityType() {
        return ReservedCapacityType.fromValue(reservedCapacityType);
    }

    /**
     * <p>
     * The type of reserved capacity offering.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #reservedCapacityType} will return {@link ReservedCapacityType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #reservedCapacityTypeAsString}.
     * </p>
     * 
     * @return The type of reserved capacity offering.
     * @see ReservedCapacityType
     */
    public final String reservedCapacityTypeAsString() {
        return reservedCapacityType;
    }

    /**
     * <p>
     * The type of UltraServer included in this reserved capacity offering, such as ml.u-p6e-gb200x72.
     * </p>
     * 
     * @return The type of UltraServer included in this reserved capacity offering, such as ml.u-p6e-gb200x72.
     */
    public final String ultraServerType() {
        return ultraServerType;
    }

    /**
     * <p>
     * The number of UltraServers included in this reserved capacity offering.
     * </p>
     * 
     * @return The number of UltraServers included in this reserved capacity offering.
     */
    public final Integer ultraServerCount() {
        return ultraServerCount;
    }

    /**
     * <p>
     * The instance type for the reserved capacity offering.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link ReservedCapacityInstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return The instance type for the reserved capacity offering.
     * @see ReservedCapacityInstanceType
     */
    public final ReservedCapacityInstanceType instanceType() {
        return ReservedCapacityInstanceType.fromValue(instanceType);
    }

    /**
     * <p>
     * The instance type for the reserved capacity offering.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link ReservedCapacityInstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return The instance type for the reserved capacity offering.
     * @see ReservedCapacityInstanceType
     */
    public final String instanceTypeAsString() {
        return instanceType;
    }

    /**
     * <p>
     * The number of instances in the reserved capacity offering.
     * </p>
     * 
     * @return The number of instances in the reserved capacity offering.
     */
    public final Integer instanceCount() {
        return instanceCount;
    }

    /**
     * <p>
     * The availability zone for the reserved capacity offering.
     * </p>
     * 
     * @return The availability zone for the reserved capacity offering.
     */
    public final String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The number of whole hours in the total duration for this reserved capacity offering.
     * </p>
     * 
     * @return The number of whole hours in the total duration for this reserved capacity offering.
     */
    public final Long durationHours() {
        return durationHours;
    }

    /**
     * <p>
     * The additional minutes beyond whole hours in the total duration for this reserved capacity offering.
     * </p>
     * 
     * @return The additional minutes beyond whole hours in the total duration for this reserved capacity offering.
     */
    public final Long durationMinutes() {
        return durationMinutes;
    }

    /**
     * <p>
     * The start time of the reserved capacity offering.
     * </p>
     * 
     * @return The start time of the reserved capacity offering.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The end time of the reserved capacity offering.
     * </p>
     * 
     * @return The end time of the reserved capacity offering.
     */
    public final Instant endTime() {
        return endTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(reservedCapacityTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(ultraServerType());
        hashCode = 31 * hashCode + Objects.hashCode(ultraServerCount());
        hashCode = 31 * hashCode + Objects.hashCode(instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(instanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(durationHours());
        hashCode = 31 * hashCode + Objects.hashCode(durationMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReservedCapacityOffering)) {
            return false;
        }
        ReservedCapacityOffering other = (ReservedCapacityOffering) obj;
        return Objects.equals(reservedCapacityTypeAsString(), other.reservedCapacityTypeAsString())
                && Objects.equals(ultraServerType(), other.ultraServerType())
                && Objects.equals(ultraServerCount(), other.ultraServerCount())
                && Objects.equals(instanceTypeAsString(), other.instanceTypeAsString())
                && Objects.equals(instanceCount(), other.instanceCount())
                && Objects.equals(availabilityZone(), other.availabilityZone())
                && Objects.equals(durationHours(), other.durationHours())
                && Objects.equals(durationMinutes(), other.durationMinutes()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(endTime(), other.endTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReservedCapacityOffering").add("ReservedCapacityType", reservedCapacityTypeAsString())
                .add("UltraServerType", ultraServerType()).add("UltraServerCount", ultraServerCount())
                .add("InstanceType", instanceTypeAsString()).add("InstanceCount", instanceCount())
                .add("AvailabilityZone", availabilityZone()).add("DurationHours", durationHours())
                .add("DurationMinutes", durationMinutes()).add("StartTime", startTime()).add("EndTime", endTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReservedCapacityType":
            return Optional.ofNullable(clazz.cast(reservedCapacityTypeAsString()));
        case "UltraServerType":
            return Optional.ofNullable(clazz.cast(ultraServerType()));
        case "UltraServerCount":
            return Optional.ofNullable(clazz.cast(ultraServerCount()));
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceTypeAsString()));
        case "InstanceCount":
            return Optional.ofNullable(clazz.cast(instanceCount()));
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "DurationHours":
            return Optional.ofNullable(clazz.cast(durationHours()));
        case "DurationMinutes":
            return Optional.ofNullable(clazz.cast(durationMinutes()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ReservedCapacityType", RESERVED_CAPACITY_TYPE_FIELD);
        map.put("UltraServerType", ULTRA_SERVER_TYPE_FIELD);
        map.put("UltraServerCount", ULTRA_SERVER_COUNT_FIELD);
        map.put("InstanceType", INSTANCE_TYPE_FIELD);
        map.put("InstanceCount", INSTANCE_COUNT_FIELD);
        map.put("AvailabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("DurationHours", DURATION_HOURS_FIELD);
        map.put("DurationMinutes", DURATION_MINUTES_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReservedCapacityOffering, T> g) {
        return obj -> g.apply((ReservedCapacityOffering) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReservedCapacityOffering> {
        /**
         * <p>
         * The type of reserved capacity offering.
         * </p>
         * 
         * @param reservedCapacityType
         *        The type of reserved capacity offering.
         * @see ReservedCapacityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReservedCapacityType
         */
        Builder reservedCapacityType(String reservedCapacityType);

        /**
         * <p>
         * The type of reserved capacity offering.
         * </p>
         * 
         * @param reservedCapacityType
         *        The type of reserved capacity offering.
         * @see ReservedCapacityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReservedCapacityType
         */
        Builder reservedCapacityType(ReservedCapacityType reservedCapacityType);

        /**
         * <p>
         * The type of UltraServer included in this reserved capacity offering, such as ml.u-p6e-gb200x72.
         * </p>
         * 
         * @param ultraServerType
         *        The type of UltraServer included in this reserved capacity offering, such as ml.u-p6e-gb200x72.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ultraServerType(String ultraServerType);

        /**
         * <p>
         * The number of UltraServers included in this reserved capacity offering.
         * </p>
         * 
         * @param ultraServerCount
         *        The number of UltraServers included in this reserved capacity offering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ultraServerCount(Integer ultraServerCount);

        /**
         * <p>
         * The instance type for the reserved capacity offering.
         * </p>
         * 
         * @param instanceType
         *        The instance type for the reserved capacity offering.
         * @see ReservedCapacityInstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReservedCapacityInstanceType
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The instance type for the reserved capacity offering.
         * </p>
         * 
         * @param instanceType
         *        The instance type for the reserved capacity offering.
         * @see ReservedCapacityInstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReservedCapacityInstanceType
         */
        Builder instanceType(ReservedCapacityInstanceType instanceType);

        /**
         * <p>
         * The number of instances in the reserved capacity offering.
         * </p>
         * 
         * @param instanceCount
         *        The number of instances in the reserved capacity offering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceCount(Integer instanceCount);

        /**
         * <p>
         * The availability zone for the reserved capacity offering.
         * </p>
         * 
         * @param availabilityZone
         *        The availability zone for the reserved capacity offering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The number of whole hours in the total duration for this reserved capacity offering.
         * </p>
         * 
         * @param durationHours
         *        The number of whole hours in the total duration for this reserved capacity offering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder durationHours(Long durationHours);

        /**
         * <p>
         * The additional minutes beyond whole hours in the total duration for this reserved capacity offering.
         * </p>
         * 
         * @param durationMinutes
         *        The additional minutes beyond whole hours in the total duration for this reserved capacity offering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder durationMinutes(Long durationMinutes);

        /**
         * <p>
         * The start time of the reserved capacity offering.
         * </p>
         * 
         * @param startTime
         *        The start time of the reserved capacity offering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The end time of the reserved capacity offering.
         * </p>
         * 
         * @param endTime
         *        The end time of the reserved capacity offering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);
    }

    static final class BuilderImpl implements Builder {
        private String reservedCapacityType;

        private String ultraServerType;

        private Integer ultraServerCount;

        private String instanceType;

        private Integer instanceCount;

        private String availabilityZone;

        private Long durationHours;

        private Long durationMinutes;

        private Instant startTime;

        private Instant endTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ReservedCapacityOffering model) {
            reservedCapacityType(model.reservedCapacityType);
            ultraServerType(model.ultraServerType);
            ultraServerCount(model.ultraServerCount);
            instanceType(model.instanceType);
            instanceCount(model.instanceCount);
            availabilityZone(model.availabilityZone);
            durationHours(model.durationHours);
            durationMinutes(model.durationMinutes);
            startTime(model.startTime);
            endTime(model.endTime);
        }

        public final String getReservedCapacityType() {
            return reservedCapacityType;
        }

        public final void setReservedCapacityType(String reservedCapacityType) {
            this.reservedCapacityType = reservedCapacityType;
        }

        @Override
        public final Builder reservedCapacityType(String reservedCapacityType) {
            this.reservedCapacityType = reservedCapacityType;
            return this;
        }

        @Override
        public final Builder reservedCapacityType(ReservedCapacityType reservedCapacityType) {
            this.reservedCapacityType(reservedCapacityType == null ? null : reservedCapacityType.toString());
            return this;
        }

        public final String getUltraServerType() {
            return ultraServerType;
        }

        public final void setUltraServerType(String ultraServerType) {
            this.ultraServerType = ultraServerType;
        }

        @Override
        public final Builder ultraServerType(String ultraServerType) {
            this.ultraServerType = ultraServerType;
            return this;
        }

        public final Integer getUltraServerCount() {
            return ultraServerCount;
        }

        public final void setUltraServerCount(Integer ultraServerCount) {
            this.ultraServerCount = ultraServerCount;
        }

        @Override
        public final Builder ultraServerCount(Integer ultraServerCount) {
            this.ultraServerCount = ultraServerCount;
            return this;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(ReservedCapacityInstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final Integer getInstanceCount() {
            return instanceCount;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final Long getDurationHours() {
            return durationHours;
        }

        public final void setDurationHours(Long durationHours) {
            this.durationHours = durationHours;
        }

        @Override
        public final Builder durationHours(Long durationHours) {
            this.durationHours = durationHours;
            return this;
        }

        public final Long getDurationMinutes() {
            return durationMinutes;
        }

        public final void setDurationMinutes(Long durationMinutes) {
            this.durationMinutes = durationMinutes;
        }

        @Override
        public final Builder durationMinutes(Long durationMinutes) {
            this.durationMinutes = durationMinutes;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        @Override
        public ReservedCapacityOffering build() {
            return new ReservedCapacityOffering(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
