/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration for the custom Amazon S3 file system.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3FileSystemConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<S3FileSystemConfig.Builder, S3FileSystemConfig> {
    private static final SdkField<String> MOUNT_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MountPath").getter(getter(S3FileSystemConfig::mountPath)).setter(setter(Builder::mountPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MountPath").build()).build();

    private static final SdkField<String> S3_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("S3Uri")
            .getter(getter(S3FileSystemConfig::s3Uri)).setter(setter(Builder::s3Uri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Uri").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(MOUNT_PATH_FIELD, S3_URI_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String mountPath;

    private final String s3Uri;

    private S3FileSystemConfig(BuilderImpl builder) {
        this.mountPath = builder.mountPath;
        this.s3Uri = builder.s3Uri;
    }

    /**
     * <p>
     * The file system path where the Amazon S3 storage location will be mounted within the Amazon SageMaker Studio
     * environment.
     * </p>
     * 
     * @return The file system path where the Amazon S3 storage location will be mounted within the Amazon SageMaker
     *         Studio environment.
     */
    public final String mountPath() {
        return mountPath;
    }

    /**
     * <p>
     * The Amazon S3 URI of the S3 file system configuration.
     * </p>
     * 
     * @return The Amazon S3 URI of the S3 file system configuration.
     */
    public final String s3Uri() {
        return s3Uri;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(mountPath());
        hashCode = 31 * hashCode + Objects.hashCode(s3Uri());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3FileSystemConfig)) {
            return false;
        }
        S3FileSystemConfig other = (S3FileSystemConfig) obj;
        return Objects.equals(mountPath(), other.mountPath()) && Objects.equals(s3Uri(), other.s3Uri());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("S3FileSystemConfig").add("MountPath", mountPath()).add("S3Uri", s3Uri()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MountPath":
            return Optional.ofNullable(clazz.cast(mountPath()));
        case "S3Uri":
            return Optional.ofNullable(clazz.cast(s3Uri()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MountPath", MOUNT_PATH_FIELD);
        map.put("S3Uri", S3_URI_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<S3FileSystemConfig, T> g) {
        return obj -> g.apply((S3FileSystemConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3FileSystemConfig> {
        /**
         * <p>
         * The file system path where the Amazon S3 storage location will be mounted within the Amazon SageMaker Studio
         * environment.
         * </p>
         * 
         * @param mountPath
         *        The file system path where the Amazon S3 storage location will be mounted within the Amazon SageMaker
         *        Studio environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mountPath(String mountPath);

        /**
         * <p>
         * The Amazon S3 URI of the S3 file system configuration.
         * </p>
         * 
         * @param s3Uri
         *        The Amazon S3 URI of the S3 file system configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Uri(String s3Uri);
    }

    static final class BuilderImpl implements Builder {
        private String mountPath;

        private String s3Uri;

        private BuilderImpl() {
        }

        private BuilderImpl(S3FileSystemConfig model) {
            mountPath(model.mountPath);
            s3Uri(model.s3Uri);
        }

        public final String getMountPath() {
            return mountPath;
        }

        public final void setMountPath(String mountPath) {
            this.mountPath = mountPath;
        }

        @Override
        public final Builder mountPath(String mountPath) {
            this.mountPath = mountPath;
            return this;
        }

        public final String getS3Uri() {
            return s3Uri;
        }

        public final void setS3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
        }

        @Override
        public final Builder s3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
            return this;
        }

        @Override
        public S3FileSystemConfig build() {
            return new S3FileSystemConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
