/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This object defines the access restrictions to Amazon S3 resources that are included in custom worker task templates
 * using the Liquid filter, <code>grant_read_access</code>.
 * </p>
 * <p>
 * To learn more about how custom templates are created, see <a
 * href="https://docs.aws.amazon.com/sagemaker/latest/dg/a2i-custom-templates.html">Create custom worker task
 * templates</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3Presign implements SdkPojo, Serializable, ToCopyableBuilder<S3Presign.Builder, S3Presign> {
    private static final SdkField<IamPolicyConstraints> IAM_POLICY_CONSTRAINTS_FIELD = SdkField
            .<IamPolicyConstraints> builder(MarshallingType.SDK_POJO).memberName("IamPolicyConstraints")
            .getter(getter(S3Presign::iamPolicyConstraints)).setter(setter(Builder::iamPolicyConstraints))
            .constructor(IamPolicyConstraints::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamPolicyConstraints").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IAM_POLICY_CONSTRAINTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final IamPolicyConstraints iamPolicyConstraints;

    private S3Presign(BuilderImpl builder) {
        this.iamPolicyConstraints = builder.iamPolicyConstraints;
    }

    /**
     * <p>
     * Use this parameter to specify the allowed request source. Possible sources are either <code>SourceIp</code> or
     * <code>VpcSourceIp</code>.
     * </p>
     * 
     * @return Use this parameter to specify the allowed request source. Possible sources are either
     *         <code>SourceIp</code> or <code>VpcSourceIp</code>.
     */
    public final IamPolicyConstraints iamPolicyConstraints() {
        return iamPolicyConstraints;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(iamPolicyConstraints());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3Presign)) {
            return false;
        }
        S3Presign other = (S3Presign) obj;
        return Objects.equals(iamPolicyConstraints(), other.iamPolicyConstraints());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("S3Presign").add("IamPolicyConstraints", iamPolicyConstraints()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IamPolicyConstraints":
            return Optional.ofNullable(clazz.cast(iamPolicyConstraints()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("IamPolicyConstraints", IAM_POLICY_CONSTRAINTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<S3Presign, T> g) {
        return obj -> g.apply((S3Presign) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3Presign> {
        /**
         * <p>
         * Use this parameter to specify the allowed request source. Possible sources are either <code>SourceIp</code>
         * or <code>VpcSourceIp</code>.
         * </p>
         * 
         * @param iamPolicyConstraints
         *        Use this parameter to specify the allowed request source. Possible sources are either
         *        <code>SourceIp</code> or <code>VpcSourceIp</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamPolicyConstraints(IamPolicyConstraints iamPolicyConstraints);

        /**
         * <p>
         * Use this parameter to specify the allowed request source. Possible sources are either <code>SourceIp</code>
         * or <code>VpcSourceIp</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link IamPolicyConstraints.Builder} avoiding
         * the need to create one manually via {@link IamPolicyConstraints#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IamPolicyConstraints.Builder#build()} is called immediately and
         * its result is passed to {@link #iamPolicyConstraints(IamPolicyConstraints)}.
         * 
         * @param iamPolicyConstraints
         *        a consumer that will call methods on {@link IamPolicyConstraints.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #iamPolicyConstraints(IamPolicyConstraints)
         */
        default Builder iamPolicyConstraints(Consumer<IamPolicyConstraints.Builder> iamPolicyConstraints) {
            return iamPolicyConstraints(IamPolicyConstraints.builder().applyMutation(iamPolicyConstraints).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private IamPolicyConstraints iamPolicyConstraints;

        private BuilderImpl() {
        }

        private BuilderImpl(S3Presign model) {
            iamPolicyConstraints(model.iamPolicyConstraints);
        }

        public final IamPolicyConstraints.Builder getIamPolicyConstraints() {
            return iamPolicyConstraints != null ? iamPolicyConstraints.toBuilder() : null;
        }

        public final void setIamPolicyConstraints(IamPolicyConstraints.BuilderImpl iamPolicyConstraints) {
            this.iamPolicyConstraints = iamPolicyConstraints != null ? iamPolicyConstraints.build() : null;
        }

        @Override
        public final Builder iamPolicyConstraints(IamPolicyConstraints iamPolicyConstraints) {
            this.iamPolicyConstraints = iamPolicyConstraints;
            return this;
        }

        @Override
        public S3Presign build() {
            return new S3Presign(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
