/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration of <code>ShadowMode</code> inference experiment type, which specifies a production variant to take
 * all the inference requests, and a shadow variant to which Amazon SageMaker replicates a percentage of the inference
 * requests. For the shadow variant it also specifies the percentage of requests that Amazon SageMaker replicates.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ShadowModeConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<ShadowModeConfig.Builder, ShadowModeConfig> {
    private static final SdkField<String> SOURCE_MODEL_VARIANT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceModelVariantName").getter(getter(ShadowModeConfig::sourceModelVariantName))
            .setter(setter(Builder::sourceModelVariantName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceModelVariantName").build())
            .build();

    private static final SdkField<List<ShadowModelVariantConfig>> SHADOW_MODEL_VARIANTS_FIELD = SdkField
            .<List<ShadowModelVariantConfig>> builder(MarshallingType.LIST)
            .memberName("ShadowModelVariants")
            .getter(getter(ShadowModeConfig::shadowModelVariants))
            .setter(setter(Builder::shadowModelVariants))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShadowModelVariants").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ShadowModelVariantConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(ShadowModelVariantConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SOURCE_MODEL_VARIANT_NAME_FIELD, SHADOW_MODEL_VARIANTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String sourceModelVariantName;

    private final List<ShadowModelVariantConfig> shadowModelVariants;

    private ShadowModeConfig(BuilderImpl builder) {
        this.sourceModelVariantName = builder.sourceModelVariantName;
        this.shadowModelVariants = builder.shadowModelVariants;
    }

    /**
     * <p>
     * The name of the production variant, which takes all the inference requests.
     * </p>
     * 
     * @return The name of the production variant, which takes all the inference requests.
     */
    public final String sourceModelVariantName() {
        return sourceModelVariantName;
    }

    /**
     * For responses, this returns true if the service returned a value for the ShadowModelVariants property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasShadowModelVariants() {
        return shadowModelVariants != null && !(shadowModelVariants instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of shadow variant configurations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasShadowModelVariants} method.
     * </p>
     * 
     * @return List of shadow variant configurations.
     */
    public final List<ShadowModelVariantConfig> shadowModelVariants() {
        return shadowModelVariants;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourceModelVariantName());
        hashCode = 31 * hashCode + Objects.hashCode(hasShadowModelVariants() ? shadowModelVariants() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ShadowModeConfig)) {
            return false;
        }
        ShadowModeConfig other = (ShadowModeConfig) obj;
        return Objects.equals(sourceModelVariantName(), other.sourceModelVariantName())
                && hasShadowModelVariants() == other.hasShadowModelVariants()
                && Objects.equals(shadowModelVariants(), other.shadowModelVariants());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ShadowModeConfig").add("SourceModelVariantName", sourceModelVariantName())
                .add("ShadowModelVariants", hasShadowModelVariants() ? shadowModelVariants() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceModelVariantName":
            return Optional.ofNullable(clazz.cast(sourceModelVariantName()));
        case "ShadowModelVariants":
            return Optional.ofNullable(clazz.cast(shadowModelVariants()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SourceModelVariantName", SOURCE_MODEL_VARIANT_NAME_FIELD);
        map.put("ShadowModelVariants", SHADOW_MODEL_VARIANTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ShadowModeConfig, T> g) {
        return obj -> g.apply((ShadowModeConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ShadowModeConfig> {
        /**
         * <p>
         * The name of the production variant, which takes all the inference requests.
         * </p>
         * 
         * @param sourceModelVariantName
         *        The name of the production variant, which takes all the inference requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceModelVariantName(String sourceModelVariantName);

        /**
         * <p>
         * List of shadow variant configurations.
         * </p>
         * 
         * @param shadowModelVariants
         *        List of shadow variant configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shadowModelVariants(Collection<ShadowModelVariantConfig> shadowModelVariants);

        /**
         * <p>
         * List of shadow variant configurations.
         * </p>
         * 
         * @param shadowModelVariants
         *        List of shadow variant configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shadowModelVariants(ShadowModelVariantConfig... shadowModelVariants);

        /**
         * <p>
         * List of shadow variant configurations.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.ShadowModelVariantConfig.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.sagemaker.model.ShadowModelVariantConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.ShadowModelVariantConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #shadowModelVariants(List<ShadowModelVariantConfig>)}.
         * 
         * @param shadowModelVariants
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.ShadowModelVariantConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #shadowModelVariants(java.util.Collection<ShadowModelVariantConfig>)
         */
        Builder shadowModelVariants(Consumer<ShadowModelVariantConfig.Builder>... shadowModelVariants);
    }

    static final class BuilderImpl implements Builder {
        private String sourceModelVariantName;

        private List<ShadowModelVariantConfig> shadowModelVariants = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ShadowModeConfig model) {
            sourceModelVariantName(model.sourceModelVariantName);
            shadowModelVariants(model.shadowModelVariants);
        }

        public final String getSourceModelVariantName() {
            return sourceModelVariantName;
        }

        public final void setSourceModelVariantName(String sourceModelVariantName) {
            this.sourceModelVariantName = sourceModelVariantName;
        }

        @Override
        public final Builder sourceModelVariantName(String sourceModelVariantName) {
            this.sourceModelVariantName = sourceModelVariantName;
            return this;
        }

        public final List<ShadowModelVariantConfig.Builder> getShadowModelVariants() {
            List<ShadowModelVariantConfig.Builder> result = ShadowModelVariantConfigListCopier
                    .copyToBuilder(this.shadowModelVariants);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setShadowModelVariants(Collection<ShadowModelVariantConfig.BuilderImpl> shadowModelVariants) {
            this.shadowModelVariants = ShadowModelVariantConfigListCopier.copyFromBuilder(shadowModelVariants);
        }

        @Override
        public final Builder shadowModelVariants(Collection<ShadowModelVariantConfig> shadowModelVariants) {
            this.shadowModelVariants = ShadowModelVariantConfigListCopier.copy(shadowModelVariants);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder shadowModelVariants(ShadowModelVariantConfig... shadowModelVariants) {
            shadowModelVariants(Arrays.asList(shadowModelVariants));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder shadowModelVariants(Consumer<ShadowModelVariantConfig.Builder>... shadowModelVariants) {
            shadowModelVariants(Stream.of(shadowModelVariants)
                    .map(c -> ShadowModelVariantConfig.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ShadowModeConfig build() {
            return new ShadowModeConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
