/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a high-performance compute server used for distributed training in SageMaker AI. An UltraServer consists
 * of multiple instances within a shared NVLink interconnect domain.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UltraServer implements SdkPojo, Serializable, ToCopyableBuilder<UltraServer.Builder, UltraServer> {
    private static final SdkField<String> ULTRA_SERVER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UltraServerId").getter(getter(UltraServer::ultraServerId)).setter(setter(Builder::ultraServerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UltraServerId").build()).build();

    private static final SdkField<String> ULTRA_SERVER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UltraServerType").getter(getter(UltraServer::ultraServerType)).setter(setter(Builder::ultraServerType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UltraServerType").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZone").getter(getter(UltraServer::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()).build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceType").getter(getter(UltraServer::instanceTypeAsString)).setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()).build();

    private static final SdkField<Integer> TOTAL_INSTANCE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TotalInstanceCount").getter(getter(UltraServer::totalInstanceCount))
            .setter(setter(Builder::totalInstanceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalInstanceCount").build())
            .build();

    private static final SdkField<Integer> CONFIGURED_SPARE_INSTANCE_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("ConfiguredSpareInstanceCount")
            .getter(getter(UltraServer::configuredSpareInstanceCount))
            .setter(setter(Builder::configuredSpareInstanceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfiguredSpareInstanceCount")
                    .build()).build();

    private static final SdkField<Integer> AVAILABLE_INSTANCE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("AvailableInstanceCount").getter(getter(UltraServer::availableInstanceCount))
            .setter(setter(Builder::availableInstanceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailableInstanceCount").build())
            .build();

    private static final SdkField<Integer> IN_USE_INSTANCE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("InUseInstanceCount").getter(getter(UltraServer::inUseInstanceCount))
            .setter(setter(Builder::inUseInstanceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InUseInstanceCount").build())
            .build();

    private static final SdkField<Integer> AVAILABLE_SPARE_INSTANCE_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("AvailableSpareInstanceCount")
            .getter(getter(UltraServer::availableSpareInstanceCount))
            .setter(setter(Builder::availableSpareInstanceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailableSpareInstanceCount")
                    .build()).build();

    private static final SdkField<Integer> UNHEALTHY_INSTANCE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("UnhealthyInstanceCount").getter(getter(UltraServer::unhealthyInstanceCount))
            .setter(setter(Builder::unhealthyInstanceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnhealthyInstanceCount").build())
            .build();

    private static final SdkField<String> HEALTH_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HealthStatus").getter(getter(UltraServer::healthStatusAsString)).setter(setter(Builder::healthStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ULTRA_SERVER_ID_FIELD,
            ULTRA_SERVER_TYPE_FIELD, AVAILABILITY_ZONE_FIELD, INSTANCE_TYPE_FIELD, TOTAL_INSTANCE_COUNT_FIELD,
            CONFIGURED_SPARE_INSTANCE_COUNT_FIELD, AVAILABLE_INSTANCE_COUNT_FIELD, IN_USE_INSTANCE_COUNT_FIELD,
            AVAILABLE_SPARE_INSTANCE_COUNT_FIELD, UNHEALTHY_INSTANCE_COUNT_FIELD, HEALTH_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String ultraServerId;

    private final String ultraServerType;

    private final String availabilityZone;

    private final String instanceType;

    private final Integer totalInstanceCount;

    private final Integer configuredSpareInstanceCount;

    private final Integer availableInstanceCount;

    private final Integer inUseInstanceCount;

    private final Integer availableSpareInstanceCount;

    private final Integer unhealthyInstanceCount;

    private final String healthStatus;

    private UltraServer(BuilderImpl builder) {
        this.ultraServerId = builder.ultraServerId;
        this.ultraServerType = builder.ultraServerType;
        this.availabilityZone = builder.availabilityZone;
        this.instanceType = builder.instanceType;
        this.totalInstanceCount = builder.totalInstanceCount;
        this.configuredSpareInstanceCount = builder.configuredSpareInstanceCount;
        this.availableInstanceCount = builder.availableInstanceCount;
        this.inUseInstanceCount = builder.inUseInstanceCount;
        this.availableSpareInstanceCount = builder.availableSpareInstanceCount;
        this.unhealthyInstanceCount = builder.unhealthyInstanceCount;
        this.healthStatus = builder.healthStatus;
    }

    /**
     * <p>
     * The unique identifier for the UltraServer.
     * </p>
     * 
     * @return The unique identifier for the UltraServer.
     */
    public final String ultraServerId() {
        return ultraServerId;
    }

    /**
     * <p>
     * The type of UltraServer, such as ml.u-p6e-gb200x72.
     * </p>
     * 
     * @return The type of UltraServer, such as ml.u-p6e-gb200x72.
     */
    public final String ultraServerType() {
        return ultraServerType;
    }

    /**
     * <p>
     * The name of the Availability Zone where the UltraServer is provisioned.
     * </p>
     * 
     * @return The name of the Availability Zone where the UltraServer is provisioned.
     */
    public final String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The Amazon EC2 instance type used in the UltraServer.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link ReservedCapacityInstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return The Amazon EC2 instance type used in the UltraServer.
     * @see ReservedCapacityInstanceType
     */
    public final ReservedCapacityInstanceType instanceType() {
        return ReservedCapacityInstanceType.fromValue(instanceType);
    }

    /**
     * <p>
     * The Amazon EC2 instance type used in the UltraServer.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link ReservedCapacityInstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return The Amazon EC2 instance type used in the UltraServer.
     * @see ReservedCapacityInstanceType
     */
    public final String instanceTypeAsString() {
        return instanceType;
    }

    /**
     * <p>
     * The total number of instances in this UltraServer.
     * </p>
     * 
     * @return The total number of instances in this UltraServer.
     */
    public final Integer totalInstanceCount() {
        return totalInstanceCount;
    }

    /**
     * <p>
     * The number of spare instances configured for this UltraServer to provide enhanced resiliency.
     * </p>
     * 
     * @return The number of spare instances configured for this UltraServer to provide enhanced resiliency.
     */
    public final Integer configuredSpareInstanceCount() {
        return configuredSpareInstanceCount;
    }

    /**
     * <p>
     * The number of instances currently available for use in this UltraServer.
     * </p>
     * 
     * @return The number of instances currently available for use in this UltraServer.
     */
    public final Integer availableInstanceCount() {
        return availableInstanceCount;
    }

    /**
     * <p>
     * The number of instances currently in use in this UltraServer.
     * </p>
     * 
     * @return The number of instances currently in use in this UltraServer.
     */
    public final Integer inUseInstanceCount() {
        return inUseInstanceCount;
    }

    /**
     * <p>
     * The number of available spare instances in the UltraServer.
     * </p>
     * 
     * @return The number of available spare instances in the UltraServer.
     */
    public final Integer availableSpareInstanceCount() {
        return availableSpareInstanceCount;
    }

    /**
     * <p>
     * The number of instances in this UltraServer that are currently in an unhealthy state.
     * </p>
     * 
     * @return The number of instances in this UltraServer that are currently in an unhealthy state.
     */
    public final Integer unhealthyInstanceCount() {
        return unhealthyInstanceCount;
    }

    /**
     * <p>
     * The overall health status of the UltraServer.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #healthStatus} will
     * return {@link UltraServerHealthStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #healthStatusAsString}.
     * </p>
     * 
     * @return The overall health status of the UltraServer.
     * @see UltraServerHealthStatus
     */
    public final UltraServerHealthStatus healthStatus() {
        return UltraServerHealthStatus.fromValue(healthStatus);
    }

    /**
     * <p>
     * The overall health status of the UltraServer.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #healthStatus} will
     * return {@link UltraServerHealthStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #healthStatusAsString}.
     * </p>
     * 
     * @return The overall health status of the UltraServer.
     * @see UltraServerHealthStatus
     */
    public final String healthStatusAsString() {
        return healthStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ultraServerId());
        hashCode = 31 * hashCode + Objects.hashCode(ultraServerType());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(totalInstanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(configuredSpareInstanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(availableInstanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(inUseInstanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(availableSpareInstanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(unhealthyInstanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(healthStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UltraServer)) {
            return false;
        }
        UltraServer other = (UltraServer) obj;
        return Objects.equals(ultraServerId(), other.ultraServerId())
                && Objects.equals(ultraServerType(), other.ultraServerType())
                && Objects.equals(availabilityZone(), other.availabilityZone())
                && Objects.equals(instanceTypeAsString(), other.instanceTypeAsString())
                && Objects.equals(totalInstanceCount(), other.totalInstanceCount())
                && Objects.equals(configuredSpareInstanceCount(), other.configuredSpareInstanceCount())
                && Objects.equals(availableInstanceCount(), other.availableInstanceCount())
                && Objects.equals(inUseInstanceCount(), other.inUseInstanceCount())
                && Objects.equals(availableSpareInstanceCount(), other.availableSpareInstanceCount())
                && Objects.equals(unhealthyInstanceCount(), other.unhealthyInstanceCount())
                && Objects.equals(healthStatusAsString(), other.healthStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UltraServer").add("UltraServerId", ultraServerId()).add("UltraServerType", ultraServerType())
                .add("AvailabilityZone", availabilityZone()).add("InstanceType", instanceTypeAsString())
                .add("TotalInstanceCount", totalInstanceCount())
                .add("ConfiguredSpareInstanceCount", configuredSpareInstanceCount())
                .add("AvailableInstanceCount", availableInstanceCount()).add("InUseInstanceCount", inUseInstanceCount())
                .add("AvailableSpareInstanceCount", availableSpareInstanceCount())
                .add("UnhealthyInstanceCount", unhealthyInstanceCount()).add("HealthStatus", healthStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UltraServerId":
            return Optional.ofNullable(clazz.cast(ultraServerId()));
        case "UltraServerType":
            return Optional.ofNullable(clazz.cast(ultraServerType()));
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceTypeAsString()));
        case "TotalInstanceCount":
            return Optional.ofNullable(clazz.cast(totalInstanceCount()));
        case "ConfiguredSpareInstanceCount":
            return Optional.ofNullable(clazz.cast(configuredSpareInstanceCount()));
        case "AvailableInstanceCount":
            return Optional.ofNullable(clazz.cast(availableInstanceCount()));
        case "InUseInstanceCount":
            return Optional.ofNullable(clazz.cast(inUseInstanceCount()));
        case "AvailableSpareInstanceCount":
            return Optional.ofNullable(clazz.cast(availableSpareInstanceCount()));
        case "UnhealthyInstanceCount":
            return Optional.ofNullable(clazz.cast(unhealthyInstanceCount()));
        case "HealthStatus":
            return Optional.ofNullable(clazz.cast(healthStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("UltraServerId", ULTRA_SERVER_ID_FIELD);
        map.put("UltraServerType", ULTRA_SERVER_TYPE_FIELD);
        map.put("AvailabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("InstanceType", INSTANCE_TYPE_FIELD);
        map.put("TotalInstanceCount", TOTAL_INSTANCE_COUNT_FIELD);
        map.put("ConfiguredSpareInstanceCount", CONFIGURED_SPARE_INSTANCE_COUNT_FIELD);
        map.put("AvailableInstanceCount", AVAILABLE_INSTANCE_COUNT_FIELD);
        map.put("InUseInstanceCount", IN_USE_INSTANCE_COUNT_FIELD);
        map.put("AvailableSpareInstanceCount", AVAILABLE_SPARE_INSTANCE_COUNT_FIELD);
        map.put("UnhealthyInstanceCount", UNHEALTHY_INSTANCE_COUNT_FIELD);
        map.put("HealthStatus", HEALTH_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UltraServer, T> g) {
        return obj -> g.apply((UltraServer) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UltraServer> {
        /**
         * <p>
         * The unique identifier for the UltraServer.
         * </p>
         * 
         * @param ultraServerId
         *        The unique identifier for the UltraServer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ultraServerId(String ultraServerId);

        /**
         * <p>
         * The type of UltraServer, such as ml.u-p6e-gb200x72.
         * </p>
         * 
         * @param ultraServerType
         *        The type of UltraServer, such as ml.u-p6e-gb200x72.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ultraServerType(String ultraServerType);

        /**
         * <p>
         * The name of the Availability Zone where the UltraServer is provisioned.
         * </p>
         * 
         * @param availabilityZone
         *        The name of the Availability Zone where the UltraServer is provisioned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The Amazon EC2 instance type used in the UltraServer.
         * </p>
         * 
         * @param instanceType
         *        The Amazon EC2 instance type used in the UltraServer.
         * @see ReservedCapacityInstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReservedCapacityInstanceType
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The Amazon EC2 instance type used in the UltraServer.
         * </p>
         * 
         * @param instanceType
         *        The Amazon EC2 instance type used in the UltraServer.
         * @see ReservedCapacityInstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReservedCapacityInstanceType
         */
        Builder instanceType(ReservedCapacityInstanceType instanceType);

        /**
         * <p>
         * The total number of instances in this UltraServer.
         * </p>
         * 
         * @param totalInstanceCount
         *        The total number of instances in this UltraServer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalInstanceCount(Integer totalInstanceCount);

        /**
         * <p>
         * The number of spare instances configured for this UltraServer to provide enhanced resiliency.
         * </p>
         * 
         * @param configuredSpareInstanceCount
         *        The number of spare instances configured for this UltraServer to provide enhanced resiliency.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuredSpareInstanceCount(Integer configuredSpareInstanceCount);

        /**
         * <p>
         * The number of instances currently available for use in this UltraServer.
         * </p>
         * 
         * @param availableInstanceCount
         *        The number of instances currently available for use in this UltraServer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availableInstanceCount(Integer availableInstanceCount);

        /**
         * <p>
         * The number of instances currently in use in this UltraServer.
         * </p>
         * 
         * @param inUseInstanceCount
         *        The number of instances currently in use in this UltraServer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inUseInstanceCount(Integer inUseInstanceCount);

        /**
         * <p>
         * The number of available spare instances in the UltraServer.
         * </p>
         * 
         * @param availableSpareInstanceCount
         *        The number of available spare instances in the UltraServer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availableSpareInstanceCount(Integer availableSpareInstanceCount);

        /**
         * <p>
         * The number of instances in this UltraServer that are currently in an unhealthy state.
         * </p>
         * 
         * @param unhealthyInstanceCount
         *        The number of instances in this UltraServer that are currently in an unhealthy state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unhealthyInstanceCount(Integer unhealthyInstanceCount);

        /**
         * <p>
         * The overall health status of the UltraServer.
         * </p>
         * 
         * @param healthStatus
         *        The overall health status of the UltraServer.
         * @see UltraServerHealthStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UltraServerHealthStatus
         */
        Builder healthStatus(String healthStatus);

        /**
         * <p>
         * The overall health status of the UltraServer.
         * </p>
         * 
         * @param healthStatus
         *        The overall health status of the UltraServer.
         * @see UltraServerHealthStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UltraServerHealthStatus
         */
        Builder healthStatus(UltraServerHealthStatus healthStatus);
    }

    static final class BuilderImpl implements Builder {
        private String ultraServerId;

        private String ultraServerType;

        private String availabilityZone;

        private String instanceType;

        private Integer totalInstanceCount;

        private Integer configuredSpareInstanceCount;

        private Integer availableInstanceCount;

        private Integer inUseInstanceCount;

        private Integer availableSpareInstanceCount;

        private Integer unhealthyInstanceCount;

        private String healthStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(UltraServer model) {
            ultraServerId(model.ultraServerId);
            ultraServerType(model.ultraServerType);
            availabilityZone(model.availabilityZone);
            instanceType(model.instanceType);
            totalInstanceCount(model.totalInstanceCount);
            configuredSpareInstanceCount(model.configuredSpareInstanceCount);
            availableInstanceCount(model.availableInstanceCount);
            inUseInstanceCount(model.inUseInstanceCount);
            availableSpareInstanceCount(model.availableSpareInstanceCount);
            unhealthyInstanceCount(model.unhealthyInstanceCount);
            healthStatus(model.healthStatus);
        }

        public final String getUltraServerId() {
            return ultraServerId;
        }

        public final void setUltraServerId(String ultraServerId) {
            this.ultraServerId = ultraServerId;
        }

        @Override
        public final Builder ultraServerId(String ultraServerId) {
            this.ultraServerId = ultraServerId;
            return this;
        }

        public final String getUltraServerType() {
            return ultraServerType;
        }

        public final void setUltraServerType(String ultraServerType) {
            this.ultraServerType = ultraServerType;
        }

        @Override
        public final Builder ultraServerType(String ultraServerType) {
            this.ultraServerType = ultraServerType;
            return this;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(ReservedCapacityInstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final Integer getTotalInstanceCount() {
            return totalInstanceCount;
        }

        public final void setTotalInstanceCount(Integer totalInstanceCount) {
            this.totalInstanceCount = totalInstanceCount;
        }

        @Override
        public final Builder totalInstanceCount(Integer totalInstanceCount) {
            this.totalInstanceCount = totalInstanceCount;
            return this;
        }

        public final Integer getConfiguredSpareInstanceCount() {
            return configuredSpareInstanceCount;
        }

        public final void setConfiguredSpareInstanceCount(Integer configuredSpareInstanceCount) {
            this.configuredSpareInstanceCount = configuredSpareInstanceCount;
        }

        @Override
        public final Builder configuredSpareInstanceCount(Integer configuredSpareInstanceCount) {
            this.configuredSpareInstanceCount = configuredSpareInstanceCount;
            return this;
        }

        public final Integer getAvailableInstanceCount() {
            return availableInstanceCount;
        }

        public final void setAvailableInstanceCount(Integer availableInstanceCount) {
            this.availableInstanceCount = availableInstanceCount;
        }

        @Override
        public final Builder availableInstanceCount(Integer availableInstanceCount) {
            this.availableInstanceCount = availableInstanceCount;
            return this;
        }

        public final Integer getInUseInstanceCount() {
            return inUseInstanceCount;
        }

        public final void setInUseInstanceCount(Integer inUseInstanceCount) {
            this.inUseInstanceCount = inUseInstanceCount;
        }

        @Override
        public final Builder inUseInstanceCount(Integer inUseInstanceCount) {
            this.inUseInstanceCount = inUseInstanceCount;
            return this;
        }

        public final Integer getAvailableSpareInstanceCount() {
            return availableSpareInstanceCount;
        }

        public final void setAvailableSpareInstanceCount(Integer availableSpareInstanceCount) {
            this.availableSpareInstanceCount = availableSpareInstanceCount;
        }

        @Override
        public final Builder availableSpareInstanceCount(Integer availableSpareInstanceCount) {
            this.availableSpareInstanceCount = availableSpareInstanceCount;
            return this;
        }

        public final Integer getUnhealthyInstanceCount() {
            return unhealthyInstanceCount;
        }

        public final void setUnhealthyInstanceCount(Integer unhealthyInstanceCount) {
            this.unhealthyInstanceCount = unhealthyInstanceCount;
        }

        @Override
        public final Builder unhealthyInstanceCount(Integer unhealthyInstanceCount) {
            this.unhealthyInstanceCount = unhealthyInstanceCount;
            return this;
        }

        public final String getHealthStatus() {
            return healthStatus;
        }

        public final void setHealthStatus(String healthStatus) {
            this.healthStatus = healthStatus;
        }

        @Override
        public final Builder healthStatus(String healthStatus) {
            this.healthStatus = healthStatus;
            return this;
        }

        @Override
        public final Builder healthStatus(UltraServerHealthStatus healthStatus) {
            this.healthStatus(healthStatus == null ? null : healthStatus.toString());
            return this;
        }

        @Override
        public UltraServer build() {
            return new UltraServer(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
