/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of UltraServer resources and their current status.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UltraServerSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<UltraServerSummary.Builder, UltraServerSummary> {
    private static final SdkField<String> ULTRA_SERVER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UltraServerType").getter(getter(UltraServerSummary::ultraServerType))
            .setter(setter(Builder::ultraServerType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UltraServerType").build()).build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceType").getter(getter(UltraServerSummary::instanceTypeAsString))
            .setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()).build();

    private static final SdkField<Integer> ULTRA_SERVER_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("UltraServerCount").getter(getter(UltraServerSummary::ultraServerCount))
            .setter(setter(Builder::ultraServerCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UltraServerCount").build()).build();

    private static final SdkField<Integer> AVAILABLE_SPARE_INSTANCE_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("AvailableSpareInstanceCount")
            .getter(getter(UltraServerSummary::availableSpareInstanceCount))
            .setter(setter(Builder::availableSpareInstanceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailableSpareInstanceCount")
                    .build()).build();

    private static final SdkField<Integer> UNHEALTHY_INSTANCE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("UnhealthyInstanceCount").getter(getter(UltraServerSummary::unhealthyInstanceCount))
            .setter(setter(Builder::unhealthyInstanceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnhealthyInstanceCount").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ULTRA_SERVER_TYPE_FIELD,
            INSTANCE_TYPE_FIELD, ULTRA_SERVER_COUNT_FIELD, AVAILABLE_SPARE_INSTANCE_COUNT_FIELD, UNHEALTHY_INSTANCE_COUNT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String ultraServerType;

    private final String instanceType;

    private final Integer ultraServerCount;

    private final Integer availableSpareInstanceCount;

    private final Integer unhealthyInstanceCount;

    private UltraServerSummary(BuilderImpl builder) {
        this.ultraServerType = builder.ultraServerType;
        this.instanceType = builder.instanceType;
        this.ultraServerCount = builder.ultraServerCount;
        this.availableSpareInstanceCount = builder.availableSpareInstanceCount;
        this.unhealthyInstanceCount = builder.unhealthyInstanceCount;
    }

    /**
     * <p>
     * The type of UltraServer, such as ml.u-p6e-gb200x72.
     * </p>
     * 
     * @return The type of UltraServer, such as ml.u-p6e-gb200x72.
     */
    public final String ultraServerType() {
        return ultraServerType;
    }

    /**
     * <p>
     * The Amazon EC2 instance type used in the UltraServer.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link ReservedCapacityInstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return The Amazon EC2 instance type used in the UltraServer.
     * @see ReservedCapacityInstanceType
     */
    public final ReservedCapacityInstanceType instanceType() {
        return ReservedCapacityInstanceType.fromValue(instanceType);
    }

    /**
     * <p>
     * The Amazon EC2 instance type used in the UltraServer.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link ReservedCapacityInstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return The Amazon EC2 instance type used in the UltraServer.
     * @see ReservedCapacityInstanceType
     */
    public final String instanceTypeAsString() {
        return instanceType;
    }

    /**
     * <p>
     * The number of UltraServers of this type.
     * </p>
     * 
     * @return The number of UltraServers of this type.
     */
    public final Integer ultraServerCount() {
        return ultraServerCount;
    }

    /**
     * <p>
     * The number of available spare instances in the UltraServers.
     * </p>
     * 
     * @return The number of available spare instances in the UltraServers.
     */
    public final Integer availableSpareInstanceCount() {
        return availableSpareInstanceCount;
    }

    /**
     * <p>
     * The total number of instances across all UltraServers of this type that are currently in an unhealthy state.
     * </p>
     * 
     * @return The total number of instances across all UltraServers of this type that are currently in an unhealthy
     *         state.
     */
    public final Integer unhealthyInstanceCount() {
        return unhealthyInstanceCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ultraServerType());
        hashCode = 31 * hashCode + Objects.hashCode(instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(ultraServerCount());
        hashCode = 31 * hashCode + Objects.hashCode(availableSpareInstanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(unhealthyInstanceCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UltraServerSummary)) {
            return false;
        }
        UltraServerSummary other = (UltraServerSummary) obj;
        return Objects.equals(ultraServerType(), other.ultraServerType())
                && Objects.equals(instanceTypeAsString(), other.instanceTypeAsString())
                && Objects.equals(ultraServerCount(), other.ultraServerCount())
                && Objects.equals(availableSpareInstanceCount(), other.availableSpareInstanceCount())
                && Objects.equals(unhealthyInstanceCount(), other.unhealthyInstanceCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UltraServerSummary").add("UltraServerType", ultraServerType())
                .add("InstanceType", instanceTypeAsString()).add("UltraServerCount", ultraServerCount())
                .add("AvailableSpareInstanceCount", availableSpareInstanceCount())
                .add("UnhealthyInstanceCount", unhealthyInstanceCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UltraServerType":
            return Optional.ofNullable(clazz.cast(ultraServerType()));
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceTypeAsString()));
        case "UltraServerCount":
            return Optional.ofNullable(clazz.cast(ultraServerCount()));
        case "AvailableSpareInstanceCount":
            return Optional.ofNullable(clazz.cast(availableSpareInstanceCount()));
        case "UnhealthyInstanceCount":
            return Optional.ofNullable(clazz.cast(unhealthyInstanceCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("UltraServerType", ULTRA_SERVER_TYPE_FIELD);
        map.put("InstanceType", INSTANCE_TYPE_FIELD);
        map.put("UltraServerCount", ULTRA_SERVER_COUNT_FIELD);
        map.put("AvailableSpareInstanceCount", AVAILABLE_SPARE_INSTANCE_COUNT_FIELD);
        map.put("UnhealthyInstanceCount", UNHEALTHY_INSTANCE_COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UltraServerSummary, T> g) {
        return obj -> g.apply((UltraServerSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UltraServerSummary> {
        /**
         * <p>
         * The type of UltraServer, such as ml.u-p6e-gb200x72.
         * </p>
         * 
         * @param ultraServerType
         *        The type of UltraServer, such as ml.u-p6e-gb200x72.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ultraServerType(String ultraServerType);

        /**
         * <p>
         * The Amazon EC2 instance type used in the UltraServer.
         * </p>
         * 
         * @param instanceType
         *        The Amazon EC2 instance type used in the UltraServer.
         * @see ReservedCapacityInstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReservedCapacityInstanceType
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The Amazon EC2 instance type used in the UltraServer.
         * </p>
         * 
         * @param instanceType
         *        The Amazon EC2 instance type used in the UltraServer.
         * @see ReservedCapacityInstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReservedCapacityInstanceType
         */
        Builder instanceType(ReservedCapacityInstanceType instanceType);

        /**
         * <p>
         * The number of UltraServers of this type.
         * </p>
         * 
         * @param ultraServerCount
         *        The number of UltraServers of this type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ultraServerCount(Integer ultraServerCount);

        /**
         * <p>
         * The number of available spare instances in the UltraServers.
         * </p>
         * 
         * @param availableSpareInstanceCount
         *        The number of available spare instances in the UltraServers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availableSpareInstanceCount(Integer availableSpareInstanceCount);

        /**
         * <p>
         * The total number of instances across all UltraServers of this type that are currently in an unhealthy state.
         * </p>
         * 
         * @param unhealthyInstanceCount
         *        The total number of instances across all UltraServers of this type that are currently in an unhealthy
         *        state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unhealthyInstanceCount(Integer unhealthyInstanceCount);
    }

    static final class BuilderImpl implements Builder {
        private String ultraServerType;

        private String instanceType;

        private Integer ultraServerCount;

        private Integer availableSpareInstanceCount;

        private Integer unhealthyInstanceCount;

        private BuilderImpl() {
        }

        private BuilderImpl(UltraServerSummary model) {
            ultraServerType(model.ultraServerType);
            instanceType(model.instanceType);
            ultraServerCount(model.ultraServerCount);
            availableSpareInstanceCount(model.availableSpareInstanceCount);
            unhealthyInstanceCount(model.unhealthyInstanceCount);
        }

        public final String getUltraServerType() {
            return ultraServerType;
        }

        public final void setUltraServerType(String ultraServerType) {
            this.ultraServerType = ultraServerType;
        }

        @Override
        public final Builder ultraServerType(String ultraServerType) {
            this.ultraServerType = ultraServerType;
            return this;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(ReservedCapacityInstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final Integer getUltraServerCount() {
            return ultraServerCount;
        }

        public final void setUltraServerCount(Integer ultraServerCount) {
            this.ultraServerCount = ultraServerCount;
        }

        @Override
        public final Builder ultraServerCount(Integer ultraServerCount) {
            this.ultraServerCount = ultraServerCount;
            return this;
        }

        public final Integer getAvailableSpareInstanceCount() {
            return availableSpareInstanceCount;
        }

        public final void setAvailableSpareInstanceCount(Integer availableSpareInstanceCount) {
            this.availableSpareInstanceCount = availableSpareInstanceCount;
        }

        @Override
        public final Builder availableSpareInstanceCount(Integer availableSpareInstanceCount) {
            this.availableSpareInstanceCount = availableSpareInstanceCount;
            return this;
        }

        public final Integer getUnhealthyInstanceCount() {
            return unhealthyInstanceCount;
        }

        public final void setUnhealthyInstanceCount(Integer unhealthyInstanceCount) {
            this.unhealthyInstanceCount = unhealthyInstanceCount;
        }

        @Override
        public final Builder unhealthyInstanceCount(Integer unhealthyInstanceCount) {
            this.unhealthyInstanceCount = unhealthyInstanceCount;
            return this;
        }

        @Override
        public UltraServerSummary build() {
            return new UltraServerSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
