/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateAppImageConfigRequest extends SageMakerRequest implements
        ToCopyableBuilder<UpdateAppImageConfigRequest.Builder, UpdateAppImageConfigRequest> {
    private static final SdkField<String> APP_IMAGE_CONFIG_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AppImageConfigName").getter(getter(UpdateAppImageConfigRequest::appImageConfigName))
            .setter(setter(Builder::appImageConfigName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppImageConfigName").build())
            .build();

    private static final SdkField<KernelGatewayImageConfig> KERNEL_GATEWAY_IMAGE_CONFIG_FIELD = SdkField
            .<KernelGatewayImageConfig> builder(MarshallingType.SDK_POJO).memberName("KernelGatewayImageConfig")
            .getter(getter(UpdateAppImageConfigRequest::kernelGatewayImageConfig))
            .setter(setter(Builder::kernelGatewayImageConfig)).constructor(KernelGatewayImageConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KernelGatewayImageConfig").build())
            .build();

    private static final SdkField<JupyterLabAppImageConfig> JUPYTER_LAB_APP_IMAGE_CONFIG_FIELD = SdkField
            .<JupyterLabAppImageConfig> builder(MarshallingType.SDK_POJO).memberName("JupyterLabAppImageConfig")
            .getter(getter(UpdateAppImageConfigRequest::jupyterLabAppImageConfig))
            .setter(setter(Builder::jupyterLabAppImageConfig)).constructor(JupyterLabAppImageConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JupyterLabAppImageConfig").build())
            .build();

    private static final SdkField<CodeEditorAppImageConfig> CODE_EDITOR_APP_IMAGE_CONFIG_FIELD = SdkField
            .<CodeEditorAppImageConfig> builder(MarshallingType.SDK_POJO).memberName("CodeEditorAppImageConfig")
            .getter(getter(UpdateAppImageConfigRequest::codeEditorAppImageConfig))
            .setter(setter(Builder::codeEditorAppImageConfig)).constructor(CodeEditorAppImageConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeEditorAppImageConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_IMAGE_CONFIG_NAME_FIELD,
            KERNEL_GATEWAY_IMAGE_CONFIG_FIELD, JUPYTER_LAB_APP_IMAGE_CONFIG_FIELD, CODE_EDITOR_APP_IMAGE_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String appImageConfigName;

    private final KernelGatewayImageConfig kernelGatewayImageConfig;

    private final JupyterLabAppImageConfig jupyterLabAppImageConfig;

    private final CodeEditorAppImageConfig codeEditorAppImageConfig;

    private UpdateAppImageConfigRequest(BuilderImpl builder) {
        super(builder);
        this.appImageConfigName = builder.appImageConfigName;
        this.kernelGatewayImageConfig = builder.kernelGatewayImageConfig;
        this.jupyterLabAppImageConfig = builder.jupyterLabAppImageConfig;
        this.codeEditorAppImageConfig = builder.codeEditorAppImageConfig;
    }

    /**
     * <p>
     * The name of the AppImageConfig to update.
     * </p>
     * 
     * @return The name of the AppImageConfig to update.
     */
    public final String appImageConfigName() {
        return appImageConfigName;
    }

    /**
     * <p>
     * The new KernelGateway app to run on the image.
     * </p>
     * 
     * @return The new KernelGateway app to run on the image.
     */
    public final KernelGatewayImageConfig kernelGatewayImageConfig() {
        return kernelGatewayImageConfig;
    }

    /**
     * <p>
     * The JupyterLab app running on the image.
     * </p>
     * 
     * @return The JupyterLab app running on the image.
     */
    public final JupyterLabAppImageConfig jupyterLabAppImageConfig() {
        return jupyterLabAppImageConfig;
    }

    /**
     * <p>
     * The Code Editor app running on the image.
     * </p>
     * 
     * @return The Code Editor app running on the image.
     */
    public final CodeEditorAppImageConfig codeEditorAppImageConfig() {
        return codeEditorAppImageConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(appImageConfigName());
        hashCode = 31 * hashCode + Objects.hashCode(kernelGatewayImageConfig());
        hashCode = 31 * hashCode + Objects.hashCode(jupyterLabAppImageConfig());
        hashCode = 31 * hashCode + Objects.hashCode(codeEditorAppImageConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAppImageConfigRequest)) {
            return false;
        }
        UpdateAppImageConfigRequest other = (UpdateAppImageConfigRequest) obj;
        return Objects.equals(appImageConfigName(), other.appImageConfigName())
                && Objects.equals(kernelGatewayImageConfig(), other.kernelGatewayImageConfig())
                && Objects.equals(jupyterLabAppImageConfig(), other.jupyterLabAppImageConfig())
                && Objects.equals(codeEditorAppImageConfig(), other.codeEditorAppImageConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateAppImageConfigRequest").add("AppImageConfigName", appImageConfigName())
                .add("KernelGatewayImageConfig", kernelGatewayImageConfig())
                .add("JupyterLabAppImageConfig", jupyterLabAppImageConfig())
                .add("CodeEditorAppImageConfig", codeEditorAppImageConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AppImageConfigName":
            return Optional.ofNullable(clazz.cast(appImageConfigName()));
        case "KernelGatewayImageConfig":
            return Optional.ofNullable(clazz.cast(kernelGatewayImageConfig()));
        case "JupyterLabAppImageConfig":
            return Optional.ofNullable(clazz.cast(jupyterLabAppImageConfig()));
        case "CodeEditorAppImageConfig":
            return Optional.ofNullable(clazz.cast(codeEditorAppImageConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AppImageConfigName", APP_IMAGE_CONFIG_NAME_FIELD);
        map.put("KernelGatewayImageConfig", KERNEL_GATEWAY_IMAGE_CONFIG_FIELD);
        map.put("JupyterLabAppImageConfig", JUPYTER_LAB_APP_IMAGE_CONFIG_FIELD);
        map.put("CodeEditorAppImageConfig", CODE_EDITOR_APP_IMAGE_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateAppImageConfigRequest, T> g) {
        return obj -> g.apply((UpdateAppImageConfigRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateAppImageConfigRequest> {
        /**
         * <p>
         * The name of the AppImageConfig to update.
         * </p>
         * 
         * @param appImageConfigName
         *        The name of the AppImageConfig to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appImageConfigName(String appImageConfigName);

        /**
         * <p>
         * The new KernelGateway app to run on the image.
         * </p>
         * 
         * @param kernelGatewayImageConfig
         *        The new KernelGateway app to run on the image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kernelGatewayImageConfig(KernelGatewayImageConfig kernelGatewayImageConfig);

        /**
         * <p>
         * The new KernelGateway app to run on the image.
         * </p>
         * This is a convenience method that creates an instance of the {@link KernelGatewayImageConfig.Builder}
         * avoiding the need to create one manually via {@link KernelGatewayImageConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KernelGatewayImageConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #kernelGatewayImageConfig(KernelGatewayImageConfig)}.
         * 
         * @param kernelGatewayImageConfig
         *        a consumer that will call methods on {@link KernelGatewayImageConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kernelGatewayImageConfig(KernelGatewayImageConfig)
         */
        default Builder kernelGatewayImageConfig(Consumer<KernelGatewayImageConfig.Builder> kernelGatewayImageConfig) {
            return kernelGatewayImageConfig(KernelGatewayImageConfig.builder().applyMutation(kernelGatewayImageConfig).build());
        }

        /**
         * <p>
         * The JupyterLab app running on the image.
         * </p>
         * 
         * @param jupyterLabAppImageConfig
         *        The JupyterLab app running on the image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jupyterLabAppImageConfig(JupyterLabAppImageConfig jupyterLabAppImageConfig);

        /**
         * <p>
         * The JupyterLab app running on the image.
         * </p>
         * This is a convenience method that creates an instance of the {@link JupyterLabAppImageConfig.Builder}
         * avoiding the need to create one manually via {@link JupyterLabAppImageConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link JupyterLabAppImageConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #jupyterLabAppImageConfig(JupyterLabAppImageConfig)}.
         * 
         * @param jupyterLabAppImageConfig
         *        a consumer that will call methods on {@link JupyterLabAppImageConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jupyterLabAppImageConfig(JupyterLabAppImageConfig)
         */
        default Builder jupyterLabAppImageConfig(Consumer<JupyterLabAppImageConfig.Builder> jupyterLabAppImageConfig) {
            return jupyterLabAppImageConfig(JupyterLabAppImageConfig.builder().applyMutation(jupyterLabAppImageConfig).build());
        }

        /**
         * <p>
         * The Code Editor app running on the image.
         * </p>
         * 
         * @param codeEditorAppImageConfig
         *        The Code Editor app running on the image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeEditorAppImageConfig(CodeEditorAppImageConfig codeEditorAppImageConfig);

        /**
         * <p>
         * The Code Editor app running on the image.
         * </p>
         * This is a convenience method that creates an instance of the {@link CodeEditorAppImageConfig.Builder}
         * avoiding the need to create one manually via {@link CodeEditorAppImageConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CodeEditorAppImageConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #codeEditorAppImageConfig(CodeEditorAppImageConfig)}.
         * 
         * @param codeEditorAppImageConfig
         *        a consumer that will call methods on {@link CodeEditorAppImageConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #codeEditorAppImageConfig(CodeEditorAppImageConfig)
         */
        default Builder codeEditorAppImageConfig(Consumer<CodeEditorAppImageConfig.Builder> codeEditorAppImageConfig) {
            return codeEditorAppImageConfig(CodeEditorAppImageConfig.builder().applyMutation(codeEditorAppImageConfig).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String appImageConfigName;

        private KernelGatewayImageConfig kernelGatewayImageConfig;

        private JupyterLabAppImageConfig jupyterLabAppImageConfig;

        private CodeEditorAppImageConfig codeEditorAppImageConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAppImageConfigRequest model) {
            super(model);
            appImageConfigName(model.appImageConfigName);
            kernelGatewayImageConfig(model.kernelGatewayImageConfig);
            jupyterLabAppImageConfig(model.jupyterLabAppImageConfig);
            codeEditorAppImageConfig(model.codeEditorAppImageConfig);
        }

        public final String getAppImageConfigName() {
            return appImageConfigName;
        }

        public final void setAppImageConfigName(String appImageConfigName) {
            this.appImageConfigName = appImageConfigName;
        }

        @Override
        public final Builder appImageConfigName(String appImageConfigName) {
            this.appImageConfigName = appImageConfigName;
            return this;
        }

        public final KernelGatewayImageConfig.Builder getKernelGatewayImageConfig() {
            return kernelGatewayImageConfig != null ? kernelGatewayImageConfig.toBuilder() : null;
        }

        public final void setKernelGatewayImageConfig(KernelGatewayImageConfig.BuilderImpl kernelGatewayImageConfig) {
            this.kernelGatewayImageConfig = kernelGatewayImageConfig != null ? kernelGatewayImageConfig.build() : null;
        }

        @Override
        public final Builder kernelGatewayImageConfig(KernelGatewayImageConfig kernelGatewayImageConfig) {
            this.kernelGatewayImageConfig = kernelGatewayImageConfig;
            return this;
        }

        public final JupyterLabAppImageConfig.Builder getJupyterLabAppImageConfig() {
            return jupyterLabAppImageConfig != null ? jupyterLabAppImageConfig.toBuilder() : null;
        }

        public final void setJupyterLabAppImageConfig(JupyterLabAppImageConfig.BuilderImpl jupyterLabAppImageConfig) {
            this.jupyterLabAppImageConfig = jupyterLabAppImageConfig != null ? jupyterLabAppImageConfig.build() : null;
        }

        @Override
        public final Builder jupyterLabAppImageConfig(JupyterLabAppImageConfig jupyterLabAppImageConfig) {
            this.jupyterLabAppImageConfig = jupyterLabAppImageConfig;
            return this;
        }

        public final CodeEditorAppImageConfig.Builder getCodeEditorAppImageConfig() {
            return codeEditorAppImageConfig != null ? codeEditorAppImageConfig.toBuilder() : null;
        }

        public final void setCodeEditorAppImageConfig(CodeEditorAppImageConfig.BuilderImpl codeEditorAppImageConfig) {
            this.codeEditorAppImageConfig = codeEditorAppImageConfig != null ? codeEditorAppImageConfig.build() : null;
        }

        @Override
        public final Builder codeEditorAppImageConfig(CodeEditorAppImageConfig codeEditorAppImageConfig) {
            this.codeEditorAppImageConfig = codeEditorAppImageConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAppImageConfigRequest build() {
            return new UpdateAppImageConfigRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
