/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateClusterRequest extends SageMakerRequest implements
        ToCopyableBuilder<UpdateClusterRequest.Builder, UpdateClusterRequest> {
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterName").getter(getter(UpdateClusterRequest::clusterName)).setter(setter(Builder::clusterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterName").build()).build();

    private static final SdkField<List<ClusterInstanceGroupSpecification>> INSTANCE_GROUPS_FIELD = SdkField
            .<List<ClusterInstanceGroupSpecification>> builder(MarshallingType.LIST)
            .memberName("InstanceGroups")
            .getter(getter(UpdateClusterRequest::instanceGroups))
            .setter(setter(Builder::instanceGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ClusterInstanceGroupSpecification> builder(MarshallingType.SDK_POJO)
                                            .constructor(ClusterInstanceGroupSpecification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ClusterRestrictedInstanceGroupSpecification>> RESTRICTED_INSTANCE_GROUPS_FIELD = SdkField
            .<List<ClusterRestrictedInstanceGroupSpecification>> builder(MarshallingType.LIST)
            .memberName("RestrictedInstanceGroups")
            .getter(getter(UpdateClusterRequest::restrictedInstanceGroups))
            .setter(setter(Builder::restrictedInstanceGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestrictedInstanceGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ClusterRestrictedInstanceGroupSpecification> builder(MarshallingType.SDK_POJO)
                                            .constructor(ClusterRestrictedInstanceGroupSpecification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ClusterTieredStorageConfig> TIERED_STORAGE_CONFIG_FIELD = SdkField
            .<ClusterTieredStorageConfig> builder(MarshallingType.SDK_POJO).memberName("TieredStorageConfig")
            .getter(getter(UpdateClusterRequest::tieredStorageConfig)).setter(setter(Builder::tieredStorageConfig))
            .constructor(ClusterTieredStorageConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TieredStorageConfig").build())
            .build();

    private static final SdkField<String> NODE_RECOVERY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NodeRecovery").getter(getter(UpdateClusterRequest::nodeRecoveryAsString))
            .setter(setter(Builder::nodeRecovery))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeRecovery").build()).build();

    private static final SdkField<List<String>> INSTANCE_GROUPS_TO_DELETE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("InstanceGroupsToDelete")
            .getter(getter(UpdateClusterRequest::instanceGroupsToDelete))
            .setter(setter(Builder::instanceGroupsToDelete))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceGroupsToDelete").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NODE_PROVISIONING_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NodeProvisioningMode").getter(getter(UpdateClusterRequest::nodeProvisioningModeAsString))
            .setter(setter(Builder::nodeProvisioningMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeProvisioningMode").build())
            .build();

    private static final SdkField<String> CLUSTER_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterRole").getter(getter(UpdateClusterRequest::clusterRole)).setter(setter(Builder::clusterRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterRole").build()).build();

    private static final SdkField<ClusterAutoScalingConfig> AUTO_SCALING_FIELD = SdkField
            .<ClusterAutoScalingConfig> builder(MarshallingType.SDK_POJO).memberName("AutoScaling")
            .getter(getter(UpdateClusterRequest::autoScaling)).setter(setter(Builder::autoScaling))
            .constructor(ClusterAutoScalingConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScaling").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_NAME_FIELD,
            INSTANCE_GROUPS_FIELD, RESTRICTED_INSTANCE_GROUPS_FIELD, TIERED_STORAGE_CONFIG_FIELD, NODE_RECOVERY_FIELD,
            INSTANCE_GROUPS_TO_DELETE_FIELD, NODE_PROVISIONING_MODE_FIELD, CLUSTER_ROLE_FIELD, AUTO_SCALING_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clusterName;

    private final List<ClusterInstanceGroupSpecification> instanceGroups;

    private final List<ClusterRestrictedInstanceGroupSpecification> restrictedInstanceGroups;

    private final ClusterTieredStorageConfig tieredStorageConfig;

    private final String nodeRecovery;

    private final List<String> instanceGroupsToDelete;

    private final String nodeProvisioningMode;

    private final String clusterRole;

    private final ClusterAutoScalingConfig autoScaling;

    private UpdateClusterRequest(BuilderImpl builder) {
        super(builder);
        this.clusterName = builder.clusterName;
        this.instanceGroups = builder.instanceGroups;
        this.restrictedInstanceGroups = builder.restrictedInstanceGroups;
        this.tieredStorageConfig = builder.tieredStorageConfig;
        this.nodeRecovery = builder.nodeRecovery;
        this.instanceGroupsToDelete = builder.instanceGroupsToDelete;
        this.nodeProvisioningMode = builder.nodeProvisioningMode;
        this.clusterRole = builder.clusterRole;
        this.autoScaling = builder.autoScaling;
    }

    /**
     * <p>
     * Specify the name of the SageMaker HyperPod cluster you want to update.
     * </p>
     * 
     * @return Specify the name of the SageMaker HyperPod cluster you want to update.
     */
    public final String clusterName() {
        return clusterName;
    }

    /**
     * For responses, this returns true if the service returned a value for the InstanceGroups property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInstanceGroups() {
        return instanceGroups != null && !(instanceGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specify the instance groups to update.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInstanceGroups} method.
     * </p>
     * 
     * @return Specify the instance groups to update.
     */
    public final List<ClusterInstanceGroupSpecification> instanceGroups() {
        return instanceGroups;
    }

    /**
     * For responses, this returns true if the service returned a value for the RestrictedInstanceGroups property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasRestrictedInstanceGroups() {
        return restrictedInstanceGroups != null && !(restrictedInstanceGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The specialized instance groups for training models like Amazon Nova to be created in the SageMaker HyperPod
     * cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRestrictedInstanceGroups} method.
     * </p>
     * 
     * @return The specialized instance groups for training models like Amazon Nova to be created in the SageMaker
     *         HyperPod cluster.
     */
    public final List<ClusterRestrictedInstanceGroupSpecification> restrictedInstanceGroups() {
        return restrictedInstanceGroups;
    }

    /**
     * <p>
     * Updates the configuration for managed tier checkpointing on the HyperPod cluster. For example, you can enable or
     * disable the feature and modify the percentage of cluster memory allocated for checkpoint storage.
     * </p>
     * 
     * @return Updates the configuration for managed tier checkpointing on the HyperPod cluster. For example, you can
     *         enable or disable the feature and modify the percentage of cluster memory allocated for checkpoint
     *         storage.
     */
    public final ClusterTieredStorageConfig tieredStorageConfig() {
        return tieredStorageConfig;
    }

    /**
     * <p>
     * The node recovery mode to be applied to the SageMaker HyperPod cluster.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #nodeRecovery} will
     * return {@link ClusterNodeRecovery#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #nodeRecoveryAsString}.
     * </p>
     * 
     * @return The node recovery mode to be applied to the SageMaker HyperPod cluster.
     * @see ClusterNodeRecovery
     */
    public final ClusterNodeRecovery nodeRecovery() {
        return ClusterNodeRecovery.fromValue(nodeRecovery);
    }

    /**
     * <p>
     * The node recovery mode to be applied to the SageMaker HyperPod cluster.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #nodeRecovery} will
     * return {@link ClusterNodeRecovery#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #nodeRecoveryAsString}.
     * </p>
     * 
     * @return The node recovery mode to be applied to the SageMaker HyperPod cluster.
     * @see ClusterNodeRecovery
     */
    public final String nodeRecoveryAsString() {
        return nodeRecovery;
    }

    /**
     * For responses, this returns true if the service returned a value for the InstanceGroupsToDelete property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasInstanceGroupsToDelete() {
        return instanceGroupsToDelete != null && !(instanceGroupsToDelete instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specify the names of the instance groups to delete. Use a single <code>,</code> as the separator between multiple
     * names.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInstanceGroupsToDelete} method.
     * </p>
     * 
     * @return Specify the names of the instance groups to delete. Use a single <code>,</code> as the separator between
     *         multiple names.
     */
    public final List<String> instanceGroupsToDelete() {
        return instanceGroupsToDelete;
    }

    /**
     * <p>
     * Determines how instance provisioning is handled during cluster operations. In <code>Continuous</code> mode, the
     * cluster provisions available instances incrementally and retries until the target count is reached. The cluster
     * becomes operational once cluster-level resources are ready. Use <code>CurrentCount</code> and
     * <code>TargetCount</code> in <code>DescribeCluster</code> to track provisioning progress.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #nodeProvisioningMode} will return {@link ClusterNodeProvisioningMode#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #nodeProvisioningModeAsString}.
     * </p>
     * 
     * @return Determines how instance provisioning is handled during cluster operations. In <code>Continuous</code>
     *         mode, the cluster provisions available instances incrementally and retries until the target count is
     *         reached. The cluster becomes operational once cluster-level resources are ready. Use
     *         <code>CurrentCount</code> and <code>TargetCount</code> in <code>DescribeCluster</code> to track
     *         provisioning progress.
     * @see ClusterNodeProvisioningMode
     */
    public final ClusterNodeProvisioningMode nodeProvisioningMode() {
        return ClusterNodeProvisioningMode.fromValue(nodeProvisioningMode);
    }

    /**
     * <p>
     * Determines how instance provisioning is handled during cluster operations. In <code>Continuous</code> mode, the
     * cluster provisions available instances incrementally and retries until the target count is reached. The cluster
     * becomes operational once cluster-level resources are ready. Use <code>CurrentCount</code> and
     * <code>TargetCount</code> in <code>DescribeCluster</code> to track provisioning progress.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #nodeProvisioningMode} will return {@link ClusterNodeProvisioningMode#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #nodeProvisioningModeAsString}.
     * </p>
     * 
     * @return Determines how instance provisioning is handled during cluster operations. In <code>Continuous</code>
     *         mode, the cluster provisions available instances incrementally and retries until the target count is
     *         reached. The cluster becomes operational once cluster-level resources are ready. Use
     *         <code>CurrentCount</code> and <code>TargetCount</code> in <code>DescribeCluster</code> to track
     *         provisioning progress.
     * @see ClusterNodeProvisioningMode
     */
    public final String nodeProvisioningModeAsString() {
        return nodeProvisioningMode;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role that HyperPod assumes for cluster autoscaling operations. Cannot
     * be updated while autoscaling is enabled.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role that HyperPod assumes for cluster autoscaling operations.
     *         Cannot be updated while autoscaling is enabled.
     */
    public final String clusterRole() {
        return clusterRole;
    }

    /**
     * <p>
     * Updates the autoscaling configuration for the cluster. Use to enable or disable automatic node scaling.
     * </p>
     * 
     * @return Updates the autoscaling configuration for the cluster. Use to enable or disable automatic node scaling.
     */
    public final ClusterAutoScalingConfig autoScaling() {
        return autoScaling;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(hasInstanceGroups() ? instanceGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRestrictedInstanceGroups() ? restrictedInstanceGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(tieredStorageConfig());
        hashCode = 31 * hashCode + Objects.hashCode(nodeRecoveryAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasInstanceGroupsToDelete() ? instanceGroupsToDelete() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nodeProvisioningModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(clusterRole());
        hashCode = 31 * hashCode + Objects.hashCode(autoScaling());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateClusterRequest)) {
            return false;
        }
        UpdateClusterRequest other = (UpdateClusterRequest) obj;
        return Objects.equals(clusterName(), other.clusterName()) && hasInstanceGroups() == other.hasInstanceGroups()
                && Objects.equals(instanceGroups(), other.instanceGroups())
                && hasRestrictedInstanceGroups() == other.hasRestrictedInstanceGroups()
                && Objects.equals(restrictedInstanceGroups(), other.restrictedInstanceGroups())
                && Objects.equals(tieredStorageConfig(), other.tieredStorageConfig())
                && Objects.equals(nodeRecoveryAsString(), other.nodeRecoveryAsString())
                && hasInstanceGroupsToDelete() == other.hasInstanceGroupsToDelete()
                && Objects.equals(instanceGroupsToDelete(), other.instanceGroupsToDelete())
                && Objects.equals(nodeProvisioningModeAsString(), other.nodeProvisioningModeAsString())
                && Objects.equals(clusterRole(), other.clusterRole()) && Objects.equals(autoScaling(), other.autoScaling());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateClusterRequest").add("ClusterName", clusterName())
                .add("InstanceGroups", hasInstanceGroups() ? instanceGroups() : null)
                .add("RestrictedInstanceGroups", hasRestrictedInstanceGroups() ? restrictedInstanceGroups() : null)
                .add("TieredStorageConfig", tieredStorageConfig()).add("NodeRecovery", nodeRecoveryAsString())
                .add("InstanceGroupsToDelete", hasInstanceGroupsToDelete() ? instanceGroupsToDelete() : null)
                .add("NodeProvisioningMode", nodeProvisioningModeAsString()).add("ClusterRole", clusterRole())
                .add("AutoScaling", autoScaling()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterName":
            return Optional.ofNullable(clazz.cast(clusterName()));
        case "InstanceGroups":
            return Optional.ofNullable(clazz.cast(instanceGroups()));
        case "RestrictedInstanceGroups":
            return Optional.ofNullable(clazz.cast(restrictedInstanceGroups()));
        case "TieredStorageConfig":
            return Optional.ofNullable(clazz.cast(tieredStorageConfig()));
        case "NodeRecovery":
            return Optional.ofNullable(clazz.cast(nodeRecoveryAsString()));
        case "InstanceGroupsToDelete":
            return Optional.ofNullable(clazz.cast(instanceGroupsToDelete()));
        case "NodeProvisioningMode":
            return Optional.ofNullable(clazz.cast(nodeProvisioningModeAsString()));
        case "ClusterRole":
            return Optional.ofNullable(clazz.cast(clusterRole()));
        case "AutoScaling":
            return Optional.ofNullable(clazz.cast(autoScaling()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ClusterName", CLUSTER_NAME_FIELD);
        map.put("InstanceGroups", INSTANCE_GROUPS_FIELD);
        map.put("RestrictedInstanceGroups", RESTRICTED_INSTANCE_GROUPS_FIELD);
        map.put("TieredStorageConfig", TIERED_STORAGE_CONFIG_FIELD);
        map.put("NodeRecovery", NODE_RECOVERY_FIELD);
        map.put("InstanceGroupsToDelete", INSTANCE_GROUPS_TO_DELETE_FIELD);
        map.put("NodeProvisioningMode", NODE_PROVISIONING_MODE_FIELD);
        map.put("ClusterRole", CLUSTER_ROLE_FIELD);
        map.put("AutoScaling", AUTO_SCALING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateClusterRequest, T> g) {
        return obj -> g.apply((UpdateClusterRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateClusterRequest> {
        /**
         * <p>
         * Specify the name of the SageMaker HyperPod cluster you want to update.
         * </p>
         * 
         * @param clusterName
         *        Specify the name of the SageMaker HyperPod cluster you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterName(String clusterName);

        /**
         * <p>
         * Specify the instance groups to update.
         * </p>
         * 
         * @param instanceGroups
         *        Specify the instance groups to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceGroups(Collection<ClusterInstanceGroupSpecification> instanceGroups);

        /**
         * <p>
         * Specify the instance groups to update.
         * </p>
         * 
         * @param instanceGroups
         *        Specify the instance groups to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceGroups(ClusterInstanceGroupSpecification... instanceGroups);

        /**
         * <p>
         * Specify the instance groups to update.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.ClusterInstanceGroupSpecification.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.sagemaker.model.ClusterInstanceGroupSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.ClusterInstanceGroupSpecification.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #instanceGroups(List<ClusterInstanceGroupSpecification>)}.
         * 
         * @param instanceGroups
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.ClusterInstanceGroupSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceGroups(java.util.Collection<ClusterInstanceGroupSpecification>)
         */
        Builder instanceGroups(Consumer<ClusterInstanceGroupSpecification.Builder>... instanceGroups);

        /**
         * <p>
         * The specialized instance groups for training models like Amazon Nova to be created in the SageMaker HyperPod
         * cluster.
         * </p>
         * 
         * @param restrictedInstanceGroups
         *        The specialized instance groups for training models like Amazon Nova to be created in the SageMaker
         *        HyperPod cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restrictedInstanceGroups(Collection<ClusterRestrictedInstanceGroupSpecification> restrictedInstanceGroups);

        /**
         * <p>
         * The specialized instance groups for training models like Amazon Nova to be created in the SageMaker HyperPod
         * cluster.
         * </p>
         * 
         * @param restrictedInstanceGroups
         *        The specialized instance groups for training models like Amazon Nova to be created in the SageMaker
         *        HyperPod cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restrictedInstanceGroups(ClusterRestrictedInstanceGroupSpecification... restrictedInstanceGroups);

        /**
         * <p>
         * The specialized instance groups for training models like Amazon Nova to be created in the SageMaker HyperPod
         * cluster.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.ClusterRestrictedInstanceGroupSpecification.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.sagemaker.model.ClusterRestrictedInstanceGroupSpecification#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.ClusterRestrictedInstanceGroupSpecification.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #restrictedInstanceGroups(List<ClusterRestrictedInstanceGroupSpecification>)}.
         * 
         * @param restrictedInstanceGroups
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.ClusterRestrictedInstanceGroupSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #restrictedInstanceGroups(java.util.Collection<ClusterRestrictedInstanceGroupSpecification>)
         */
        Builder restrictedInstanceGroups(
                Consumer<ClusterRestrictedInstanceGroupSpecification.Builder>... restrictedInstanceGroups);

        /**
         * <p>
         * Updates the configuration for managed tier checkpointing on the HyperPod cluster. For example, you can enable
         * or disable the feature and modify the percentage of cluster memory allocated for checkpoint storage.
         * </p>
         * 
         * @param tieredStorageConfig
         *        Updates the configuration for managed tier checkpointing on the HyperPod cluster. For example, you can
         *        enable or disable the feature and modify the percentage of cluster memory allocated for checkpoint
         *        storage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tieredStorageConfig(ClusterTieredStorageConfig tieredStorageConfig);

        /**
         * <p>
         * Updates the configuration for managed tier checkpointing on the HyperPod cluster. For example, you can enable
         * or disable the feature and modify the percentage of cluster memory allocated for checkpoint storage.
         * </p>
         * This is a convenience method that creates an instance of the {@link ClusterTieredStorageConfig.Builder}
         * avoiding the need to create one manually via {@link ClusterTieredStorageConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ClusterTieredStorageConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #tieredStorageConfig(ClusterTieredStorageConfig)}.
         * 
         * @param tieredStorageConfig
         *        a consumer that will call methods on {@link ClusterTieredStorageConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tieredStorageConfig(ClusterTieredStorageConfig)
         */
        default Builder tieredStorageConfig(Consumer<ClusterTieredStorageConfig.Builder> tieredStorageConfig) {
            return tieredStorageConfig(ClusterTieredStorageConfig.builder().applyMutation(tieredStorageConfig).build());
        }

        /**
         * <p>
         * The node recovery mode to be applied to the SageMaker HyperPod cluster.
         * </p>
         * 
         * @param nodeRecovery
         *        The node recovery mode to be applied to the SageMaker HyperPod cluster.
         * @see ClusterNodeRecovery
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClusterNodeRecovery
         */
        Builder nodeRecovery(String nodeRecovery);

        /**
         * <p>
         * The node recovery mode to be applied to the SageMaker HyperPod cluster.
         * </p>
         * 
         * @param nodeRecovery
         *        The node recovery mode to be applied to the SageMaker HyperPod cluster.
         * @see ClusterNodeRecovery
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClusterNodeRecovery
         */
        Builder nodeRecovery(ClusterNodeRecovery nodeRecovery);

        /**
         * <p>
         * Specify the names of the instance groups to delete. Use a single <code>,</code> as the separator between
         * multiple names.
         * </p>
         * 
         * @param instanceGroupsToDelete
         *        Specify the names of the instance groups to delete. Use a single <code>,</code> as the separator
         *        between multiple names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceGroupsToDelete(Collection<String> instanceGroupsToDelete);

        /**
         * <p>
         * Specify the names of the instance groups to delete. Use a single <code>,</code> as the separator between
         * multiple names.
         * </p>
         * 
         * @param instanceGroupsToDelete
         *        Specify the names of the instance groups to delete. Use a single <code>,</code> as the separator
         *        between multiple names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceGroupsToDelete(String... instanceGroupsToDelete);

        /**
         * <p>
         * Determines how instance provisioning is handled during cluster operations. In <code>Continuous</code> mode,
         * the cluster provisions available instances incrementally and retries until the target count is reached. The
         * cluster becomes operational once cluster-level resources are ready. Use <code>CurrentCount</code> and
         * <code>TargetCount</code> in <code>DescribeCluster</code> to track provisioning progress.
         * </p>
         * 
         * @param nodeProvisioningMode
         *        Determines how instance provisioning is handled during cluster operations. In <code>Continuous</code>
         *        mode, the cluster provisions available instances incrementally and retries until the target count is
         *        reached. The cluster becomes operational once cluster-level resources are ready. Use
         *        <code>CurrentCount</code> and <code>TargetCount</code> in <code>DescribeCluster</code> to track
         *        provisioning progress.
         * @see ClusterNodeProvisioningMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClusterNodeProvisioningMode
         */
        Builder nodeProvisioningMode(String nodeProvisioningMode);

        /**
         * <p>
         * Determines how instance provisioning is handled during cluster operations. In <code>Continuous</code> mode,
         * the cluster provisions available instances incrementally and retries until the target count is reached. The
         * cluster becomes operational once cluster-level resources are ready. Use <code>CurrentCount</code> and
         * <code>TargetCount</code> in <code>DescribeCluster</code> to track provisioning progress.
         * </p>
         * 
         * @param nodeProvisioningMode
         *        Determines how instance provisioning is handled during cluster operations. In <code>Continuous</code>
         *        mode, the cluster provisions available instances incrementally and retries until the target count is
         *        reached. The cluster becomes operational once cluster-level resources are ready. Use
         *        <code>CurrentCount</code> and <code>TargetCount</code> in <code>DescribeCluster</code> to track
         *        provisioning progress.
         * @see ClusterNodeProvisioningMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClusterNodeProvisioningMode
         */
        Builder nodeProvisioningMode(ClusterNodeProvisioningMode nodeProvisioningMode);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role that HyperPod assumes for cluster autoscaling operations.
         * Cannot be updated while autoscaling is enabled.
         * </p>
         * 
         * @param clusterRole
         *        The Amazon Resource Name (ARN) of the IAM role that HyperPod assumes for cluster autoscaling
         *        operations. Cannot be updated while autoscaling is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterRole(String clusterRole);

        /**
         * <p>
         * Updates the autoscaling configuration for the cluster. Use to enable or disable automatic node scaling.
         * </p>
         * 
         * @param autoScaling
         *        Updates the autoscaling configuration for the cluster. Use to enable or disable automatic node
         *        scaling.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScaling(ClusterAutoScalingConfig autoScaling);

        /**
         * <p>
         * Updates the autoscaling configuration for the cluster. Use to enable or disable automatic node scaling.
         * </p>
         * This is a convenience method that creates an instance of the {@link ClusterAutoScalingConfig.Builder}
         * avoiding the need to create one manually via {@link ClusterAutoScalingConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ClusterAutoScalingConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #autoScaling(ClusterAutoScalingConfig)}.
         * 
         * @param autoScaling
         *        a consumer that will call methods on {@link ClusterAutoScalingConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #autoScaling(ClusterAutoScalingConfig)
         */
        default Builder autoScaling(Consumer<ClusterAutoScalingConfig.Builder> autoScaling) {
            return autoScaling(ClusterAutoScalingConfig.builder().applyMutation(autoScaling).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String clusterName;

        private List<ClusterInstanceGroupSpecification> instanceGroups = DefaultSdkAutoConstructList.getInstance();

        private List<ClusterRestrictedInstanceGroupSpecification> restrictedInstanceGroups = DefaultSdkAutoConstructList
                .getInstance();

        private ClusterTieredStorageConfig tieredStorageConfig;

        private String nodeRecovery;

        private List<String> instanceGroupsToDelete = DefaultSdkAutoConstructList.getInstance();

        private String nodeProvisioningMode;

        private String clusterRole;

        private ClusterAutoScalingConfig autoScaling;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateClusterRequest model) {
            super(model);
            clusterName(model.clusterName);
            instanceGroups(model.instanceGroups);
            restrictedInstanceGroups(model.restrictedInstanceGroups);
            tieredStorageConfig(model.tieredStorageConfig);
            nodeRecovery(model.nodeRecovery);
            instanceGroupsToDelete(model.instanceGroupsToDelete);
            nodeProvisioningMode(model.nodeProvisioningMode);
            clusterRole(model.clusterRole);
            autoScaling(model.autoScaling);
        }

        public final String getClusterName() {
            return clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final List<ClusterInstanceGroupSpecification.Builder> getInstanceGroups() {
            List<ClusterInstanceGroupSpecification.Builder> result = ClusterInstanceGroupSpecificationsCopier
                    .copyToBuilder(this.instanceGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInstanceGroups(Collection<ClusterInstanceGroupSpecification.BuilderImpl> instanceGroups) {
            this.instanceGroups = ClusterInstanceGroupSpecificationsCopier.copyFromBuilder(instanceGroups);
        }

        @Override
        public final Builder instanceGroups(Collection<ClusterInstanceGroupSpecification> instanceGroups) {
            this.instanceGroups = ClusterInstanceGroupSpecificationsCopier.copy(instanceGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceGroups(ClusterInstanceGroupSpecification... instanceGroups) {
            instanceGroups(Arrays.asList(instanceGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceGroups(Consumer<ClusterInstanceGroupSpecification.Builder>... instanceGroups) {
            instanceGroups(Stream.of(instanceGroups)
                    .map(c -> ClusterInstanceGroupSpecification.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ClusterRestrictedInstanceGroupSpecification.Builder> getRestrictedInstanceGroups() {
            List<ClusterRestrictedInstanceGroupSpecification.Builder> result = ClusterRestrictedInstanceGroupSpecificationsCopier
                    .copyToBuilder(this.restrictedInstanceGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRestrictedInstanceGroups(
                Collection<ClusterRestrictedInstanceGroupSpecification.BuilderImpl> restrictedInstanceGroups) {
            this.restrictedInstanceGroups = ClusterRestrictedInstanceGroupSpecificationsCopier
                    .copyFromBuilder(restrictedInstanceGroups);
        }

        @Override
        public final Builder restrictedInstanceGroups(
                Collection<ClusterRestrictedInstanceGroupSpecification> restrictedInstanceGroups) {
            this.restrictedInstanceGroups = ClusterRestrictedInstanceGroupSpecificationsCopier.copy(restrictedInstanceGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder restrictedInstanceGroups(ClusterRestrictedInstanceGroupSpecification... restrictedInstanceGroups) {
            restrictedInstanceGroups(Arrays.asList(restrictedInstanceGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder restrictedInstanceGroups(
                Consumer<ClusterRestrictedInstanceGroupSpecification.Builder>... restrictedInstanceGroups) {
            restrictedInstanceGroups(Stream.of(restrictedInstanceGroups)
                    .map(c -> ClusterRestrictedInstanceGroupSpecification.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final ClusterTieredStorageConfig.Builder getTieredStorageConfig() {
            return tieredStorageConfig != null ? tieredStorageConfig.toBuilder() : null;
        }

        public final void setTieredStorageConfig(ClusterTieredStorageConfig.BuilderImpl tieredStorageConfig) {
            this.tieredStorageConfig = tieredStorageConfig != null ? tieredStorageConfig.build() : null;
        }

        @Override
        public final Builder tieredStorageConfig(ClusterTieredStorageConfig tieredStorageConfig) {
            this.tieredStorageConfig = tieredStorageConfig;
            return this;
        }

        public final String getNodeRecovery() {
            return nodeRecovery;
        }

        public final void setNodeRecovery(String nodeRecovery) {
            this.nodeRecovery = nodeRecovery;
        }

        @Override
        public final Builder nodeRecovery(String nodeRecovery) {
            this.nodeRecovery = nodeRecovery;
            return this;
        }

        @Override
        public final Builder nodeRecovery(ClusterNodeRecovery nodeRecovery) {
            this.nodeRecovery(nodeRecovery == null ? null : nodeRecovery.toString());
            return this;
        }

        public final Collection<String> getInstanceGroupsToDelete() {
            if (instanceGroupsToDelete instanceof SdkAutoConstructList) {
                return null;
            }
            return instanceGroupsToDelete;
        }

        public final void setInstanceGroupsToDelete(Collection<String> instanceGroupsToDelete) {
            this.instanceGroupsToDelete = ClusterInstanceGroupsToDeleteCopier.copy(instanceGroupsToDelete);
        }

        @Override
        public final Builder instanceGroupsToDelete(Collection<String> instanceGroupsToDelete) {
            this.instanceGroupsToDelete = ClusterInstanceGroupsToDeleteCopier.copy(instanceGroupsToDelete);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceGroupsToDelete(String... instanceGroupsToDelete) {
            instanceGroupsToDelete(Arrays.asList(instanceGroupsToDelete));
            return this;
        }

        public final String getNodeProvisioningMode() {
            return nodeProvisioningMode;
        }

        public final void setNodeProvisioningMode(String nodeProvisioningMode) {
            this.nodeProvisioningMode = nodeProvisioningMode;
        }

        @Override
        public final Builder nodeProvisioningMode(String nodeProvisioningMode) {
            this.nodeProvisioningMode = nodeProvisioningMode;
            return this;
        }

        @Override
        public final Builder nodeProvisioningMode(ClusterNodeProvisioningMode nodeProvisioningMode) {
            this.nodeProvisioningMode(nodeProvisioningMode == null ? null : nodeProvisioningMode.toString());
            return this;
        }

        public final String getClusterRole() {
            return clusterRole;
        }

        public final void setClusterRole(String clusterRole) {
            this.clusterRole = clusterRole;
        }

        @Override
        public final Builder clusterRole(String clusterRole) {
            this.clusterRole = clusterRole;
            return this;
        }

        public final ClusterAutoScalingConfig.Builder getAutoScaling() {
            return autoScaling != null ? autoScaling.toBuilder() : null;
        }

        public final void setAutoScaling(ClusterAutoScalingConfig.BuilderImpl autoScaling) {
            this.autoScaling = autoScaling != null ? autoScaling.build() : null;
        }

        @Override
        public final Builder autoScaling(ClusterAutoScalingConfig autoScaling) {
            this.autoScaling = autoScaling;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateClusterRequest build() {
            return new UpdateClusterRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
