/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdatePartnerAppRequest extends SageMakerRequest implements
        ToCopyableBuilder<UpdatePartnerAppRequest.Builder, UpdatePartnerAppRequest> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(UpdatePartnerAppRequest::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<PartnerAppMaintenanceConfig> MAINTENANCE_CONFIG_FIELD = SdkField
            .<PartnerAppMaintenanceConfig> builder(MarshallingType.SDK_POJO).memberName("MaintenanceConfig")
            .getter(getter(UpdatePartnerAppRequest::maintenanceConfig)).setter(setter(Builder::maintenanceConfig))
            .constructor(PartnerAppMaintenanceConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaintenanceConfig").build()).build();

    private static final SdkField<String> TIER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Tier")
            .getter(getter(UpdatePartnerAppRequest::tier)).setter(setter(Builder::tier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tier").build()).build();

    private static final SdkField<PartnerAppConfig> APPLICATION_CONFIG_FIELD = SdkField
            .<PartnerAppConfig> builder(MarshallingType.SDK_POJO).memberName("ApplicationConfig")
            .getter(getter(UpdatePartnerAppRequest::applicationConfig)).setter(setter(Builder::applicationConfig))
            .constructor(PartnerAppConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationConfig").build()).build();

    private static final SdkField<Boolean> ENABLE_IAM_SESSION_BASED_IDENTITY_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableIamSessionBasedIdentity")
            .getter(getter(UpdatePartnerAppRequest::enableIamSessionBasedIdentity))
            .setter(setter(Builder::enableIamSessionBasedIdentity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableIamSessionBasedIdentity")
                    .build()).build();

    private static final SdkField<Boolean> ENABLE_AUTO_MINOR_VERSION_UPGRADE_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableAutoMinorVersionUpgrade")
            .getter(getter(UpdatePartnerAppRequest::enableAutoMinorVersionUpgrade))
            .setter(setter(Builder::enableAutoMinorVersionUpgrade))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableAutoMinorVersionUpgrade")
                    .build()).build();

    private static final SdkField<String> APP_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AppVersion").getter(getter(UpdatePartnerAppRequest::appVersion)).setter(setter(Builder::appVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppVersion").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(UpdatePartnerAppRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(UpdatePartnerAppRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            MAINTENANCE_CONFIG_FIELD, TIER_FIELD, APPLICATION_CONFIG_FIELD, ENABLE_IAM_SESSION_BASED_IDENTITY_FIELD,
            ENABLE_AUTO_MINOR_VERSION_UPGRADE_FIELD, APP_VERSION_FIELD, CLIENT_TOKEN_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String arn;

    private final PartnerAppMaintenanceConfig maintenanceConfig;

    private final String tier;

    private final PartnerAppConfig applicationConfig;

    private final Boolean enableIamSessionBasedIdentity;

    private final Boolean enableAutoMinorVersionUpgrade;

    private final String appVersion;

    private final String clientToken;

    private final List<Tag> tags;

    private UpdatePartnerAppRequest(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.maintenanceConfig = builder.maintenanceConfig;
        this.tier = builder.tier;
        this.applicationConfig = builder.applicationConfig;
        this.enableIamSessionBasedIdentity = builder.enableIamSessionBasedIdentity;
        this.enableAutoMinorVersionUpgrade = builder.enableAutoMinorVersionUpgrade;
        this.appVersion = builder.appVersion;
        this.clientToken = builder.clientToken;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The ARN of the SageMaker Partner AI App to update.
     * </p>
     * 
     * @return The ARN of the SageMaker Partner AI App to update.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * Maintenance configuration settings for the SageMaker Partner AI App.
     * </p>
     * 
     * @return Maintenance configuration settings for the SageMaker Partner AI App.
     */
    public final PartnerAppMaintenanceConfig maintenanceConfig() {
        return maintenanceConfig;
    }

    /**
     * <p>
     * Indicates the instance type and size of the cluster attached to the SageMaker Partner AI App.
     * </p>
     * 
     * @return Indicates the instance type and size of the cluster attached to the SageMaker Partner AI App.
     */
    public final String tier() {
        return tier;
    }

    /**
     * <p>
     * Configuration settings for the SageMaker Partner AI App.
     * </p>
     * 
     * @return Configuration settings for the SageMaker Partner AI App.
     */
    public final PartnerAppConfig applicationConfig() {
        return applicationConfig;
    }

    /**
     * <p>
     * When set to <code>TRUE</code>, the SageMaker Partner AI App sets the Amazon Web Services IAM session name or the
     * authenticated IAM user as the identity of the SageMaker Partner AI App user.
     * </p>
     * 
     * @return When set to <code>TRUE</code>, the SageMaker Partner AI App sets the Amazon Web Services IAM session name
     *         or the authenticated IAM user as the identity of the SageMaker Partner AI App user.
     */
    public final Boolean enableIamSessionBasedIdentity() {
        return enableIamSessionBasedIdentity;
    }

    /**
     * <p>
     * When set to <code>TRUE</code>, the SageMaker Partner AI App is automatically upgraded to the latest minor version
     * during the next scheduled maintenance window, if one is available.
     * </p>
     * 
     * @return When set to <code>TRUE</code>, the SageMaker Partner AI App is automatically upgraded to the latest minor
     *         version during the next scheduled maintenance window, if one is available.
     */
    public final Boolean enableAutoMinorVersionUpgrade() {
        return enableAutoMinorVersionUpgrade;
    }

    /**
     * <p>
     * The semantic version to upgrade the SageMaker Partner AI App to. Must be the same semantic version returned in
     * the <code>AvailableUpgrade</code> field from <code>DescribePartnerApp</code>. Version skipping and downgrades are
     * not supported.
     * </p>
     * 
     * @return The semantic version to upgrade the SageMaker Partner AI App to. Must be the same semantic version
     *         returned in the <code>AvailableUpgrade</code> field from <code>DescribePartnerApp</code>. Version
     *         skipping and downgrades are not supported.
     */
    public final String appVersion() {
        return appVersion;
    }

    /**
     * <p>
     * A unique token that guarantees that the call to this API is idempotent.
     * </p>
     * 
     * @return A unique token that guarantees that the call to this API is idempotent.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Each tag consists of a key and an optional value. Tag keys must be unique per resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Each tag consists of a key and an optional value. Tag keys must be unique per resource.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(maintenanceConfig());
        hashCode = 31 * hashCode + Objects.hashCode(tier());
        hashCode = 31 * hashCode + Objects.hashCode(applicationConfig());
        hashCode = 31 * hashCode + Objects.hashCode(enableIamSessionBasedIdentity());
        hashCode = 31 * hashCode + Objects.hashCode(enableAutoMinorVersionUpgrade());
        hashCode = 31 * hashCode + Objects.hashCode(appVersion());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePartnerAppRequest)) {
            return false;
        }
        UpdatePartnerAppRequest other = (UpdatePartnerAppRequest) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(maintenanceConfig(), other.maintenanceConfig())
                && Objects.equals(tier(), other.tier()) && Objects.equals(applicationConfig(), other.applicationConfig())
                && Objects.equals(enableIamSessionBasedIdentity(), other.enableIamSessionBasedIdentity())
                && Objects.equals(enableAutoMinorVersionUpgrade(), other.enableAutoMinorVersionUpgrade())
                && Objects.equals(appVersion(), other.appVersion()) && Objects.equals(clientToken(), other.clientToken())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdatePartnerAppRequest").add("Arn", arn()).add("MaintenanceConfig", maintenanceConfig())
                .add("Tier", tier()).add("ApplicationConfig", applicationConfig())
                .add("EnableIamSessionBasedIdentity", enableIamSessionBasedIdentity())
                .add("EnableAutoMinorVersionUpgrade", enableAutoMinorVersionUpgrade()).add("AppVersion", appVersion())
                .add("ClientToken", clientToken()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "MaintenanceConfig":
            return Optional.ofNullable(clazz.cast(maintenanceConfig()));
        case "Tier":
            return Optional.ofNullable(clazz.cast(tier()));
        case "ApplicationConfig":
            return Optional.ofNullable(clazz.cast(applicationConfig()));
        case "EnableIamSessionBasedIdentity":
            return Optional.ofNullable(clazz.cast(enableIamSessionBasedIdentity()));
        case "EnableAutoMinorVersionUpgrade":
            return Optional.ofNullable(clazz.cast(enableAutoMinorVersionUpgrade()));
        case "AppVersion":
            return Optional.ofNullable(clazz.cast(appVersion()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Arn", ARN_FIELD);
        map.put("MaintenanceConfig", MAINTENANCE_CONFIG_FIELD);
        map.put("Tier", TIER_FIELD);
        map.put("ApplicationConfig", APPLICATION_CONFIG_FIELD);
        map.put("EnableIamSessionBasedIdentity", ENABLE_IAM_SESSION_BASED_IDENTITY_FIELD);
        map.put("EnableAutoMinorVersionUpgrade", ENABLE_AUTO_MINOR_VERSION_UPGRADE_FIELD);
        map.put("AppVersion", APP_VERSION_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdatePartnerAppRequest, T> g) {
        return obj -> g.apply((UpdatePartnerAppRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdatePartnerAppRequest> {
        /**
         * <p>
         * The ARN of the SageMaker Partner AI App to update.
         * </p>
         * 
         * @param arn
         *        The ARN of the SageMaker Partner AI App to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * Maintenance configuration settings for the SageMaker Partner AI App.
         * </p>
         * 
         * @param maintenanceConfig
         *        Maintenance configuration settings for the SageMaker Partner AI App.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maintenanceConfig(PartnerAppMaintenanceConfig maintenanceConfig);

        /**
         * <p>
         * Maintenance configuration settings for the SageMaker Partner AI App.
         * </p>
         * This is a convenience method that creates an instance of the {@link PartnerAppMaintenanceConfig.Builder}
         * avoiding the need to create one manually via {@link PartnerAppMaintenanceConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PartnerAppMaintenanceConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #maintenanceConfig(PartnerAppMaintenanceConfig)}.
         * 
         * @param maintenanceConfig
         *        a consumer that will call methods on {@link PartnerAppMaintenanceConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #maintenanceConfig(PartnerAppMaintenanceConfig)
         */
        default Builder maintenanceConfig(Consumer<PartnerAppMaintenanceConfig.Builder> maintenanceConfig) {
            return maintenanceConfig(PartnerAppMaintenanceConfig.builder().applyMutation(maintenanceConfig).build());
        }

        /**
         * <p>
         * Indicates the instance type and size of the cluster attached to the SageMaker Partner AI App.
         * </p>
         * 
         * @param tier
         *        Indicates the instance type and size of the cluster attached to the SageMaker Partner AI App.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tier(String tier);

        /**
         * <p>
         * Configuration settings for the SageMaker Partner AI App.
         * </p>
         * 
         * @param applicationConfig
         *        Configuration settings for the SageMaker Partner AI App.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationConfig(PartnerAppConfig applicationConfig);

        /**
         * <p>
         * Configuration settings for the SageMaker Partner AI App.
         * </p>
         * This is a convenience method that creates an instance of the {@link PartnerAppConfig.Builder} avoiding the
         * need to create one manually via {@link PartnerAppConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PartnerAppConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #applicationConfig(PartnerAppConfig)}.
         * 
         * @param applicationConfig
         *        a consumer that will call methods on {@link PartnerAppConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #applicationConfig(PartnerAppConfig)
         */
        default Builder applicationConfig(Consumer<PartnerAppConfig.Builder> applicationConfig) {
            return applicationConfig(PartnerAppConfig.builder().applyMutation(applicationConfig).build());
        }

        /**
         * <p>
         * When set to <code>TRUE</code>, the SageMaker Partner AI App sets the Amazon Web Services IAM session name or
         * the authenticated IAM user as the identity of the SageMaker Partner AI App user.
         * </p>
         * 
         * @param enableIamSessionBasedIdentity
         *        When set to <code>TRUE</code>, the SageMaker Partner AI App sets the Amazon Web Services IAM session
         *        name or the authenticated IAM user as the identity of the SageMaker Partner AI App user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableIamSessionBasedIdentity(Boolean enableIamSessionBasedIdentity);

        /**
         * <p>
         * When set to <code>TRUE</code>, the SageMaker Partner AI App is automatically upgraded to the latest minor
         * version during the next scheduled maintenance window, if one is available.
         * </p>
         * 
         * @param enableAutoMinorVersionUpgrade
         *        When set to <code>TRUE</code>, the SageMaker Partner AI App is automatically upgraded to the latest
         *        minor version during the next scheduled maintenance window, if one is available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableAutoMinorVersionUpgrade(Boolean enableAutoMinorVersionUpgrade);

        /**
         * <p>
         * The semantic version to upgrade the SageMaker Partner AI App to. Must be the same semantic version returned
         * in the <code>AvailableUpgrade</code> field from <code>DescribePartnerApp</code>. Version skipping and
         * downgrades are not supported.
         * </p>
         * 
         * @param appVersion
         *        The semantic version to upgrade the SageMaker Partner AI App to. Must be the same semantic version
         *        returned in the <code>AvailableUpgrade</code> field from <code>DescribePartnerApp</code>. Version
         *        skipping and downgrades are not supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appVersion(String appVersion);

        /**
         * <p>
         * A unique token that guarantees that the call to this API is idempotent.
         * </p>
         * 
         * @param clientToken
         *        A unique token that guarantees that the call to this API is idempotent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * Each tag consists of a key and an optional value. Tag keys must be unique per resource.
         * </p>
         * 
         * @param tags
         *        Each tag consists of a key and an optional value. Tag keys must be unique per resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Each tag consists of a key and an optional value. Tag keys must be unique per resource.
         * </p>
         * 
         * @param tags
         *        Each tag consists of a key and an optional value. Tag keys must be unique per resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Each tag consists of a key and an optional value. Tag keys must be unique per resource.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.sagemaker.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String arn;

        private PartnerAppMaintenanceConfig maintenanceConfig;

        private String tier;

        private PartnerAppConfig applicationConfig;

        private Boolean enableIamSessionBasedIdentity;

        private Boolean enableAutoMinorVersionUpgrade;

        private String appVersion;

        private String clientToken;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePartnerAppRequest model) {
            super(model);
            arn(model.arn);
            maintenanceConfig(model.maintenanceConfig);
            tier(model.tier);
            applicationConfig(model.applicationConfig);
            enableIamSessionBasedIdentity(model.enableIamSessionBasedIdentity);
            enableAutoMinorVersionUpgrade(model.enableAutoMinorVersionUpgrade);
            appVersion(model.appVersion);
            clientToken(model.clientToken);
            tags(model.tags);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final PartnerAppMaintenanceConfig.Builder getMaintenanceConfig() {
            return maintenanceConfig != null ? maintenanceConfig.toBuilder() : null;
        }

        public final void setMaintenanceConfig(PartnerAppMaintenanceConfig.BuilderImpl maintenanceConfig) {
            this.maintenanceConfig = maintenanceConfig != null ? maintenanceConfig.build() : null;
        }

        @Override
        public final Builder maintenanceConfig(PartnerAppMaintenanceConfig maintenanceConfig) {
            this.maintenanceConfig = maintenanceConfig;
            return this;
        }

        public final String getTier() {
            return tier;
        }

        public final void setTier(String tier) {
            this.tier = tier;
        }

        @Override
        public final Builder tier(String tier) {
            this.tier = tier;
            return this;
        }

        public final PartnerAppConfig.Builder getApplicationConfig() {
            return applicationConfig != null ? applicationConfig.toBuilder() : null;
        }

        public final void setApplicationConfig(PartnerAppConfig.BuilderImpl applicationConfig) {
            this.applicationConfig = applicationConfig != null ? applicationConfig.build() : null;
        }

        @Override
        public final Builder applicationConfig(PartnerAppConfig applicationConfig) {
            this.applicationConfig = applicationConfig;
            return this;
        }

        public final Boolean getEnableIamSessionBasedIdentity() {
            return enableIamSessionBasedIdentity;
        }

        public final void setEnableIamSessionBasedIdentity(Boolean enableIamSessionBasedIdentity) {
            this.enableIamSessionBasedIdentity = enableIamSessionBasedIdentity;
        }

        @Override
        public final Builder enableIamSessionBasedIdentity(Boolean enableIamSessionBasedIdentity) {
            this.enableIamSessionBasedIdentity = enableIamSessionBasedIdentity;
            return this;
        }

        public final Boolean getEnableAutoMinorVersionUpgrade() {
            return enableAutoMinorVersionUpgrade;
        }

        public final void setEnableAutoMinorVersionUpgrade(Boolean enableAutoMinorVersionUpgrade) {
            this.enableAutoMinorVersionUpgrade = enableAutoMinorVersionUpgrade;
        }

        @Override
        public final Builder enableAutoMinorVersionUpgrade(Boolean enableAutoMinorVersionUpgrade) {
            this.enableAutoMinorVersionUpgrade = enableAutoMinorVersionUpgrade;
            return this;
        }

        public final String getAppVersion() {
            return appVersion;
        }

        public final void setAppVersion(String appVersion) {
            this.appVersion = appVersion;
        }

        @Override
        public final Builder appVersion(String appVersion) {
            this.appVersion = appVersion;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdatePartnerAppRequest build() {
            return new UpdatePartnerAppRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
