/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdatePipelineVersionRequest extends SageMakerRequest implements
        ToCopyableBuilder<UpdatePipelineVersionRequest.Builder, UpdatePipelineVersionRequest> {
    private static final SdkField<String> PIPELINE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PipelineArn").getter(getter(UpdatePipelineVersionRequest::pipelineArn))
            .setter(setter(Builder::pipelineArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineArn").build()).build();

    private static final SdkField<Long> PIPELINE_VERSION_ID_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("PipelineVersionId").getter(getter(UpdatePipelineVersionRequest::pipelineVersionId))
            .setter(setter(Builder::pipelineVersionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineVersionId").build()).build();

    private static final SdkField<String> PIPELINE_VERSION_DISPLAY_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PipelineVersionDisplayName")
            .getter(getter(UpdatePipelineVersionRequest::pipelineVersionDisplayName))
            .setter(setter(Builder::pipelineVersionDisplayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineVersionDisplayName").build())
            .build();

    private static final SdkField<String> PIPELINE_VERSION_DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PipelineVersionDescription")
            .getter(getter(UpdatePipelineVersionRequest::pipelineVersionDescription))
            .setter(setter(Builder::pipelineVersionDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineVersionDescription").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_ARN_FIELD,
            PIPELINE_VERSION_ID_FIELD, PIPELINE_VERSION_DISPLAY_NAME_FIELD, PIPELINE_VERSION_DESCRIPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String pipelineArn;

    private final Long pipelineVersionId;

    private final String pipelineVersionDisplayName;

    private final String pipelineVersionDescription;

    private UpdatePipelineVersionRequest(BuilderImpl builder) {
        super(builder);
        this.pipelineArn = builder.pipelineArn;
        this.pipelineVersionId = builder.pipelineVersionId;
        this.pipelineVersionDisplayName = builder.pipelineVersionDisplayName;
        this.pipelineVersionDescription = builder.pipelineVersionDescription;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the pipeline.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the pipeline.
     */
    public final String pipelineArn() {
        return pipelineArn;
    }

    /**
     * <p>
     * The pipeline version ID to update.
     * </p>
     * 
     * @return The pipeline version ID to update.
     */
    public final Long pipelineVersionId() {
        return pipelineVersionId;
    }

    /**
     * <p>
     * The display name of the pipeline version.
     * </p>
     * 
     * @return The display name of the pipeline version.
     */
    public final String pipelineVersionDisplayName() {
        return pipelineVersionDisplayName;
    }

    /**
     * <p>
     * The description of the pipeline version.
     * </p>
     * 
     * @return The description of the pipeline version.
     */
    public final String pipelineVersionDescription() {
        return pipelineVersionDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(pipelineArn());
        hashCode = 31 * hashCode + Objects.hashCode(pipelineVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(pipelineVersionDisplayName());
        hashCode = 31 * hashCode + Objects.hashCode(pipelineVersionDescription());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePipelineVersionRequest)) {
            return false;
        }
        UpdatePipelineVersionRequest other = (UpdatePipelineVersionRequest) obj;
        return Objects.equals(pipelineArn(), other.pipelineArn())
                && Objects.equals(pipelineVersionId(), other.pipelineVersionId())
                && Objects.equals(pipelineVersionDisplayName(), other.pipelineVersionDisplayName())
                && Objects.equals(pipelineVersionDescription(), other.pipelineVersionDescription());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdatePipelineVersionRequest").add("PipelineArn", pipelineArn())
                .add("PipelineVersionId", pipelineVersionId()).add("PipelineVersionDisplayName", pipelineVersionDisplayName())
                .add("PipelineVersionDescription", pipelineVersionDescription()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PipelineArn":
            return Optional.ofNullable(clazz.cast(pipelineArn()));
        case "PipelineVersionId":
            return Optional.ofNullable(clazz.cast(pipelineVersionId()));
        case "PipelineVersionDisplayName":
            return Optional.ofNullable(clazz.cast(pipelineVersionDisplayName()));
        case "PipelineVersionDescription":
            return Optional.ofNullable(clazz.cast(pipelineVersionDescription()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PipelineArn", PIPELINE_ARN_FIELD);
        map.put("PipelineVersionId", PIPELINE_VERSION_ID_FIELD);
        map.put("PipelineVersionDisplayName", PIPELINE_VERSION_DISPLAY_NAME_FIELD);
        map.put("PipelineVersionDescription", PIPELINE_VERSION_DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdatePipelineVersionRequest, T> g) {
        return obj -> g.apply((UpdatePipelineVersionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdatePipelineVersionRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the pipeline.
         * </p>
         * 
         * @param pipelineArn
         *        The Amazon Resource Name (ARN) of the pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineArn(String pipelineArn);

        /**
         * <p>
         * The pipeline version ID to update.
         * </p>
         * 
         * @param pipelineVersionId
         *        The pipeline version ID to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineVersionId(Long pipelineVersionId);

        /**
         * <p>
         * The display name of the pipeline version.
         * </p>
         * 
         * @param pipelineVersionDisplayName
         *        The display name of the pipeline version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineVersionDisplayName(String pipelineVersionDisplayName);

        /**
         * <p>
         * The description of the pipeline version.
         * </p>
         * 
         * @param pipelineVersionDescription
         *        The description of the pipeline version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineVersionDescription(String pipelineVersionDescription);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String pipelineArn;

        private Long pipelineVersionId;

        private String pipelineVersionDisplayName;

        private String pipelineVersionDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePipelineVersionRequest model) {
            super(model);
            pipelineArn(model.pipelineArn);
            pipelineVersionId(model.pipelineVersionId);
            pipelineVersionDisplayName(model.pipelineVersionDisplayName);
            pipelineVersionDescription(model.pipelineVersionDescription);
        }

        public final String getPipelineArn() {
            return pipelineArn;
        }

        public final void setPipelineArn(String pipelineArn) {
            this.pipelineArn = pipelineArn;
        }

        @Override
        public final Builder pipelineArn(String pipelineArn) {
            this.pipelineArn = pipelineArn;
            return this;
        }

        public final Long getPipelineVersionId() {
            return pipelineVersionId;
        }

        public final void setPipelineVersionId(Long pipelineVersionId) {
            this.pipelineVersionId = pipelineVersionId;
        }

        @Override
        public final Builder pipelineVersionId(Long pipelineVersionId) {
            this.pipelineVersionId = pipelineVersionId;
            return this;
        }

        public final String getPipelineVersionDisplayName() {
            return pipelineVersionDisplayName;
        }

        public final void setPipelineVersionDisplayName(String pipelineVersionDisplayName) {
            this.pipelineVersionDisplayName = pipelineVersionDisplayName;
        }

        @Override
        public final Builder pipelineVersionDisplayName(String pipelineVersionDisplayName) {
            this.pipelineVersionDisplayName = pipelineVersionDisplayName;
            return this;
        }

        public final String getPipelineVersionDescription() {
            return pipelineVersionDescription;
        }

        public final void setPipelineVersionDescription(String pipelineVersionDescription) {
            this.pipelineVersionDescription = pipelineVersionDescription;
        }

        @Override
        public final Builder pipelineVersionDescription(String pipelineVersionDescription) {
            this.pipelineVersionDescription = pipelineVersionDescription;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdatePipelineVersionRequest build() {
            return new UpdatePipelineVersionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
