/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class UpdateTemplateProviderListCopier {
    static List<UpdateTemplateProvider> copy(Collection<? extends UpdateTemplateProvider> updateTemplateProviderListParam) {
        List<UpdateTemplateProvider> list;
        if (updateTemplateProviderListParam == null || updateTemplateProviderListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<UpdateTemplateProvider> modifiableList = new ArrayList<>(updateTemplateProviderListParam.size());
            updateTemplateProviderListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<UpdateTemplateProvider> copyFromBuilder(
            Collection<? extends UpdateTemplateProvider.Builder> updateTemplateProviderListParam) {
        List<UpdateTemplateProvider> list;
        if (updateTemplateProviderListParam == null || updateTemplateProviderListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<UpdateTemplateProvider> modifiableList = new ArrayList<>(updateTemplateProviderListParam.size());
            updateTemplateProviderListParam.forEach(entry -> {
                UpdateTemplateProvider member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<UpdateTemplateProvider.Builder> copyToBuilder(
            Collection<? extends UpdateTemplateProvider> updateTemplateProviderListParam) {
        List<UpdateTemplateProvider.Builder> list;
        if (updateTemplateProviderListParam == null || updateTemplateProviderListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<UpdateTemplateProvider.Builder> modifiableList = new ArrayList<>(updateTemplateProviderListParam.size());
            updateTemplateProviderListParam.forEach(entry -> {
                UpdateTemplateProvider.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
