/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A lineage entity connected to the starting entity(ies).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Vertex implements SdkPojo, Serializable, ToCopyableBuilder<Vertex.Builder, Vertex> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(Vertex::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(Vertex::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> LINEAGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LineageType").getter(getter(Vertex::lineageTypeAsString)).setter(setter(Builder::lineageType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LineageType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, TYPE_FIELD,
            LINEAGE_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String type;

    private final String lineageType;

    private Vertex(BuilderImpl builder) {
        this.arn = builder.arn;
        this.type = builder.type;
        this.lineageType = builder.lineageType;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the lineage entity resource.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the lineage entity resource.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The type of the lineage entity resource. For example: <code>DataSet</code>, <code>Model</code>,
     * <code>Endpoint</code>, etc...
     * </p>
     * 
     * @return The type of the lineage entity resource. For example: <code>DataSet</code>, <code>Model</code>,
     *         <code>Endpoint</code>, etc...
     */
    public final String type() {
        return type;
    }

    /**
     * <p>
     * The type of resource of the lineage entity.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lineageType} will
     * return {@link LineageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #lineageTypeAsString}.
     * </p>
     * 
     * @return The type of resource of the lineage entity.
     * @see LineageType
     */
    public final LineageType lineageType() {
        return LineageType.fromValue(lineageType);
    }

    /**
     * <p>
     * The type of resource of the lineage entity.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lineageType} will
     * return {@link LineageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #lineageTypeAsString}.
     * </p>
     * 
     * @return The type of resource of the lineage entity.
     * @see LineageType
     */
    public final String lineageTypeAsString() {
        return lineageType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(lineageTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Vertex)) {
            return false;
        }
        Vertex other = (Vertex) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(type(), other.type())
                && Objects.equals(lineageTypeAsString(), other.lineageTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Vertex").add("Arn", arn()).add("Type", type()).add("LineageType", lineageTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        case "LineageType":
            return Optional.ofNullable(clazz.cast(lineageTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Arn", ARN_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("LineageType", LINEAGE_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Vertex, T> g) {
        return obj -> g.apply((Vertex) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Vertex> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the lineage entity resource.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the lineage entity resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The type of the lineage entity resource. For example: <code>DataSet</code>, <code>Model</code>,
         * <code>Endpoint</code>, etc...
         * </p>
         * 
         * @param type
         *        The type of the lineage entity resource. For example: <code>DataSet</code>, <code>Model</code>,
         *        <code>Endpoint</code>, etc...
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * <p>
         * The type of resource of the lineage entity.
         * </p>
         * 
         * @param lineageType
         *        The type of resource of the lineage entity.
         * @see LineageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LineageType
         */
        Builder lineageType(String lineageType);

        /**
         * <p>
         * The type of resource of the lineage entity.
         * </p>
         * 
         * @param lineageType
         *        The type of resource of the lineage entity.
         * @see LineageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LineageType
         */
        Builder lineageType(LineageType lineageType);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String type;

        private String lineageType;

        private BuilderImpl() {
        }

        private BuilderImpl(Vertex model) {
            arn(model.arn);
            type(model.type);
            lineageType(model.lineageType);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final String getLineageType() {
            return lineageType;
        }

        public final void setLineageType(String lineageType) {
            this.lineageType = lineageType;
        }

        @Override
        public final Builder lineageType(String lineageType) {
            this.lineageType = lineageType;
            return this;
        }

        @Override
        public final Builder lineageType(LineageType lineageType) {
            this.lineageType(lineageType == null ? null : lineageType.toString());
            return this;
        }

        @Override
        public Vertex build() {
            return new Vertex(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
