/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.CapacityReservation;
import software.amazon.awssdk.services.sagemaker.model.SecurityGroupIdsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstanceGroupMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InstanceGroupMetadata> {
    private static final SdkField<String> FAILURE_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureMessage").getter(InstanceGroupMetadata.getter(InstanceGroupMetadata::failureMessage)).setter(InstanceGroupMetadata.setter(Builder::failureMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureMessage").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZoneId").getter(InstanceGroupMetadata.getter(InstanceGroupMetadata::availabilityZoneId)).setter(InstanceGroupMetadata.setter(Builder::availabilityZoneId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZoneId").build()}).build();
    private static final SdkField<CapacityReservation> CAPACITY_RESERVATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CapacityReservation").getter(InstanceGroupMetadata.getter(InstanceGroupMetadata::capacityReservation)).setter(InstanceGroupMetadata.setter(Builder::capacityReservation)).constructor(CapacityReservation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityReservation").build()}).build();
    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubnetId").getter(InstanceGroupMetadata.getter(InstanceGroupMetadata::subnetId)).setter(InstanceGroupMetadata.setter(Builder::subnetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityGroupIds").getter(InstanceGroupMetadata.getter(InstanceGroupMetadata::securityGroupIds)).setter(InstanceGroupMetadata.setter(Builder::securityGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> AMI_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AmiOverride").getter(InstanceGroupMetadata.getter(InstanceGroupMetadata::amiOverride)).setter(InstanceGroupMetadata.setter(Builder::amiOverride)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AmiOverride").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAILURE_MESSAGE_FIELD, AVAILABILITY_ZONE_ID_FIELD, CAPACITY_RESERVATION_FIELD, SUBNET_ID_FIELD, SECURITY_GROUP_IDS_FIELD, AMI_OVERRIDE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InstanceGroupMetadata.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String failureMessage;
    private final String availabilityZoneId;
    private final CapacityReservation capacityReservation;
    private final String subnetId;
    private final List<String> securityGroupIds;
    private final String amiOverride;

    private InstanceGroupMetadata(BuilderImpl builder) {
        this.failureMessage = builder.failureMessage;
        this.availabilityZoneId = builder.availabilityZoneId;
        this.capacityReservation = builder.capacityReservation;
        this.subnetId = builder.subnetId;
        this.securityGroupIds = builder.securityGroupIds;
        this.amiOverride = builder.amiOverride;
    }

    public final String failureMessage() {
        return this.failureMessage;
    }

    public final String availabilityZoneId() {
        return this.availabilityZoneId;
    }

    public final CapacityReservation capacityReservation() {
        return this.capacityReservation;
    }

    public final String subnetId() {
        return this.subnetId;
    }

    public final boolean hasSecurityGroupIds() {
        return this.securityGroupIds != null && !(this.securityGroupIds instanceof SdkAutoConstructList);
    }

    public final List<String> securityGroupIds() {
        return this.securityGroupIds;
    }

    public final String amiOverride() {
        return this.amiOverride;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.failureMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(this.capacityReservation());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroupIds() ? this.securityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.amiOverride());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceGroupMetadata)) {
            return false;
        }
        InstanceGroupMetadata other = (InstanceGroupMetadata)obj;
        return Objects.equals(this.failureMessage(), other.failureMessage()) && Objects.equals(this.availabilityZoneId(), other.availabilityZoneId()) && Objects.equals(this.capacityReservation(), other.capacityReservation()) && Objects.equals(this.subnetId(), other.subnetId()) && this.hasSecurityGroupIds() == other.hasSecurityGroupIds() && Objects.equals(this.securityGroupIds(), other.securityGroupIds()) && Objects.equals(this.amiOverride(), other.amiOverride());
    }

    public final String toString() {
        return ToString.builder((String)"InstanceGroupMetadata").add("FailureMessage", (Object)this.failureMessage()).add("AvailabilityZoneId", (Object)this.availabilityZoneId()).add("CapacityReservation", (Object)this.capacityReservation()).add("SubnetId", (Object)this.subnetId()).add("SecurityGroupIds", this.hasSecurityGroupIds() ? this.securityGroupIds() : null).add("AmiOverride", (Object)this.amiOverride()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FailureMessage": {
                return Optional.ofNullable(clazz.cast(this.failureMessage()));
            }
            case "AvailabilityZoneId": {
                return Optional.ofNullable(clazz.cast(this.availabilityZoneId()));
            }
            case "CapacityReservation": {
                return Optional.ofNullable(clazz.cast(this.capacityReservation()));
            }
            case "SubnetId": {
                return Optional.ofNullable(clazz.cast(this.subnetId()));
            }
            case "SecurityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.securityGroupIds()));
            }
            case "AmiOverride": {
                return Optional.ofNullable(clazz.cast(this.amiOverride()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("FailureMessage", FAILURE_MESSAGE_FIELD);
        map.put("AvailabilityZoneId", AVAILABILITY_ZONE_ID_FIELD);
        map.put("CapacityReservation", CAPACITY_RESERVATION_FIELD);
        map.put("SubnetId", SUBNET_ID_FIELD);
        map.put("SecurityGroupIds", SECURITY_GROUP_IDS_FIELD);
        map.put("AmiOverride", AMI_OVERRIDE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InstanceGroupMetadata, T> g) {
        return obj -> g.apply((InstanceGroupMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String failureMessage;
        private String availabilityZoneId;
        private CapacityReservation capacityReservation;
        private String subnetId;
        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();
        private String amiOverride;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceGroupMetadata model) {
            this.failureMessage(model.failureMessage);
            this.availabilityZoneId(model.availabilityZoneId);
            this.capacityReservation(model.capacityReservation);
            this.subnetId(model.subnetId);
            this.securityGroupIds(model.securityGroupIds);
            this.amiOverride(model.amiOverride);
        }

        public final String getFailureMessage() {
            return this.failureMessage;
        }

        public final void setFailureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
        }

        @Override
        public final Builder failureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
            return this;
        }

        public final String getAvailabilityZoneId() {
            return this.availabilityZoneId;
        }

        public final void setAvailabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
        }

        @Override
        public final Builder availabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
            return this;
        }

        public final CapacityReservation.Builder getCapacityReservation() {
            return this.capacityReservation != null ? this.capacityReservation.toBuilder() : null;
        }

        public final void setCapacityReservation(CapacityReservation.BuilderImpl capacityReservation) {
            this.capacityReservation = capacityReservation != null ? capacityReservation.build() : null;
        }

        @Override
        public final Builder capacityReservation(CapacityReservation capacityReservation) {
            this.capacityReservation = capacityReservation;
            return this;
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final Collection<String> getSecurityGroupIds() {
            if (this.securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.securityGroupIds;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsCopier.copy(securityGroupIds);
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String ... securityGroupIds) {
            this.securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final String getAmiOverride() {
            return this.amiOverride;
        }

        public final void setAmiOverride(String amiOverride) {
            this.amiOverride = amiOverride;
        }

        @Override
        public final Builder amiOverride(String amiOverride) {
            this.amiOverride = amiOverride;
            return this;
        }

        public InstanceGroupMetadata build() {
            return new InstanceGroupMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InstanceGroupMetadata> {
        public Builder failureMessage(String var1);

        public Builder availabilityZoneId(String var1);

        public Builder capacityReservation(CapacityReservation var1);

        default public Builder capacityReservation(Consumer<CapacityReservation.Builder> capacityReservation) {
            return this.capacityReservation((CapacityReservation)((CapacityReservation.Builder)CapacityReservation.builder().applyMutation(capacityReservation)).build());
        }

        public Builder subnetId(String var1);

        public Builder securityGroupIds(Collection<String> var1);

        public Builder securityGroupIds(String ... var1);

        public Builder amiOverride(String var1);
    }
}

