/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateCompilationJobResponse extends SageMakerResponse implements
        ToCopyableBuilder<CreateCompilationJobResponse.Builder, CreateCompilationJobResponse> {
    private static final SdkField<String> COMPILATION_JOB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateCompilationJobResponse::compilationJobArn)).setter(setter(Builder::compilationJobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompilationJobArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPILATION_JOB_ARN_FIELD));

    private final String compilationJobArn;

    private CreateCompilationJobResponse(BuilderImpl builder) {
        super(builder);
        this.compilationJobArn = builder.compilationJobArn;
    }

    /**
     * <p>
     * If the action is successful, the service sends back an HTTP 200 response. Amazon SageMaker returns the following
     * data in JSON format:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CompilationJobArn</code>: The Amazon Resource Name (ARN) of the compiled job.
     * </p>
     * </li>
     * </ul>
     * 
     * @return If the action is successful, the service sends back an HTTP 200 response. Amazon SageMaker returns the
     *         following data in JSON format:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CompilationJobArn</code>: The Amazon Resource Name (ARN) of the compiled job.
     *         </p>
     *         </li>
     */
    public String compilationJobArn() {
        return compilationJobArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(compilationJobArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCompilationJobResponse)) {
            return false;
        }
        CreateCompilationJobResponse other = (CreateCompilationJobResponse) obj;
        return Objects.equals(compilationJobArn(), other.compilationJobArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateCompilationJobResponse").add("CompilationJobArn", compilationJobArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CompilationJobArn":
            return Optional.ofNullable(clazz.cast(compilationJobArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateCompilationJobResponse, T> g) {
        return obj -> g.apply((CreateCompilationJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateCompilationJobResponse> {
        /**
         * <p>
         * If the action is successful, the service sends back an HTTP 200 response. Amazon SageMaker returns the
         * following data in JSON format:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CompilationJobArn</code>: The Amazon Resource Name (ARN) of the compiled job.
         * </p>
         * </li>
         * </ul>
         * 
         * @param compilationJobArn
         *        If the action is successful, the service sends back an HTTP 200 response. Amazon SageMaker returns the
         *        following data in JSON format:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CompilationJobArn</code>: The Amazon Resource Name (ARN) of the compiled job.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compilationJobArn(String compilationJobArn);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private String compilationJobArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCompilationJobResponse model) {
            super(model);
            compilationJobArn(model.compilationJobArn);
        }

        public final String getCompilationJobArn() {
            return compilationJobArn;
        }

        @Override
        public final Builder compilationJobArn(String compilationJobArn) {
            this.compilationJobArn = compilationJobArn;
            return this;
        }

        public final void setCompilationJobArn(String compilationJobArn) {
            this.compilationJobArn = compilationJobArn;
        }

        @Override
        public CreateCompilationJobResponse build() {
            return new CreateCompilationJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
