/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateEndpointConfigRequest extends SageMakerRequest implements
        ToCopyableBuilder<CreateEndpointConfigRequest.Builder, CreateEndpointConfigRequest> {
    private static final SdkField<String> ENDPOINT_CONFIG_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateEndpointConfigRequest::endpointConfigName)).setter(setter(Builder::endpointConfigName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointConfigName").build())
            .build();

    private static final SdkField<List<ProductionVariant>> PRODUCTION_VARIANTS_FIELD = SdkField
            .<List<ProductionVariant>> builder(MarshallingType.LIST)
            .getter(getter(CreateEndpointConfigRequest::productionVariants))
            .setter(setter(Builder::productionVariants))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductionVariants").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProductionVariant> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProductionVariant::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .getter(getter(CreateEndpointConfigRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateEndpointConfigRequest::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_CONFIG_NAME_FIELD,
            PRODUCTION_VARIANTS_FIELD, TAGS_FIELD, KMS_KEY_ID_FIELD));

    private final String endpointConfigName;

    private final List<ProductionVariant> productionVariants;

    private final List<Tag> tags;

    private final String kmsKeyId;

    private CreateEndpointConfigRequest(BuilderImpl builder) {
        super(builder);
        this.endpointConfigName = builder.endpointConfigName;
        this.productionVariants = builder.productionVariants;
        this.tags = builder.tags;
        this.kmsKeyId = builder.kmsKeyId;
    }

    /**
     * <p>
     * The name of the endpoint configuration. You specify this name in a <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateEndpoint.html">CreateEndpoint</a> request.
     * </p>
     * 
     * @return The name of the endpoint configuration. You specify this name in a <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateEndpoint.html">CreateEndpoint</a>
     *         request.
     */
    public String endpointConfigName() {
        return endpointConfigName;
    }

    /**
     * <p>
     * An list of <code>ProductionVariant</code> objects, one for each model that you want to host at this endpoint.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An list of <code>ProductionVariant</code> objects, one for each model that you want to host at this
     *         endpoint.
     */
    public List<ProductionVariant> productionVariants() {
        return productionVariants;
    }

    /**
     * <p>
     * A list of key-value pairs. For more information, see <a
     * href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what">Using
     * Cost Allocation Tags</a> in the <i> AWS Billing and Cost Management User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of key-value pairs. For more information, see <a
     *         href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what"
     *         >Using Cost Allocation Tags</a> in the <i> AWS Billing and Cost Management User Guide</i>.
     */
    public List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of a AWS Key Management Service key that Amazon SageMaker uses to encrypt data on
     * the storage volume attached to the ML compute instance that hosts the endpoint.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of a AWS Key Management Service key that Amazon SageMaker uses to encrypt
     *         data on the storage volume attached to the ML compute instance that hosts the endpoint.
     */
    public String kmsKeyId() {
        return kmsKeyId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(endpointConfigName());
        hashCode = 31 * hashCode + Objects.hashCode(productionVariants());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEndpointConfigRequest)) {
            return false;
        }
        CreateEndpointConfigRequest other = (CreateEndpointConfigRequest) obj;
        return Objects.equals(endpointConfigName(), other.endpointConfigName())
                && Objects.equals(productionVariants(), other.productionVariants()) && Objects.equals(tags(), other.tags())
                && Objects.equals(kmsKeyId(), other.kmsKeyId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateEndpointConfigRequest").add("EndpointConfigName", endpointConfigName())
                .add("ProductionVariants", productionVariants()).add("Tags", tags()).add("KmsKeyId", kmsKeyId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EndpointConfigName":
            return Optional.ofNullable(clazz.cast(endpointConfigName()));
        case "ProductionVariants":
            return Optional.ofNullable(clazz.cast(productionVariants()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateEndpointConfigRequest, T> g) {
        return obj -> g.apply((CreateEndpointConfigRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateEndpointConfigRequest> {
        /**
         * <p>
         * The name of the endpoint configuration. You specify this name in a <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateEndpoint.html">CreateEndpoint</a> request.
         * </p>
         * 
         * @param endpointConfigName
         *        The name of the endpoint configuration. You specify this name in a <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateEndpoint.html">CreateEndpoint</a>
         *        request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointConfigName(String endpointConfigName);

        /**
         * <p>
         * An list of <code>ProductionVariant</code> objects, one for each model that you want to host at this endpoint.
         * </p>
         * 
         * @param productionVariants
         *        An list of <code>ProductionVariant</code> objects, one for each model that you want to host at this
         *        endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productionVariants(Collection<ProductionVariant> productionVariants);

        /**
         * <p>
         * An list of <code>ProductionVariant</code> objects, one for each model that you want to host at this endpoint.
         * </p>
         * 
         * @param productionVariants
         *        An list of <code>ProductionVariant</code> objects, one for each model that you want to host at this
         *        endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productionVariants(ProductionVariant... productionVariants);

        /**
         * <p>
         * An list of <code>ProductionVariant</code> objects, one for each model that you want to host at this endpoint.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ProductionVariant>.Builder} avoiding the
         * need to create one manually via {@link List<ProductionVariant>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ProductionVariant>.Builder#build()} is called immediately
         * and its result is passed to {@link #productionVariants(List<ProductionVariant>)}.
         * 
         * @param productionVariants
         *        a consumer that will call methods on {@link List<ProductionVariant>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #productionVariants(List<ProductionVariant>)
         */
        Builder productionVariants(Consumer<ProductionVariant.Builder>... productionVariants);

        /**
         * <p>
         * A list of key-value pairs. For more information, see <a
         * href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what"
         * >Using Cost Allocation Tags</a> in the <i> AWS Billing and Cost Management User Guide</i>.
         * </p>
         * 
         * @param tags
         *        A list of key-value pairs. For more information, see <a href=
         *        "https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what"
         *        >Using Cost Allocation Tags</a> in the <i> AWS Billing and Cost Management User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of key-value pairs. For more information, see <a
         * href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what"
         * >Using Cost Allocation Tags</a> in the <i> AWS Billing and Cost Management User Guide</i>.
         * </p>
         * 
         * @param tags
         *        A list of key-value pairs. For more information, see <a href=
         *        "https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what"
         *        >Using Cost Allocation Tags</a> in the <i> AWS Billing and Cost Management User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of key-value pairs. For more information, see <a
         * href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what"
         * >Using Cost Allocation Tags</a> in the <i> AWS Billing and Cost Management User Guide</i>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of a AWS Key Management Service key that Amazon SageMaker uses to encrypt data
         * on the storage volume attached to the ML compute instance that hosts the endpoint.
         * </p>
         * 
         * @param kmsKeyId
         *        The Amazon Resource Name (ARN) of a AWS Key Management Service key that Amazon SageMaker uses to
         *        encrypt data on the storage volume attached to the ML compute instance that hosts the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String endpointConfigName;

        private List<ProductionVariant> productionVariants = DefaultSdkAutoConstructList.getInstance();

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String kmsKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEndpointConfigRequest model) {
            super(model);
            endpointConfigName(model.endpointConfigName);
            productionVariants(model.productionVariants);
            tags(model.tags);
            kmsKeyId(model.kmsKeyId);
        }

        public final String getEndpointConfigName() {
            return endpointConfigName;
        }

        @Override
        public final Builder endpointConfigName(String endpointConfigName) {
            this.endpointConfigName = endpointConfigName;
            return this;
        }

        public final void setEndpointConfigName(String endpointConfigName) {
            this.endpointConfigName = endpointConfigName;
        }

        public final Collection<ProductionVariant.Builder> getProductionVariants() {
            return productionVariants != null ? productionVariants.stream().map(ProductionVariant::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder productionVariants(Collection<ProductionVariant> productionVariants) {
            this.productionVariants = ProductionVariantListCopier.copy(productionVariants);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productionVariants(ProductionVariant... productionVariants) {
            productionVariants(Arrays.asList(productionVariants));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productionVariants(Consumer<ProductionVariant.Builder>... productionVariants) {
            productionVariants(Stream.of(productionVariants).map(c -> ProductionVariant.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setProductionVariants(Collection<ProductionVariant.BuilderImpl> productionVariants) {
            this.productionVariants = ProductionVariantListCopier.copyFromBuilder(productionVariants);
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateEndpointConfigRequest build() {
            return new CreateEndpointConfigRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
