/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeNotebookInstanceLifecycleConfigResponse extends SageMakerResponse
        implements
        ToCopyableBuilder<DescribeNotebookInstanceLifecycleConfigResponse.Builder, DescribeNotebookInstanceLifecycleConfigResponse> {
    private static final SdkField<String> NOTEBOOK_INSTANCE_LIFECYCLE_CONFIG_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeNotebookInstanceLifecycleConfigResponse::notebookInstanceLifecycleConfigArn))
            .setter(setter(Builder::notebookInstanceLifecycleConfigArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotebookInstanceLifecycleConfigArn")
                    .build()).build();

    private static final SdkField<String> NOTEBOOK_INSTANCE_LIFECYCLE_CONFIG_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeNotebookInstanceLifecycleConfigResponse::notebookInstanceLifecycleConfigName))
            .setter(setter(Builder::notebookInstanceLifecycleConfigName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("NotebookInstanceLifecycleConfigName").build()).build();

    private static final SdkField<List<NotebookInstanceLifecycleHook>> ON_CREATE_FIELD = SdkField
            .<List<NotebookInstanceLifecycleHook>> builder(MarshallingType.LIST)
            .getter(getter(DescribeNotebookInstanceLifecycleConfigResponse::onCreate))
            .setter(setter(Builder::onCreate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnCreate").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<NotebookInstanceLifecycleHook> builder(MarshallingType.SDK_POJO)
                                            .constructor(NotebookInstanceLifecycleHook::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<NotebookInstanceLifecycleHook>> ON_START_FIELD = SdkField
            .<List<NotebookInstanceLifecycleHook>> builder(MarshallingType.LIST)
            .getter(getter(DescribeNotebookInstanceLifecycleConfigResponse::onStart))
            .setter(setter(Builder::onStart))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnStart").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<NotebookInstanceLifecycleHook> builder(MarshallingType.SDK_POJO)
                                            .constructor(NotebookInstanceLifecycleHook::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(DescribeNotebookInstanceLifecycleConfigResponse::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(DescribeNotebookInstanceLifecycleConfigResponse::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            NOTEBOOK_INSTANCE_LIFECYCLE_CONFIG_ARN_FIELD, NOTEBOOK_INSTANCE_LIFECYCLE_CONFIG_NAME_FIELD, ON_CREATE_FIELD,
            ON_START_FIELD, LAST_MODIFIED_TIME_FIELD, CREATION_TIME_FIELD));

    private final String notebookInstanceLifecycleConfigArn;

    private final String notebookInstanceLifecycleConfigName;

    private final List<NotebookInstanceLifecycleHook> onCreate;

    private final List<NotebookInstanceLifecycleHook> onStart;

    private final Instant lastModifiedTime;

    private final Instant creationTime;

    private DescribeNotebookInstanceLifecycleConfigResponse(BuilderImpl builder) {
        super(builder);
        this.notebookInstanceLifecycleConfigArn = builder.notebookInstanceLifecycleConfigArn;
        this.notebookInstanceLifecycleConfigName = builder.notebookInstanceLifecycleConfigName;
        this.onCreate = builder.onCreate;
        this.onStart = builder.onStart;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.creationTime = builder.creationTime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the lifecycle configuration.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the lifecycle configuration.
     */
    public String notebookInstanceLifecycleConfigArn() {
        return notebookInstanceLifecycleConfigArn;
    }

    /**
     * <p>
     * The name of the lifecycle configuration.
     * </p>
     * 
     * @return The name of the lifecycle configuration.
     */
    public String notebookInstanceLifecycleConfigName() {
        return notebookInstanceLifecycleConfigName;
    }

    /**
     * <p>
     * The shell script that runs only once, when you create a notebook instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The shell script that runs only once, when you create a notebook instance.
     */
    public List<NotebookInstanceLifecycleHook> onCreate() {
        return onCreate;
    }

    /**
     * <p>
     * The shell script that runs every time you start a notebook instance, including when you create the notebook
     * instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The shell script that runs every time you start a notebook instance, including when you create the
     *         notebook instance.
     */
    public List<NotebookInstanceLifecycleHook> onStart() {
        return onStart;
    }

    /**
     * <p>
     * A timestamp that tells when the lifecycle configuration was last modified.
     * </p>
     * 
     * @return A timestamp that tells when the lifecycle configuration was last modified.
     */
    public Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * A timestamp that tells when the lifecycle configuration was created.
     * </p>
     * 
     * @return A timestamp that tells when the lifecycle configuration was created.
     */
    public Instant creationTime() {
        return creationTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(notebookInstanceLifecycleConfigArn());
        hashCode = 31 * hashCode + Objects.hashCode(notebookInstanceLifecycleConfigName());
        hashCode = 31 * hashCode + Objects.hashCode(onCreate());
        hashCode = 31 * hashCode + Objects.hashCode(onStart());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeNotebookInstanceLifecycleConfigResponse)) {
            return false;
        }
        DescribeNotebookInstanceLifecycleConfigResponse other = (DescribeNotebookInstanceLifecycleConfigResponse) obj;
        return Objects.equals(notebookInstanceLifecycleConfigArn(), other.notebookInstanceLifecycleConfigArn())
                && Objects.equals(notebookInstanceLifecycleConfigName(), other.notebookInstanceLifecycleConfigName())
                && Objects.equals(onCreate(), other.onCreate()) && Objects.equals(onStart(), other.onStart())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(creationTime(), other.creationTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeNotebookInstanceLifecycleConfigResponse")
                .add("NotebookInstanceLifecycleConfigArn", notebookInstanceLifecycleConfigArn())
                .add("NotebookInstanceLifecycleConfigName", notebookInstanceLifecycleConfigName()).add("OnCreate", onCreate())
                .add("OnStart", onStart()).add("LastModifiedTime", lastModifiedTime()).add("CreationTime", creationTime())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NotebookInstanceLifecycleConfigArn":
            return Optional.ofNullable(clazz.cast(notebookInstanceLifecycleConfigArn()));
        case "NotebookInstanceLifecycleConfigName":
            return Optional.ofNullable(clazz.cast(notebookInstanceLifecycleConfigName()));
        case "OnCreate":
            return Optional.ofNullable(clazz.cast(onCreate()));
        case "OnStart":
            return Optional.ofNullable(clazz.cast(onStart()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeNotebookInstanceLifecycleConfigResponse, T> g) {
        return obj -> g.apply((DescribeNotebookInstanceLifecycleConfigResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeNotebookInstanceLifecycleConfigResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the lifecycle configuration.
         * </p>
         * 
         * @param notebookInstanceLifecycleConfigArn
         *        The Amazon Resource Name (ARN) of the lifecycle configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notebookInstanceLifecycleConfigArn(String notebookInstanceLifecycleConfigArn);

        /**
         * <p>
         * The name of the lifecycle configuration.
         * </p>
         * 
         * @param notebookInstanceLifecycleConfigName
         *        The name of the lifecycle configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notebookInstanceLifecycleConfigName(String notebookInstanceLifecycleConfigName);

        /**
         * <p>
         * The shell script that runs only once, when you create a notebook instance.
         * </p>
         * 
         * @param onCreate
         *        The shell script that runs only once, when you create a notebook instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onCreate(Collection<NotebookInstanceLifecycleHook> onCreate);

        /**
         * <p>
         * The shell script that runs only once, when you create a notebook instance.
         * </p>
         * 
         * @param onCreate
         *        The shell script that runs only once, when you create a notebook instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onCreate(NotebookInstanceLifecycleHook... onCreate);

        /**
         * <p>
         * The shell script that runs only once, when you create a notebook instance.
         * </p>
         * This is a convenience that creates an instance of the {@link List<NotebookInstanceLifecycleHook>.Builder}
         * avoiding the need to create one manually via {@link List<NotebookInstanceLifecycleHook>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<NotebookInstanceLifecycleHook>.Builder#build()} is called
         * immediately and its result is passed to {@link #onCreate(List<NotebookInstanceLifecycleHook>)}.
         * 
         * @param onCreate
         *        a consumer that will call methods on {@link List<NotebookInstanceLifecycleHook>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #onCreate(List<NotebookInstanceLifecycleHook>)
         */
        Builder onCreate(Consumer<NotebookInstanceLifecycleHook.Builder>... onCreate);

        /**
         * <p>
         * The shell script that runs every time you start a notebook instance, including when you create the notebook
         * instance.
         * </p>
         * 
         * @param onStart
         *        The shell script that runs every time you start a notebook instance, including when you create the
         *        notebook instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onStart(Collection<NotebookInstanceLifecycleHook> onStart);

        /**
         * <p>
         * The shell script that runs every time you start a notebook instance, including when you create the notebook
         * instance.
         * </p>
         * 
         * @param onStart
         *        The shell script that runs every time you start a notebook instance, including when you create the
         *        notebook instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onStart(NotebookInstanceLifecycleHook... onStart);

        /**
         * <p>
         * The shell script that runs every time you start a notebook instance, including when you create the notebook
         * instance.
         * </p>
         * This is a convenience that creates an instance of the {@link List<NotebookInstanceLifecycleHook>.Builder}
         * avoiding the need to create one manually via {@link List<NotebookInstanceLifecycleHook>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<NotebookInstanceLifecycleHook>.Builder#build()} is called
         * immediately and its result is passed to {@link #onStart(List<NotebookInstanceLifecycleHook>)}.
         * 
         * @param onStart
         *        a consumer that will call methods on {@link List<NotebookInstanceLifecycleHook>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #onStart(List<NotebookInstanceLifecycleHook>)
         */
        Builder onStart(Consumer<NotebookInstanceLifecycleHook.Builder>... onStart);

        /**
         * <p>
         * A timestamp that tells when the lifecycle configuration was last modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        A timestamp that tells when the lifecycle configuration was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * A timestamp that tells when the lifecycle configuration was created.
         * </p>
         * 
         * @param creationTime
         *        A timestamp that tells when the lifecycle configuration was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private String notebookInstanceLifecycleConfigArn;

        private String notebookInstanceLifecycleConfigName;

        private List<NotebookInstanceLifecycleHook> onCreate = DefaultSdkAutoConstructList.getInstance();

        private List<NotebookInstanceLifecycleHook> onStart = DefaultSdkAutoConstructList.getInstance();

        private Instant lastModifiedTime;

        private Instant creationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeNotebookInstanceLifecycleConfigResponse model) {
            super(model);
            notebookInstanceLifecycleConfigArn(model.notebookInstanceLifecycleConfigArn);
            notebookInstanceLifecycleConfigName(model.notebookInstanceLifecycleConfigName);
            onCreate(model.onCreate);
            onStart(model.onStart);
            lastModifiedTime(model.lastModifiedTime);
            creationTime(model.creationTime);
        }

        public final String getNotebookInstanceLifecycleConfigArn() {
            return notebookInstanceLifecycleConfigArn;
        }

        @Override
        public final Builder notebookInstanceLifecycleConfigArn(String notebookInstanceLifecycleConfigArn) {
            this.notebookInstanceLifecycleConfigArn = notebookInstanceLifecycleConfigArn;
            return this;
        }

        public final void setNotebookInstanceLifecycleConfigArn(String notebookInstanceLifecycleConfigArn) {
            this.notebookInstanceLifecycleConfigArn = notebookInstanceLifecycleConfigArn;
        }

        public final String getNotebookInstanceLifecycleConfigName() {
            return notebookInstanceLifecycleConfigName;
        }

        @Override
        public final Builder notebookInstanceLifecycleConfigName(String notebookInstanceLifecycleConfigName) {
            this.notebookInstanceLifecycleConfigName = notebookInstanceLifecycleConfigName;
            return this;
        }

        public final void setNotebookInstanceLifecycleConfigName(String notebookInstanceLifecycleConfigName) {
            this.notebookInstanceLifecycleConfigName = notebookInstanceLifecycleConfigName;
        }

        public final Collection<NotebookInstanceLifecycleHook.Builder> getOnCreate() {
            return onCreate != null ? onCreate.stream().map(NotebookInstanceLifecycleHook::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder onCreate(Collection<NotebookInstanceLifecycleHook> onCreate) {
            this.onCreate = NotebookInstanceLifecycleConfigListCopier.copy(onCreate);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder onCreate(NotebookInstanceLifecycleHook... onCreate) {
            onCreate(Arrays.asList(onCreate));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder onCreate(Consumer<NotebookInstanceLifecycleHook.Builder>... onCreate) {
            onCreate(Stream.of(onCreate).map(c -> NotebookInstanceLifecycleHook.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setOnCreate(Collection<NotebookInstanceLifecycleHook.BuilderImpl> onCreate) {
            this.onCreate = NotebookInstanceLifecycleConfigListCopier.copyFromBuilder(onCreate);
        }

        public final Collection<NotebookInstanceLifecycleHook.Builder> getOnStart() {
            return onStart != null ? onStart.stream().map(NotebookInstanceLifecycleHook::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder onStart(Collection<NotebookInstanceLifecycleHook> onStart) {
            this.onStart = NotebookInstanceLifecycleConfigListCopier.copy(onStart);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder onStart(NotebookInstanceLifecycleHook... onStart) {
            onStart(Arrays.asList(onStart));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder onStart(Consumer<NotebookInstanceLifecycleHook.Builder>... onStart) {
            onStart(Stream.of(onStart).map(c -> NotebookInstanceLifecycleHook.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setOnStart(Collection<NotebookInstanceLifecycleHook.BuilderImpl> onStart) {
            this.onStart = NotebookInstanceLifecycleConfigListCopier.copyFromBuilder(onStart);
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public DescribeNotebookInstanceLifecycleConfigResponse build() {
            return new DescribeNotebookInstanceLifecycleConfigResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
