/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies batch transform jobs that Amazon SageMaker runs to validate your model package.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModelPackageValidationSpecification implements SdkPojo, Serializable,
        ToCopyableBuilder<ModelPackageValidationSpecification.Builder, ModelPackageValidationSpecification> {
    private static final SdkField<String> VALIDATION_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ModelPackageValidationSpecification::validationRole)).setter(setter(Builder::validationRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationRole").build()).build();

    private static final SdkField<List<ModelPackageValidationProfile>> VALIDATION_PROFILES_FIELD = SdkField
            .<List<ModelPackageValidationProfile>> builder(MarshallingType.LIST)
            .getter(getter(ModelPackageValidationSpecification::validationProfiles))
            .setter(setter(Builder::validationProfiles))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationProfiles").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ModelPackageValidationProfile> builder(MarshallingType.SDK_POJO)
                                            .constructor(ModelPackageValidationProfile::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALIDATION_ROLE_FIELD,
            VALIDATION_PROFILES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String validationRole;

    private final List<ModelPackageValidationProfile> validationProfiles;

    private ModelPackageValidationSpecification(BuilderImpl builder) {
        this.validationRole = builder.validationRole;
        this.validationProfiles = builder.validationProfiles;
    }

    /**
     * <p>
     * The IAM roles to be used for the validation of the model package.
     * </p>
     * 
     * @return The IAM roles to be used for the validation of the model package.
     */
    public String validationRole() {
        return validationRole;
    }

    /**
     * <p>
     * An array of <code>ModelPackageValidationProfile</code> objects, each of which specifies a batch transform job
     * that Amazon SageMaker runs to validate your model package.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of <code>ModelPackageValidationProfile</code> objects, each of which specifies a batch transform
     *         job that Amazon SageMaker runs to validate your model package.
     */
    public List<ModelPackageValidationProfile> validationProfiles() {
        return validationProfiles;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(validationRole());
        hashCode = 31 * hashCode + Objects.hashCode(validationProfiles());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelPackageValidationSpecification)) {
            return false;
        }
        ModelPackageValidationSpecification other = (ModelPackageValidationSpecification) obj;
        return Objects.equals(validationRole(), other.validationRole())
                && Objects.equals(validationProfiles(), other.validationProfiles());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ModelPackageValidationSpecification").add("ValidationRole", validationRole())
                .add("ValidationProfiles", validationProfiles()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ValidationRole":
            return Optional.ofNullable(clazz.cast(validationRole()));
        case "ValidationProfiles":
            return Optional.ofNullable(clazz.cast(validationProfiles()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModelPackageValidationSpecification, T> g) {
        return obj -> g.apply((ModelPackageValidationSpecification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ModelPackageValidationSpecification> {
        /**
         * <p>
         * The IAM roles to be used for the validation of the model package.
         * </p>
         * 
         * @param validationRole
         *        The IAM roles to be used for the validation of the model package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validationRole(String validationRole);

        /**
         * <p>
         * An array of <code>ModelPackageValidationProfile</code> objects, each of which specifies a batch transform job
         * that Amazon SageMaker runs to validate your model package.
         * </p>
         * 
         * @param validationProfiles
         *        An array of <code>ModelPackageValidationProfile</code> objects, each of which specifies a batch
         *        transform job that Amazon SageMaker runs to validate your model package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validationProfiles(Collection<ModelPackageValidationProfile> validationProfiles);

        /**
         * <p>
         * An array of <code>ModelPackageValidationProfile</code> objects, each of which specifies a batch transform job
         * that Amazon SageMaker runs to validate your model package.
         * </p>
         * 
         * @param validationProfiles
         *        An array of <code>ModelPackageValidationProfile</code> objects, each of which specifies a batch
         *        transform job that Amazon SageMaker runs to validate your model package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validationProfiles(ModelPackageValidationProfile... validationProfiles);

        /**
         * <p>
         * An array of <code>ModelPackageValidationProfile</code> objects, each of which specifies a batch transform job
         * that Amazon SageMaker runs to validate your model package.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ModelPackageValidationProfile>.Builder}
         * avoiding the need to create one manually via {@link List<ModelPackageValidationProfile>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ModelPackageValidationProfile>.Builder#build()} is called
         * immediately and its result is passed to {@link #validationProfiles(List<ModelPackageValidationProfile>)}.
         * 
         * @param validationProfiles
         *        a consumer that will call methods on {@link List<ModelPackageValidationProfile>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #validationProfiles(List<ModelPackageValidationProfile>)
         */
        Builder validationProfiles(Consumer<ModelPackageValidationProfile.Builder>... validationProfiles);
    }

    static final class BuilderImpl implements Builder {
        private String validationRole;

        private List<ModelPackageValidationProfile> validationProfiles = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ModelPackageValidationSpecification model) {
            validationRole(model.validationRole);
            validationProfiles(model.validationProfiles);
        }

        public final String getValidationRole() {
            return validationRole;
        }

        @Override
        public final Builder validationRole(String validationRole) {
            this.validationRole = validationRole;
            return this;
        }

        public final void setValidationRole(String validationRole) {
            this.validationRole = validationRole;
        }

        public final Collection<ModelPackageValidationProfile.Builder> getValidationProfiles() {
            return validationProfiles != null ? validationProfiles.stream().map(ModelPackageValidationProfile::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder validationProfiles(Collection<ModelPackageValidationProfile> validationProfiles) {
            this.validationProfiles = ModelPackageValidationProfilesCopier.copy(validationProfiles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validationProfiles(ModelPackageValidationProfile... validationProfiles) {
            validationProfiles(Arrays.asList(validationProfiles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validationProfiles(Consumer<ModelPackageValidationProfile.Builder>... validationProfiles) {
            validationProfiles(Stream.of(validationProfiles)
                    .map(c -> ModelPackageValidationProfile.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setValidationProfiles(Collection<ModelPackageValidationProfile.BuilderImpl> validationProfiles) {
            this.validationProfiles = ModelPackageValidationProfilesCopier.copyFromBuilder(validationProfiles);
        }

        @Override
        public ModelPackageValidationSpecification build() {
            return new ModelPackageValidationSpecification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
