/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides a summary of a notebook instance lifecycle configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NotebookInstanceLifecycleConfigSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<NotebookInstanceLifecycleConfigSummary.Builder, NotebookInstanceLifecycleConfigSummary> {
    private static final SdkField<String> NOTEBOOK_INSTANCE_LIFECYCLE_CONFIG_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(NotebookInstanceLifecycleConfigSummary::notebookInstanceLifecycleConfigName))
            .setter(setter(Builder::notebookInstanceLifecycleConfigName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("NotebookInstanceLifecycleConfigName").build()).build();

    private static final SdkField<String> NOTEBOOK_INSTANCE_LIFECYCLE_CONFIG_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(NotebookInstanceLifecycleConfigSummary::notebookInstanceLifecycleConfigArn))
            .setter(setter(Builder::notebookInstanceLifecycleConfigArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotebookInstanceLifecycleConfigArn")
                    .build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(NotebookInstanceLifecycleConfigSummary::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(NotebookInstanceLifecycleConfigSummary::lastModifiedTime)).setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            NOTEBOOK_INSTANCE_LIFECYCLE_CONFIG_NAME_FIELD, NOTEBOOK_INSTANCE_LIFECYCLE_CONFIG_ARN_FIELD, CREATION_TIME_FIELD,
            LAST_MODIFIED_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String notebookInstanceLifecycleConfigName;

    private final String notebookInstanceLifecycleConfigArn;

    private final Instant creationTime;

    private final Instant lastModifiedTime;

    private NotebookInstanceLifecycleConfigSummary(BuilderImpl builder) {
        this.notebookInstanceLifecycleConfigName = builder.notebookInstanceLifecycleConfigName;
        this.notebookInstanceLifecycleConfigArn = builder.notebookInstanceLifecycleConfigArn;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
    }

    /**
     * <p>
     * The name of the lifecycle configuration.
     * </p>
     * 
     * @return The name of the lifecycle configuration.
     */
    public String notebookInstanceLifecycleConfigName() {
        return notebookInstanceLifecycleConfigName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the lifecycle configuration.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the lifecycle configuration.
     */
    public String notebookInstanceLifecycleConfigArn() {
        return notebookInstanceLifecycleConfigArn;
    }

    /**
     * <p>
     * A timestamp that tells when the lifecycle configuration was created.
     * </p>
     * 
     * @return A timestamp that tells when the lifecycle configuration was created.
     */
    public Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * A timestamp that tells when the lifecycle configuration was last modified.
     * </p>
     * 
     * @return A timestamp that tells when the lifecycle configuration was last modified.
     */
    public Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(notebookInstanceLifecycleConfigName());
        hashCode = 31 * hashCode + Objects.hashCode(notebookInstanceLifecycleConfigArn());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NotebookInstanceLifecycleConfigSummary)) {
            return false;
        }
        NotebookInstanceLifecycleConfigSummary other = (NotebookInstanceLifecycleConfigSummary) obj;
        return Objects.equals(notebookInstanceLifecycleConfigName(), other.notebookInstanceLifecycleConfigName())
                && Objects.equals(notebookInstanceLifecycleConfigArn(), other.notebookInstanceLifecycleConfigArn())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("NotebookInstanceLifecycleConfigSummary")
                .add("NotebookInstanceLifecycleConfigName", notebookInstanceLifecycleConfigName())
                .add("NotebookInstanceLifecycleConfigArn", notebookInstanceLifecycleConfigArn())
                .add("CreationTime", creationTime()).add("LastModifiedTime", lastModifiedTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NotebookInstanceLifecycleConfigName":
            return Optional.ofNullable(clazz.cast(notebookInstanceLifecycleConfigName()));
        case "NotebookInstanceLifecycleConfigArn":
            return Optional.ofNullable(clazz.cast(notebookInstanceLifecycleConfigArn()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NotebookInstanceLifecycleConfigSummary, T> g) {
        return obj -> g.apply((NotebookInstanceLifecycleConfigSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NotebookInstanceLifecycleConfigSummary> {
        /**
         * <p>
         * The name of the lifecycle configuration.
         * </p>
         * 
         * @param notebookInstanceLifecycleConfigName
         *        The name of the lifecycle configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notebookInstanceLifecycleConfigName(String notebookInstanceLifecycleConfigName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the lifecycle configuration.
         * </p>
         * 
         * @param notebookInstanceLifecycleConfigArn
         *        The Amazon Resource Name (ARN) of the lifecycle configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notebookInstanceLifecycleConfigArn(String notebookInstanceLifecycleConfigArn);

        /**
         * <p>
         * A timestamp that tells when the lifecycle configuration was created.
         * </p>
         * 
         * @param creationTime
         *        A timestamp that tells when the lifecycle configuration was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * A timestamp that tells when the lifecycle configuration was last modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        A timestamp that tells when the lifecycle configuration was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);
    }

    static final class BuilderImpl implements Builder {
        private String notebookInstanceLifecycleConfigName;

        private String notebookInstanceLifecycleConfigArn;

        private Instant creationTime;

        private Instant lastModifiedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(NotebookInstanceLifecycleConfigSummary model) {
            notebookInstanceLifecycleConfigName(model.notebookInstanceLifecycleConfigName);
            notebookInstanceLifecycleConfigArn(model.notebookInstanceLifecycleConfigArn);
            creationTime(model.creationTime);
            lastModifiedTime(model.lastModifiedTime);
        }

        public final String getNotebookInstanceLifecycleConfigName() {
            return notebookInstanceLifecycleConfigName;
        }

        @Override
        public final Builder notebookInstanceLifecycleConfigName(String notebookInstanceLifecycleConfigName) {
            this.notebookInstanceLifecycleConfigName = notebookInstanceLifecycleConfigName;
            return this;
        }

        public final void setNotebookInstanceLifecycleConfigName(String notebookInstanceLifecycleConfigName) {
            this.notebookInstanceLifecycleConfigName = notebookInstanceLifecycleConfigName;
        }

        public final String getNotebookInstanceLifecycleConfigArn() {
            return notebookInstanceLifecycleConfigArn;
        }

        @Override
        public final Builder notebookInstanceLifecycleConfigArn(String notebookInstanceLifecycleConfigArn) {
            this.notebookInstanceLifecycleConfigArn = notebookInstanceLifecycleConfigArn;
            return this;
        }

        public final void setNotebookInstanceLifecycleConfigArn(String notebookInstanceLifecycleConfigArn) {
            this.notebookInstanceLifecycleConfigArn = notebookInstanceLifecycleConfigArn;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public NotebookInstanceLifecycleConfigSummary build() {
            return new NotebookInstanceLifecycleConfigSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
