/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An individual search result record that contains a single resource object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchRecord implements SdkPojo, Serializable, ToCopyableBuilder<SearchRecord.Builder, SearchRecord> {
    private static final SdkField<TrainingJob> TRAINING_JOB_FIELD = SdkField.<TrainingJob> builder(MarshallingType.SDK_POJO)
            .getter(getter(SearchRecord::trainingJob)).setter(setter(Builder::trainingJob)).constructor(TrainingJob::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingJob").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAINING_JOB_FIELD));

    private static final long serialVersionUID = 1L;

    private final TrainingJob trainingJob;

    private SearchRecord(BuilderImpl builder) {
        this.trainingJob = builder.trainingJob;
    }

    /**
     * <p>
     * A <code>TrainingJob</code> object that is returned as part of a <code>Search</code> request.
     * </p>
     * 
     * @return A <code>TrainingJob</code> object that is returned as part of a <code>Search</code> request.
     */
    public TrainingJob trainingJob() {
        return trainingJob;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(trainingJob());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchRecord)) {
            return false;
        }
        SearchRecord other = (SearchRecord) obj;
        return Objects.equals(trainingJob(), other.trainingJob());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SearchRecord").add("TrainingJob", trainingJob()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrainingJob":
            return Optional.ofNullable(clazz.cast(trainingJob()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchRecord, T> g) {
        return obj -> g.apply((SearchRecord) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SearchRecord> {
        /**
         * <p>
         * A <code>TrainingJob</code> object that is returned as part of a <code>Search</code> request.
         * </p>
         * 
         * @param trainingJob
         *        A <code>TrainingJob</code> object that is returned as part of a <code>Search</code> request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainingJob(TrainingJob trainingJob);

        /**
         * <p>
         * A <code>TrainingJob</code> object that is returned as part of a <code>Search</code> request.
         * </p>
         * This is a convenience that creates an instance of the {@link TrainingJob.Builder} avoiding the need to create
         * one manually via {@link TrainingJob#builder()}.
         *
         * When the {@link Consumer} completes, {@link TrainingJob.Builder#build()} is called immediately and its result
         * is passed to {@link #trainingJob(TrainingJob)}.
         * 
         * @param trainingJob
         *        a consumer that will call methods on {@link TrainingJob.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trainingJob(TrainingJob)
         */
        default Builder trainingJob(Consumer<TrainingJob.Builder> trainingJob) {
            return trainingJob(TrainingJob.builder().applyMutation(trainingJob).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private TrainingJob trainingJob;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchRecord model) {
            trainingJob(model.trainingJob);
        }

        public final TrainingJob.Builder getTrainingJob() {
            return trainingJob != null ? trainingJob.toBuilder() : null;
        }

        @Override
        public final Builder trainingJob(TrainingJob trainingJob) {
            this.trainingJob = trainingJob;
            return this;
        }

        public final void setTrainingJob(TrainingJob.BuilderImpl trainingJob) {
            this.trainingJob = trainingJob != null ? trainingJob.build() : null;
        }

        @Override
        public SearchRecord build() {
            return new SearchRecord(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
