/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies summary information about a training job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HyperParameterTrainingJobSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<HyperParameterTrainingJobSummary.Builder, HyperParameterTrainingJobSummary> {
    private static final SdkField<String> TRAINING_JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(HyperParameterTrainingJobSummary::trainingJobName)).setter(setter(Builder::trainingJobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingJobName").build()).build();

    private static final SdkField<String> TRAINING_JOB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(HyperParameterTrainingJobSummary::trainingJobArn)).setter(setter(Builder::trainingJobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingJobArn").build()).build();

    private static final SdkField<String> TUNING_JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(HyperParameterTrainingJobSummary::tuningJobName)).setter(setter(Builder::tuningJobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TuningJobName").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(HyperParameterTrainingJobSummary::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> TRAINING_START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(HyperParameterTrainingJobSummary::trainingStartTime)).setter(setter(Builder::trainingStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingStartTime").build()).build();

    private static final SdkField<Instant> TRAINING_END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(HyperParameterTrainingJobSummary::trainingEndTime)).setter(setter(Builder::trainingEndTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingEndTime").build()).build();

    private static final SdkField<String> TRAINING_JOB_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(HyperParameterTrainingJobSummary::trainingJobStatusAsString))
            .setter(setter(Builder::trainingJobStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingJobStatus").build()).build();

    private static final SdkField<Map<String, String>> TUNED_HYPER_PARAMETERS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(HyperParameterTrainingJobSummary::tunedHyperParameters))
            .setter(setter(Builder::tunedHyperParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TunedHyperParameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(HyperParameterTrainingJobSummary::failureReason)).setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()).build();

    private static final SdkField<FinalHyperParameterTuningJobObjectiveMetric> FINAL_HYPER_PARAMETER_TUNING_JOB_OBJECTIVE_METRIC_FIELD = SdkField
            .<FinalHyperParameterTuningJobObjectiveMetric> builder(MarshallingType.SDK_POJO)
            .getter(getter(HyperParameterTrainingJobSummary::finalHyperParameterTuningJobObjectiveMetric))
            .setter(setter(Builder::finalHyperParameterTuningJobObjectiveMetric))
            .constructor(FinalHyperParameterTuningJobObjectiveMetric::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("FinalHyperParameterTuningJobObjectiveMetric").build()).build();

    private static final SdkField<String> OBJECTIVE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(HyperParameterTrainingJobSummary::objectiveStatusAsString)).setter(setter(Builder::objectiveStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectiveStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAINING_JOB_NAME_FIELD,
            TRAINING_JOB_ARN_FIELD, TUNING_JOB_NAME_FIELD, CREATION_TIME_FIELD, TRAINING_START_TIME_FIELD,
            TRAINING_END_TIME_FIELD, TRAINING_JOB_STATUS_FIELD, TUNED_HYPER_PARAMETERS_FIELD, FAILURE_REASON_FIELD,
            FINAL_HYPER_PARAMETER_TUNING_JOB_OBJECTIVE_METRIC_FIELD, OBJECTIVE_STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String trainingJobName;

    private final String trainingJobArn;

    private final String tuningJobName;

    private final Instant creationTime;

    private final Instant trainingStartTime;

    private final Instant trainingEndTime;

    private final String trainingJobStatus;

    private final Map<String, String> tunedHyperParameters;

    private final String failureReason;

    private final FinalHyperParameterTuningJobObjectiveMetric finalHyperParameterTuningJobObjectiveMetric;

    private final String objectiveStatus;

    private HyperParameterTrainingJobSummary(BuilderImpl builder) {
        this.trainingJobName = builder.trainingJobName;
        this.trainingJobArn = builder.trainingJobArn;
        this.tuningJobName = builder.tuningJobName;
        this.creationTime = builder.creationTime;
        this.trainingStartTime = builder.trainingStartTime;
        this.trainingEndTime = builder.trainingEndTime;
        this.trainingJobStatus = builder.trainingJobStatus;
        this.tunedHyperParameters = builder.tunedHyperParameters;
        this.failureReason = builder.failureReason;
        this.finalHyperParameterTuningJobObjectiveMetric = builder.finalHyperParameterTuningJobObjectiveMetric;
        this.objectiveStatus = builder.objectiveStatus;
    }

    /**
     * <p>
     * The name of the training job.
     * </p>
     * 
     * @return The name of the training job.
     */
    public String trainingJobName() {
        return trainingJobName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the training job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the training job.
     */
    public String trainingJobArn() {
        return trainingJobArn;
    }

    /**
     * <p>
     * The HyperParameter tuning job that launched the training job.
     * </p>
     * 
     * @return The HyperParameter tuning job that launched the training job.
     */
    public String tuningJobName() {
        return tuningJobName;
    }

    /**
     * <p>
     * The date and time that the training job was created.
     * </p>
     * 
     * @return The date and time that the training job was created.
     */
    public Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The date and time that the training job started.
     * </p>
     * 
     * @return The date and time that the training job started.
     */
    public Instant trainingStartTime() {
        return trainingStartTime;
    }

    /**
     * <p>
     * Specifies the time when the training job ends on training instances. You are billed for the time interval between
     * the value of <code>TrainingStartTime</code> and this time. For successful jobs and stopped jobs, this is the time
     * after model artifacts are uploaded. For failed jobs, this is the time when Amazon SageMaker detects a job
     * failure.
     * </p>
     * 
     * @return Specifies the time when the training job ends on training instances. You are billed for the time interval
     *         between the value of <code>TrainingStartTime</code> and this time. For successful jobs and stopped jobs,
     *         this is the time after model artifacts are uploaded. For failed jobs, this is the time when Amazon
     *         SageMaker detects a job failure.
     */
    public Instant trainingEndTime() {
        return trainingEndTime;
    }

    /**
     * <p>
     * The status of the training job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #trainingJobStatus}
     * will return {@link TrainingJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #trainingJobStatusAsString}.
     * </p>
     * 
     * @return The status of the training job.
     * @see TrainingJobStatus
     */
    public TrainingJobStatus trainingJobStatus() {
        return TrainingJobStatus.fromValue(trainingJobStatus);
    }

    /**
     * <p>
     * The status of the training job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #trainingJobStatus}
     * will return {@link TrainingJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #trainingJobStatusAsString}.
     * </p>
     * 
     * @return The status of the training job.
     * @see TrainingJobStatus
     */
    public String trainingJobStatusAsString() {
        return trainingJobStatus;
    }

    /**
     * <p>
     * A list of the hyperparameters for which you specified ranges to search.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of the hyperparameters for which you specified ranges to search.
     */
    public Map<String, String> tunedHyperParameters() {
        return tunedHyperParameters;
    }

    /**
     * <p>
     * The reason that the training job failed.
     * </p>
     * 
     * @return The reason that the training job failed.
     */
    public String failureReason() {
        return failureReason;
    }

    /**
     * <p>
     * The <a>FinalHyperParameterTuningJobObjectiveMetric</a> object that specifies the value of the objective metric of
     * the tuning job that launched this training job.
     * </p>
     * 
     * @return The <a>FinalHyperParameterTuningJobObjectiveMetric</a> object that specifies the value of the objective
     *         metric of the tuning job that launched this training job.
     */
    public FinalHyperParameterTuningJobObjectiveMetric finalHyperParameterTuningJobObjectiveMetric() {
        return finalHyperParameterTuningJobObjectiveMetric;
    }

    /**
     * <p>
     * The status of the objective metric for the training job:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Succeeded: The final objective metric for the training job was evaluated by the hyperparameter tuning job and
     * used in the hyperparameter tuning process.
     * </p>
     * </li>
     * </ul>
     * <ul>
     * <li>
     * <p>
     * Pending: The training job is in progress and evaluation of its final objective metric is pending.
     * </p>
     * </li>
     * </ul>
     * <ul>
     * <li>
     * <p>
     * Failed: The final objective metric for the training job was not evaluated, and was not used in the hyperparameter
     * tuning process. This typically occurs when the training job failed or did not emit an objective metric.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #objectiveStatus}
     * will return {@link ObjectiveStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #objectiveStatusAsString}.
     * </p>
     * 
     * @return The status of the objective metric for the training job:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Succeeded: The final objective metric for the training job was evaluated by the hyperparameter tuning job
     *         and used in the hyperparameter tuning process.
     *         </p>
     *         </li>
     *         </ul>
     *         <ul>
     *         <li>
     *         <p>
     *         Pending: The training job is in progress and evaluation of its final objective metric is pending.
     *         </p>
     *         </li>
     *         </ul>
     *         <ul>
     *         <li>
     *         <p>
     *         Failed: The final objective metric for the training job was not evaluated, and was not used in the
     *         hyperparameter tuning process. This typically occurs when the training job failed or did not emit an
     *         objective metric.
     *         </p>
     *         </li>
     * @see ObjectiveStatus
     */
    public ObjectiveStatus objectiveStatus() {
        return ObjectiveStatus.fromValue(objectiveStatus);
    }

    /**
     * <p>
     * The status of the objective metric for the training job:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Succeeded: The final objective metric for the training job was evaluated by the hyperparameter tuning job and
     * used in the hyperparameter tuning process.
     * </p>
     * </li>
     * </ul>
     * <ul>
     * <li>
     * <p>
     * Pending: The training job is in progress and evaluation of its final objective metric is pending.
     * </p>
     * </li>
     * </ul>
     * <ul>
     * <li>
     * <p>
     * Failed: The final objective metric for the training job was not evaluated, and was not used in the hyperparameter
     * tuning process. This typically occurs when the training job failed or did not emit an objective metric.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #objectiveStatus}
     * will return {@link ObjectiveStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #objectiveStatusAsString}.
     * </p>
     * 
     * @return The status of the objective metric for the training job:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Succeeded: The final objective metric for the training job was evaluated by the hyperparameter tuning job
     *         and used in the hyperparameter tuning process.
     *         </p>
     *         </li>
     *         </ul>
     *         <ul>
     *         <li>
     *         <p>
     *         Pending: The training job is in progress and evaluation of its final objective metric is pending.
     *         </p>
     *         </li>
     *         </ul>
     *         <ul>
     *         <li>
     *         <p>
     *         Failed: The final objective metric for the training job was not evaluated, and was not used in the
     *         hyperparameter tuning process. This typically occurs when the training job failed or did not emit an
     *         objective metric.
     *         </p>
     *         </li>
     * @see ObjectiveStatus
     */
    public String objectiveStatusAsString() {
        return objectiveStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(trainingJobName());
        hashCode = 31 * hashCode + Objects.hashCode(trainingJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(tuningJobName());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(trainingStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(trainingEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(trainingJobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(tunedHyperParameters());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(finalHyperParameterTuningJobObjectiveMetric());
        hashCode = 31 * hashCode + Objects.hashCode(objectiveStatusAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HyperParameterTrainingJobSummary)) {
            return false;
        }
        HyperParameterTrainingJobSummary other = (HyperParameterTrainingJobSummary) obj;
        return Objects.equals(trainingJobName(), other.trainingJobName())
                && Objects.equals(trainingJobArn(), other.trainingJobArn())
                && Objects.equals(tuningJobName(), other.tuningJobName())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(trainingStartTime(), other.trainingStartTime())
                && Objects.equals(trainingEndTime(), other.trainingEndTime())
                && Objects.equals(trainingJobStatusAsString(), other.trainingJobStatusAsString())
                && Objects.equals(tunedHyperParameters(), other.tunedHyperParameters())
                && Objects.equals(failureReason(), other.failureReason())
                && Objects.equals(finalHyperParameterTuningJobObjectiveMetric(),
                        other.finalHyperParameterTuningJobObjectiveMetric())
                && Objects.equals(objectiveStatusAsString(), other.objectiveStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("HyperParameterTrainingJobSummary").add("TrainingJobName", trainingJobName())
                .add("TrainingJobArn", trainingJobArn()).add("TuningJobName", tuningJobName())
                .add("CreationTime", creationTime()).add("TrainingStartTime", trainingStartTime())
                .add("TrainingEndTime", trainingEndTime()).add("TrainingJobStatus", trainingJobStatusAsString())
                .add("TunedHyperParameters", tunedHyperParameters()).add("FailureReason", failureReason())
                .add("FinalHyperParameterTuningJobObjectiveMetric", finalHyperParameterTuningJobObjectiveMetric())
                .add("ObjectiveStatus", objectiveStatusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrainingJobName":
            return Optional.ofNullable(clazz.cast(trainingJobName()));
        case "TrainingJobArn":
            return Optional.ofNullable(clazz.cast(trainingJobArn()));
        case "TuningJobName":
            return Optional.ofNullable(clazz.cast(tuningJobName()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "TrainingStartTime":
            return Optional.ofNullable(clazz.cast(trainingStartTime()));
        case "TrainingEndTime":
            return Optional.ofNullable(clazz.cast(trainingEndTime()));
        case "TrainingJobStatus":
            return Optional.ofNullable(clazz.cast(trainingJobStatusAsString()));
        case "TunedHyperParameters":
            return Optional.ofNullable(clazz.cast(tunedHyperParameters()));
        case "FailureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        case "FinalHyperParameterTuningJobObjectiveMetric":
            return Optional.ofNullable(clazz.cast(finalHyperParameterTuningJobObjectiveMetric()));
        case "ObjectiveStatus":
            return Optional.ofNullable(clazz.cast(objectiveStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HyperParameterTrainingJobSummary, T> g) {
        return obj -> g.apply((HyperParameterTrainingJobSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HyperParameterTrainingJobSummary> {
        /**
         * <p>
         * The name of the training job.
         * </p>
         * 
         * @param trainingJobName
         *        The name of the training job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainingJobName(String trainingJobName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the training job.
         * </p>
         * 
         * @param trainingJobArn
         *        The Amazon Resource Name (ARN) of the training job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainingJobArn(String trainingJobArn);

        /**
         * <p>
         * The HyperParameter tuning job that launched the training job.
         * </p>
         * 
         * @param tuningJobName
         *        The HyperParameter tuning job that launched the training job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tuningJobName(String tuningJobName);

        /**
         * <p>
         * The date and time that the training job was created.
         * </p>
         * 
         * @param creationTime
         *        The date and time that the training job was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The date and time that the training job started.
         * </p>
         * 
         * @param trainingStartTime
         *        The date and time that the training job started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainingStartTime(Instant trainingStartTime);

        /**
         * <p>
         * Specifies the time when the training job ends on training instances. You are billed for the time interval
         * between the value of <code>TrainingStartTime</code> and this time. For successful jobs and stopped jobs, this
         * is the time after model artifacts are uploaded. For failed jobs, this is the time when Amazon SageMaker
         * detects a job failure.
         * </p>
         * 
         * @param trainingEndTime
         *        Specifies the time when the training job ends on training instances. You are billed for the time
         *        interval between the value of <code>TrainingStartTime</code> and this time. For successful jobs and
         *        stopped jobs, this is the time after model artifacts are uploaded. For failed jobs, this is the time
         *        when Amazon SageMaker detects a job failure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainingEndTime(Instant trainingEndTime);

        /**
         * <p>
         * The status of the training job.
         * </p>
         * 
         * @param trainingJobStatus
         *        The status of the training job.
         * @see TrainingJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrainingJobStatus
         */
        Builder trainingJobStatus(String trainingJobStatus);

        /**
         * <p>
         * The status of the training job.
         * </p>
         * 
         * @param trainingJobStatus
         *        The status of the training job.
         * @see TrainingJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrainingJobStatus
         */
        Builder trainingJobStatus(TrainingJobStatus trainingJobStatus);

        /**
         * <p>
         * A list of the hyperparameters for which you specified ranges to search.
         * </p>
         * 
         * @param tunedHyperParameters
         *        A list of the hyperparameters for which you specified ranges to search.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tunedHyperParameters(Map<String, String> tunedHyperParameters);

        /**
         * <p>
         * The reason that the training job failed.
         * </p>
         * 
         * @param failureReason
         *        The reason that the training job failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);

        /**
         * <p>
         * The <a>FinalHyperParameterTuningJobObjectiveMetric</a> object that specifies the value of the objective
         * metric of the tuning job that launched this training job.
         * </p>
         * 
         * @param finalHyperParameterTuningJobObjectiveMetric
         *        The <a>FinalHyperParameterTuningJobObjectiveMetric</a> object that specifies the value of the
         *        objective metric of the tuning job that launched this training job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder finalHyperParameterTuningJobObjectiveMetric(
                FinalHyperParameterTuningJobObjectiveMetric finalHyperParameterTuningJobObjectiveMetric);

        /**
         * <p>
         * The <a>FinalHyperParameterTuningJobObjectiveMetric</a> object that specifies the value of the objective
         * metric of the tuning job that launched this training job.
         * </p>
         * This is a convenience that creates an instance of the
         * {@link FinalHyperParameterTuningJobObjectiveMetric.Builder} avoiding the need to create one manually via
         * {@link FinalHyperParameterTuningJobObjectiveMetric#builder()}.
         *
         * When the {@link Consumer} completes, {@link FinalHyperParameterTuningJobObjectiveMetric.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #finalHyperParameterTuningJobObjectiveMetric(FinalHyperParameterTuningJobObjectiveMetric)}.
         * 
         * @param finalHyperParameterTuningJobObjectiveMetric
         *        a consumer that will call methods on {@link FinalHyperParameterTuningJobObjectiveMetric.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #finalHyperParameterTuningJobObjectiveMetric(FinalHyperParameterTuningJobObjectiveMetric)
         */
        default Builder finalHyperParameterTuningJobObjectiveMetric(
                Consumer<FinalHyperParameterTuningJobObjectiveMetric.Builder> finalHyperParameterTuningJobObjectiveMetric) {
            return finalHyperParameterTuningJobObjectiveMetric(FinalHyperParameterTuningJobObjectiveMetric.builder()
                    .applyMutation(finalHyperParameterTuningJobObjectiveMetric).build());
        }

        /**
         * <p>
         * The status of the objective metric for the training job:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Succeeded: The final objective metric for the training job was evaluated by the hyperparameter tuning job and
         * used in the hyperparameter tuning process.
         * </p>
         * </li>
         * </ul>
         * <ul>
         * <li>
         * <p>
         * Pending: The training job is in progress and evaluation of its final objective metric is pending.
         * </p>
         * </li>
         * </ul>
         * <ul>
         * <li>
         * <p>
         * Failed: The final objective metric for the training job was not evaluated, and was not used in the
         * hyperparameter tuning process. This typically occurs when the training job failed or did not emit an
         * objective metric.
         * </p>
         * </li>
         * </ul>
         * 
         * @param objectiveStatus
         *        The status of the objective metric for the training job:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Succeeded: The final objective metric for the training job was evaluated by the hyperparameter tuning
         *        job and used in the hyperparameter tuning process.
         *        </p>
         *        </li>
         *        </ul>
         *        <ul>
         *        <li>
         *        <p>
         *        Pending: The training job is in progress and evaluation of its final objective metric is pending.
         *        </p>
         *        </li>
         *        </ul>
         *        <ul>
         *        <li>
         *        <p>
         *        Failed: The final objective metric for the training job was not evaluated, and was not used in the
         *        hyperparameter tuning process. This typically occurs when the training job failed or did not emit an
         *        objective metric.
         *        </p>
         *        </li>
         * @see ObjectiveStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ObjectiveStatus
         */
        Builder objectiveStatus(String objectiveStatus);

        /**
         * <p>
         * The status of the objective metric for the training job:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Succeeded: The final objective metric for the training job was evaluated by the hyperparameter tuning job and
         * used in the hyperparameter tuning process.
         * </p>
         * </li>
         * </ul>
         * <ul>
         * <li>
         * <p>
         * Pending: The training job is in progress and evaluation of its final objective metric is pending.
         * </p>
         * </li>
         * </ul>
         * <ul>
         * <li>
         * <p>
         * Failed: The final objective metric for the training job was not evaluated, and was not used in the
         * hyperparameter tuning process. This typically occurs when the training job failed or did not emit an
         * objective metric.
         * </p>
         * </li>
         * </ul>
         * 
         * @param objectiveStatus
         *        The status of the objective metric for the training job:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Succeeded: The final objective metric for the training job was evaluated by the hyperparameter tuning
         *        job and used in the hyperparameter tuning process.
         *        </p>
         *        </li>
         *        </ul>
         *        <ul>
         *        <li>
         *        <p>
         *        Pending: The training job is in progress and evaluation of its final objective metric is pending.
         *        </p>
         *        </li>
         *        </ul>
         *        <ul>
         *        <li>
         *        <p>
         *        Failed: The final objective metric for the training job was not evaluated, and was not used in the
         *        hyperparameter tuning process. This typically occurs when the training job failed or did not emit an
         *        objective metric.
         *        </p>
         *        </li>
         * @see ObjectiveStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ObjectiveStatus
         */
        Builder objectiveStatus(ObjectiveStatus objectiveStatus);
    }

    static final class BuilderImpl implements Builder {
        private String trainingJobName;

        private String trainingJobArn;

        private String tuningJobName;

        private Instant creationTime;

        private Instant trainingStartTime;

        private Instant trainingEndTime;

        private String trainingJobStatus;

        private Map<String, String> tunedHyperParameters = DefaultSdkAutoConstructMap.getInstance();

        private String failureReason;

        private FinalHyperParameterTuningJobObjectiveMetric finalHyperParameterTuningJobObjectiveMetric;

        private String objectiveStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(HyperParameterTrainingJobSummary model) {
            trainingJobName(model.trainingJobName);
            trainingJobArn(model.trainingJobArn);
            tuningJobName(model.tuningJobName);
            creationTime(model.creationTime);
            trainingStartTime(model.trainingStartTime);
            trainingEndTime(model.trainingEndTime);
            trainingJobStatus(model.trainingJobStatus);
            tunedHyperParameters(model.tunedHyperParameters);
            failureReason(model.failureReason);
            finalHyperParameterTuningJobObjectiveMetric(model.finalHyperParameterTuningJobObjectiveMetric);
            objectiveStatus(model.objectiveStatus);
        }

        public final String getTrainingJobName() {
            return trainingJobName;
        }

        @Override
        public final Builder trainingJobName(String trainingJobName) {
            this.trainingJobName = trainingJobName;
            return this;
        }

        public final void setTrainingJobName(String trainingJobName) {
            this.trainingJobName = trainingJobName;
        }

        public final String getTrainingJobArn() {
            return trainingJobArn;
        }

        @Override
        public final Builder trainingJobArn(String trainingJobArn) {
            this.trainingJobArn = trainingJobArn;
            return this;
        }

        public final void setTrainingJobArn(String trainingJobArn) {
            this.trainingJobArn = trainingJobArn;
        }

        public final String getTuningJobName() {
            return tuningJobName;
        }

        @Override
        public final Builder tuningJobName(String tuningJobName) {
            this.tuningJobName = tuningJobName;
            return this;
        }

        public final void setTuningJobName(String tuningJobName) {
            this.tuningJobName = tuningJobName;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getTrainingStartTime() {
            return trainingStartTime;
        }

        @Override
        public final Builder trainingStartTime(Instant trainingStartTime) {
            this.trainingStartTime = trainingStartTime;
            return this;
        }

        public final void setTrainingStartTime(Instant trainingStartTime) {
            this.trainingStartTime = trainingStartTime;
        }

        public final Instant getTrainingEndTime() {
            return trainingEndTime;
        }

        @Override
        public final Builder trainingEndTime(Instant trainingEndTime) {
            this.trainingEndTime = trainingEndTime;
            return this;
        }

        public final void setTrainingEndTime(Instant trainingEndTime) {
            this.trainingEndTime = trainingEndTime;
        }

        public final String getTrainingJobStatusAsString() {
            return trainingJobStatus;
        }

        @Override
        public final Builder trainingJobStatus(String trainingJobStatus) {
            this.trainingJobStatus = trainingJobStatus;
            return this;
        }

        @Override
        public final Builder trainingJobStatus(TrainingJobStatus trainingJobStatus) {
            this.trainingJobStatus(trainingJobStatus == null ? null : trainingJobStatus.toString());
            return this;
        }

        public final void setTrainingJobStatus(String trainingJobStatus) {
            this.trainingJobStatus = trainingJobStatus;
        }

        public final Map<String, String> getTunedHyperParameters() {
            return tunedHyperParameters;
        }

        @Override
        public final Builder tunedHyperParameters(Map<String, String> tunedHyperParameters) {
            this.tunedHyperParameters = HyperParametersCopier.copy(tunedHyperParameters);
            return this;
        }

        public final void setTunedHyperParameters(Map<String, String> tunedHyperParameters) {
            this.tunedHyperParameters = HyperParametersCopier.copy(tunedHyperParameters);
        }

        public final String getFailureReason() {
            return failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        public final FinalHyperParameterTuningJobObjectiveMetric.Builder getFinalHyperParameterTuningJobObjectiveMetric() {
            return finalHyperParameterTuningJobObjectiveMetric != null ? finalHyperParameterTuningJobObjectiveMetric.toBuilder()
                    : null;
        }

        @Override
        public final Builder finalHyperParameterTuningJobObjectiveMetric(
                FinalHyperParameterTuningJobObjectiveMetric finalHyperParameterTuningJobObjectiveMetric) {
            this.finalHyperParameterTuningJobObjectiveMetric = finalHyperParameterTuningJobObjectiveMetric;
            return this;
        }

        public final void setFinalHyperParameterTuningJobObjectiveMetric(
                FinalHyperParameterTuningJobObjectiveMetric.BuilderImpl finalHyperParameterTuningJobObjectiveMetric) {
            this.finalHyperParameterTuningJobObjectiveMetric = finalHyperParameterTuningJobObjectiveMetric != null ? finalHyperParameterTuningJobObjectiveMetric
                    .build() : null;
        }

        public final String getObjectiveStatusAsString() {
            return objectiveStatus;
        }

        @Override
        public final Builder objectiveStatus(String objectiveStatus) {
            this.objectiveStatus = objectiveStatus;
            return this;
        }

        @Override
        public final Builder objectiveStatus(ObjectiveStatus objectiveStatus) {
            this.objectiveStatus(objectiveStatus == null ? null : objectiveStatus.toString());
            return this;
        }

        public final void setObjectiveStatus(String objectiveStatus) {
            this.objectiveStatus = objectiveStatus;
        }

        @Override
        public HyperParameterTrainingJobSummary build() {
            return new HyperParameterTrainingJobSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
