/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines how to perform inference generation after a training job is run.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InferenceSpecification implements SdkPojo, Serializable,
        ToCopyableBuilder<InferenceSpecification.Builder, InferenceSpecification> {
    private static final SdkField<List<ModelPackageContainerDefinition>> CONTAINERS_FIELD = SdkField
            .<List<ModelPackageContainerDefinition>> builder(MarshallingType.LIST)
            .getter(getter(InferenceSpecification::containers))
            .setter(setter(Builder::containers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Containers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ModelPackageContainerDefinition> builder(MarshallingType.SDK_POJO)
                                            .constructor(ModelPackageContainerDefinition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SUPPORTED_TRANSFORM_INSTANCE_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(InferenceSpecification::supportedTransformInstanceTypesAsStrings))
            .setter(setter(Builder::supportedTransformInstanceTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedTransformInstanceTypes")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SUPPORTED_REALTIME_INFERENCE_INSTANCE_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(InferenceSpecification::supportedRealtimeInferenceInstanceTypesAsStrings))
            .setter(setter(Builder::supportedRealtimeInferenceInstanceTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("SupportedRealtimeInferenceInstanceTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SUPPORTED_CONTENT_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(InferenceSpecification::supportedContentTypes))
            .setter(setter(Builder::supportedContentTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedContentTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SUPPORTED_RESPONSE_MIME_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(InferenceSpecification::supportedResponseMIMETypes))
            .setter(setter(Builder::supportedResponseMIMETypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedResponseMIMETypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINERS_FIELD,
            SUPPORTED_TRANSFORM_INSTANCE_TYPES_FIELD, SUPPORTED_REALTIME_INFERENCE_INSTANCE_TYPES_FIELD,
            SUPPORTED_CONTENT_TYPES_FIELD, SUPPORTED_RESPONSE_MIME_TYPES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<ModelPackageContainerDefinition> containers;

    private final List<String> supportedTransformInstanceTypes;

    private final List<String> supportedRealtimeInferenceInstanceTypes;

    private final List<String> supportedContentTypes;

    private final List<String> supportedResponseMIMETypes;

    private InferenceSpecification(BuilderImpl builder) {
        this.containers = builder.containers;
        this.supportedTransformInstanceTypes = builder.supportedTransformInstanceTypes;
        this.supportedRealtimeInferenceInstanceTypes = builder.supportedRealtimeInferenceInstanceTypes;
        this.supportedContentTypes = builder.supportedContentTypes;
        this.supportedResponseMIMETypes = builder.supportedResponseMIMETypes;
    }

    /**
     * <p>
     * The Amazon ECR registry path of the Docker image that contains the inference code.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The Amazon ECR registry path of the Docker image that contains the inference code.
     */
    public List<ModelPackageContainerDefinition> containers() {
        return containers;
    }

    /**
     * <p>
     * A list of the instance types on which a transformation job can be run or on which an endpoint can be deployed.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of the instance types on which a transformation job can be run or on which an endpoint can be
     *         deployed.
     */
    public List<TransformInstanceType> supportedTransformInstanceTypes() {
        return TransformInstanceTypesCopier.copyStringToEnum(supportedTransformInstanceTypes);
    }

    /**
     * <p>
     * A list of the instance types on which a transformation job can be run or on which an endpoint can be deployed.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of the instance types on which a transformation job can be run or on which an endpoint can be
     *         deployed.
     */
    public List<String> supportedTransformInstanceTypesAsStrings() {
        return supportedTransformInstanceTypes;
    }

    /**
     * <p>
     * A list of the instance types that are used to generate inferences in real-time.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of the instance types that are used to generate inferences in real-time.
     */
    public List<ProductionVariantInstanceType> supportedRealtimeInferenceInstanceTypes() {
        return RealtimeInferenceInstanceTypesCopier.copyStringToEnum(supportedRealtimeInferenceInstanceTypes);
    }

    /**
     * <p>
     * A list of the instance types that are used to generate inferences in real-time.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of the instance types that are used to generate inferences in real-time.
     */
    public List<String> supportedRealtimeInferenceInstanceTypesAsStrings() {
        return supportedRealtimeInferenceInstanceTypes;
    }

    /**
     * <p>
     * The supported MIME types for the input data.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The supported MIME types for the input data.
     */
    public List<String> supportedContentTypes() {
        return supportedContentTypes;
    }

    /**
     * <p>
     * The supported MIME types for the output data.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The supported MIME types for the output data.
     */
    public List<String> supportedResponseMIMETypes() {
        return supportedResponseMIMETypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(containers());
        hashCode = 31 * hashCode + Objects.hashCode(supportedTransformInstanceTypesAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(supportedRealtimeInferenceInstanceTypesAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(supportedContentTypes());
        hashCode = 31 * hashCode + Objects.hashCode(supportedResponseMIMETypes());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InferenceSpecification)) {
            return false;
        }
        InferenceSpecification other = (InferenceSpecification) obj;
        return Objects.equals(containers(), other.containers())
                && Objects.equals(supportedTransformInstanceTypesAsStrings(), other.supportedTransformInstanceTypesAsStrings())
                && Objects.equals(supportedRealtimeInferenceInstanceTypesAsStrings(),
                        other.supportedRealtimeInferenceInstanceTypesAsStrings())
                && Objects.equals(supportedContentTypes(), other.supportedContentTypes())
                && Objects.equals(supportedResponseMIMETypes(), other.supportedResponseMIMETypes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("InferenceSpecification").add("Containers", containers())
                .add("SupportedTransformInstanceTypes", supportedTransformInstanceTypesAsStrings())
                .add("SupportedRealtimeInferenceInstanceTypes", supportedRealtimeInferenceInstanceTypesAsStrings())
                .add("SupportedContentTypes", supportedContentTypes())
                .add("SupportedResponseMIMETypes", supportedResponseMIMETypes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Containers":
            return Optional.ofNullable(clazz.cast(containers()));
        case "SupportedTransformInstanceTypes":
            return Optional.ofNullable(clazz.cast(supportedTransformInstanceTypesAsStrings()));
        case "SupportedRealtimeInferenceInstanceTypes":
            return Optional.ofNullable(clazz.cast(supportedRealtimeInferenceInstanceTypesAsStrings()));
        case "SupportedContentTypes":
            return Optional.ofNullable(clazz.cast(supportedContentTypes()));
        case "SupportedResponseMIMETypes":
            return Optional.ofNullable(clazz.cast(supportedResponseMIMETypes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InferenceSpecification, T> g) {
        return obj -> g.apply((InferenceSpecification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InferenceSpecification> {
        /**
         * <p>
         * The Amazon ECR registry path of the Docker image that contains the inference code.
         * </p>
         * 
         * @param containers
         *        The Amazon ECR registry path of the Docker image that contains the inference code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containers(Collection<ModelPackageContainerDefinition> containers);

        /**
         * <p>
         * The Amazon ECR registry path of the Docker image that contains the inference code.
         * </p>
         * 
         * @param containers
         *        The Amazon ECR registry path of the Docker image that contains the inference code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containers(ModelPackageContainerDefinition... containers);

        /**
         * <p>
         * The Amazon ECR registry path of the Docker image that contains the inference code.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ModelPackageContainerDefinition>.Builder}
         * avoiding the need to create one manually via {@link List<ModelPackageContainerDefinition>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ModelPackageContainerDefinition>.Builder#build()} is called
         * immediately and its result is passed to {@link #containers(List<ModelPackageContainerDefinition>)}.
         * 
         * @param containers
         *        a consumer that will call methods on {@link List<ModelPackageContainerDefinition>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #containers(List<ModelPackageContainerDefinition>)
         */
        Builder containers(Consumer<ModelPackageContainerDefinition.Builder>... containers);

        /**
         * <p>
         * A list of the instance types on which a transformation job can be run or on which an endpoint can be
         * deployed.
         * </p>
         * 
         * @param supportedTransformInstanceTypes
         *        A list of the instance types on which a transformation job can be run or on which an endpoint can be
         *        deployed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedTransformInstanceTypesWithStrings(Collection<String> supportedTransformInstanceTypes);

        /**
         * <p>
         * A list of the instance types on which a transformation job can be run or on which an endpoint can be
         * deployed.
         * </p>
         * 
         * @param supportedTransformInstanceTypes
         *        A list of the instance types on which a transformation job can be run or on which an endpoint can be
         *        deployed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedTransformInstanceTypesWithStrings(String... supportedTransformInstanceTypes);

        /**
         * <p>
         * A list of the instance types on which a transformation job can be run or on which an endpoint can be
         * deployed.
         * </p>
         * 
         * @param supportedTransformInstanceTypes
         *        A list of the instance types on which a transformation job can be run or on which an endpoint can be
         *        deployed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedTransformInstanceTypes(Collection<TransformInstanceType> supportedTransformInstanceTypes);

        /**
         * <p>
         * A list of the instance types on which a transformation job can be run or on which an endpoint can be
         * deployed.
         * </p>
         * 
         * @param supportedTransformInstanceTypes
         *        A list of the instance types on which a transformation job can be run or on which an endpoint can be
         *        deployed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedTransformInstanceTypes(TransformInstanceType... supportedTransformInstanceTypes);

        /**
         * <p>
         * A list of the instance types that are used to generate inferences in real-time.
         * </p>
         * 
         * @param supportedRealtimeInferenceInstanceTypes
         *        A list of the instance types that are used to generate inferences in real-time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedRealtimeInferenceInstanceTypesWithStrings(Collection<String> supportedRealtimeInferenceInstanceTypes);

        /**
         * <p>
         * A list of the instance types that are used to generate inferences in real-time.
         * </p>
         * 
         * @param supportedRealtimeInferenceInstanceTypes
         *        A list of the instance types that are used to generate inferences in real-time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedRealtimeInferenceInstanceTypesWithStrings(String... supportedRealtimeInferenceInstanceTypes);

        /**
         * <p>
         * A list of the instance types that are used to generate inferences in real-time.
         * </p>
         * 
         * @param supportedRealtimeInferenceInstanceTypes
         *        A list of the instance types that are used to generate inferences in real-time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedRealtimeInferenceInstanceTypes(
                Collection<ProductionVariantInstanceType> supportedRealtimeInferenceInstanceTypes);

        /**
         * <p>
         * A list of the instance types that are used to generate inferences in real-time.
         * </p>
         * 
         * @param supportedRealtimeInferenceInstanceTypes
         *        A list of the instance types that are used to generate inferences in real-time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedRealtimeInferenceInstanceTypes(ProductionVariantInstanceType... supportedRealtimeInferenceInstanceTypes);

        /**
         * <p>
         * The supported MIME types for the input data.
         * </p>
         * 
         * @param supportedContentTypes
         *        The supported MIME types for the input data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedContentTypes(Collection<String> supportedContentTypes);

        /**
         * <p>
         * The supported MIME types for the input data.
         * </p>
         * 
         * @param supportedContentTypes
         *        The supported MIME types for the input data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedContentTypes(String... supportedContentTypes);

        /**
         * <p>
         * The supported MIME types for the output data.
         * </p>
         * 
         * @param supportedResponseMIMETypes
         *        The supported MIME types for the output data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedResponseMIMETypes(Collection<String> supportedResponseMIMETypes);

        /**
         * <p>
         * The supported MIME types for the output data.
         * </p>
         * 
         * @param supportedResponseMIMETypes
         *        The supported MIME types for the output data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedResponseMIMETypes(String... supportedResponseMIMETypes);
    }

    static final class BuilderImpl implements Builder {
        private List<ModelPackageContainerDefinition> containers = DefaultSdkAutoConstructList.getInstance();

        private List<String> supportedTransformInstanceTypes = DefaultSdkAutoConstructList.getInstance();

        private List<String> supportedRealtimeInferenceInstanceTypes = DefaultSdkAutoConstructList.getInstance();

        private List<String> supportedContentTypes = DefaultSdkAutoConstructList.getInstance();

        private List<String> supportedResponseMIMETypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InferenceSpecification model) {
            containers(model.containers);
            supportedTransformInstanceTypesWithStrings(model.supportedTransformInstanceTypes);
            supportedRealtimeInferenceInstanceTypesWithStrings(model.supportedRealtimeInferenceInstanceTypes);
            supportedContentTypes(model.supportedContentTypes);
            supportedResponseMIMETypes(model.supportedResponseMIMETypes);
        }

        public final Collection<ModelPackageContainerDefinition.Builder> getContainers() {
            return containers != null ? containers.stream().map(ModelPackageContainerDefinition::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder containers(Collection<ModelPackageContainerDefinition> containers) {
            this.containers = ModelPackageContainerDefinitionListCopier.copy(containers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containers(ModelPackageContainerDefinition... containers) {
            containers(Arrays.asList(containers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containers(Consumer<ModelPackageContainerDefinition.Builder>... containers) {
            containers(Stream.of(containers).map(c -> ModelPackageContainerDefinition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setContainers(Collection<ModelPackageContainerDefinition.BuilderImpl> containers) {
            this.containers = ModelPackageContainerDefinitionListCopier.copyFromBuilder(containers);
        }

        public final Collection<String> getSupportedTransformInstanceTypesAsStrings() {
            return supportedTransformInstanceTypes;
        }

        @Override
        public final Builder supportedTransformInstanceTypesWithStrings(Collection<String> supportedTransformInstanceTypes) {
            this.supportedTransformInstanceTypes = TransformInstanceTypesCopier.copy(supportedTransformInstanceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedTransformInstanceTypesWithStrings(String... supportedTransformInstanceTypes) {
            supportedTransformInstanceTypesWithStrings(Arrays.asList(supportedTransformInstanceTypes));
            return this;
        }

        @Override
        public final Builder supportedTransformInstanceTypes(Collection<TransformInstanceType> supportedTransformInstanceTypes) {
            this.supportedTransformInstanceTypes = TransformInstanceTypesCopier.copyEnumToString(supportedTransformInstanceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedTransformInstanceTypes(TransformInstanceType... supportedTransformInstanceTypes) {
            supportedTransformInstanceTypes(Arrays.asList(supportedTransformInstanceTypes));
            return this;
        }

        public final void setSupportedTransformInstanceTypesWithStrings(Collection<String> supportedTransformInstanceTypes) {
            this.supportedTransformInstanceTypes = TransformInstanceTypesCopier.copy(supportedTransformInstanceTypes);
        }

        public final Collection<String> getSupportedRealtimeInferenceInstanceTypesAsStrings() {
            return supportedRealtimeInferenceInstanceTypes;
        }

        @Override
        public final Builder supportedRealtimeInferenceInstanceTypesWithStrings(
                Collection<String> supportedRealtimeInferenceInstanceTypes) {
            this.supportedRealtimeInferenceInstanceTypes = RealtimeInferenceInstanceTypesCopier
                    .copy(supportedRealtimeInferenceInstanceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedRealtimeInferenceInstanceTypesWithStrings(String... supportedRealtimeInferenceInstanceTypes) {
            supportedRealtimeInferenceInstanceTypesWithStrings(Arrays.asList(supportedRealtimeInferenceInstanceTypes));
            return this;
        }

        @Override
        public final Builder supportedRealtimeInferenceInstanceTypes(
                Collection<ProductionVariantInstanceType> supportedRealtimeInferenceInstanceTypes) {
            this.supportedRealtimeInferenceInstanceTypes = RealtimeInferenceInstanceTypesCopier
                    .copyEnumToString(supportedRealtimeInferenceInstanceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedRealtimeInferenceInstanceTypes(
                ProductionVariantInstanceType... supportedRealtimeInferenceInstanceTypes) {
            supportedRealtimeInferenceInstanceTypes(Arrays.asList(supportedRealtimeInferenceInstanceTypes));
            return this;
        }

        public final void setSupportedRealtimeInferenceInstanceTypesWithStrings(
                Collection<String> supportedRealtimeInferenceInstanceTypes) {
            this.supportedRealtimeInferenceInstanceTypes = RealtimeInferenceInstanceTypesCopier
                    .copy(supportedRealtimeInferenceInstanceTypes);
        }

        public final Collection<String> getSupportedContentTypes() {
            return supportedContentTypes;
        }

        @Override
        public final Builder supportedContentTypes(Collection<String> supportedContentTypes) {
            this.supportedContentTypes = ContentTypesCopier.copy(supportedContentTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedContentTypes(String... supportedContentTypes) {
            supportedContentTypes(Arrays.asList(supportedContentTypes));
            return this;
        }

        public final void setSupportedContentTypes(Collection<String> supportedContentTypes) {
            this.supportedContentTypes = ContentTypesCopier.copy(supportedContentTypes);
        }

        public final Collection<String> getSupportedResponseMIMETypes() {
            return supportedResponseMIMETypes;
        }

        @Override
        public final Builder supportedResponseMIMETypes(Collection<String> supportedResponseMIMETypes) {
            this.supportedResponseMIMETypes = ResponseMIMETypesCopier.copy(supportedResponseMIMETypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedResponseMIMETypes(String... supportedResponseMIMETypes) {
            supportedResponseMIMETypes(Arrays.asList(supportedResponseMIMETypes));
            return this;
        }

        public final void setSupportedResponseMIMETypes(Collection<String> supportedResponseMIMETypes) {
            this.supportedResponseMIMETypes = ResponseMIMETypesCopier.copy(supportedResponseMIMETypes);
        }

        @Override
        public InferenceSpecification build() {
            return new InferenceSpecification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
