/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides summary information for a work team.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LabelingJobForWorkteamSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<LabelingJobForWorkteamSummary.Builder, LabelingJobForWorkteamSummary> {
    private static final SdkField<String> LABELING_JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(LabelingJobForWorkteamSummary::labelingJobName)).setter(setter(Builder::labelingJobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelingJobName").build()).build();

    private static final SdkField<String> JOB_REFERENCE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(LabelingJobForWorkteamSummary::jobReferenceCode)).setter(setter(Builder::jobReferenceCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobReferenceCode").build()).build();

    private static final SdkField<String> WORK_REQUESTER_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(LabelingJobForWorkteamSummary::workRequesterAccountId))
            .setter(setter(Builder::workRequesterAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkRequesterAccountId").build())
            .build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(LabelingJobForWorkteamSummary::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<LabelCountersForWorkteam> LABEL_COUNTERS_FIELD = SdkField
            .<LabelCountersForWorkteam> builder(MarshallingType.SDK_POJO)
            .getter(getter(LabelingJobForWorkteamSummary::labelCounters)).setter(setter(Builder::labelCounters))
            .constructor(LabelCountersForWorkteam::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelCounters").build()).build();

    private static final SdkField<Integer> NUMBER_OF_HUMAN_WORKERS_PER_DATA_OBJECT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(LabelingJobForWorkteamSummary::numberOfHumanWorkersPerDataObject))
            .setter(setter(Builder::numberOfHumanWorkersPerDataObject))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfHumanWorkersPerDataObject")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LABELING_JOB_NAME_FIELD,
            JOB_REFERENCE_CODE_FIELD, WORK_REQUESTER_ACCOUNT_ID_FIELD, CREATION_TIME_FIELD, LABEL_COUNTERS_FIELD,
            NUMBER_OF_HUMAN_WORKERS_PER_DATA_OBJECT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String labelingJobName;

    private final String jobReferenceCode;

    private final String workRequesterAccountId;

    private final Instant creationTime;

    private final LabelCountersForWorkteam labelCounters;

    private final Integer numberOfHumanWorkersPerDataObject;

    private LabelingJobForWorkteamSummary(BuilderImpl builder) {
        this.labelingJobName = builder.labelingJobName;
        this.jobReferenceCode = builder.jobReferenceCode;
        this.workRequesterAccountId = builder.workRequesterAccountId;
        this.creationTime = builder.creationTime;
        this.labelCounters = builder.labelCounters;
        this.numberOfHumanWorkersPerDataObject = builder.numberOfHumanWorkersPerDataObject;
    }

    /**
     * <p>
     * The name of the labeling job that the work team is assigned to.
     * </p>
     * 
     * @return The name of the labeling job that the work team is assigned to.
     */
    public String labelingJobName() {
        return labelingJobName;
    }

    /**
     * <p>
     * A unique identifier for a labeling job. You can use this to refer to a specific labeling job.
     * </p>
     * 
     * @return A unique identifier for a labeling job. You can use this to refer to a specific labeling job.
     */
    public String jobReferenceCode() {
        return jobReferenceCode;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public String workRequesterAccountId() {
        return workRequesterAccountId;
    }

    /**
     * <p>
     * The date and time that the labeling job was created.
     * </p>
     * 
     * @return The date and time that the labeling job was created.
     */
    public Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * Provides information about the progress of a labeling job.
     * </p>
     * 
     * @return Provides information about the progress of a labeling job.
     */
    public LabelCountersForWorkteam labelCounters() {
        return labelCounters;
    }

    /**
     * <p>
     * The configured number of workers per data object.
     * </p>
     * 
     * @return The configured number of workers per data object.
     */
    public Integer numberOfHumanWorkersPerDataObject() {
        return numberOfHumanWorkersPerDataObject;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(labelingJobName());
        hashCode = 31 * hashCode + Objects.hashCode(jobReferenceCode());
        hashCode = 31 * hashCode + Objects.hashCode(workRequesterAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(labelCounters());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfHumanWorkersPerDataObject());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LabelingJobForWorkteamSummary)) {
            return false;
        }
        LabelingJobForWorkteamSummary other = (LabelingJobForWorkteamSummary) obj;
        return Objects.equals(labelingJobName(), other.labelingJobName())
                && Objects.equals(jobReferenceCode(), other.jobReferenceCode())
                && Objects.equals(workRequesterAccountId(), other.workRequesterAccountId())
                && Objects.equals(creationTime(), other.creationTime()) && Objects.equals(labelCounters(), other.labelCounters())
                && Objects.equals(numberOfHumanWorkersPerDataObject(), other.numberOfHumanWorkersPerDataObject());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("LabelingJobForWorkteamSummary").add("LabelingJobName", labelingJobName())
                .add("JobReferenceCode", jobReferenceCode()).add("WorkRequesterAccountId", workRequesterAccountId())
                .add("CreationTime", creationTime()).add("LabelCounters", labelCounters())
                .add("NumberOfHumanWorkersPerDataObject", numberOfHumanWorkersPerDataObject()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LabelingJobName":
            return Optional.ofNullable(clazz.cast(labelingJobName()));
        case "JobReferenceCode":
            return Optional.ofNullable(clazz.cast(jobReferenceCode()));
        case "WorkRequesterAccountId":
            return Optional.ofNullable(clazz.cast(workRequesterAccountId()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LabelCounters":
            return Optional.ofNullable(clazz.cast(labelCounters()));
        case "NumberOfHumanWorkersPerDataObject":
            return Optional.ofNullable(clazz.cast(numberOfHumanWorkersPerDataObject()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LabelingJobForWorkteamSummary, T> g) {
        return obj -> g.apply((LabelingJobForWorkteamSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LabelingJobForWorkteamSummary> {
        /**
         * <p>
         * The name of the labeling job that the work team is assigned to.
         * </p>
         * 
         * @param labelingJobName
         *        The name of the labeling job that the work team is assigned to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labelingJobName(String labelingJobName);

        /**
         * <p>
         * A unique identifier for a labeling job. You can use this to refer to a specific labeling job.
         * </p>
         * 
         * @param jobReferenceCode
         *        A unique identifier for a labeling job. You can use this to refer to a specific labeling job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobReferenceCode(String jobReferenceCode);

        /**
         * <p/>
         * 
         * @param workRequesterAccountId
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workRequesterAccountId(String workRequesterAccountId);

        /**
         * <p>
         * The date and time that the labeling job was created.
         * </p>
         * 
         * @param creationTime
         *        The date and time that the labeling job was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * Provides information about the progress of a labeling job.
         * </p>
         * 
         * @param labelCounters
         *        Provides information about the progress of a labeling job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labelCounters(LabelCountersForWorkteam labelCounters);

        /**
         * <p>
         * Provides information about the progress of a labeling job.
         * </p>
         * This is a convenience that creates an instance of the {@link LabelCountersForWorkteam.Builder} avoiding the
         * need to create one manually via {@link LabelCountersForWorkteam#builder()}.
         *
         * When the {@link Consumer} completes, {@link LabelCountersForWorkteam.Builder#build()} is called immediately
         * and its result is passed to {@link #labelCounters(LabelCountersForWorkteam)}.
         * 
         * @param labelCounters
         *        a consumer that will call methods on {@link LabelCountersForWorkteam.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #labelCounters(LabelCountersForWorkteam)
         */
        default Builder labelCounters(Consumer<LabelCountersForWorkteam.Builder> labelCounters) {
            return labelCounters(LabelCountersForWorkteam.builder().applyMutation(labelCounters).build());
        }

        /**
         * <p>
         * The configured number of workers per data object.
         * </p>
         * 
         * @param numberOfHumanWorkersPerDataObject
         *        The configured number of workers per data object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfHumanWorkersPerDataObject(Integer numberOfHumanWorkersPerDataObject);
    }

    static final class BuilderImpl implements Builder {
        private String labelingJobName;

        private String jobReferenceCode;

        private String workRequesterAccountId;

        private Instant creationTime;

        private LabelCountersForWorkteam labelCounters;

        private Integer numberOfHumanWorkersPerDataObject;

        private BuilderImpl() {
        }

        private BuilderImpl(LabelingJobForWorkteamSummary model) {
            labelingJobName(model.labelingJobName);
            jobReferenceCode(model.jobReferenceCode);
            workRequesterAccountId(model.workRequesterAccountId);
            creationTime(model.creationTime);
            labelCounters(model.labelCounters);
            numberOfHumanWorkersPerDataObject(model.numberOfHumanWorkersPerDataObject);
        }

        public final String getLabelingJobName() {
            return labelingJobName;
        }

        @Override
        public final Builder labelingJobName(String labelingJobName) {
            this.labelingJobName = labelingJobName;
            return this;
        }

        public final void setLabelingJobName(String labelingJobName) {
            this.labelingJobName = labelingJobName;
        }

        public final String getJobReferenceCode() {
            return jobReferenceCode;
        }

        @Override
        public final Builder jobReferenceCode(String jobReferenceCode) {
            this.jobReferenceCode = jobReferenceCode;
            return this;
        }

        public final void setJobReferenceCode(String jobReferenceCode) {
            this.jobReferenceCode = jobReferenceCode;
        }

        public final String getWorkRequesterAccountId() {
            return workRequesterAccountId;
        }

        @Override
        public final Builder workRequesterAccountId(String workRequesterAccountId) {
            this.workRequesterAccountId = workRequesterAccountId;
            return this;
        }

        public final void setWorkRequesterAccountId(String workRequesterAccountId) {
            this.workRequesterAccountId = workRequesterAccountId;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final LabelCountersForWorkteam.Builder getLabelCounters() {
            return labelCounters != null ? labelCounters.toBuilder() : null;
        }

        @Override
        public final Builder labelCounters(LabelCountersForWorkteam labelCounters) {
            this.labelCounters = labelCounters;
            return this;
        }

        public final void setLabelCounters(LabelCountersForWorkteam.BuilderImpl labelCounters) {
            this.labelCounters = labelCounters != null ? labelCounters.build() : null;
        }

        public final Integer getNumberOfHumanWorkersPerDataObject() {
            return numberOfHumanWorkersPerDataObject;
        }

        @Override
        public final Builder numberOfHumanWorkersPerDataObject(Integer numberOfHumanWorkersPerDataObject) {
            this.numberOfHumanWorkersPerDataObject = numberOfHumanWorkersPerDataObject;
            return this;
        }

        public final void setNumberOfHumanWorkersPerDataObject(Integer numberOfHumanWorkersPerDataObject) {
            this.numberOfHumanWorkersPerDataObject = numberOfHumanWorkersPerDataObject;
        }

        @Override
        public LabelingJobForWorkteamSummary build() {
            return new LabelingJobForWorkteamSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
