/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListHyperParameterTuningJobsResponse extends SageMakerResponse implements
        ToCopyableBuilder<ListHyperParameterTuningJobsResponse.Builder, ListHyperParameterTuningJobsResponse> {
    private static final SdkField<List<HyperParameterTuningJobSummary>> HYPER_PARAMETER_TUNING_JOB_SUMMARIES_FIELD = SdkField
            .<List<HyperParameterTuningJobSummary>> builder(MarshallingType.LIST)
            .getter(getter(ListHyperParameterTuningJobsResponse::hyperParameterTuningJobSummaries))
            .setter(setter(Builder::hyperParameterTuningJobSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HyperParameterTuningJobSummaries")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<HyperParameterTuningJobSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(HyperParameterTuningJobSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListHyperParameterTuningJobsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            HYPER_PARAMETER_TUNING_JOB_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));

    private final List<HyperParameterTuningJobSummary> hyperParameterTuningJobSummaries;

    private final String nextToken;

    private ListHyperParameterTuningJobsResponse(BuilderImpl builder) {
        super(builder);
        this.hyperParameterTuningJobSummaries = builder.hyperParameterTuningJobSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * A list of <a>HyperParameterTuningJobSummary</a> objects that describe the tuning jobs that the
     * <code>ListHyperParameterTuningJobs</code> request returned.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of <a>HyperParameterTuningJobSummary</a> objects that describe the tuning jobs that the
     *         <code>ListHyperParameterTuningJobs</code> request returned.
     */
    public List<HyperParameterTuningJobSummary> hyperParameterTuningJobSummaries() {
        return hyperParameterTuningJobSummaries;
    }

    /**
     * <p>
     * If the result of this <code>ListHyperParameterTuningJobs</code> request was truncated, the response includes a
     * <code>NextToken</code>. To retrieve the next set of tuning jobs, use the token in the next request.
     * </p>
     * 
     * @return If the result of this <code>ListHyperParameterTuningJobs</code> request was truncated, the response
     *         includes a <code>NextToken</code>. To retrieve the next set of tuning jobs, use the token in the next
     *         request.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hyperParameterTuningJobSummaries());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListHyperParameterTuningJobsResponse)) {
            return false;
        }
        ListHyperParameterTuningJobsResponse other = (ListHyperParameterTuningJobsResponse) obj;
        return Objects.equals(hyperParameterTuningJobSummaries(), other.hyperParameterTuningJobSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListHyperParameterTuningJobsResponse")
                .add("HyperParameterTuningJobSummaries", hyperParameterTuningJobSummaries()).add("NextToken", nextToken())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HyperParameterTuningJobSummaries":
            return Optional.ofNullable(clazz.cast(hyperParameterTuningJobSummaries()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListHyperParameterTuningJobsResponse, T> g) {
        return obj -> g.apply((ListHyperParameterTuningJobsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListHyperParameterTuningJobsResponse> {
        /**
         * <p>
         * A list of <a>HyperParameterTuningJobSummary</a> objects that describe the tuning jobs that the
         * <code>ListHyperParameterTuningJobs</code> request returned.
         * </p>
         * 
         * @param hyperParameterTuningJobSummaries
         *        A list of <a>HyperParameterTuningJobSummary</a> objects that describe the tuning jobs that the
         *        <code>ListHyperParameterTuningJobs</code> request returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hyperParameterTuningJobSummaries(Collection<HyperParameterTuningJobSummary> hyperParameterTuningJobSummaries);

        /**
         * <p>
         * A list of <a>HyperParameterTuningJobSummary</a> objects that describe the tuning jobs that the
         * <code>ListHyperParameterTuningJobs</code> request returned.
         * </p>
         * 
         * @param hyperParameterTuningJobSummaries
         *        A list of <a>HyperParameterTuningJobSummary</a> objects that describe the tuning jobs that the
         *        <code>ListHyperParameterTuningJobs</code> request returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hyperParameterTuningJobSummaries(HyperParameterTuningJobSummary... hyperParameterTuningJobSummaries);

        /**
         * <p>
         * A list of <a>HyperParameterTuningJobSummary</a> objects that describe the tuning jobs that the
         * <code>ListHyperParameterTuningJobs</code> request returned.
         * </p>
         * This is a convenience that creates an instance of the {@link List<HyperParameterTuningJobSummary>.Builder}
         * avoiding the need to create one manually via {@link List<HyperParameterTuningJobSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<HyperParameterTuningJobSummary>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #hyperParameterTuningJobSummaries(List<HyperParameterTuningJobSummary>)}.
         * 
         * @param hyperParameterTuningJobSummaries
         *        a consumer that will call methods on {@link List<HyperParameterTuningJobSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hyperParameterTuningJobSummaries(List<HyperParameterTuningJobSummary>)
         */
        Builder hyperParameterTuningJobSummaries(
                Consumer<HyperParameterTuningJobSummary.Builder>... hyperParameterTuningJobSummaries);

        /**
         * <p>
         * If the result of this <code>ListHyperParameterTuningJobs</code> request was truncated, the response includes
         * a <code>NextToken</code>. To retrieve the next set of tuning jobs, use the token in the next request.
         * </p>
         * 
         * @param nextToken
         *        If the result of this <code>ListHyperParameterTuningJobs</code> request was truncated, the response
         *        includes a <code>NextToken</code>. To retrieve the next set of tuning jobs, use the token in the next
         *        request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private List<HyperParameterTuningJobSummary> hyperParameterTuningJobSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListHyperParameterTuningJobsResponse model) {
            super(model);
            hyperParameterTuningJobSummaries(model.hyperParameterTuningJobSummaries);
            nextToken(model.nextToken);
        }

        public final Collection<HyperParameterTuningJobSummary.Builder> getHyperParameterTuningJobSummaries() {
            return hyperParameterTuningJobSummaries != null ? hyperParameterTuningJobSummaries.stream()
                    .map(HyperParameterTuningJobSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder hyperParameterTuningJobSummaries(
                Collection<HyperParameterTuningJobSummary> hyperParameterTuningJobSummaries) {
            this.hyperParameterTuningJobSummaries = HyperParameterTuningJobSummariesCopier.copy(hyperParameterTuningJobSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hyperParameterTuningJobSummaries(HyperParameterTuningJobSummary... hyperParameterTuningJobSummaries) {
            hyperParameterTuningJobSummaries(Arrays.asList(hyperParameterTuningJobSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hyperParameterTuningJobSummaries(
                Consumer<HyperParameterTuningJobSummary.Builder>... hyperParameterTuningJobSummaries) {
            hyperParameterTuningJobSummaries(Stream.of(hyperParameterTuningJobSummaries)
                    .map(c -> HyperParameterTuningJobSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setHyperParameterTuningJobSummaries(
                Collection<HyperParameterTuningJobSummary.BuilderImpl> hyperParameterTuningJobSummaries) {
            this.hyperParameterTuningJobSummaries = HyperParameterTuningJobSummariesCopier
                    .copyFromBuilder(hyperParameterTuningJobSummaries);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListHyperParameterTuningJobsResponse build() {
            return new ListHyperParameterTuningJobsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
