/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the resources, including ML instance types and ML instance count, to use for transform job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TransformResources implements SdkPojo, Serializable,
        ToCopyableBuilder<TransformResources.Builder, TransformResources> {
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TransformResources::instanceTypeAsString)).setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()).build();

    private static final SdkField<Integer> INSTANCE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(TransformResources::instanceCount)).setter(setter(Builder::instanceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceCount").build()).build();

    private static final SdkField<String> VOLUME_KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TransformResources::volumeKmsKeyId)).setter(setter(Builder::volumeKmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeKmsKeyId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_TYPE_FIELD,
            INSTANCE_COUNT_FIELD, VOLUME_KMS_KEY_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String instanceType;

    private final Integer instanceCount;

    private final String volumeKmsKeyId;

    private TransformResources(BuilderImpl builder) {
        this.instanceType = builder.instanceType;
        this.instanceCount = builder.instanceCount;
        this.volumeKmsKeyId = builder.volumeKmsKeyId;
    }

    /**
     * <p>
     * The ML compute instance type for the transform job. If you are using built-in algorithms to transform moderately
     * sized datasets, we recommend using ml.m4.xlarge or <code>ml.m5.large</code> instance types.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link TransformInstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return The ML compute instance type for the transform job. If you are using built-in algorithms to transform
     *         moderately sized datasets, we recommend using ml.m4.xlarge or <code>ml.m5.large</code> instance types.
     * @see TransformInstanceType
     */
    public TransformInstanceType instanceType() {
        return TransformInstanceType.fromValue(instanceType);
    }

    /**
     * <p>
     * The ML compute instance type for the transform job. If you are using built-in algorithms to transform moderately
     * sized datasets, we recommend using ml.m4.xlarge or <code>ml.m5.large</code> instance types.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link TransformInstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return The ML compute instance type for the transform job. If you are using built-in algorithms to transform
     *         moderately sized datasets, we recommend using ml.m4.xlarge or <code>ml.m5.large</code> instance types.
     * @see TransformInstanceType
     */
    public String instanceTypeAsString() {
        return instanceType;
    }

    /**
     * <p>
     * The number of ML compute instances to use in the transform job. For distributed transform jobs, specify a value
     * greater than 1. The default value is <code>1</code>.
     * </p>
     * 
     * @return The number of ML compute instances to use in the transform job. For distributed transform jobs, specify a
     *         value greater than 1. The default value is <code>1</code>.
     */
    public Integer instanceCount() {
        return instanceCount;
    }

    /**
     * <p>
     * The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to encrypt data on the storage volume
     * attached to the ML compute instance(s) that run the batch transform job. The <code>VolumeKmsKeyId</code> can be
     * any of the following formats:
     * </p>
     * <ul>
     * <li>
     * <p>
     * // KMS Key ID
     * </p>
     * <p>
     * <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * // Amazon Resource Name (ARN) of a KMS Key
     * </p>
     * <p>
     * <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to encrypt data on the storage
     *         volume attached to the ML compute instance(s) that run the batch transform job. The
     *         <code>VolumeKmsKeyId</code> can be any of the following formats:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         // KMS Key ID
     *         </p>
     *         <p>
     *         <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         // Amazon Resource Name (ARN) of a KMS Key
     *         </p>
     *         <p>
     *         <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
     *         </p>
     *         </li>
     */
    public String volumeKmsKeyId() {
        return volumeKmsKeyId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(instanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(volumeKmsKeyId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransformResources)) {
            return false;
        }
        TransformResources other = (TransformResources) obj;
        return Objects.equals(instanceTypeAsString(), other.instanceTypeAsString())
                && Objects.equals(instanceCount(), other.instanceCount())
                && Objects.equals(volumeKmsKeyId(), other.volumeKmsKeyId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("TransformResources").add("InstanceType", instanceTypeAsString())
                .add("InstanceCount", instanceCount()).add("VolumeKmsKeyId", volumeKmsKeyId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceTypeAsString()));
        case "InstanceCount":
            return Optional.ofNullable(clazz.cast(instanceCount()));
        case "VolumeKmsKeyId":
            return Optional.ofNullable(clazz.cast(volumeKmsKeyId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TransformResources, T> g) {
        return obj -> g.apply((TransformResources) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TransformResources> {
        /**
         * <p>
         * The ML compute instance type for the transform job. If you are using built-in algorithms to transform
         * moderately sized datasets, we recommend using ml.m4.xlarge or <code>ml.m5.large</code> instance types.
         * </p>
         * 
         * @param instanceType
         *        The ML compute instance type for the transform job. If you are using built-in algorithms to transform
         *        moderately sized datasets, we recommend using ml.m4.xlarge or <code>ml.m5.large</code> instance types.
         * @see TransformInstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransformInstanceType
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The ML compute instance type for the transform job. If you are using built-in algorithms to transform
         * moderately sized datasets, we recommend using ml.m4.xlarge or <code>ml.m5.large</code> instance types.
         * </p>
         * 
         * @param instanceType
         *        The ML compute instance type for the transform job. If you are using built-in algorithms to transform
         *        moderately sized datasets, we recommend using ml.m4.xlarge or <code>ml.m5.large</code> instance types.
         * @see TransformInstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransformInstanceType
         */
        Builder instanceType(TransformInstanceType instanceType);

        /**
         * <p>
         * The number of ML compute instances to use in the transform job. For distributed transform jobs, specify a
         * value greater than 1. The default value is <code>1</code>.
         * </p>
         * 
         * @param instanceCount
         *        The number of ML compute instances to use in the transform job. For distributed transform jobs,
         *        specify a value greater than 1. The default value is <code>1</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceCount(Integer instanceCount);

        /**
         * <p>
         * The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to encrypt data on the storage volume
         * attached to the ML compute instance(s) that run the batch transform job. The <code>VolumeKmsKeyId</code> can
         * be any of the following formats:
         * </p>
         * <ul>
         * <li>
         * <p>
         * // KMS Key ID
         * </p>
         * <p>
         * <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * // Amazon Resource Name (ARN) of a KMS Key
         * </p>
         * <p>
         * <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param volumeKmsKeyId
         *        The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to encrypt data on the storage
         *        volume attached to the ML compute instance(s) that run the batch transform job. The
         *        <code>VolumeKmsKeyId</code> can be any of the following formats:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        // KMS Key ID
         *        </p>
         *        <p>
         *        <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        // Amazon Resource Name (ARN) of a KMS Key
         *        </p>
         *        <p>
         *        <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeKmsKeyId(String volumeKmsKeyId);
    }

    static final class BuilderImpl implements Builder {
        private String instanceType;

        private Integer instanceCount;

        private String volumeKmsKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(TransformResources model) {
            instanceType(model.instanceType);
            instanceCount(model.instanceCount);
            volumeKmsKeyId(model.volumeKmsKeyId);
        }

        public final String getInstanceTypeAsString() {
            return instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(TransformInstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final Integer getInstanceCount() {
            return instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        public final String getVolumeKmsKeyId() {
            return volumeKmsKeyId;
        }

        @Override
        public final Builder volumeKmsKeyId(String volumeKmsKeyId) {
            this.volumeKmsKeyId = volumeKmsKeyId;
            return this;
        }

        public final void setVolumeKmsKeyId(String volumeKmsKeyId) {
            this.volumeKmsKeyId = volumeKmsKeyId;
        }

        @Override
        public TransformResources build() {
            return new TransformResources(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
