/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemakera2iruntime;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.sagemakera2iruntime.model.DeleteHumanLoopRequest;
import software.amazon.awssdk.services.sagemakera2iruntime.model.DeleteHumanLoopResponse;
import software.amazon.awssdk.services.sagemakera2iruntime.model.DescribeHumanLoopRequest;
import software.amazon.awssdk.services.sagemakera2iruntime.model.DescribeHumanLoopResponse;
import software.amazon.awssdk.services.sagemakera2iruntime.model.InternalServerException;
import software.amazon.awssdk.services.sagemakera2iruntime.model.ListHumanLoopsRequest;
import software.amazon.awssdk.services.sagemakera2iruntime.model.ListHumanLoopsResponse;
import software.amazon.awssdk.services.sagemakera2iruntime.model.ResourceNotFoundException;
import software.amazon.awssdk.services.sagemakera2iruntime.model.SageMakerA2IRuntimeException;
import software.amazon.awssdk.services.sagemakera2iruntime.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.sagemakera2iruntime.model.StartHumanLoopRequest;
import software.amazon.awssdk.services.sagemakera2iruntime.model.StartHumanLoopResponse;
import software.amazon.awssdk.services.sagemakera2iruntime.model.StopHumanLoopRequest;
import software.amazon.awssdk.services.sagemakera2iruntime.model.StopHumanLoopResponse;
import software.amazon.awssdk.services.sagemakera2iruntime.model.ThrottlingException;
import software.amazon.awssdk.services.sagemakera2iruntime.model.ValidationException;
import software.amazon.awssdk.services.sagemakera2iruntime.paginators.ListHumanLoopsIterable;

/**
 * Service client for accessing Amazon Augmented AI Runtime. This can be created using the static {@link #builder()}
 * method.
 *
 * <p>
 * Amazon Augmented AI (Augmented AI) (Preview) is a service that adds human judgment to any machine learning
 * application. Human reviewers can take over when an AI application can't evaluate data with a high degree of
 * confidence.
 * </p>
 * <p>
 * From fraudulent bank transaction identification to document processing to image analysis, machine learning models can
 * be trained to make decisions as well as or better than a human. Nevertheless, some decisions require contextual
 * interpretation, such as when you need to decide whether an image is appropriate for a given audience. Content
 * moderation guidelines are nuanced and highly dependent on context, and they vary between countries. When trying to
 * apply AI in these situations, you can be forced to choose between "ML only" systems with unacceptably high error
 * rates or "human only" systems that are expensive and difficult to scale, and that slow down decision making.
 * </p>
 * <p>
 * This API reference includes information about API actions and data types you can use to interact with Augmented AI
 * programmatically.
 * </p>
 * <p>
 * You can create a flow definition against the Augmented AI API. Provide the Amazon Resource Name (ARN) of a flow
 * definition to integrate AI service APIs, such as <code>Textract.AnalyzeDocument</code> and
 * <code>Rekognition.DetectModerationLabels</code>. These AI services, in turn, invoke the <a>StartHumanLoop</a> API,
 * which evaluates conditions under which humans will be invoked. If humans are required, Augmented AI creates a human
 * loop. Results of human work are available asynchronously in Amazon Simple Storage Service (Amazon S3). You can use
 * Amazon CloudWatch Events to detect human work results.
 * </p>
 * <p>
 * You can find additional Augmented AI API documentation in the following reference guides: <a
 * href="https://aws.amazon.com/rekognition/latest/dg/API_Reference.html">Amazon Rekognition</a>, <a
 * href="https://aws.amazon.com/sagemaker/latest/dg/API_Reference.html">Amazon SageMaker</a>, and <a
 * href="https://aws.amazon.com/textract/latest/dg/API_Reference.html">Amazon Textract</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public interface SageMakerA2IRuntimeClient extends SdkClient {
    String SERVICE_NAME = "sagemaker";

    /**
     * Create a {@link SageMakerA2IRuntimeClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static SageMakerA2IRuntimeClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link SageMakerA2IRuntimeClient}.
     */
    static SageMakerA2IRuntimeClientBuilder builder() {
        return new DefaultSageMakerA2IRuntimeClientBuilder();
    }

    /**
     * <p>
     * Deletes the specified human loop for a flow definition.
     * </p>
     *
     * @param deleteHumanLoopRequest
     * @return Result of the DeleteHumanLoop operation returned by the service.
     * @throws ValidationException
     *         Your request was not valid. Check the syntax and try again.
     * @throws ResourceNotFoundException
     *         We were unable to find the requested resource.
     * @throws ThrottlingException
     *         Your request has exceeded the allowed amount of requests.
     * @throws InternalServerException
     *         Your request could not be processed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerA2IRuntimeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerA2IRuntimeClient.DeleteHumanLoop
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-a2i-runtime-2019-11-07/DeleteHumanLoop"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteHumanLoopResponse deleteHumanLoop(DeleteHumanLoopRequest deleteHumanLoopRequest) throws ValidationException,
            ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            SageMakerA2IRuntimeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified human loop for a flow definition.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteHumanLoopRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteHumanLoopRequest#builder()}
     * </p>
     *
     * @param deleteHumanLoopRequest
     *        A {@link Consumer} that will call methods on {@link DeleteHumanLoopRequest.Builder} to create a request.
     * @return Result of the DeleteHumanLoop operation returned by the service.
     * @throws ValidationException
     *         Your request was not valid. Check the syntax and try again.
     * @throws ResourceNotFoundException
     *         We were unable to find the requested resource.
     * @throws ThrottlingException
     *         Your request has exceeded the allowed amount of requests.
     * @throws InternalServerException
     *         Your request could not be processed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerA2IRuntimeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerA2IRuntimeClient.DeleteHumanLoop
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-a2i-runtime-2019-11-07/DeleteHumanLoop"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteHumanLoopResponse deleteHumanLoop(Consumer<DeleteHumanLoopRequest.Builder> deleteHumanLoopRequest)
            throws ValidationException, ResourceNotFoundException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, SageMakerA2IRuntimeException {
        return deleteHumanLoop(DeleteHumanLoopRequest.builder().applyMutation(deleteHumanLoopRequest).build());
    }

    /**
     * <p>
     * Returns information about the specified human loop.
     * </p>
     *
     * @param describeHumanLoopRequest
     * @return Result of the DescribeHumanLoop operation returned by the service.
     * @throws ValidationException
     *         Your request was not valid. Check the syntax and try again.
     * @throws ResourceNotFoundException
     *         We were unable to find the requested resource.
     * @throws ThrottlingException
     *         Your request has exceeded the allowed amount of requests.
     * @throws InternalServerException
     *         Your request could not be processed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerA2IRuntimeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerA2IRuntimeClient.DescribeHumanLoop
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-a2i-runtime-2019-11-07/DescribeHumanLoop"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeHumanLoopResponse describeHumanLoop(DescribeHumanLoopRequest describeHumanLoopRequest)
            throws ValidationException, ResourceNotFoundException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, SageMakerA2IRuntimeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the specified human loop.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeHumanLoopRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeHumanLoopRequest#builder()}
     * </p>
     *
     * @param describeHumanLoopRequest
     *        A {@link Consumer} that will call methods on {@link DescribeHumanLoopRequest.Builder} to create a request.
     * @return Result of the DescribeHumanLoop operation returned by the service.
     * @throws ValidationException
     *         Your request was not valid. Check the syntax and try again.
     * @throws ResourceNotFoundException
     *         We were unable to find the requested resource.
     * @throws ThrottlingException
     *         Your request has exceeded the allowed amount of requests.
     * @throws InternalServerException
     *         Your request could not be processed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerA2IRuntimeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerA2IRuntimeClient.DescribeHumanLoop
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-a2i-runtime-2019-11-07/DescribeHumanLoop"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeHumanLoopResponse describeHumanLoop(Consumer<DescribeHumanLoopRequest.Builder> describeHumanLoopRequest)
            throws ValidationException, ResourceNotFoundException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, SageMakerA2IRuntimeException {
        return describeHumanLoop(DescribeHumanLoopRequest.builder().applyMutation(describeHumanLoopRequest).build());
    }

    /**
     * <p>
     * Returns information about human loops, given the specified parameters.
     * </p>
     *
     * @param listHumanLoopsRequest
     * @return Result of the ListHumanLoops operation returned by the service.
     * @throws ValidationException
     *         Your request was not valid. Check the syntax and try again.
     * @throws ThrottlingException
     *         Your request has exceeded the allowed amount of requests.
     * @throws InternalServerException
     *         Your request could not be processed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerA2IRuntimeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerA2IRuntimeClient.ListHumanLoops
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-a2i-runtime-2019-11-07/ListHumanLoops"
     *      target="_top">AWS API Documentation</a>
     */
    default ListHumanLoopsResponse listHumanLoops(ListHumanLoopsRequest listHumanLoopsRequest) throws ValidationException,
            ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, SageMakerA2IRuntimeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about human loops, given the specified parameters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListHumanLoopsRequest.Builder} avoiding the need to
     * create one manually via {@link ListHumanLoopsRequest#builder()}
     * </p>
     *
     * @param listHumanLoopsRequest
     *        A {@link Consumer} that will call methods on {@link ListHumanLoopsRequest.Builder} to create a request.
     * @return Result of the ListHumanLoops operation returned by the service.
     * @throws ValidationException
     *         Your request was not valid. Check the syntax and try again.
     * @throws ThrottlingException
     *         Your request has exceeded the allowed amount of requests.
     * @throws InternalServerException
     *         Your request could not be processed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerA2IRuntimeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerA2IRuntimeClient.ListHumanLoops
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-a2i-runtime-2019-11-07/ListHumanLoops"
     *      target="_top">AWS API Documentation</a>
     */
    default ListHumanLoopsResponse listHumanLoops(Consumer<ListHumanLoopsRequest.Builder> listHumanLoopsRequest)
            throws ValidationException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            SageMakerA2IRuntimeException {
        return listHumanLoops(ListHumanLoopsRequest.builder().applyMutation(listHumanLoopsRequest).build());
    }

    /**
     * <p>
     * Returns information about human loops, given the specified parameters.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listHumanLoops(software.amazon.awssdk.services.sagemakera2iruntime.model.ListHumanLoopsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemakera2iruntime.paginators.ListHumanLoopsIterable responses = client.listHumanLoopsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemakera2iruntime.paginators.ListHumanLoopsIterable responses = client
     *             .listHumanLoopsPaginator(request);
     *     for (software.amazon.awssdk.services.sagemakera2iruntime.model.ListHumanLoopsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemakera2iruntime.paginators.ListHumanLoopsIterable responses = client.listHumanLoopsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listHumanLoops(software.amazon.awssdk.services.sagemakera2iruntime.model.ListHumanLoopsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listHumanLoopsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         Your request was not valid. Check the syntax and try again.
     * @throws ThrottlingException
     *         Your request has exceeded the allowed amount of requests.
     * @throws InternalServerException
     *         Your request could not be processed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerA2IRuntimeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerA2IRuntimeClient.ListHumanLoops
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-a2i-runtime-2019-11-07/ListHumanLoops"
     *      target="_top">AWS API Documentation</a>
     */
    default ListHumanLoopsIterable listHumanLoopsPaginator(ListHumanLoopsRequest listHumanLoopsRequest)
            throws ValidationException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            SageMakerA2IRuntimeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about human loops, given the specified parameters.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listHumanLoops(software.amazon.awssdk.services.sagemakera2iruntime.model.ListHumanLoopsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemakera2iruntime.paginators.ListHumanLoopsIterable responses = client.listHumanLoopsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemakera2iruntime.paginators.ListHumanLoopsIterable responses = client
     *             .listHumanLoopsPaginator(request);
     *     for (software.amazon.awssdk.services.sagemakera2iruntime.model.ListHumanLoopsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemakera2iruntime.paginators.ListHumanLoopsIterable responses = client.listHumanLoopsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listHumanLoops(software.amazon.awssdk.services.sagemakera2iruntime.model.ListHumanLoopsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListHumanLoopsRequest.Builder} avoiding the need to
     * create one manually via {@link ListHumanLoopsRequest#builder()}
     * </p>
     *
     * @param listHumanLoopsRequest
     *        A {@link Consumer} that will call methods on {@link ListHumanLoopsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         Your request was not valid. Check the syntax and try again.
     * @throws ThrottlingException
     *         Your request has exceeded the allowed amount of requests.
     * @throws InternalServerException
     *         Your request could not be processed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerA2IRuntimeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerA2IRuntimeClient.ListHumanLoops
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-a2i-runtime-2019-11-07/ListHumanLoops"
     *      target="_top">AWS API Documentation</a>
     */
    default ListHumanLoopsIterable listHumanLoopsPaginator(Consumer<ListHumanLoopsRequest.Builder> listHumanLoopsRequest)
            throws ValidationException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            SageMakerA2IRuntimeException {
        return listHumanLoopsPaginator(ListHumanLoopsRequest.builder().applyMutation(listHumanLoopsRequest).build());
    }

    /**
     * <p>
     * Starts a human loop, provided that at least one activation condition is met.
     * </p>
     *
     * @param startHumanLoopRequest
     * @return Result of the StartHumanLoop operation returned by the service.
     * @throws ValidationException
     *         Your request was not valid. Check the syntax and try again.
     * @throws ThrottlingException
     *         Your request has exceeded the allowed amount of requests.
     * @throws ServiceQuotaExceededException
     *         You have exceeded your service quota. To perform the requested action, remove some of the relevant
     *         resources, or request a service quota increase.
     * @throws InternalServerException
     *         Your request could not be processed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerA2IRuntimeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerA2IRuntimeClient.StartHumanLoop
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-a2i-runtime-2019-11-07/StartHumanLoop"
     *      target="_top">AWS API Documentation</a>
     */
    default StartHumanLoopResponse startHumanLoop(StartHumanLoopRequest startHumanLoopRequest) throws ValidationException,
            ThrottlingException, ServiceQuotaExceededException, InternalServerException, AwsServiceException, SdkClientException,
            SageMakerA2IRuntimeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a human loop, provided that at least one activation condition is met.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartHumanLoopRequest.Builder} avoiding the need to
     * create one manually via {@link StartHumanLoopRequest#builder()}
     * </p>
     *
     * @param startHumanLoopRequest
     *        A {@link Consumer} that will call methods on {@link StartHumanLoopRequest.Builder} to create a request.
     * @return Result of the StartHumanLoop operation returned by the service.
     * @throws ValidationException
     *         Your request was not valid. Check the syntax and try again.
     * @throws ThrottlingException
     *         Your request has exceeded the allowed amount of requests.
     * @throws ServiceQuotaExceededException
     *         You have exceeded your service quota. To perform the requested action, remove some of the relevant
     *         resources, or request a service quota increase.
     * @throws InternalServerException
     *         Your request could not be processed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerA2IRuntimeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerA2IRuntimeClient.StartHumanLoop
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-a2i-runtime-2019-11-07/StartHumanLoop"
     *      target="_top">AWS API Documentation</a>
     */
    default StartHumanLoopResponse startHumanLoop(Consumer<StartHumanLoopRequest.Builder> startHumanLoopRequest)
            throws ValidationException, ThrottlingException, ServiceQuotaExceededException, InternalServerException,
            AwsServiceException, SdkClientException, SageMakerA2IRuntimeException {
        return startHumanLoop(StartHumanLoopRequest.builder().applyMutation(startHumanLoopRequest).build());
    }

    /**
     * <p>
     * Stops the specified human loop.
     * </p>
     *
     * @param stopHumanLoopRequest
     * @return Result of the StopHumanLoop operation returned by the service.
     * @throws ValidationException
     *         Your request was not valid. Check the syntax and try again.
     * @throws ResourceNotFoundException
     *         We were unable to find the requested resource.
     * @throws ThrottlingException
     *         Your request has exceeded the allowed amount of requests.
     * @throws InternalServerException
     *         Your request could not be processed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerA2IRuntimeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerA2IRuntimeClient.StopHumanLoop
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-a2i-runtime-2019-11-07/StopHumanLoop"
     *      target="_top">AWS API Documentation</a>
     */
    default StopHumanLoopResponse stopHumanLoop(StopHumanLoopRequest stopHumanLoopRequest) throws ValidationException,
            ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            SageMakerA2IRuntimeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops the specified human loop.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopHumanLoopRequest.Builder} avoiding the need to
     * create one manually via {@link StopHumanLoopRequest#builder()}
     * </p>
     *
     * @param stopHumanLoopRequest
     *        A {@link Consumer} that will call methods on {@link StopHumanLoopRequest.Builder} to create a request.
     * @return Result of the StopHumanLoop operation returned by the service.
     * @throws ValidationException
     *         Your request was not valid. Check the syntax and try again.
     * @throws ResourceNotFoundException
     *         We were unable to find the requested resource.
     * @throws ThrottlingException
     *         Your request has exceeded the allowed amount of requests.
     * @throws InternalServerException
     *         Your request could not be processed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerA2IRuntimeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerA2IRuntimeClient.StopHumanLoop
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-a2i-runtime-2019-11-07/StopHumanLoop"
     *      target="_top">AWS API Documentation</a>
     */
    default StopHumanLoopResponse stopHumanLoop(Consumer<StopHumanLoopRequest.Builder> stopHumanLoopRequest)
            throws ValidationException, ResourceNotFoundException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, SageMakerA2IRuntimeException {
        return stopHumanLoop(StopHumanLoopRequest.builder().applyMutation(stopHumanLoopRequest).build());
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of("a2i-runtime.sagemaker");
    }
}
