/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemakera2iruntime.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeHumanLoopResponse extends SageMakerA2IRuntimeResponse implements
        ToCopyableBuilder<DescribeHumanLoopResponse.Builder, DescribeHumanLoopResponse> {
    private static final SdkField<Instant> CREATION_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(DescribeHumanLoopResponse::creationTimestamp)).setter(setter(Builder::creationTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimestamp").build()).build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeHumanLoopResponse::failureReason)).setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()).build();

    private static final SdkField<String> FAILURE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeHumanLoopResponse::failureCode)).setter(setter(Builder::failureCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureCode").build()).build();

    private static final SdkField<String> HUMAN_LOOP_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeHumanLoopResponse::humanLoopStatusAsString)).setter(setter(Builder::humanLoopStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HumanLoopStatus").build()).build();

    private static final SdkField<String> HUMAN_LOOP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeHumanLoopResponse::humanLoopName)).setter(setter(Builder::humanLoopName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HumanLoopName").build()).build();

    private static final SdkField<String> HUMAN_LOOP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeHumanLoopResponse::humanLoopArn)).setter(setter(Builder::humanLoopArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HumanLoopArn").build()).build();

    private static final SdkField<String> FLOW_DEFINITION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeHumanLoopResponse::flowDefinitionArn)).setter(setter(Builder::flowDefinitionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlowDefinitionArn").build()).build();

    private static final SdkField<HumanLoopInputContent> HUMAN_LOOP_INPUT_FIELD = SdkField
            .<HumanLoopInputContent> builder(MarshallingType.SDK_POJO).getter(getter(DescribeHumanLoopResponse::humanLoopInput))
            .setter(setter(Builder::humanLoopInput)).constructor(HumanLoopInputContent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HumanLoopInput").build()).build();

    private static final SdkField<HumanLoopOutputContent> HUMAN_LOOP_OUTPUT_FIELD = SdkField
            .<HumanLoopOutputContent> builder(MarshallingType.SDK_POJO)
            .getter(getter(DescribeHumanLoopResponse::humanLoopOutput)).setter(setter(Builder::humanLoopOutput))
            .constructor(HumanLoopOutputContent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HumanLoopOutput").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATION_TIMESTAMP_FIELD,
            FAILURE_REASON_FIELD, FAILURE_CODE_FIELD, HUMAN_LOOP_STATUS_FIELD, HUMAN_LOOP_NAME_FIELD, HUMAN_LOOP_ARN_FIELD,
            FLOW_DEFINITION_ARN_FIELD, HUMAN_LOOP_INPUT_FIELD, HUMAN_LOOP_OUTPUT_FIELD));

    private final Instant creationTimestamp;

    private final String failureReason;

    private final String failureCode;

    private final String humanLoopStatus;

    private final String humanLoopName;

    private final String humanLoopArn;

    private final String flowDefinitionArn;

    private final HumanLoopInputContent humanLoopInput;

    private final HumanLoopOutputContent humanLoopOutput;

    private DescribeHumanLoopResponse(BuilderImpl builder) {
        super(builder);
        this.creationTimestamp = builder.creationTimestamp;
        this.failureReason = builder.failureReason;
        this.failureCode = builder.failureCode;
        this.humanLoopStatus = builder.humanLoopStatus;
        this.humanLoopName = builder.humanLoopName;
        this.humanLoopArn = builder.humanLoopArn;
        this.flowDefinitionArn = builder.flowDefinitionArn;
        this.humanLoopInput = builder.humanLoopInput;
        this.humanLoopOutput = builder.humanLoopOutput;
    }

    /**
     * <p>
     * The timestamp when Amazon Augmented AI created the human loop.
     * </p>
     * 
     * @return The timestamp when Amazon Augmented AI created the human loop.
     */
    public Instant creationTimestamp() {
        return creationTimestamp;
    }

    /**
     * <p>
     * The reason why a human loop has failed. The failure reason is returned when the human loop status is
     * <code>Failed</code>.
     * </p>
     * 
     * @return The reason why a human loop has failed. The failure reason is returned when the human loop status is
     *         <code>Failed</code>.
     */
    public String failureReason() {
        return failureReason;
    }

    /**
     * <p>
     * A failure code denoting a specific type of failure.
     * </p>
     * 
     * @return A failure code denoting a specific type of failure.
     */
    public String failureCode() {
        return failureCode;
    }

    /**
     * <p>
     * The status of the human loop. Valid values:
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #humanLoopStatus}
     * will return {@link HumanLoopStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #humanLoopStatusAsString}.
     * </p>
     * 
     * @return The status of the human loop. Valid values:
     * @see HumanLoopStatus
     */
    public HumanLoopStatus humanLoopStatus() {
        return HumanLoopStatus.fromValue(humanLoopStatus);
    }

    /**
     * <p>
     * The status of the human loop. Valid values:
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #humanLoopStatus}
     * will return {@link HumanLoopStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #humanLoopStatusAsString}.
     * </p>
     * 
     * @return The status of the human loop. Valid values:
     * @see HumanLoopStatus
     */
    public String humanLoopStatusAsString() {
        return humanLoopStatus;
    }

    /**
     * <p>
     * The name of the human loop.
     * </p>
     * 
     * @return The name of the human loop.
     */
    public String humanLoopName() {
        return humanLoopName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the human loop.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the human loop.
     */
    public String humanLoopArn() {
        return humanLoopArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the flow definition.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the flow definition.
     */
    public String flowDefinitionArn() {
        return flowDefinitionArn;
    }

    /**
     * <p>
     * An object containing information about the human loop input.
     * </p>
     * 
     * @return An object containing information about the human loop input.
     */
    public HumanLoopInputContent humanLoopInput() {
        return humanLoopInput;
    }

    /**
     * <p>
     * An object containing information about the output of the human loop.
     * </p>
     * 
     * @return An object containing information about the output of the human loop.
     */
    public HumanLoopOutputContent humanLoopOutput() {
        return humanLoopOutput;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(creationTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(failureCode());
        hashCode = 31 * hashCode + Objects.hashCode(humanLoopStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(humanLoopName());
        hashCode = 31 * hashCode + Objects.hashCode(humanLoopArn());
        hashCode = 31 * hashCode + Objects.hashCode(flowDefinitionArn());
        hashCode = 31 * hashCode + Objects.hashCode(humanLoopInput());
        hashCode = 31 * hashCode + Objects.hashCode(humanLoopOutput());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeHumanLoopResponse)) {
            return false;
        }
        DescribeHumanLoopResponse other = (DescribeHumanLoopResponse) obj;
        return Objects.equals(creationTimestamp(), other.creationTimestamp())
                && Objects.equals(failureReason(), other.failureReason()) && Objects.equals(failureCode(), other.failureCode())
                && Objects.equals(humanLoopStatusAsString(), other.humanLoopStatusAsString())
                && Objects.equals(humanLoopName(), other.humanLoopName()) && Objects.equals(humanLoopArn(), other.humanLoopArn())
                && Objects.equals(flowDefinitionArn(), other.flowDefinitionArn())
                && Objects.equals(humanLoopInput(), other.humanLoopInput())
                && Objects.equals(humanLoopOutput(), other.humanLoopOutput());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeHumanLoopResponse").add("CreationTimestamp", creationTimestamp())
                .add("FailureReason", failureReason()).add("FailureCode", failureCode())
                .add("HumanLoopStatus", humanLoopStatusAsString()).add("HumanLoopName", humanLoopName())
                .add("HumanLoopArn", humanLoopArn()).add("FlowDefinitionArn", flowDefinitionArn())
                .add("HumanLoopInput", humanLoopInput()).add("HumanLoopOutput", humanLoopOutput()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CreationTimestamp":
            return Optional.ofNullable(clazz.cast(creationTimestamp()));
        case "FailureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        case "FailureCode":
            return Optional.ofNullable(clazz.cast(failureCode()));
        case "HumanLoopStatus":
            return Optional.ofNullable(clazz.cast(humanLoopStatusAsString()));
        case "HumanLoopName":
            return Optional.ofNullable(clazz.cast(humanLoopName()));
        case "HumanLoopArn":
            return Optional.ofNullable(clazz.cast(humanLoopArn()));
        case "FlowDefinitionArn":
            return Optional.ofNullable(clazz.cast(flowDefinitionArn()));
        case "HumanLoopInput":
            return Optional.ofNullable(clazz.cast(humanLoopInput()));
        case "HumanLoopOutput":
            return Optional.ofNullable(clazz.cast(humanLoopOutput()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeHumanLoopResponse, T> g) {
        return obj -> g.apply((DescribeHumanLoopResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerA2IRuntimeResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeHumanLoopResponse> {
        /**
         * <p>
         * The timestamp when Amazon Augmented AI created the human loop.
         * </p>
         * 
         * @param creationTimestamp
         *        The timestamp when Amazon Augmented AI created the human loop.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTimestamp(Instant creationTimestamp);

        /**
         * <p>
         * The reason why a human loop has failed. The failure reason is returned when the human loop status is
         * <code>Failed</code>.
         * </p>
         * 
         * @param failureReason
         *        The reason why a human loop has failed. The failure reason is returned when the human loop status is
         *        <code>Failed</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);

        /**
         * <p>
         * A failure code denoting a specific type of failure.
         * </p>
         * 
         * @param failureCode
         *        A failure code denoting a specific type of failure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureCode(String failureCode);

        /**
         * <p>
         * The status of the human loop. Valid values:
         * </p>
         * 
         * @param humanLoopStatus
         *        The status of the human loop. Valid values:
         * @see HumanLoopStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HumanLoopStatus
         */
        Builder humanLoopStatus(String humanLoopStatus);

        /**
         * <p>
         * The status of the human loop. Valid values:
         * </p>
         * 
         * @param humanLoopStatus
         *        The status of the human loop. Valid values:
         * @see HumanLoopStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HumanLoopStatus
         */
        Builder humanLoopStatus(HumanLoopStatus humanLoopStatus);

        /**
         * <p>
         * The name of the human loop.
         * </p>
         * 
         * @param humanLoopName
         *        The name of the human loop.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder humanLoopName(String humanLoopName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the human loop.
         * </p>
         * 
         * @param humanLoopArn
         *        The Amazon Resource Name (ARN) of the human loop.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder humanLoopArn(String humanLoopArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the flow definition.
         * </p>
         * 
         * @param flowDefinitionArn
         *        The Amazon Resource Name (ARN) of the flow definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowDefinitionArn(String flowDefinitionArn);

        /**
         * <p>
         * An object containing information about the human loop input.
         * </p>
         * 
         * @param humanLoopInput
         *        An object containing information about the human loop input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder humanLoopInput(HumanLoopInputContent humanLoopInput);

        /**
         * <p>
         * An object containing information about the human loop input.
         * </p>
         * This is a convenience that creates an instance of the {@link HumanLoopInputContent.Builder} avoiding the need
         * to create one manually via {@link HumanLoopInputContent#builder()}.
         *
         * When the {@link Consumer} completes, {@link HumanLoopInputContent.Builder#build()} is called immediately and
         * its result is passed to {@link #humanLoopInput(HumanLoopInputContent)}.
         * 
         * @param humanLoopInput
         *        a consumer that will call methods on {@link HumanLoopInputContent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #humanLoopInput(HumanLoopInputContent)
         */
        default Builder humanLoopInput(Consumer<HumanLoopInputContent.Builder> humanLoopInput) {
            return humanLoopInput(HumanLoopInputContent.builder().applyMutation(humanLoopInput).build());
        }

        /**
         * <p>
         * An object containing information about the output of the human loop.
         * </p>
         * 
         * @param humanLoopOutput
         *        An object containing information about the output of the human loop.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder humanLoopOutput(HumanLoopOutputContent humanLoopOutput);

        /**
         * <p>
         * An object containing information about the output of the human loop.
         * </p>
         * This is a convenience that creates an instance of the {@link HumanLoopOutputContent.Builder} avoiding the
         * need to create one manually via {@link HumanLoopOutputContent#builder()}.
         *
         * When the {@link Consumer} completes, {@link HumanLoopOutputContent.Builder#build()} is called immediately and
         * its result is passed to {@link #humanLoopOutput(HumanLoopOutputContent)}.
         * 
         * @param humanLoopOutput
         *        a consumer that will call methods on {@link HumanLoopOutputContent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #humanLoopOutput(HumanLoopOutputContent)
         */
        default Builder humanLoopOutput(Consumer<HumanLoopOutputContent.Builder> humanLoopOutput) {
            return humanLoopOutput(HumanLoopOutputContent.builder().applyMutation(humanLoopOutput).build());
        }
    }

    static final class BuilderImpl extends SageMakerA2IRuntimeResponse.BuilderImpl implements Builder {
        private Instant creationTimestamp;

        private String failureReason;

        private String failureCode;

        private String humanLoopStatus;

        private String humanLoopName;

        private String humanLoopArn;

        private String flowDefinitionArn;

        private HumanLoopInputContent humanLoopInput;

        private HumanLoopOutputContent humanLoopOutput;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeHumanLoopResponse model) {
            super(model);
            creationTimestamp(model.creationTimestamp);
            failureReason(model.failureReason);
            failureCode(model.failureCode);
            humanLoopStatus(model.humanLoopStatus);
            humanLoopName(model.humanLoopName);
            humanLoopArn(model.humanLoopArn);
            flowDefinitionArn(model.flowDefinitionArn);
            humanLoopInput(model.humanLoopInput);
            humanLoopOutput(model.humanLoopOutput);
        }

        public final Instant getCreationTimestamp() {
            return creationTimestamp;
        }

        @Override
        public final Builder creationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        public final void setCreationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        public final String getFailureCode() {
            return failureCode;
        }

        @Override
        public final Builder failureCode(String failureCode) {
            this.failureCode = failureCode;
            return this;
        }

        public final void setFailureCode(String failureCode) {
            this.failureCode = failureCode;
        }

        public final String getHumanLoopStatusAsString() {
            return humanLoopStatus;
        }

        @Override
        public final Builder humanLoopStatus(String humanLoopStatus) {
            this.humanLoopStatus = humanLoopStatus;
            return this;
        }

        @Override
        public final Builder humanLoopStatus(HumanLoopStatus humanLoopStatus) {
            this.humanLoopStatus(humanLoopStatus == null ? null : humanLoopStatus.toString());
            return this;
        }

        public final void setHumanLoopStatus(String humanLoopStatus) {
            this.humanLoopStatus = humanLoopStatus;
        }

        public final String getHumanLoopName() {
            return humanLoopName;
        }

        @Override
        public final Builder humanLoopName(String humanLoopName) {
            this.humanLoopName = humanLoopName;
            return this;
        }

        public final void setHumanLoopName(String humanLoopName) {
            this.humanLoopName = humanLoopName;
        }

        public final String getHumanLoopArn() {
            return humanLoopArn;
        }

        @Override
        public final Builder humanLoopArn(String humanLoopArn) {
            this.humanLoopArn = humanLoopArn;
            return this;
        }

        public final void setHumanLoopArn(String humanLoopArn) {
            this.humanLoopArn = humanLoopArn;
        }

        public final String getFlowDefinitionArn() {
            return flowDefinitionArn;
        }

        @Override
        public final Builder flowDefinitionArn(String flowDefinitionArn) {
            this.flowDefinitionArn = flowDefinitionArn;
            return this;
        }

        public final void setFlowDefinitionArn(String flowDefinitionArn) {
            this.flowDefinitionArn = flowDefinitionArn;
        }

        public final HumanLoopInputContent.Builder getHumanLoopInput() {
            return humanLoopInput != null ? humanLoopInput.toBuilder() : null;
        }

        @Override
        public final Builder humanLoopInput(HumanLoopInputContent humanLoopInput) {
            this.humanLoopInput = humanLoopInput;
            return this;
        }

        public final void setHumanLoopInput(HumanLoopInputContent.BuilderImpl humanLoopInput) {
            this.humanLoopInput = humanLoopInput != null ? humanLoopInput.build() : null;
        }

        public final HumanLoopOutputContent.Builder getHumanLoopOutput() {
            return humanLoopOutput != null ? humanLoopOutput.toBuilder() : null;
        }

        @Override
        public final Builder humanLoopOutput(HumanLoopOutputContent humanLoopOutput) {
            this.humanLoopOutput = humanLoopOutput;
            return this;
        }

        public final void setHumanLoopOutput(HumanLoopOutputContent.BuilderImpl humanLoopOutput) {
            this.humanLoopOutput = humanLoopOutput != null ? humanLoopOutput.build() : null;
        }

        @Override
        public DescribeHumanLoopResponse build() {
            return new DescribeHumanLoopResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
