/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemakera2iruntime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartHumanLoopResponse extends SageMakerA2IRuntimeResponse implements
        ToCopyableBuilder<StartHumanLoopResponse.Builder, StartHumanLoopResponse> {
    private static final SdkField<String> HUMAN_LOOP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StartHumanLoopResponse::humanLoopArn)).setter(setter(Builder::humanLoopArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HumanLoopArn").build()).build();

    private static final SdkField<HumanLoopActivationResults> HUMAN_LOOP_ACTIVATION_RESULTS_FIELD = SdkField
            .<HumanLoopActivationResults> builder(MarshallingType.SDK_POJO)
            .getter(getter(StartHumanLoopResponse::humanLoopActivationResults))
            .setter(setter(Builder::humanLoopActivationResults))
            .constructor(HumanLoopActivationResults::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HumanLoopActivationResults").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HUMAN_LOOP_ARN_FIELD,
            HUMAN_LOOP_ACTIVATION_RESULTS_FIELD));

    private final String humanLoopArn;

    private final HumanLoopActivationResults humanLoopActivationResults;

    private StartHumanLoopResponse(BuilderImpl builder) {
        super(builder);
        this.humanLoopArn = builder.humanLoopArn;
        this.humanLoopActivationResults = builder.humanLoopActivationResults;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the human loop.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the human loop.
     */
    public String humanLoopArn() {
        return humanLoopArn;
    }

    /**
     * <p>
     * An object containing information about the human loop activation.
     * </p>
     * 
     * @return An object containing information about the human loop activation.
     */
    public HumanLoopActivationResults humanLoopActivationResults() {
        return humanLoopActivationResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(humanLoopArn());
        hashCode = 31 * hashCode + Objects.hashCode(humanLoopActivationResults());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartHumanLoopResponse)) {
            return false;
        }
        StartHumanLoopResponse other = (StartHumanLoopResponse) obj;
        return Objects.equals(humanLoopArn(), other.humanLoopArn())
                && Objects.equals(humanLoopActivationResults(), other.humanLoopActivationResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("StartHumanLoopResponse").add("HumanLoopArn", humanLoopArn())
                .add("HumanLoopActivationResults", humanLoopActivationResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HumanLoopArn":
            return Optional.ofNullable(clazz.cast(humanLoopArn()));
        case "HumanLoopActivationResults":
            return Optional.ofNullable(clazz.cast(humanLoopActivationResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartHumanLoopResponse, T> g) {
        return obj -> g.apply((StartHumanLoopResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerA2IRuntimeResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, StartHumanLoopResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the human loop.
         * </p>
         * 
         * @param humanLoopArn
         *        The Amazon Resource Name (ARN) of the human loop.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder humanLoopArn(String humanLoopArn);

        /**
         * <p>
         * An object containing information about the human loop activation.
         * </p>
         * 
         * @param humanLoopActivationResults
         *        An object containing information about the human loop activation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder humanLoopActivationResults(HumanLoopActivationResults humanLoopActivationResults);

        /**
         * <p>
         * An object containing information about the human loop activation.
         * </p>
         * This is a convenience that creates an instance of the {@link HumanLoopActivationResults.Builder} avoiding the
         * need to create one manually via {@link HumanLoopActivationResults#builder()}.
         *
         * When the {@link Consumer} completes, {@link HumanLoopActivationResults.Builder#build()} is called immediately
         * and its result is passed to {@link #humanLoopActivationResults(HumanLoopActivationResults)}.
         * 
         * @param humanLoopActivationResults
         *        a consumer that will call methods on {@link HumanLoopActivationResults.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #humanLoopActivationResults(HumanLoopActivationResults)
         */
        default Builder humanLoopActivationResults(Consumer<HumanLoopActivationResults.Builder> humanLoopActivationResults) {
            return humanLoopActivationResults(HumanLoopActivationResults.builder().applyMutation(humanLoopActivationResults)
                    .build());
        }
    }

    static final class BuilderImpl extends SageMakerA2IRuntimeResponse.BuilderImpl implements Builder {
        private String humanLoopArn;

        private HumanLoopActivationResults humanLoopActivationResults;

        private BuilderImpl() {
        }

        private BuilderImpl(StartHumanLoopResponse model) {
            super(model);
            humanLoopArn(model.humanLoopArn);
            humanLoopActivationResults(model.humanLoopActivationResults);
        }

        public final String getHumanLoopArn() {
            return humanLoopArn;
        }

        @Override
        public final Builder humanLoopArn(String humanLoopArn) {
            this.humanLoopArn = humanLoopArn;
            return this;
        }

        public final void setHumanLoopArn(String humanLoopArn) {
            this.humanLoopArn = humanLoopArn;
        }

        public final HumanLoopActivationResults.Builder getHumanLoopActivationResults() {
            return humanLoopActivationResults != null ? humanLoopActivationResults.toBuilder() : null;
        }

        @Override
        public final Builder humanLoopActivationResults(HumanLoopActivationResults humanLoopActivationResults) {
            this.humanLoopActivationResults = humanLoopActivationResults;
            return this;
        }

        public final void setHumanLoopActivationResults(HumanLoopActivationResults.BuilderImpl humanLoopActivationResults) {
            this.humanLoopActivationResults = humanLoopActivationResults != null ? humanLoopActivationResults.build() : null;
        }

        @Override
        public StartHumanLoopResponse build() {
            return new StartHumanLoopResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
