/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemakera2iruntime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListHumanLoopsResponse extends SageMakerA2IRuntimeResponse implements
        ToCopyableBuilder<ListHumanLoopsResponse.Builder, ListHumanLoopsResponse> {
    private static final SdkField<List<HumanLoopSummary>> HUMAN_LOOP_SUMMARIES_FIELD = SdkField
            .<List<HumanLoopSummary>> builder(MarshallingType.LIST)
            .getter(getter(ListHumanLoopsResponse::humanLoopSummaries))
            .setter(setter(Builder::humanLoopSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HumanLoopSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<HumanLoopSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(HumanLoopSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListHumanLoopsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HUMAN_LOOP_SUMMARIES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<HumanLoopSummary> humanLoopSummaries;

    private final String nextToken;

    private ListHumanLoopsResponse(BuilderImpl builder) {
        super(builder);
        this.humanLoopSummaries = builder.humanLoopSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the HumanLoopSummaries property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasHumanLoopSummaries() {
        return humanLoopSummaries != null && !(humanLoopSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects containing information about the human loops.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasHumanLoopSummaries()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of objects containing information about the human loops.
     */
    public List<HumanLoopSummary> humanLoopSummaries() {
        return humanLoopSummaries;
    }

    /**
     * <p>
     * A token to resume pagination.
     * </p>
     * 
     * @return A token to resume pagination.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(humanLoopSummaries());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListHumanLoopsResponse)) {
            return false;
        }
        ListHumanLoopsResponse other = (ListHumanLoopsResponse) obj;
        return Objects.equals(humanLoopSummaries(), other.humanLoopSummaries()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListHumanLoopsResponse").add("HumanLoopSummaries", humanLoopSummaries())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HumanLoopSummaries":
            return Optional.ofNullable(clazz.cast(humanLoopSummaries()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListHumanLoopsResponse, T> g) {
        return obj -> g.apply((ListHumanLoopsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerA2IRuntimeResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListHumanLoopsResponse> {
        /**
         * <p>
         * An array of objects containing information about the human loops.
         * </p>
         * 
         * @param humanLoopSummaries
         *        An array of objects containing information about the human loops.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder humanLoopSummaries(Collection<HumanLoopSummary> humanLoopSummaries);

        /**
         * <p>
         * An array of objects containing information about the human loops.
         * </p>
         * 
         * @param humanLoopSummaries
         *        An array of objects containing information about the human loops.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder humanLoopSummaries(HumanLoopSummary... humanLoopSummaries);

        /**
         * <p>
         * An array of objects containing information about the human loops.
         * </p>
         * This is a convenience that creates an instance of the {@link List<HumanLoopSummary>.Builder} avoiding the
         * need to create one manually via {@link List<HumanLoopSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<HumanLoopSummary>.Builder#build()} is called immediately and
         * its result is passed to {@link #humanLoopSummaries(List<HumanLoopSummary>)}.
         * 
         * @param humanLoopSummaries
         *        a consumer that will call methods on {@link List<HumanLoopSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #humanLoopSummaries(List<HumanLoopSummary>)
         */
        Builder humanLoopSummaries(Consumer<HumanLoopSummary.Builder>... humanLoopSummaries);

        /**
         * <p>
         * A token to resume pagination.
         * </p>
         * 
         * @param nextToken
         *        A token to resume pagination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SageMakerA2IRuntimeResponse.BuilderImpl implements Builder {
        private List<HumanLoopSummary> humanLoopSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListHumanLoopsResponse model) {
            super(model);
            humanLoopSummaries(model.humanLoopSummaries);
            nextToken(model.nextToken);
        }

        public final Collection<HumanLoopSummary.Builder> getHumanLoopSummaries() {
            return humanLoopSummaries != null ? humanLoopSummaries.stream().map(HumanLoopSummary::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder humanLoopSummaries(Collection<HumanLoopSummary> humanLoopSummaries) {
            this.humanLoopSummaries = HumanLoopSummariesCopier.copy(humanLoopSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder humanLoopSummaries(HumanLoopSummary... humanLoopSummaries) {
            humanLoopSummaries(Arrays.asList(humanLoopSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder humanLoopSummaries(Consumer<HumanLoopSummary.Builder>... humanLoopSummaries) {
            humanLoopSummaries(Stream.of(humanLoopSummaries).map(c -> HumanLoopSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setHumanLoopSummaries(Collection<HumanLoopSummary.BuilderImpl> humanLoopSummaries) {
            this.humanLoopSummaries = HumanLoopSummariesCopier.copyFromBuilder(humanLoopSummaries);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListHumanLoopsResponse build() {
            return new ListHumanLoopsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
