/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemakera2iruntime;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.sagemakera2iruntime.model.DeleteHumanLoopRequest;
import software.amazon.awssdk.services.sagemakera2iruntime.model.DeleteHumanLoopResponse;
import software.amazon.awssdk.services.sagemakera2iruntime.model.DescribeHumanLoopRequest;
import software.amazon.awssdk.services.sagemakera2iruntime.model.DescribeHumanLoopResponse;
import software.amazon.awssdk.services.sagemakera2iruntime.model.ListHumanLoopsRequest;
import software.amazon.awssdk.services.sagemakera2iruntime.model.ListHumanLoopsResponse;
import software.amazon.awssdk.services.sagemakera2iruntime.model.StartHumanLoopRequest;
import software.amazon.awssdk.services.sagemakera2iruntime.model.StartHumanLoopResponse;
import software.amazon.awssdk.services.sagemakera2iruntime.model.StopHumanLoopRequest;
import software.amazon.awssdk.services.sagemakera2iruntime.model.StopHumanLoopResponse;
import software.amazon.awssdk.services.sagemakera2iruntime.paginators.ListHumanLoopsPublisher;

/**
 * Service client for accessing Amazon Augmented AI Runtime asynchronously. This can be created using the static
 * {@link #builder()} method.
 *
 * <p>
 * Amazon Augmented AI (Augmented AI) (Preview) is a service that adds human judgment to any machine learning
 * application. Human reviewers can take over when an AI application can't evaluate data with a high degree of
 * confidence.
 * </p>
 * <p>
 * From fraudulent bank transaction identification to document processing to image analysis, machine learning models can
 * be trained to make decisions as well as or better than a human. Nevertheless, some decisions require contextual
 * interpretation, such as when you need to decide whether an image is appropriate for a given audience. Content
 * moderation guidelines are nuanced and highly dependent on context, and they vary between countries. When trying to
 * apply AI in these situations, you can be forced to choose between "ML only" systems with unacceptably high error
 * rates or "human only" systems that are expensive and difficult to scale, and that slow down decision making.
 * </p>
 * <p>
 * This API reference includes information about API actions and data types you can use to interact with Augmented AI
 * programmatically.
 * </p>
 * <p>
 * You can create a flow definition against the Augmented AI API. Provide the Amazon Resource Name (ARN) of a flow
 * definition to integrate AI service APIs, such as <code>Textract.AnalyzeDocument</code> and
 * <code>Rekognition.DetectModerationLabels</code>. These AI services, in turn, invoke the <a>StartHumanLoop</a> API,
 * which evaluates conditions under which humans will be invoked. If humans are required, Augmented AI creates a human
 * loop. Results of human work are available asynchronously in Amazon Simple Storage Service (Amazon S3). You can use
 * Amazon CloudWatch Events to detect human work results.
 * </p>
 * <p>
 * You can find additional Augmented AI API documentation in the following reference guides: <a
 * href="https://docs.aws.amazon.com/rekognition/latest/dg/API_Reference.html">Amazon Rekognition</a>, <a
 * href="https://docs.aws.amazon.com/sagemaker/latest/dg/API_Reference.html">Amazon SageMaker</a>, and <a
 * href="https://docs.aws.amazon.com/textract/latest/dg/API_Reference.html">Amazon Textract</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public interface SageMakerA2IRuntimeAsyncClient extends SdkClient {
    String SERVICE_NAME = "sagemaker";

    /**
     * Create a {@link SageMakerA2IRuntimeAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static SageMakerA2IRuntimeAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link SageMakerA2IRuntimeAsyncClient}.
     */
    static SageMakerA2IRuntimeAsyncClientBuilder builder() {
        return new DefaultSageMakerA2IRuntimeAsyncClientBuilder();
    }

    /**
     * <p>
     * Deletes the specified human loop for a flow definition.
     * </p>
     *
     * @param deleteHumanLoopRequest
     * @return A Java Future containing the result of the DeleteHumanLoop operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Your request was not valid. Check the syntax and try again.</li>
     *         <li>ResourceNotFoundException We were unable to find the requested resource.</li>
     *         <li>ThrottlingException Your request has exceeded the allowed amount of requests.</li>
     *         <li>InternalServerException Your request could not be processed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerA2IRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample SageMakerA2IRuntimeAsyncClient.DeleteHumanLoop
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-a2i-runtime-2019-11-07/DeleteHumanLoop"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteHumanLoopResponse> deleteHumanLoop(DeleteHumanLoopRequest deleteHumanLoopRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified human loop for a flow definition.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteHumanLoopRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteHumanLoopRequest#builder()}
     * </p>
     *
     * @param deleteHumanLoopRequest
     *        A {@link Consumer} that will call methods on {@link DeleteHumanLoopRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteHumanLoop operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Your request was not valid. Check the syntax and try again.</li>
     *         <li>ResourceNotFoundException We were unable to find the requested resource.</li>
     *         <li>ThrottlingException Your request has exceeded the allowed amount of requests.</li>
     *         <li>InternalServerException Your request could not be processed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerA2IRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample SageMakerA2IRuntimeAsyncClient.DeleteHumanLoop
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-a2i-runtime-2019-11-07/DeleteHumanLoop"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteHumanLoopResponse> deleteHumanLoop(
            Consumer<DeleteHumanLoopRequest.Builder> deleteHumanLoopRequest) {
        return deleteHumanLoop(DeleteHumanLoopRequest.builder().applyMutation(deleteHumanLoopRequest).build());
    }

    /**
     * <p>
     * Returns information about the specified human loop.
     * </p>
     *
     * @param describeHumanLoopRequest
     * @return A Java Future containing the result of the DescribeHumanLoop operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Your request was not valid. Check the syntax and try again.</li>
     *         <li>ResourceNotFoundException We were unable to find the requested resource.</li>
     *         <li>ThrottlingException Your request has exceeded the allowed amount of requests.</li>
     *         <li>InternalServerException Your request could not be processed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerA2IRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample SageMakerA2IRuntimeAsyncClient.DescribeHumanLoop
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-a2i-runtime-2019-11-07/DescribeHumanLoop"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeHumanLoopResponse> describeHumanLoop(DescribeHumanLoopRequest describeHumanLoopRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the specified human loop.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeHumanLoopRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeHumanLoopRequest#builder()}
     * </p>
     *
     * @param describeHumanLoopRequest
     *        A {@link Consumer} that will call methods on {@link DescribeHumanLoopRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeHumanLoop operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Your request was not valid. Check the syntax and try again.</li>
     *         <li>ResourceNotFoundException We were unable to find the requested resource.</li>
     *         <li>ThrottlingException Your request has exceeded the allowed amount of requests.</li>
     *         <li>InternalServerException Your request could not be processed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerA2IRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample SageMakerA2IRuntimeAsyncClient.DescribeHumanLoop
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-a2i-runtime-2019-11-07/DescribeHumanLoop"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeHumanLoopResponse> describeHumanLoop(
            Consumer<DescribeHumanLoopRequest.Builder> describeHumanLoopRequest) {
        return describeHumanLoop(DescribeHumanLoopRequest.builder().applyMutation(describeHumanLoopRequest).build());
    }

    /**
     * <p>
     * Returns information about human loops, given the specified parameters. If a human loop was deleted, it will not
     * be included.
     * </p>
     *
     * @param listHumanLoopsRequest
     * @return A Java Future containing the result of the ListHumanLoops operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Your request was not valid. Check the syntax and try again.</li>
     *         <li>ThrottlingException Your request has exceeded the allowed amount of requests.</li>
     *         <li>InternalServerException Your request could not be processed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerA2IRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample SageMakerA2IRuntimeAsyncClient.ListHumanLoops
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-a2i-runtime-2019-11-07/ListHumanLoops"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListHumanLoopsResponse> listHumanLoops(ListHumanLoopsRequest listHumanLoopsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about human loops, given the specified parameters. If a human loop was deleted, it will not
     * be included.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListHumanLoopsRequest.Builder} avoiding the need to
     * create one manually via {@link ListHumanLoopsRequest#builder()}
     * </p>
     *
     * @param listHumanLoopsRequest
     *        A {@link Consumer} that will call methods on {@link ListHumanLoopsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListHumanLoops operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Your request was not valid. Check the syntax and try again.</li>
     *         <li>ThrottlingException Your request has exceeded the allowed amount of requests.</li>
     *         <li>InternalServerException Your request could not be processed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerA2IRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample SageMakerA2IRuntimeAsyncClient.ListHumanLoops
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-a2i-runtime-2019-11-07/ListHumanLoops"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListHumanLoopsResponse> listHumanLoops(Consumer<ListHumanLoopsRequest.Builder> listHumanLoopsRequest) {
        return listHumanLoops(ListHumanLoopsRequest.builder().applyMutation(listHumanLoopsRequest).build());
    }

    /**
     * <p>
     * Returns information about human loops, given the specified parameters. If a human loop was deleted, it will not
     * be included.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listHumanLoops(software.amazon.awssdk.services.sagemakera2iruntime.model.ListHumanLoopsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemakera2iruntime.paginators.ListHumanLoopsPublisher publisher = client.listHumanLoopsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemakera2iruntime.paginators.ListHumanLoopsPublisher publisher = client.listHumanLoopsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sagemakera2iruntime.model.ListHumanLoopsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sagemakera2iruntime.model.ListHumanLoopsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listHumanLoops(software.amazon.awssdk.services.sagemakera2iruntime.model.ListHumanLoopsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listHumanLoopsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Your request was not valid. Check the syntax and try again.</li>
     *         <li>ThrottlingException Your request has exceeded the allowed amount of requests.</li>
     *         <li>InternalServerException Your request could not be processed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerA2IRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample SageMakerA2IRuntimeAsyncClient.ListHumanLoops
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-a2i-runtime-2019-11-07/ListHumanLoops"
     *      target="_top">AWS API Documentation</a>
     */
    default ListHumanLoopsPublisher listHumanLoopsPaginator(ListHumanLoopsRequest listHumanLoopsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about human loops, given the specified parameters. If a human loop was deleted, it will not
     * be included.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listHumanLoops(software.amazon.awssdk.services.sagemakera2iruntime.model.ListHumanLoopsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemakera2iruntime.paginators.ListHumanLoopsPublisher publisher = client.listHumanLoopsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemakera2iruntime.paginators.ListHumanLoopsPublisher publisher = client.listHumanLoopsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sagemakera2iruntime.model.ListHumanLoopsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sagemakera2iruntime.model.ListHumanLoopsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listHumanLoops(software.amazon.awssdk.services.sagemakera2iruntime.model.ListHumanLoopsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListHumanLoopsRequest.Builder} avoiding the need to
     * create one manually via {@link ListHumanLoopsRequest#builder()}
     * </p>
     *
     * @param listHumanLoopsRequest
     *        A {@link Consumer} that will call methods on {@link ListHumanLoopsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Your request was not valid. Check the syntax and try again.</li>
     *         <li>ThrottlingException Your request has exceeded the allowed amount of requests.</li>
     *         <li>InternalServerException Your request could not be processed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerA2IRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample SageMakerA2IRuntimeAsyncClient.ListHumanLoops
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-a2i-runtime-2019-11-07/ListHumanLoops"
     *      target="_top">AWS API Documentation</a>
     */
    default ListHumanLoopsPublisher listHumanLoopsPaginator(Consumer<ListHumanLoopsRequest.Builder> listHumanLoopsRequest) {
        return listHumanLoopsPaginator(ListHumanLoopsRequest.builder().applyMutation(listHumanLoopsRequest).build());
    }

    /**
     * <p>
     * Starts a human loop, provided that at least one activation condition is met.
     * </p>
     *
     * @param startHumanLoopRequest
     * @return A Java Future containing the result of the StartHumanLoop operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Your request was not valid. Check the syntax and try again.</li>
     *         <li>ThrottlingException Your request has exceeded the allowed amount of requests.</li>
     *         <li>ServiceQuotaExceededException You have exceeded your service quota. To perform the requested action,
     *         remove some of the relevant resources, or request a service quota increase.</li>
     *         <li>InternalServerException Your request could not be processed.</li>
     *         <li>ConflictException Your request has the same name as another active human loop but has different input
     *         data. You cannot start two human loops with the same name and different input data.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerA2IRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample SageMakerA2IRuntimeAsyncClient.StartHumanLoop
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-a2i-runtime-2019-11-07/StartHumanLoop"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartHumanLoopResponse> startHumanLoop(StartHumanLoopRequest startHumanLoopRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a human loop, provided that at least one activation condition is met.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartHumanLoopRequest.Builder} avoiding the need to
     * create one manually via {@link StartHumanLoopRequest#builder()}
     * </p>
     *
     * @param startHumanLoopRequest
     *        A {@link Consumer} that will call methods on {@link StartHumanLoopRequest.Builder} to create a request.
     * @return A Java Future containing the result of the StartHumanLoop operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Your request was not valid. Check the syntax and try again.</li>
     *         <li>ThrottlingException Your request has exceeded the allowed amount of requests.</li>
     *         <li>ServiceQuotaExceededException You have exceeded your service quota. To perform the requested action,
     *         remove some of the relevant resources, or request a service quota increase.</li>
     *         <li>InternalServerException Your request could not be processed.</li>
     *         <li>ConflictException Your request has the same name as another active human loop but has different input
     *         data. You cannot start two human loops with the same name and different input data.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerA2IRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample SageMakerA2IRuntimeAsyncClient.StartHumanLoop
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-a2i-runtime-2019-11-07/StartHumanLoop"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartHumanLoopResponse> startHumanLoop(Consumer<StartHumanLoopRequest.Builder> startHumanLoopRequest) {
        return startHumanLoop(StartHumanLoopRequest.builder().applyMutation(startHumanLoopRequest).build());
    }

    /**
     * <p>
     * Stops the specified human loop.
     * </p>
     *
     * @param stopHumanLoopRequest
     * @return A Java Future containing the result of the StopHumanLoop operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Your request was not valid. Check the syntax and try again.</li>
     *         <li>ResourceNotFoundException We were unable to find the requested resource.</li>
     *         <li>ThrottlingException Your request has exceeded the allowed amount of requests.</li>
     *         <li>InternalServerException Your request could not be processed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerA2IRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample SageMakerA2IRuntimeAsyncClient.StopHumanLoop
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-a2i-runtime-2019-11-07/StopHumanLoop"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StopHumanLoopResponse> stopHumanLoop(StopHumanLoopRequest stopHumanLoopRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops the specified human loop.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopHumanLoopRequest.Builder} avoiding the need to
     * create one manually via {@link StopHumanLoopRequest#builder()}
     * </p>
     *
     * @param stopHumanLoopRequest
     *        A {@link Consumer} that will call methods on {@link StopHumanLoopRequest.Builder} to create a request.
     * @return A Java Future containing the result of the StopHumanLoop operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Your request was not valid. Check the syntax and try again.</li>
     *         <li>ResourceNotFoundException We were unable to find the requested resource.</li>
     *         <li>ThrottlingException Your request has exceeded the allowed amount of requests.</li>
     *         <li>InternalServerException Your request could not be processed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerA2IRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample SageMakerA2IRuntimeAsyncClient.StopHumanLoop
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-a2i-runtime-2019-11-07/StopHumanLoop"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StopHumanLoopResponse> stopHumanLoop(Consumer<StopHumanLoopRequest.Builder> stopHumanLoopRequest) {
        return stopHumanLoop(StopHumanLoopRequest.builder().applyMutation(stopHumanLoopRequest).build());
    }
}
