/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemakera2iruntime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartHumanLoopRequest extends SageMakerA2IRuntimeRequest implements
        ToCopyableBuilder<StartHumanLoopRequest.Builder, StartHumanLoopRequest> {
    private static final SdkField<String> HUMAN_LOOP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StartHumanLoopRequest::humanLoopName)).setter(setter(Builder::humanLoopName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HumanLoopName").build()).build();

    private static final SdkField<String> FLOW_DEFINITION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StartHumanLoopRequest::flowDefinitionArn)).setter(setter(Builder::flowDefinitionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlowDefinitionArn").build()).build();

    private static final SdkField<HumanLoopInput> HUMAN_LOOP_INPUT_FIELD = SdkField
            .<HumanLoopInput> builder(MarshallingType.SDK_POJO).getter(getter(StartHumanLoopRequest::humanLoopInput))
            .setter(setter(Builder::humanLoopInput)).constructor(HumanLoopInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HumanLoopInput").build()).build();

    private static final SdkField<HumanLoopDataAttributes> DATA_ATTRIBUTES_FIELD = SdkField
            .<HumanLoopDataAttributes> builder(MarshallingType.SDK_POJO).getter(getter(StartHumanLoopRequest::dataAttributes))
            .setter(setter(Builder::dataAttributes)).constructor(HumanLoopDataAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataAttributes").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HUMAN_LOOP_NAME_FIELD,
            FLOW_DEFINITION_ARN_FIELD, HUMAN_LOOP_INPUT_FIELD, DATA_ATTRIBUTES_FIELD));

    private final String humanLoopName;

    private final String flowDefinitionArn;

    private final HumanLoopInput humanLoopInput;

    private final HumanLoopDataAttributes dataAttributes;

    private StartHumanLoopRequest(BuilderImpl builder) {
        super(builder);
        this.humanLoopName = builder.humanLoopName;
        this.flowDefinitionArn = builder.flowDefinitionArn;
        this.humanLoopInput = builder.humanLoopInput;
        this.dataAttributes = builder.dataAttributes;
    }

    /**
     * <p>
     * The name of the human loop.
     * </p>
     * 
     * @return The name of the human loop.
     */
    public String humanLoopName() {
        return humanLoopName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the flow definition associated with this human loop.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the flow definition associated with this human loop.
     */
    public String flowDefinitionArn() {
        return flowDefinitionArn;
    }

    /**
     * <p>
     * An object that contains information about the human loop.
     * </p>
     * 
     * @return An object that contains information about the human loop.
     */
    public HumanLoopInput humanLoopInput() {
        return humanLoopInput;
    }

    /**
     * <p>
     * Attributes of the specified data. Use <code>DataAttributes</code> to specify if your data is free of personally
     * identifiable information and/or free of adult content.
     * </p>
     * 
     * @return Attributes of the specified data. Use <code>DataAttributes</code> to specify if your data is free of
     *         personally identifiable information and/or free of adult content.
     */
    public HumanLoopDataAttributes dataAttributes() {
        return dataAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(humanLoopName());
        hashCode = 31 * hashCode + Objects.hashCode(flowDefinitionArn());
        hashCode = 31 * hashCode + Objects.hashCode(humanLoopInput());
        hashCode = 31 * hashCode + Objects.hashCode(dataAttributes());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartHumanLoopRequest)) {
            return false;
        }
        StartHumanLoopRequest other = (StartHumanLoopRequest) obj;
        return Objects.equals(humanLoopName(), other.humanLoopName())
                && Objects.equals(flowDefinitionArn(), other.flowDefinitionArn())
                && Objects.equals(humanLoopInput(), other.humanLoopInput())
                && Objects.equals(dataAttributes(), other.dataAttributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("StartHumanLoopRequest").add("HumanLoopName", humanLoopName())
                .add("FlowDefinitionArn", flowDefinitionArn()).add("HumanLoopInput", humanLoopInput())
                .add("DataAttributes", dataAttributes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HumanLoopName":
            return Optional.ofNullable(clazz.cast(humanLoopName()));
        case "FlowDefinitionArn":
            return Optional.ofNullable(clazz.cast(flowDefinitionArn()));
        case "HumanLoopInput":
            return Optional.ofNullable(clazz.cast(humanLoopInput()));
        case "DataAttributes":
            return Optional.ofNullable(clazz.cast(dataAttributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartHumanLoopRequest, T> g) {
        return obj -> g.apply((StartHumanLoopRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerA2IRuntimeRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartHumanLoopRequest> {
        /**
         * <p>
         * The name of the human loop.
         * </p>
         * 
         * @param humanLoopName
         *        The name of the human loop.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder humanLoopName(String humanLoopName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the flow definition associated with this human loop.
         * </p>
         * 
         * @param flowDefinitionArn
         *        The Amazon Resource Name (ARN) of the flow definition associated with this human loop.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowDefinitionArn(String flowDefinitionArn);

        /**
         * <p>
         * An object that contains information about the human loop.
         * </p>
         * 
         * @param humanLoopInput
         *        An object that contains information about the human loop.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder humanLoopInput(HumanLoopInput humanLoopInput);

        /**
         * <p>
         * An object that contains information about the human loop.
         * </p>
         * This is a convenience that creates an instance of the {@link HumanLoopInput.Builder} avoiding the need to
         * create one manually via {@link HumanLoopInput#builder()}.
         *
         * When the {@link Consumer} completes, {@link HumanLoopInput.Builder#build()} is called immediately and its
         * result is passed to {@link #humanLoopInput(HumanLoopInput)}.
         * 
         * @param humanLoopInput
         *        a consumer that will call methods on {@link HumanLoopInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #humanLoopInput(HumanLoopInput)
         */
        default Builder humanLoopInput(Consumer<HumanLoopInput.Builder> humanLoopInput) {
            return humanLoopInput(HumanLoopInput.builder().applyMutation(humanLoopInput).build());
        }

        /**
         * <p>
         * Attributes of the specified data. Use <code>DataAttributes</code> to specify if your data is free of
         * personally identifiable information and/or free of adult content.
         * </p>
         * 
         * @param dataAttributes
         *        Attributes of the specified data. Use <code>DataAttributes</code> to specify if your data is free of
         *        personally identifiable information and/or free of adult content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataAttributes(HumanLoopDataAttributes dataAttributes);

        /**
         * <p>
         * Attributes of the specified data. Use <code>DataAttributes</code> to specify if your data is free of
         * personally identifiable information and/or free of adult content.
         * </p>
         * This is a convenience that creates an instance of the {@link HumanLoopDataAttributes.Builder} avoiding the
         * need to create one manually via {@link HumanLoopDataAttributes#builder()}.
         *
         * When the {@link Consumer} completes, {@link HumanLoopDataAttributes.Builder#build()} is called immediately
         * and its result is passed to {@link #dataAttributes(HumanLoopDataAttributes)}.
         * 
         * @param dataAttributes
         *        a consumer that will call methods on {@link HumanLoopDataAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataAttributes(HumanLoopDataAttributes)
         */
        default Builder dataAttributes(Consumer<HumanLoopDataAttributes.Builder> dataAttributes) {
            return dataAttributes(HumanLoopDataAttributes.builder().applyMutation(dataAttributes).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerA2IRuntimeRequest.BuilderImpl implements Builder {
        private String humanLoopName;

        private String flowDefinitionArn;

        private HumanLoopInput humanLoopInput;

        private HumanLoopDataAttributes dataAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(StartHumanLoopRequest model) {
            super(model);
            humanLoopName(model.humanLoopName);
            flowDefinitionArn(model.flowDefinitionArn);
            humanLoopInput(model.humanLoopInput);
            dataAttributes(model.dataAttributes);
        }

        public final String getHumanLoopName() {
            return humanLoopName;
        }

        @Override
        public final Builder humanLoopName(String humanLoopName) {
            this.humanLoopName = humanLoopName;
            return this;
        }

        public final void setHumanLoopName(String humanLoopName) {
            this.humanLoopName = humanLoopName;
        }

        public final String getFlowDefinitionArn() {
            return flowDefinitionArn;
        }

        @Override
        public final Builder flowDefinitionArn(String flowDefinitionArn) {
            this.flowDefinitionArn = flowDefinitionArn;
            return this;
        }

        public final void setFlowDefinitionArn(String flowDefinitionArn) {
            this.flowDefinitionArn = flowDefinitionArn;
        }

        public final HumanLoopInput.Builder getHumanLoopInput() {
            return humanLoopInput != null ? humanLoopInput.toBuilder() : null;
        }

        @Override
        public final Builder humanLoopInput(HumanLoopInput humanLoopInput) {
            this.humanLoopInput = humanLoopInput;
            return this;
        }

        public final void setHumanLoopInput(HumanLoopInput.BuilderImpl humanLoopInput) {
            this.humanLoopInput = humanLoopInput != null ? humanLoopInput.build() : null;
        }

        public final HumanLoopDataAttributes.Builder getDataAttributes() {
            return dataAttributes != null ? dataAttributes.toBuilder() : null;
        }

        @Override
        public final Builder dataAttributes(HumanLoopDataAttributes dataAttributes) {
            this.dataAttributes = dataAttributes;
            return this;
        }

        public final void setDataAttributes(HumanLoopDataAttributes.BuilderImpl dataAttributes) {
            this.dataAttributes = dataAttributes != null ? dataAttributes.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartHumanLoopRequest build() {
            return new StartHumanLoopRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
