/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemakera2iruntime.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary information about the human loop.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HumanLoopSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<HumanLoopSummary.Builder, HumanLoopSummary> {
    private static final SdkField<String> HUMAN_LOOP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HumanLoopName").getter(getter(HumanLoopSummary::humanLoopName)).setter(setter(Builder::humanLoopName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HumanLoopName").build()).build();

    private static final SdkField<String> HUMAN_LOOP_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HumanLoopStatus").getter(getter(HumanLoopSummary::humanLoopStatusAsString))
            .setter(setter(Builder::humanLoopStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HumanLoopStatus").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(HumanLoopSummary::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailureReason").getter(getter(HumanLoopSummary::failureReason)).setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()).build();

    private static final SdkField<String> FLOW_DEFINITION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FlowDefinitionArn").getter(getter(HumanLoopSummary::flowDefinitionArn))
            .setter(setter(Builder::flowDefinitionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlowDefinitionArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HUMAN_LOOP_NAME_FIELD,
            HUMAN_LOOP_STATUS_FIELD, CREATION_TIME_FIELD, FAILURE_REASON_FIELD, FLOW_DEFINITION_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String humanLoopName;

    private final String humanLoopStatus;

    private final Instant creationTime;

    private final String failureReason;

    private final String flowDefinitionArn;

    private HumanLoopSummary(BuilderImpl builder) {
        this.humanLoopName = builder.humanLoopName;
        this.humanLoopStatus = builder.humanLoopStatus;
        this.creationTime = builder.creationTime;
        this.failureReason = builder.failureReason;
        this.flowDefinitionArn = builder.flowDefinitionArn;
    }

    /**
     * <p>
     * The name of the human loop.
     * </p>
     * 
     * @return The name of the human loop.
     */
    public final String humanLoopName() {
        return humanLoopName;
    }

    /**
     * <p>
     * The status of the human loop.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #humanLoopStatus}
     * will return {@link HumanLoopStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #humanLoopStatusAsString}.
     * </p>
     * 
     * @return The status of the human loop.
     * @see HumanLoopStatus
     */
    public final HumanLoopStatus humanLoopStatus() {
        return HumanLoopStatus.fromValue(humanLoopStatus);
    }

    /**
     * <p>
     * The status of the human loop.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #humanLoopStatus}
     * will return {@link HumanLoopStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #humanLoopStatusAsString}.
     * </p>
     * 
     * @return The status of the human loop.
     * @see HumanLoopStatus
     */
    public final String humanLoopStatusAsString() {
        return humanLoopStatus;
    }

    /**
     * <p>
     * When Amazon Augmented AI created the human loop.
     * </p>
     * 
     * @return When Amazon Augmented AI created the human loop.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The reason why the human loop failed. A failure reason is returned when the status of the human loop is
     * <code>Failed</code>.
     * </p>
     * 
     * @return The reason why the human loop failed. A failure reason is returned when the status of the human loop is
     *         <code>Failed</code>.
     */
    public final String failureReason() {
        return failureReason;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the flow definition used to configure the human loop.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the flow definition used to configure the human loop.
     */
    public final String flowDefinitionArn() {
        return flowDefinitionArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(humanLoopName());
        hashCode = 31 * hashCode + Objects.hashCode(humanLoopStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(flowDefinitionArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HumanLoopSummary)) {
            return false;
        }
        HumanLoopSummary other = (HumanLoopSummary) obj;
        return Objects.equals(humanLoopName(), other.humanLoopName())
                && Objects.equals(humanLoopStatusAsString(), other.humanLoopStatusAsString())
                && Objects.equals(creationTime(), other.creationTime()) && Objects.equals(failureReason(), other.failureReason())
                && Objects.equals(flowDefinitionArn(), other.flowDefinitionArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HumanLoopSummary").add("HumanLoopName", humanLoopName())
                .add("HumanLoopStatus", humanLoopStatusAsString()).add("CreationTime", creationTime())
                .add("FailureReason", failureReason()).add("FlowDefinitionArn", flowDefinitionArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HumanLoopName":
            return Optional.ofNullable(clazz.cast(humanLoopName()));
        case "HumanLoopStatus":
            return Optional.ofNullable(clazz.cast(humanLoopStatusAsString()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "FailureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        case "FlowDefinitionArn":
            return Optional.ofNullable(clazz.cast(flowDefinitionArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HumanLoopSummary, T> g) {
        return obj -> g.apply((HumanLoopSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HumanLoopSummary> {
        /**
         * <p>
         * The name of the human loop.
         * </p>
         * 
         * @param humanLoopName
         *        The name of the human loop.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder humanLoopName(String humanLoopName);

        /**
         * <p>
         * The status of the human loop.
         * </p>
         * 
         * @param humanLoopStatus
         *        The status of the human loop.
         * @see HumanLoopStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HumanLoopStatus
         */
        Builder humanLoopStatus(String humanLoopStatus);

        /**
         * <p>
         * The status of the human loop.
         * </p>
         * 
         * @param humanLoopStatus
         *        The status of the human loop.
         * @see HumanLoopStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HumanLoopStatus
         */
        Builder humanLoopStatus(HumanLoopStatus humanLoopStatus);

        /**
         * <p>
         * When Amazon Augmented AI created the human loop.
         * </p>
         * 
         * @param creationTime
         *        When Amazon Augmented AI created the human loop.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The reason why the human loop failed. A failure reason is returned when the status of the human loop is
         * <code>Failed</code>.
         * </p>
         * 
         * @param failureReason
         *        The reason why the human loop failed. A failure reason is returned when the status of the human loop
         *        is <code>Failed</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the flow definition used to configure the human loop.
         * </p>
         * 
         * @param flowDefinitionArn
         *        The Amazon Resource Name (ARN) of the flow definition used to configure the human loop.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowDefinitionArn(String flowDefinitionArn);
    }

    static final class BuilderImpl implements Builder {
        private String humanLoopName;

        private String humanLoopStatus;

        private Instant creationTime;

        private String failureReason;

        private String flowDefinitionArn;

        private BuilderImpl() {
        }

        private BuilderImpl(HumanLoopSummary model) {
            humanLoopName(model.humanLoopName);
            humanLoopStatus(model.humanLoopStatus);
            creationTime(model.creationTime);
            failureReason(model.failureReason);
            flowDefinitionArn(model.flowDefinitionArn);
        }

        public final String getHumanLoopName() {
            return humanLoopName;
        }

        public final void setHumanLoopName(String humanLoopName) {
            this.humanLoopName = humanLoopName;
        }

        @Override
        public final Builder humanLoopName(String humanLoopName) {
            this.humanLoopName = humanLoopName;
            return this;
        }

        public final String getHumanLoopStatus() {
            return humanLoopStatus;
        }

        public final void setHumanLoopStatus(String humanLoopStatus) {
            this.humanLoopStatus = humanLoopStatus;
        }

        @Override
        public final Builder humanLoopStatus(String humanLoopStatus) {
            this.humanLoopStatus = humanLoopStatus;
            return this;
        }

        @Override
        public final Builder humanLoopStatus(HumanLoopStatus humanLoopStatus) {
            this.humanLoopStatus(humanLoopStatus == null ? null : humanLoopStatus.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final String getFlowDefinitionArn() {
            return flowDefinitionArn;
        }

        public final void setFlowDefinitionArn(String flowDefinitionArn) {
            this.flowDefinitionArn = flowDefinitionArn;
        }

        @Override
        public final Builder flowDefinitionArn(String flowDefinitionArn) {
            this.flowDefinitionArn = flowDefinitionArn;
            return this;
        }

        @Override
        public HumanLoopSummary build() {
            return new HumanLoopSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
