/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemakera2iruntime.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeHumanLoopResponse extends SageMakerA2IRuntimeResponse implements
        ToCopyableBuilder<DescribeHumanLoopResponse.Builder, DescribeHumanLoopResponse> {
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime")
            .getter(getter(DescribeHumanLoopResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailureReason").getter(getter(DescribeHumanLoopResponse::failureReason))
            .setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()).build();

    private static final SdkField<String> FAILURE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailureCode").getter(getter(DescribeHumanLoopResponse::failureCode))
            .setter(setter(Builder::failureCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureCode").build()).build();

    private static final SdkField<String> HUMAN_LOOP_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HumanLoopStatus").getter(getter(DescribeHumanLoopResponse::humanLoopStatusAsString))
            .setter(setter(Builder::humanLoopStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HumanLoopStatus").build()).build();

    private static final SdkField<String> HUMAN_LOOP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HumanLoopName").getter(getter(DescribeHumanLoopResponse::humanLoopName))
            .setter(setter(Builder::humanLoopName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HumanLoopName").build()).build();

    private static final SdkField<String> HUMAN_LOOP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HumanLoopArn").getter(getter(DescribeHumanLoopResponse::humanLoopArn))
            .setter(setter(Builder::humanLoopArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HumanLoopArn").build()).build();

    private static final SdkField<String> FLOW_DEFINITION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FlowDefinitionArn").getter(getter(DescribeHumanLoopResponse::flowDefinitionArn))
            .setter(setter(Builder::flowDefinitionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlowDefinitionArn").build()).build();

    private static final SdkField<HumanLoopOutput> HUMAN_LOOP_OUTPUT_FIELD = SdkField
            .<HumanLoopOutput> builder(MarshallingType.SDK_POJO).memberName("HumanLoopOutput")
            .getter(getter(DescribeHumanLoopResponse::humanLoopOutput)).setter(setter(Builder::humanLoopOutput))
            .constructor(HumanLoopOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HumanLoopOutput").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATION_TIME_FIELD,
            FAILURE_REASON_FIELD, FAILURE_CODE_FIELD, HUMAN_LOOP_STATUS_FIELD, HUMAN_LOOP_NAME_FIELD, HUMAN_LOOP_ARN_FIELD,
            FLOW_DEFINITION_ARN_FIELD, HUMAN_LOOP_OUTPUT_FIELD));

    private final Instant creationTime;

    private final String failureReason;

    private final String failureCode;

    private final String humanLoopStatus;

    private final String humanLoopName;

    private final String humanLoopArn;

    private final String flowDefinitionArn;

    private final HumanLoopOutput humanLoopOutput;

    private DescribeHumanLoopResponse(BuilderImpl builder) {
        super(builder);
        this.creationTime = builder.creationTime;
        this.failureReason = builder.failureReason;
        this.failureCode = builder.failureCode;
        this.humanLoopStatus = builder.humanLoopStatus;
        this.humanLoopName = builder.humanLoopName;
        this.humanLoopArn = builder.humanLoopArn;
        this.flowDefinitionArn = builder.flowDefinitionArn;
        this.humanLoopOutput = builder.humanLoopOutput;
    }

    /**
     * <p>
     * The creation time when Amazon Augmented AI created the human loop.
     * </p>
     * 
     * @return The creation time when Amazon Augmented AI created the human loop.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The reason why a human loop failed. The failure reason is returned when the status of the human loop is
     * <code>Failed</code>.
     * </p>
     * 
     * @return The reason why a human loop failed. The failure reason is returned when the status of the human loop is
     *         <code>Failed</code>.
     */
    public final String failureReason() {
        return failureReason;
    }

    /**
     * <p>
     * A failure code that identifies the type of failure.
     * </p>
     * <p>
     * Possible values: <code>ValidationError</code>, <code>Expired</code>, <code>InternalError</code>
     * </p>
     * 
     * @return A failure code that identifies the type of failure.</p>
     *         <p>
     *         Possible values: <code>ValidationError</code>, <code>Expired</code>, <code>InternalError</code>
     */
    public final String failureCode() {
        return failureCode;
    }

    /**
     * <p>
     * The status of the human loop.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #humanLoopStatus}
     * will return {@link HumanLoopStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #humanLoopStatusAsString}.
     * </p>
     * 
     * @return The status of the human loop.
     * @see HumanLoopStatus
     */
    public final HumanLoopStatus humanLoopStatus() {
        return HumanLoopStatus.fromValue(humanLoopStatus);
    }

    /**
     * <p>
     * The status of the human loop.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #humanLoopStatus}
     * will return {@link HumanLoopStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #humanLoopStatusAsString}.
     * </p>
     * 
     * @return The status of the human loop.
     * @see HumanLoopStatus
     */
    public final String humanLoopStatusAsString() {
        return humanLoopStatus;
    }

    /**
     * <p>
     * The name of the human loop. The name must be lowercase, unique within the Region in your account, and can have up
     * to 63 characters. Valid characters: a-z, 0-9, and - (hyphen).
     * </p>
     * 
     * @return The name of the human loop. The name must be lowercase, unique within the Region in your account, and can
     *         have up to 63 characters. Valid characters: a-z, 0-9, and - (hyphen).
     */
    public final String humanLoopName() {
        return humanLoopName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the human loop.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the human loop.
     */
    public final String humanLoopArn() {
        return humanLoopArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the flow definition.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the flow definition.
     */
    public final String flowDefinitionArn() {
        return flowDefinitionArn;
    }

    /**
     * <p>
     * An object that contains information about the output of the human loop.
     * </p>
     * 
     * @return An object that contains information about the output of the human loop.
     */
    public final HumanLoopOutput humanLoopOutput() {
        return humanLoopOutput;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(failureCode());
        hashCode = 31 * hashCode + Objects.hashCode(humanLoopStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(humanLoopName());
        hashCode = 31 * hashCode + Objects.hashCode(humanLoopArn());
        hashCode = 31 * hashCode + Objects.hashCode(flowDefinitionArn());
        hashCode = 31 * hashCode + Objects.hashCode(humanLoopOutput());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeHumanLoopResponse)) {
            return false;
        }
        DescribeHumanLoopResponse other = (DescribeHumanLoopResponse) obj;
        return Objects.equals(creationTime(), other.creationTime()) && Objects.equals(failureReason(), other.failureReason())
                && Objects.equals(failureCode(), other.failureCode())
                && Objects.equals(humanLoopStatusAsString(), other.humanLoopStatusAsString())
                && Objects.equals(humanLoopName(), other.humanLoopName()) && Objects.equals(humanLoopArn(), other.humanLoopArn())
                && Objects.equals(flowDefinitionArn(), other.flowDefinitionArn())
                && Objects.equals(humanLoopOutput(), other.humanLoopOutput());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeHumanLoopResponse").add("CreationTime", creationTime())
                .add("FailureReason", failureReason()).add("FailureCode", failureCode())
                .add("HumanLoopStatus", humanLoopStatusAsString()).add("HumanLoopName", humanLoopName())
                .add("HumanLoopArn", humanLoopArn()).add("FlowDefinitionArn", flowDefinitionArn())
                .add("HumanLoopOutput", humanLoopOutput()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "FailureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        case "FailureCode":
            return Optional.ofNullable(clazz.cast(failureCode()));
        case "HumanLoopStatus":
            return Optional.ofNullable(clazz.cast(humanLoopStatusAsString()));
        case "HumanLoopName":
            return Optional.ofNullable(clazz.cast(humanLoopName()));
        case "HumanLoopArn":
            return Optional.ofNullable(clazz.cast(humanLoopArn()));
        case "FlowDefinitionArn":
            return Optional.ofNullable(clazz.cast(flowDefinitionArn()));
        case "HumanLoopOutput":
            return Optional.ofNullable(clazz.cast(humanLoopOutput()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeHumanLoopResponse, T> g) {
        return obj -> g.apply((DescribeHumanLoopResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerA2IRuntimeResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeHumanLoopResponse> {
        /**
         * <p>
         * The creation time when Amazon Augmented AI created the human loop.
         * </p>
         * 
         * @param creationTime
         *        The creation time when Amazon Augmented AI created the human loop.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The reason why a human loop failed. The failure reason is returned when the status of the human loop is
         * <code>Failed</code>.
         * </p>
         * 
         * @param failureReason
         *        The reason why a human loop failed. The failure reason is returned when the status of the human loop
         *        is <code>Failed</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);

        /**
         * <p>
         * A failure code that identifies the type of failure.
         * </p>
         * <p>
         * Possible values: <code>ValidationError</code>, <code>Expired</code>, <code>InternalError</code>
         * </p>
         * 
         * @param failureCode
         *        A failure code that identifies the type of failure.</p>
         *        <p>
         *        Possible values: <code>ValidationError</code>, <code>Expired</code>, <code>InternalError</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureCode(String failureCode);

        /**
         * <p>
         * The status of the human loop.
         * </p>
         * 
         * @param humanLoopStatus
         *        The status of the human loop.
         * @see HumanLoopStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HumanLoopStatus
         */
        Builder humanLoopStatus(String humanLoopStatus);

        /**
         * <p>
         * The status of the human loop.
         * </p>
         * 
         * @param humanLoopStatus
         *        The status of the human loop.
         * @see HumanLoopStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HumanLoopStatus
         */
        Builder humanLoopStatus(HumanLoopStatus humanLoopStatus);

        /**
         * <p>
         * The name of the human loop. The name must be lowercase, unique within the Region in your account, and can
         * have up to 63 characters. Valid characters: a-z, 0-9, and - (hyphen).
         * </p>
         * 
         * @param humanLoopName
         *        The name of the human loop. The name must be lowercase, unique within the Region in your account, and
         *        can have up to 63 characters. Valid characters: a-z, 0-9, and - (hyphen).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder humanLoopName(String humanLoopName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the human loop.
         * </p>
         * 
         * @param humanLoopArn
         *        The Amazon Resource Name (ARN) of the human loop.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder humanLoopArn(String humanLoopArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the flow definition.
         * </p>
         * 
         * @param flowDefinitionArn
         *        The Amazon Resource Name (ARN) of the flow definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowDefinitionArn(String flowDefinitionArn);

        /**
         * <p>
         * An object that contains information about the output of the human loop.
         * </p>
         * 
         * @param humanLoopOutput
         *        An object that contains information about the output of the human loop.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder humanLoopOutput(HumanLoopOutput humanLoopOutput);

        /**
         * <p>
         * An object that contains information about the output of the human loop.
         * </p>
         * This is a convenience method that creates an instance of the {@link HumanLoopOutput.Builder} avoiding the
         * need to create one manually via {@link HumanLoopOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HumanLoopOutput.Builder#build()} is called immediately and its
         * result is passed to {@link #humanLoopOutput(HumanLoopOutput)}.
         * 
         * @param humanLoopOutput
         *        a consumer that will call methods on {@link HumanLoopOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #humanLoopOutput(HumanLoopOutput)
         */
        default Builder humanLoopOutput(Consumer<HumanLoopOutput.Builder> humanLoopOutput) {
            return humanLoopOutput(HumanLoopOutput.builder().applyMutation(humanLoopOutput).build());
        }
    }

    static final class BuilderImpl extends SageMakerA2IRuntimeResponse.BuilderImpl implements Builder {
        private Instant creationTime;

        private String failureReason;

        private String failureCode;

        private String humanLoopStatus;

        private String humanLoopName;

        private String humanLoopArn;

        private String flowDefinitionArn;

        private HumanLoopOutput humanLoopOutput;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeHumanLoopResponse model) {
            super(model);
            creationTime(model.creationTime);
            failureReason(model.failureReason);
            failureCode(model.failureCode);
            humanLoopStatus(model.humanLoopStatus);
            humanLoopName(model.humanLoopName);
            humanLoopArn(model.humanLoopArn);
            flowDefinitionArn(model.flowDefinitionArn);
            humanLoopOutput(model.humanLoopOutput);
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final String getFailureCode() {
            return failureCode;
        }

        public final void setFailureCode(String failureCode) {
            this.failureCode = failureCode;
        }

        @Override
        public final Builder failureCode(String failureCode) {
            this.failureCode = failureCode;
            return this;
        }

        public final String getHumanLoopStatus() {
            return humanLoopStatus;
        }

        public final void setHumanLoopStatus(String humanLoopStatus) {
            this.humanLoopStatus = humanLoopStatus;
        }

        @Override
        public final Builder humanLoopStatus(String humanLoopStatus) {
            this.humanLoopStatus = humanLoopStatus;
            return this;
        }

        @Override
        public final Builder humanLoopStatus(HumanLoopStatus humanLoopStatus) {
            this.humanLoopStatus(humanLoopStatus == null ? null : humanLoopStatus.toString());
            return this;
        }

        public final String getHumanLoopName() {
            return humanLoopName;
        }

        public final void setHumanLoopName(String humanLoopName) {
            this.humanLoopName = humanLoopName;
        }

        @Override
        public final Builder humanLoopName(String humanLoopName) {
            this.humanLoopName = humanLoopName;
            return this;
        }

        public final String getHumanLoopArn() {
            return humanLoopArn;
        }

        public final void setHumanLoopArn(String humanLoopArn) {
            this.humanLoopArn = humanLoopArn;
        }

        @Override
        public final Builder humanLoopArn(String humanLoopArn) {
            this.humanLoopArn = humanLoopArn;
            return this;
        }

        public final String getFlowDefinitionArn() {
            return flowDefinitionArn;
        }

        public final void setFlowDefinitionArn(String flowDefinitionArn) {
            this.flowDefinitionArn = flowDefinitionArn;
        }

        @Override
        public final Builder flowDefinitionArn(String flowDefinitionArn) {
            this.flowDefinitionArn = flowDefinitionArn;
            return this;
        }

        public final HumanLoopOutput.Builder getHumanLoopOutput() {
            return humanLoopOutput != null ? humanLoopOutput.toBuilder() : null;
        }

        public final void setHumanLoopOutput(HumanLoopOutput.BuilderImpl humanLoopOutput) {
            this.humanLoopOutput = humanLoopOutput != null ? humanLoopOutput.build() : null;
        }

        @Override
        public final Builder humanLoopOutput(HumanLoopOutput humanLoopOutput) {
            this.humanLoopOutput = humanLoopOutput;
            return this;
        }

        @Override
        public DescribeHumanLoopResponse build() {
            return new DescribeHumanLoopResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
