/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemakera2iruntime;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.sagemakera2iruntime.model.DeleteHumanLoopRequest;
import software.amazon.awssdk.services.sagemakera2iruntime.model.DeleteHumanLoopResponse;
import software.amazon.awssdk.services.sagemakera2iruntime.model.DescribeHumanLoopRequest;
import software.amazon.awssdk.services.sagemakera2iruntime.model.DescribeHumanLoopResponse;
import software.amazon.awssdk.services.sagemakera2iruntime.model.ListHumanLoopsRequest;
import software.amazon.awssdk.services.sagemakera2iruntime.model.ListHumanLoopsResponse;
import software.amazon.awssdk.services.sagemakera2iruntime.model.StartHumanLoopRequest;
import software.amazon.awssdk.services.sagemakera2iruntime.model.StartHumanLoopResponse;
import software.amazon.awssdk.services.sagemakera2iruntime.model.StopHumanLoopRequest;
import software.amazon.awssdk.services.sagemakera2iruntime.model.StopHumanLoopResponse;
import software.amazon.awssdk.services.sagemakera2iruntime.paginators.ListHumanLoopsPublisher;

/**
 * Service client for accessing Amazon Augmented AI Runtime asynchronously. This can be created using the static
 * {@link #builder()} method.The asynchronous client performs non-blocking I/O when configured with any
 * {@code SdkAsyncHttpClient} supported in the SDK. However, full non-blocking is not guaranteed as the async client may
 * perform blocking calls in some cases such as credentials retrieval and endpoint discovery as part of the async API
 * call.
 *
 * <p>
 * Amazon Augmented AI (Amazon A2I) adds the benefit of human judgment to any machine learning application. When an AI
 * application can't evaluate data with a high degree of confidence, human reviewers can take over. This human review is
 * called a human review workflow. To create and start a human review workflow, you need three resources: a <i>worker
 * task template</i>, a <i>flow definition</i>, and a <i>human loop</i>.
 * </p>
 * <p>
 * For information about these resources and prerequisites for using Amazon A2I, see <a
 * href="https://docs.aws.amazon.com/sagemaker/latest/dg/a2i-getting-started.html">Get Started with Amazon Augmented
 * AI</a> in the Amazon SageMaker Developer Guide.
 * </p>
 * <p>
 * This API reference includes information about API actions and data types that you can use to interact with Amazon A2I
 * programmatically. Use this guide to:
 * </p>
 * <ul>
 * <li>
 * <p>
 * Start a human loop with the <code>StartHumanLoop</code> operation when using Amazon A2I with a <i>custom task
 * type</i>. To learn more about the difference between custom and built-in task types, see <a
 * href="https://docs.aws.amazon.com/sagemaker/latest/dg/a2i-task-types-general.html">Use Task Types </a>. To learn how
 * to start a human loop using this API, see <a
 * href="https://docs.aws.amazon.com/sagemaker/latest/dg/a2i-start-human-loop.html#a2i-instructions-starthumanloop"
 * >Create and Start a Human Loop for a Custom Task Type </a> in the Amazon SageMaker Developer Guide.
 * </p>
 * </li>
 * <li>
 * <p>
 * Manage your human loops. You can list all human loops that you have created, describe individual human loops, and
 * stop and delete human loops. To learn more, see <a
 * href="https://docs.aws.amazon.com/sagemaker/latest/dg/a2i-monitor-humanloop-results.html">Monitor and Manage Your
 * Human Loop </a> in the Amazon SageMaker Developer Guide.
 * </p>
 * </li>
 * </ul>
 * <p>
 * Amazon A2I integrates APIs from various AWS services to create and start human review workflows for those services.
 * To learn how Amazon A2I uses these APIs, see <a
 * href="https://docs.aws.amazon.com/sagemaker/latest/dg/a2i-api-references.html">Use APIs in Amazon A2I</a> in the
 * Amazon SageMaker Developer Guide.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface SageMakerA2IRuntimeAsyncClient extends AwsClient {
    String SERVICE_NAME = "sagemaker";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "a2i-runtime.sagemaker";

    /**
     * <p>
     * Deletes the specified human loop for a flow definition.
     * </p>
     * <p>
     * If the human loop was deleted, this operation will return a <code>ResourceNotFoundException</code>.
     * </p>
     *
     * @param deleteHumanLoopRequest
     * @return A Java Future containing the result of the DeleteHumanLoop operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request isn't valid. Check the syntax and try again.</li>
     *         <li>ResourceNotFoundException We couldn't find the requested resource. Check that your resources exists
     *         and were created in the same AWS Region as your request, and try your request again.</li>
     *         <li>ThrottlingException You exceeded the maximum number of requests.</li>
     *         <li>InternalServerException We couldn't process your request because of an issue with the server. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerA2IRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample SageMakerA2IRuntimeAsyncClient.DeleteHumanLoop
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-a2i-runtime-2019-11-07/DeleteHumanLoop"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteHumanLoopResponse> deleteHumanLoop(DeleteHumanLoopRequest deleteHumanLoopRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified human loop for a flow definition.
     * </p>
     * <p>
     * If the human loop was deleted, this operation will return a <code>ResourceNotFoundException</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteHumanLoopRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteHumanLoopRequest#builder()}
     * </p>
     *
     * @param deleteHumanLoopRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemakera2iruntime.model.DeleteHumanLoopRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DeleteHumanLoop operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request isn't valid. Check the syntax and try again.</li>
     *         <li>ResourceNotFoundException We couldn't find the requested resource. Check that your resources exists
     *         and were created in the same AWS Region as your request, and try your request again.</li>
     *         <li>ThrottlingException You exceeded the maximum number of requests.</li>
     *         <li>InternalServerException We couldn't process your request because of an issue with the server. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerA2IRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample SageMakerA2IRuntimeAsyncClient.DeleteHumanLoop
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-a2i-runtime-2019-11-07/DeleteHumanLoop"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteHumanLoopResponse> deleteHumanLoop(
            Consumer<DeleteHumanLoopRequest.Builder> deleteHumanLoopRequest) {
        return deleteHumanLoop(DeleteHumanLoopRequest.builder().applyMutation(deleteHumanLoopRequest).build());
    }

    /**
     * <p>
     * Returns information about the specified human loop. If the human loop was deleted, this operation will return a
     * <code>ResourceNotFoundException</code> error.
     * </p>
     *
     * @param describeHumanLoopRequest
     * @return A Java Future containing the result of the DescribeHumanLoop operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request isn't valid. Check the syntax and try again.</li>
     *         <li>ResourceNotFoundException We couldn't find the requested resource. Check that your resources exists
     *         and were created in the same AWS Region as your request, and try your request again.</li>
     *         <li>ThrottlingException You exceeded the maximum number of requests.</li>
     *         <li>InternalServerException We couldn't process your request because of an issue with the server. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerA2IRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample SageMakerA2IRuntimeAsyncClient.DescribeHumanLoop
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-a2i-runtime-2019-11-07/DescribeHumanLoop"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeHumanLoopResponse> describeHumanLoop(DescribeHumanLoopRequest describeHumanLoopRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the specified human loop. If the human loop was deleted, this operation will return a
     * <code>ResourceNotFoundException</code> error.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeHumanLoopRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeHumanLoopRequest#builder()}
     * </p>
     *
     * @param describeHumanLoopRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemakera2iruntime.model.DescribeHumanLoopRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeHumanLoop operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request isn't valid. Check the syntax and try again.</li>
     *         <li>ResourceNotFoundException We couldn't find the requested resource. Check that your resources exists
     *         and were created in the same AWS Region as your request, and try your request again.</li>
     *         <li>ThrottlingException You exceeded the maximum number of requests.</li>
     *         <li>InternalServerException We couldn't process your request because of an issue with the server. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerA2IRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample SageMakerA2IRuntimeAsyncClient.DescribeHumanLoop
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-a2i-runtime-2019-11-07/DescribeHumanLoop"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeHumanLoopResponse> describeHumanLoop(
            Consumer<DescribeHumanLoopRequest.Builder> describeHumanLoopRequest) {
        return describeHumanLoop(DescribeHumanLoopRequest.builder().applyMutation(describeHumanLoopRequest).build());
    }

    /**
     * <p>
     * Returns information about human loops, given the specified parameters. If a human loop was deleted, it will not
     * be included.
     * </p>
     *
     * @param listHumanLoopsRequest
     * @return A Java Future containing the result of the ListHumanLoops operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request isn't valid. Check the syntax and try again.</li>
     *         <li>ResourceNotFoundException We couldn't find the requested resource. Check that your resources exists
     *         and were created in the same AWS Region as your request, and try your request again.</li>
     *         <li>ThrottlingException You exceeded the maximum number of requests.</li>
     *         <li>InternalServerException We couldn't process your request because of an issue with the server. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerA2IRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample SageMakerA2IRuntimeAsyncClient.ListHumanLoops
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-a2i-runtime-2019-11-07/ListHumanLoops"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListHumanLoopsResponse> listHumanLoops(ListHumanLoopsRequest listHumanLoopsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about human loops, given the specified parameters. If a human loop was deleted, it will not
     * be included.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListHumanLoopsRequest.Builder} avoiding the need to
     * create one manually via {@link ListHumanLoopsRequest#builder()}
     * </p>
     *
     * @param listHumanLoopsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemakera2iruntime.model.ListHumanLoopsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ListHumanLoops operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request isn't valid. Check the syntax and try again.</li>
     *         <li>ResourceNotFoundException We couldn't find the requested resource. Check that your resources exists
     *         and were created in the same AWS Region as your request, and try your request again.</li>
     *         <li>ThrottlingException You exceeded the maximum number of requests.</li>
     *         <li>InternalServerException We couldn't process your request because of an issue with the server. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerA2IRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample SageMakerA2IRuntimeAsyncClient.ListHumanLoops
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-a2i-runtime-2019-11-07/ListHumanLoops"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListHumanLoopsResponse> listHumanLoops(Consumer<ListHumanLoopsRequest.Builder> listHumanLoopsRequest) {
        return listHumanLoops(ListHumanLoopsRequest.builder().applyMutation(listHumanLoopsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listHumanLoops(software.amazon.awssdk.services.sagemakera2iruntime.model.ListHumanLoopsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemakera2iruntime.paginators.ListHumanLoopsPublisher publisher = client.listHumanLoopsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemakera2iruntime.paginators.ListHumanLoopsPublisher publisher = client.listHumanLoopsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sagemakera2iruntime.model.ListHumanLoopsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sagemakera2iruntime.model.ListHumanLoopsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listHumanLoops(software.amazon.awssdk.services.sagemakera2iruntime.model.ListHumanLoopsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listHumanLoopsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request isn't valid. Check the syntax and try again.</li>
     *         <li>ResourceNotFoundException We couldn't find the requested resource. Check that your resources exists
     *         and were created in the same AWS Region as your request, and try your request again.</li>
     *         <li>ThrottlingException You exceeded the maximum number of requests.</li>
     *         <li>InternalServerException We couldn't process your request because of an issue with the server. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerA2IRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample SageMakerA2IRuntimeAsyncClient.ListHumanLoops
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-a2i-runtime-2019-11-07/ListHumanLoops"
     *      target="_top">AWS API Documentation</a>
     */
    default ListHumanLoopsPublisher listHumanLoopsPaginator(ListHumanLoopsRequest listHumanLoopsRequest) {
        return new ListHumanLoopsPublisher(this, listHumanLoopsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listHumanLoops(software.amazon.awssdk.services.sagemakera2iruntime.model.ListHumanLoopsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemakera2iruntime.paginators.ListHumanLoopsPublisher publisher = client.listHumanLoopsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemakera2iruntime.paginators.ListHumanLoopsPublisher publisher = client.listHumanLoopsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sagemakera2iruntime.model.ListHumanLoopsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sagemakera2iruntime.model.ListHumanLoopsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listHumanLoops(software.amazon.awssdk.services.sagemakera2iruntime.model.ListHumanLoopsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListHumanLoopsRequest.Builder} avoiding the need to
     * create one manually via {@link ListHumanLoopsRequest#builder()}
     * </p>
     *
     * @param listHumanLoopsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemakera2iruntime.model.ListHumanLoopsRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request isn't valid. Check the syntax and try again.</li>
     *         <li>ResourceNotFoundException We couldn't find the requested resource. Check that your resources exists
     *         and were created in the same AWS Region as your request, and try your request again.</li>
     *         <li>ThrottlingException You exceeded the maximum number of requests.</li>
     *         <li>InternalServerException We couldn't process your request because of an issue with the server. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerA2IRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample SageMakerA2IRuntimeAsyncClient.ListHumanLoops
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-a2i-runtime-2019-11-07/ListHumanLoops"
     *      target="_top">AWS API Documentation</a>
     */
    default ListHumanLoopsPublisher listHumanLoopsPaginator(Consumer<ListHumanLoopsRequest.Builder> listHumanLoopsRequest) {
        return listHumanLoopsPaginator(ListHumanLoopsRequest.builder().applyMutation(listHumanLoopsRequest).build());
    }

    /**
     * <p>
     * Starts a human loop, provided that at least one activation condition is met.
     * </p>
     *
     * @param startHumanLoopRequest
     * @return A Java Future containing the result of the StartHumanLoop operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request isn't valid. Check the syntax and try again.</li>
     *         <li>ThrottlingException You exceeded the maximum number of requests.</li>
     *         <li>ServiceQuotaExceededException You exceeded your service quota. Service quotas, also referred to as
     *         limits, are the maximum number of service resources or operations for your AWS account. For a list of
     *         Amazon A2I service quotes, see <a href="https://docs.aws.amazon.com/general/latest/gr/a2i.html">Amazon
     *         Augmented AI Service Quotes</a>. Delete some resources or request an increase in your service quota. You
     *         can request a quota increase using Service Quotas or the AWS Support Center. To request an increase, see
     *         <a href="https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html">AWS Service Quotas</a> in
     *         the <i>AWS General Reference</i>.</li>
     *         <li>InternalServerException We couldn't process your request because of an issue with the server. Try
     *         again later.</li>
     *         <li>ConflictException Your request has the same name as another active human loop but has different input
     *         data. You cannot start two human loops with the same name and different input data.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerA2IRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample SageMakerA2IRuntimeAsyncClient.StartHumanLoop
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-a2i-runtime-2019-11-07/StartHumanLoop"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartHumanLoopResponse> startHumanLoop(StartHumanLoopRequest startHumanLoopRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a human loop, provided that at least one activation condition is met.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartHumanLoopRequest.Builder} avoiding the need to
     * create one manually via {@link StartHumanLoopRequest#builder()}
     * </p>
     *
     * @param startHumanLoopRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemakera2iruntime.model.StartHumanLoopRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the StartHumanLoop operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request isn't valid. Check the syntax and try again.</li>
     *         <li>ThrottlingException You exceeded the maximum number of requests.</li>
     *         <li>ServiceQuotaExceededException You exceeded your service quota. Service quotas, also referred to as
     *         limits, are the maximum number of service resources or operations for your AWS account. For a list of
     *         Amazon A2I service quotes, see <a href="https://docs.aws.amazon.com/general/latest/gr/a2i.html">Amazon
     *         Augmented AI Service Quotes</a>. Delete some resources or request an increase in your service quota. You
     *         can request a quota increase using Service Quotas or the AWS Support Center. To request an increase, see
     *         <a href="https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html">AWS Service Quotas</a> in
     *         the <i>AWS General Reference</i>.</li>
     *         <li>InternalServerException We couldn't process your request because of an issue with the server. Try
     *         again later.</li>
     *         <li>ConflictException Your request has the same name as another active human loop but has different input
     *         data. You cannot start two human loops with the same name and different input data.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerA2IRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample SageMakerA2IRuntimeAsyncClient.StartHumanLoop
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-a2i-runtime-2019-11-07/StartHumanLoop"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartHumanLoopResponse> startHumanLoop(Consumer<StartHumanLoopRequest.Builder> startHumanLoopRequest) {
        return startHumanLoop(StartHumanLoopRequest.builder().applyMutation(startHumanLoopRequest).build());
    }

    /**
     * <p>
     * Stops the specified human loop.
     * </p>
     *
     * @param stopHumanLoopRequest
     * @return A Java Future containing the result of the StopHumanLoop operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request isn't valid. Check the syntax and try again.</li>
     *         <li>ResourceNotFoundException We couldn't find the requested resource. Check that your resources exists
     *         and were created in the same AWS Region as your request, and try your request again.</li>
     *         <li>ThrottlingException You exceeded the maximum number of requests.</li>
     *         <li>InternalServerException We couldn't process your request because of an issue with the server. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerA2IRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample SageMakerA2IRuntimeAsyncClient.StopHumanLoop
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-a2i-runtime-2019-11-07/StopHumanLoop"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StopHumanLoopResponse> stopHumanLoop(StopHumanLoopRequest stopHumanLoopRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops the specified human loop.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopHumanLoopRequest.Builder} avoiding the need to
     * create one manually via {@link StopHumanLoopRequest#builder()}
     * </p>
     *
     * @param stopHumanLoopRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemakera2iruntime.model.StopHumanLoopRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StopHumanLoop operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request isn't valid. Check the syntax and try again.</li>
     *         <li>ResourceNotFoundException We couldn't find the requested resource. Check that your resources exists
     *         and were created in the same AWS Region as your request, and try your request again.</li>
     *         <li>ThrottlingException You exceeded the maximum number of requests.</li>
     *         <li>InternalServerException We couldn't process your request because of an issue with the server. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerA2IRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample SageMakerA2IRuntimeAsyncClient.StopHumanLoop
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-a2i-runtime-2019-11-07/StopHumanLoop"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StopHumanLoopResponse> stopHumanLoop(Consumer<StopHumanLoopRequest.Builder> stopHumanLoopRequest) {
        return stopHumanLoop(StopHumanLoopRequest.builder().applyMutation(stopHumanLoopRequest).build());
    }

    @Override
    default SageMakerA2IRuntimeServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link SageMakerA2IRuntimeAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static SageMakerA2IRuntimeAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link SageMakerA2IRuntimeAsyncClient}.
     */
    static SageMakerA2IRuntimeAsyncClientBuilder builder() {
        return new DefaultSageMakerA2IRuntimeAsyncClientBuilder();
    }
}
