/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemakera2iruntime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeHumanLoopRequest extends SageMakerA2IRuntimeRequest implements
        ToCopyableBuilder<DescribeHumanLoopRequest.Builder, DescribeHumanLoopRequest> {
    private static final SdkField<String> HUMAN_LOOP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HumanLoopName").getter(getter(DescribeHumanLoopRequest::humanLoopName))
            .setter(setter(Builder::humanLoopName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("HumanLoopName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HUMAN_LOOP_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String humanLoopName;

    private DescribeHumanLoopRequest(BuilderImpl builder) {
        super(builder);
        this.humanLoopName = builder.humanLoopName;
    }

    /**
     * <p>
     * The name of the human loop that you want information about.
     * </p>
     * 
     * @return The name of the human loop that you want information about.
     */
    public final String humanLoopName() {
        return humanLoopName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(humanLoopName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeHumanLoopRequest)) {
            return false;
        }
        DescribeHumanLoopRequest other = (DescribeHumanLoopRequest) obj;
        return Objects.equals(humanLoopName(), other.humanLoopName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeHumanLoopRequest").add("HumanLoopName", humanLoopName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HumanLoopName":
            return Optional.ofNullable(clazz.cast(humanLoopName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("HumanLoopName", HUMAN_LOOP_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeHumanLoopRequest, T> g) {
        return obj -> g.apply((DescribeHumanLoopRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SageMakerA2IRuntimeRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeHumanLoopRequest> {
        /**
         * <p>
         * The name of the human loop that you want information about.
         * </p>
         * 
         * @param humanLoopName
         *        The name of the human loop that you want information about.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder humanLoopName(String humanLoopName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerA2IRuntimeRequest.BuilderImpl implements Builder {
        private String humanLoopName;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeHumanLoopRequest model) {
            super(model);
            humanLoopName(model.humanLoopName);
        }

        public final String getHumanLoopName() {
            return humanLoopName;
        }

        public final void setHumanLoopName(String humanLoopName) {
            this.humanLoopName = humanLoopName;
        }

        @Override
        public final Builder humanLoopName(String humanLoopName) {
            this.humanLoopName = humanLoopName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeHumanLoopRequest build() {
            return new DescribeHumanLoopRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
