/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemakeredge.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SendHeartbeatRequest extends SagemakerEdgeRequest implements
        ToCopyableBuilder<SendHeartbeatRequest.Builder, SendHeartbeatRequest> {
    private static final SdkField<List<EdgeMetric>> AGENT_METRICS_FIELD = SdkField
            .<List<EdgeMetric>> builder(MarshallingType.LIST)
            .memberName("AgentMetrics")
            .getter(getter(SendHeartbeatRequest::agentMetrics))
            .setter(setter(Builder::agentMetrics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgentMetrics").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EdgeMetric> builder(MarshallingType.SDK_POJO)
                                            .constructor(EdgeMetric::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Model>> MODELS_FIELD = SdkField
            .<List<Model>> builder(MarshallingType.LIST)
            .memberName("Models")
            .getter(getter(SendHeartbeatRequest::models))
            .setter(setter(Builder::models))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Models").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Model> builder(MarshallingType.SDK_POJO)
                                            .constructor(Model::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> AGENT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AgentVersion").getter(getter(SendHeartbeatRequest::agentVersion)).setter(setter(Builder::agentVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgentVersion").build()).build();

    private static final SdkField<String> DEVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceName").getter(getter(SendHeartbeatRequest::deviceName)).setter(setter(Builder::deviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceName").build()).build();

    private static final SdkField<String> DEVICE_FLEET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceFleetName").getter(getter(SendHeartbeatRequest::deviceFleetName))
            .setter(setter(Builder::deviceFleetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceFleetName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_METRICS_FIELD,
            MODELS_FIELD, AGENT_VERSION_FIELD, DEVICE_NAME_FIELD, DEVICE_FLEET_NAME_FIELD));

    private final List<EdgeMetric> agentMetrics;

    private final List<Model> models;

    private final String agentVersion;

    private final String deviceName;

    private final String deviceFleetName;

    private SendHeartbeatRequest(BuilderImpl builder) {
        super(builder);
        this.agentMetrics = builder.agentMetrics;
        this.models = builder.models;
        this.agentVersion = builder.agentVersion;
        this.deviceName = builder.deviceName;
        this.deviceFleetName = builder.deviceFleetName;
    }

    /**
     * For responses, this returns true if the service returned a value for the AgentMetrics property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAgentMetrics() {
        return agentMetrics != null && !(agentMetrics instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * For internal use. Returns a list of SageMaker Edge Manager agent operating metrics.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAgentMetrics} method.
     * </p>
     * 
     * @return For internal use. Returns a list of SageMaker Edge Manager agent operating metrics.
     */
    public final List<EdgeMetric> agentMetrics() {
        return agentMetrics;
    }

    /**
     * For responses, this returns true if the service returned a value for the Models property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasModels() {
        return models != null && !(models instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Returns a list of models deployed on the the device.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasModels} method.
     * </p>
     * 
     * @return Returns a list of models deployed on the the device.
     */
    public final List<Model> models() {
        return models;
    }

    /**
     * <p>
     * Returns the version of the agent.
     * </p>
     * 
     * @return Returns the version of the agent.
     */
    public final String agentVersion() {
        return agentVersion;
    }

    /**
     * <p>
     * The unique name of the device.
     * </p>
     * 
     * @return The unique name of the device.
     */
    public final String deviceName() {
        return deviceName;
    }

    /**
     * <p>
     * The name of the fleet that the device belongs to.
     * </p>
     * 
     * @return The name of the fleet that the device belongs to.
     */
    public final String deviceFleetName() {
        return deviceFleetName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAgentMetrics() ? agentMetrics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasModels() ? models() : null);
        hashCode = 31 * hashCode + Objects.hashCode(agentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(deviceName());
        hashCode = 31 * hashCode + Objects.hashCode(deviceFleetName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendHeartbeatRequest)) {
            return false;
        }
        SendHeartbeatRequest other = (SendHeartbeatRequest) obj;
        return hasAgentMetrics() == other.hasAgentMetrics() && Objects.equals(agentMetrics(), other.agentMetrics())
                && hasModels() == other.hasModels() && Objects.equals(models(), other.models())
                && Objects.equals(agentVersion(), other.agentVersion()) && Objects.equals(deviceName(), other.deviceName())
                && Objects.equals(deviceFleetName(), other.deviceFleetName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SendHeartbeatRequest").add("AgentMetrics", hasAgentMetrics() ? agentMetrics() : null)
                .add("Models", hasModels() ? models() : null).add("AgentVersion", agentVersion()).add("DeviceName", deviceName())
                .add("DeviceFleetName", deviceFleetName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AgentMetrics":
            return Optional.ofNullable(clazz.cast(agentMetrics()));
        case "Models":
            return Optional.ofNullable(clazz.cast(models()));
        case "AgentVersion":
            return Optional.ofNullable(clazz.cast(agentVersion()));
        case "DeviceName":
            return Optional.ofNullable(clazz.cast(deviceName()));
        case "DeviceFleetName":
            return Optional.ofNullable(clazz.cast(deviceFleetName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SendHeartbeatRequest, T> g) {
        return obj -> g.apply((SendHeartbeatRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SagemakerEdgeRequest.Builder, SdkPojo, CopyableBuilder<Builder, SendHeartbeatRequest> {
        /**
         * <p>
         * For internal use. Returns a list of SageMaker Edge Manager agent operating metrics.
         * </p>
         * 
         * @param agentMetrics
         *        For internal use. Returns a list of SageMaker Edge Manager agent operating metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentMetrics(Collection<EdgeMetric> agentMetrics);

        /**
         * <p>
         * For internal use. Returns a list of SageMaker Edge Manager agent operating metrics.
         * </p>
         * 
         * @param agentMetrics
         *        For internal use. Returns a list of SageMaker Edge Manager agent operating metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentMetrics(EdgeMetric... agentMetrics);

        /**
         * <p>
         * For internal use. Returns a list of SageMaker Edge Manager agent operating metrics.
         * </p>
         * This is a convenience that creates an instance of the {@link List<EdgeMetric>.Builder} avoiding the need to
         * create one manually via {@link List<EdgeMetric>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<EdgeMetric>.Builder#build()} is called immediately and its
         * result is passed to {@link #agentMetrics(List<EdgeMetric>)}.
         * 
         * @param agentMetrics
         *        a consumer that will call methods on {@link List<EdgeMetric>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #agentMetrics(List<EdgeMetric>)
         */
        Builder agentMetrics(Consumer<EdgeMetric.Builder>... agentMetrics);

        /**
         * <p>
         * Returns a list of models deployed on the the device.
         * </p>
         * 
         * @param models
         *        Returns a list of models deployed on the the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder models(Collection<Model> models);

        /**
         * <p>
         * Returns a list of models deployed on the the device.
         * </p>
         * 
         * @param models
         *        Returns a list of models deployed on the the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder models(Model... models);

        /**
         * <p>
         * Returns a list of models deployed on the the device.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Model>.Builder} avoiding the need to create
         * one manually via {@link List<Model>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Model>.Builder#build()} is called immediately and its result
         * is passed to {@link #models(List<Model>)}.
         * 
         * @param models
         *        a consumer that will call methods on {@link List<Model>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #models(List<Model>)
         */
        Builder models(Consumer<Model.Builder>... models);

        /**
         * <p>
         * Returns the version of the agent.
         * </p>
         * 
         * @param agentVersion
         *        Returns the version of the agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentVersion(String agentVersion);

        /**
         * <p>
         * The unique name of the device.
         * </p>
         * 
         * @param deviceName
         *        The unique name of the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceName(String deviceName);

        /**
         * <p>
         * The name of the fleet that the device belongs to.
         * </p>
         * 
         * @param deviceFleetName
         *        The name of the fleet that the device belongs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceFleetName(String deviceFleetName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SagemakerEdgeRequest.BuilderImpl implements Builder {
        private List<EdgeMetric> agentMetrics = DefaultSdkAutoConstructList.getInstance();

        private List<Model> models = DefaultSdkAutoConstructList.getInstance();

        private String agentVersion;

        private String deviceName;

        private String deviceFleetName;

        private BuilderImpl() {
        }

        private BuilderImpl(SendHeartbeatRequest model) {
            super(model);
            agentMetrics(model.agentMetrics);
            models(model.models);
            agentVersion(model.agentVersion);
            deviceName(model.deviceName);
            deviceFleetName(model.deviceFleetName);
        }

        public final List<EdgeMetric.Builder> getAgentMetrics() {
            List<EdgeMetric.Builder> result = EdgeMetricsCopier.copyToBuilder(this.agentMetrics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAgentMetrics(Collection<EdgeMetric.BuilderImpl> agentMetrics) {
            this.agentMetrics = EdgeMetricsCopier.copyFromBuilder(agentMetrics);
        }

        @Override
        @Transient
        public final Builder agentMetrics(Collection<EdgeMetric> agentMetrics) {
            this.agentMetrics = EdgeMetricsCopier.copy(agentMetrics);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder agentMetrics(EdgeMetric... agentMetrics) {
            agentMetrics(Arrays.asList(agentMetrics));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder agentMetrics(Consumer<EdgeMetric.Builder>... agentMetrics) {
            agentMetrics(Stream.of(agentMetrics).map(c -> EdgeMetric.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<Model.Builder> getModels() {
            List<Model.Builder> result = ModelsCopier.copyToBuilder(this.models);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setModels(Collection<Model.BuilderImpl> models) {
            this.models = ModelsCopier.copyFromBuilder(models);
        }

        @Override
        @Transient
        public final Builder models(Collection<Model> models) {
            this.models = ModelsCopier.copy(models);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder models(Model... models) {
            models(Arrays.asList(models));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder models(Consumer<Model.Builder>... models) {
            models(Stream.of(models).map(c -> Model.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getAgentVersion() {
            return agentVersion;
        }

        public final void setAgentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
        }

        @Override
        @Transient
        public final Builder agentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
            return this;
        }

        public final String getDeviceName() {
            return deviceName;
        }

        public final void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }

        @Override
        @Transient
        public final Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public final String getDeviceFleetName() {
            return deviceFleetName;
        }

        public final void setDeviceFleetName(String deviceFleetName) {
            this.deviceFleetName = deviceFleetName;
        }

        @Override
        @Transient
        public final Builder deviceFleetName(String deviceFleetName) {
            this.deviceFleetName = deviceFleetName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SendHeartbeatRequest build() {
            return new SendHeartbeatRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
