/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemakeredge.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemakeredge.model.Checksum;
import software.amazon.awssdk.services.sagemakeredge.model.ModelState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Definition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Definition> {
    private static final SdkField<String> MODEL_HANDLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelHandle").getter(Definition.getter(Definition::modelHandle)).setter(Definition.setter(Builder::modelHandle)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelHandle").build()}).build();
    private static final SdkField<String> S3_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3Url").getter(Definition.getter(Definition::s3Url)).setter(Definition.setter(Builder::s3Url)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Url").build()}).build();
    private static final SdkField<Checksum> CHECKSUM_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Checksum").getter(Definition.getter(Definition::checksum)).setter(Definition.setter(Builder::checksum)).constructor(Checksum::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Checksum").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(Definition.getter(Definition::stateAsString)).setter(Definition.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_HANDLE_FIELD, S3_URL_FIELD, CHECKSUM_FIELD, STATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String modelHandle;
    private final String s3Url;
    private final Checksum checksum;
    private final String state;

    private Definition(BuilderImpl builder) {
        this.modelHandle = builder.modelHandle;
        this.s3Url = builder.s3Url;
        this.checksum = builder.checksum;
        this.state = builder.state;
    }

    public final String modelHandle() {
        return this.modelHandle;
    }

    public final String s3Url() {
        return this.s3Url;
    }

    public final Checksum checksum() {
        return this.checksum;
    }

    public final ModelState state() {
        return ModelState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.modelHandle());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Url());
        hashCode = 31 * hashCode + Objects.hashCode(this.checksum());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Definition)) {
            return false;
        }
        Definition other = (Definition)obj;
        return Objects.equals(this.modelHandle(), other.modelHandle()) && Objects.equals(this.s3Url(), other.s3Url()) && Objects.equals(this.checksum(), other.checksum()) && Objects.equals(this.stateAsString(), other.stateAsString());
    }

    public final String toString() {
        return ToString.builder((String)"Definition").add("ModelHandle", (Object)this.modelHandle()).add("S3Url", (Object)this.s3Url()).add("Checksum", (Object)this.checksum()).add("State", (Object)this.stateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ModelHandle": {
                return Optional.ofNullable(clazz.cast(this.modelHandle()));
            }
            case "S3Url": {
                return Optional.ofNullable(clazz.cast(this.s3Url()));
            }
            case "Checksum": {
                return Optional.ofNullable(clazz.cast(this.checksum()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Definition, T> g) {
        return obj -> g.apply((Definition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String modelHandle;
        private String s3Url;
        private Checksum checksum;
        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(Definition model) {
            this.modelHandle(model.modelHandle);
            this.s3Url(model.s3Url);
            this.checksum(model.checksum);
            this.state(model.state);
        }

        public final String getModelHandle() {
            return this.modelHandle;
        }

        public final void setModelHandle(String modelHandle) {
            this.modelHandle = modelHandle;
        }

        @Override
        public final Builder modelHandle(String modelHandle) {
            this.modelHandle = modelHandle;
            return this;
        }

        public final String getS3Url() {
            return this.s3Url;
        }

        public final void setS3Url(String s3Url) {
            this.s3Url = s3Url;
        }

        @Override
        public final Builder s3Url(String s3Url) {
            this.s3Url = s3Url;
            return this;
        }

        public final Checksum.Builder getChecksum() {
            return this.checksum != null ? this.checksum.toBuilder() : null;
        }

        public final void setChecksum(Checksum.BuilderImpl checksum) {
            this.checksum = checksum != null ? checksum.build() : null;
        }

        @Override
        public final Builder checksum(Checksum checksum) {
            this.checksum = checksum;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ModelState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public Definition build() {
            return new Definition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Definition> {
        public Builder modelHandle(String var1);

        public Builder s3Url(String var1);

        public Builder checksum(Checksum var1);

        default public Builder checksum(Consumer<Checksum.Builder> checksum) {
            return this.checksum((Checksum)((Checksum.Builder)Checksum.builder().applyMutation(checksum)).build());
        }

        public Builder state(String var1);

        public Builder state(ModelState var1);
    }
}

