/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemakeredge.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeploymentModel implements SdkPojo, Serializable, ToCopyableBuilder<DeploymentModel.Builder, DeploymentModel> {
    private static final SdkField<String> MODEL_HANDLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelHandle").getter(getter(DeploymentModel::modelHandle)).setter(setter(Builder::modelHandle))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelHandle").build()).build();

    private static final SdkField<String> MODEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelName").getter(getter(DeploymentModel::modelName)).setter(setter(Builder::modelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelName").build()).build();

    private static final SdkField<String> MODEL_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelVersion").getter(getter(DeploymentModel::modelVersion)).setter(setter(Builder::modelVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelVersion").build()).build();

    private static final SdkField<String> DESIRED_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DesiredState").getter(getter(DeploymentModel::desiredStateAsString))
            .setter(setter(Builder::desiredState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredState").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(DeploymentModel::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DeploymentModel::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusReason").getter(getter(DeploymentModel::statusReason)).setter(setter(Builder::statusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusReason").build()).build();

    private static final SdkField<String> ROLLBACK_FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RollbackFailureReason").getter(getter(DeploymentModel::rollbackFailureReason))
            .setter(setter(Builder::rollbackFailureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RollbackFailureReason").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_HANDLE_FIELD,
            MODEL_NAME_FIELD, MODEL_VERSION_FIELD, DESIRED_STATE_FIELD, STATE_FIELD, STATUS_FIELD, STATUS_REASON_FIELD,
            ROLLBACK_FAILURE_REASON_FIELD));

    private static final long serialVersionUID = 1L;

    private final String modelHandle;

    private final String modelName;

    private final String modelVersion;

    private final String desiredState;

    private final String state;

    private final String status;

    private final String statusReason;

    private final String rollbackFailureReason;

    private DeploymentModel(BuilderImpl builder) {
        this.modelHandle = builder.modelHandle;
        this.modelName = builder.modelName;
        this.modelVersion = builder.modelVersion;
        this.desiredState = builder.desiredState;
        this.state = builder.state;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.rollbackFailureReason = builder.rollbackFailureReason;
    }

    /**
     * <p>
     * The unique handle of the model.
     * </p>
     * 
     * @return The unique handle of the model.
     */
    public final String modelHandle() {
        return modelHandle;
    }

    /**
     * <p>
     * The name of the model.
     * </p>
     * 
     * @return The name of the model.
     */
    public final String modelName() {
        return modelName;
    }

    /**
     * <p>
     * The version of the model.
     * </p>
     * 
     * @return The version of the model.
     */
    public final String modelVersion() {
        return modelVersion;
    }

    /**
     * <p>
     * The desired state of the model.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #desiredState} will
     * return {@link ModelState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #desiredStateAsString}.
     * </p>
     * 
     * @return The desired state of the model.
     * @see ModelState
     */
    public final ModelState desiredState() {
        return ModelState.fromValue(desiredState);
    }

    /**
     * <p>
     * The desired state of the model.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #desiredState} will
     * return {@link ModelState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #desiredStateAsString}.
     * </p>
     * 
     * @return The desired state of the model.
     * @see ModelState
     */
    public final String desiredStateAsString() {
        return desiredState;
    }

    /**
     * <p>
     * Returns the current state of the model.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ModelState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return Returns the current state of the model.
     * @see ModelState
     */
    public final ModelState state() {
        return ModelState.fromValue(state);
    }

    /**
     * <p>
     * Returns the current state of the model.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ModelState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return Returns the current state of the model.
     * @see ModelState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * Returns the deployment status of the model.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DeploymentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Returns the deployment status of the model.
     * @see DeploymentStatus
     */
    public final DeploymentStatus status() {
        return DeploymentStatus.fromValue(status);
    }

    /**
     * <p>
     * Returns the deployment status of the model.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DeploymentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Returns the deployment status of the model.
     * @see DeploymentStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Returns the error message for the deployment status result.
     * </p>
     * 
     * @return Returns the error message for the deployment status result.
     */
    public final String statusReason() {
        return statusReason;
    }

    /**
     * <p>
     * Returns the error message if there is a rollback.
     * </p>
     * 
     * @return Returns the error message if there is a rollback.
     */
    public final String rollbackFailureReason() {
        return rollbackFailureReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(modelHandle());
        hashCode = 31 * hashCode + Objects.hashCode(modelName());
        hashCode = 31 * hashCode + Objects.hashCode(modelVersion());
        hashCode = 31 * hashCode + Objects.hashCode(desiredStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(rollbackFailureReason());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeploymentModel)) {
            return false;
        }
        DeploymentModel other = (DeploymentModel) obj;
        return Objects.equals(modelHandle(), other.modelHandle()) && Objects.equals(modelName(), other.modelName())
                && Objects.equals(modelVersion(), other.modelVersion())
                && Objects.equals(desiredStateAsString(), other.desiredStateAsString())
                && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusReason(), other.statusReason())
                && Objects.equals(rollbackFailureReason(), other.rollbackFailureReason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeploymentModel").add("ModelHandle", modelHandle()).add("ModelName", modelName())
                .add("ModelVersion", modelVersion()).add("DesiredState", desiredStateAsString()).add("State", stateAsString())
                .add("Status", statusAsString()).add("StatusReason", statusReason())
                .add("RollbackFailureReason", rollbackFailureReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ModelHandle":
            return Optional.ofNullable(clazz.cast(modelHandle()));
        case "ModelName":
            return Optional.ofNullable(clazz.cast(modelName()));
        case "ModelVersion":
            return Optional.ofNullable(clazz.cast(modelVersion()));
        case "DesiredState":
            return Optional.ofNullable(clazz.cast(desiredStateAsString()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatusReason":
            return Optional.ofNullable(clazz.cast(statusReason()));
        case "RollbackFailureReason":
            return Optional.ofNullable(clazz.cast(rollbackFailureReason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeploymentModel, T> g) {
        return obj -> g.apply((DeploymentModel) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeploymentModel> {
        /**
         * <p>
         * The unique handle of the model.
         * </p>
         * 
         * @param modelHandle
         *        The unique handle of the model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelHandle(String modelHandle);

        /**
         * <p>
         * The name of the model.
         * </p>
         * 
         * @param modelName
         *        The name of the model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelName(String modelName);

        /**
         * <p>
         * The version of the model.
         * </p>
         * 
         * @param modelVersion
         *        The version of the model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelVersion(String modelVersion);

        /**
         * <p>
         * The desired state of the model.
         * </p>
         * 
         * @param desiredState
         *        The desired state of the model.
         * @see ModelState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelState
         */
        Builder desiredState(String desiredState);

        /**
         * <p>
         * The desired state of the model.
         * </p>
         * 
         * @param desiredState
         *        The desired state of the model.
         * @see ModelState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelState
         */
        Builder desiredState(ModelState desiredState);

        /**
         * <p>
         * Returns the current state of the model.
         * </p>
         * 
         * @param state
         *        Returns the current state of the model.
         * @see ModelState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelState
         */
        Builder state(String state);

        /**
         * <p>
         * Returns the current state of the model.
         * </p>
         * 
         * @param state
         *        Returns the current state of the model.
         * @see ModelState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelState
         */
        Builder state(ModelState state);

        /**
         * <p>
         * Returns the deployment status of the model.
         * </p>
         * 
         * @param status
         *        Returns the deployment status of the model.
         * @see DeploymentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Returns the deployment status of the model.
         * </p>
         * 
         * @param status
         *        Returns the deployment status of the model.
         * @see DeploymentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentStatus
         */
        Builder status(DeploymentStatus status);

        /**
         * <p>
         * Returns the error message for the deployment status result.
         * </p>
         * 
         * @param statusReason
         *        Returns the error message for the deployment status result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(String statusReason);

        /**
         * <p>
         * Returns the error message if there is a rollback.
         * </p>
         * 
         * @param rollbackFailureReason
         *        Returns the error message if there is a rollback.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rollbackFailureReason(String rollbackFailureReason);
    }

    static final class BuilderImpl implements Builder {
        private String modelHandle;

        private String modelName;

        private String modelVersion;

        private String desiredState;

        private String state;

        private String status;

        private String statusReason;

        private String rollbackFailureReason;

        private BuilderImpl() {
        }

        private BuilderImpl(DeploymentModel model) {
            modelHandle(model.modelHandle);
            modelName(model.modelName);
            modelVersion(model.modelVersion);
            desiredState(model.desiredState);
            state(model.state);
            status(model.status);
            statusReason(model.statusReason);
            rollbackFailureReason(model.rollbackFailureReason);
        }

        public final String getModelHandle() {
            return modelHandle;
        }

        public final void setModelHandle(String modelHandle) {
            this.modelHandle = modelHandle;
        }

        @Override
        public final Builder modelHandle(String modelHandle) {
            this.modelHandle = modelHandle;
            return this;
        }

        public final String getModelName() {
            return modelName;
        }

        public final void setModelName(String modelName) {
            this.modelName = modelName;
        }

        @Override
        public final Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public final String getModelVersion() {
            return modelVersion;
        }

        public final void setModelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
        }

        @Override
        public final Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            return this;
        }

        public final String getDesiredState() {
            return desiredState;
        }

        public final void setDesiredState(String desiredState) {
            this.desiredState = desiredState;
        }

        @Override
        public final Builder desiredState(String desiredState) {
            this.desiredState = desiredState;
            return this;
        }

        @Override
        public final Builder desiredState(ModelState desiredState) {
            this.desiredState(desiredState == null ? null : desiredState.toString());
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ModelState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DeploymentStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final String getRollbackFailureReason() {
            return rollbackFailureReason;
        }

        public final void setRollbackFailureReason(String rollbackFailureReason) {
            this.rollbackFailureReason = rollbackFailureReason;
        }

        @Override
        public final Builder rollbackFailureReason(String rollbackFailureReason) {
            this.rollbackFailureReason = rollbackFailureReason;
            return this;
        }

        @Override
        public DeploymentModel build() {
            return new DeploymentModel(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
