/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemakeredge.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a deployment on an edge device that is registered with SageMaker Edge Manager.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EdgeDeployment implements SdkPojo, Serializable, ToCopyableBuilder<EdgeDeployment.Builder, EdgeDeployment> {
    private static final SdkField<String> DEPLOYMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeploymentName").getter(getter(EdgeDeployment::deploymentName)).setter(setter(Builder::deploymentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentName").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(EdgeDeployment::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> FAILURE_HANDLING_POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailureHandlingPolicy").getter(getter(EdgeDeployment::failureHandlingPolicyAsString))
            .setter(setter(Builder::failureHandlingPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureHandlingPolicy").build())
            .build();

    private static final SdkField<List<Definition>> DEFINITIONS_FIELD = SdkField
            .<List<Definition>> builder(MarshallingType.LIST)
            .memberName("Definitions")
            .getter(getter(EdgeDeployment::definitions))
            .setter(setter(Builder::definitions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Definitions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Definition> builder(MarshallingType.SDK_POJO)
                                            .constructor(Definition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPLOYMENT_NAME_FIELD,
            TYPE_FIELD, FAILURE_HANDLING_POLICY_FIELD, DEFINITIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String deploymentName;

    private final String type;

    private final String failureHandlingPolicy;

    private final List<Definition> definitions;

    private EdgeDeployment(BuilderImpl builder) {
        this.deploymentName = builder.deploymentName;
        this.type = builder.type;
        this.failureHandlingPolicy = builder.failureHandlingPolicy;
        this.definitions = builder.definitions;
    }

    /**
     * <p>
     * The name and unique ID of the deployment.
     * </p>
     * 
     * @return The name and unique ID of the deployment.
     */
    public final String deploymentName() {
        return deploymentName;
    }

    /**
     * <p>
     * The type of the deployment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link DeploymentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the deployment.
     * @see DeploymentType
     */
    public final DeploymentType type() {
        return DeploymentType.fromValue(type);
    }

    /**
     * <p>
     * The type of the deployment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link DeploymentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the deployment.
     * @see DeploymentType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * Determines whether to rollback to previous configuration if deployment fails.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #failureHandlingPolicy} will return {@link FailureHandlingPolicy#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #failureHandlingPolicyAsString}.
     * </p>
     * 
     * @return Determines whether to rollback to previous configuration if deployment fails.
     * @see FailureHandlingPolicy
     */
    public final FailureHandlingPolicy failureHandlingPolicy() {
        return FailureHandlingPolicy.fromValue(failureHandlingPolicy);
    }

    /**
     * <p>
     * Determines whether to rollback to previous configuration if deployment fails.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #failureHandlingPolicy} will return {@link FailureHandlingPolicy#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #failureHandlingPolicyAsString}.
     * </p>
     * 
     * @return Determines whether to rollback to previous configuration if deployment fails.
     * @see FailureHandlingPolicy
     */
    public final String failureHandlingPolicyAsString() {
        return failureHandlingPolicy;
    }

    /**
     * For responses, this returns true if the service returned a value for the Definitions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDefinitions() {
        return definitions != null && !(definitions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Returns a list of Definition objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDefinitions} method.
     * </p>
     * 
     * @return Returns a list of Definition objects.
     */
    public final List<Definition> definitions() {
        return definitions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deploymentName());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(failureHandlingPolicyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasDefinitions() ? definitions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EdgeDeployment)) {
            return false;
        }
        EdgeDeployment other = (EdgeDeployment) obj;
        return Objects.equals(deploymentName(), other.deploymentName()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(failureHandlingPolicyAsString(), other.failureHandlingPolicyAsString())
                && hasDefinitions() == other.hasDefinitions() && Objects.equals(definitions(), other.definitions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EdgeDeployment").add("DeploymentName", deploymentName()).add("Type", typeAsString())
                .add("FailureHandlingPolicy", failureHandlingPolicyAsString())
                .add("Definitions", hasDefinitions() ? definitions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeploymentName":
            return Optional.ofNullable(clazz.cast(deploymentName()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "FailureHandlingPolicy":
            return Optional.ofNullable(clazz.cast(failureHandlingPolicyAsString()));
        case "Definitions":
            return Optional.ofNullable(clazz.cast(definitions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EdgeDeployment, T> g) {
        return obj -> g.apply((EdgeDeployment) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EdgeDeployment> {
        /**
         * <p>
         * The name and unique ID of the deployment.
         * </p>
         * 
         * @param deploymentName
         *        The name and unique ID of the deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentName(String deploymentName);

        /**
         * <p>
         * The type of the deployment.
         * </p>
         * 
         * @param type
         *        The type of the deployment.
         * @see DeploymentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the deployment.
         * </p>
         * 
         * @param type
         *        The type of the deployment.
         * @see DeploymentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentType
         */
        Builder type(DeploymentType type);

        /**
         * <p>
         * Determines whether to rollback to previous configuration if deployment fails.
         * </p>
         * 
         * @param failureHandlingPolicy
         *        Determines whether to rollback to previous configuration if deployment fails.
         * @see FailureHandlingPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FailureHandlingPolicy
         */
        Builder failureHandlingPolicy(String failureHandlingPolicy);

        /**
         * <p>
         * Determines whether to rollback to previous configuration if deployment fails.
         * </p>
         * 
         * @param failureHandlingPolicy
         *        Determines whether to rollback to previous configuration if deployment fails.
         * @see FailureHandlingPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FailureHandlingPolicy
         */
        Builder failureHandlingPolicy(FailureHandlingPolicy failureHandlingPolicy);

        /**
         * <p>
         * Returns a list of Definition objects.
         * </p>
         * 
         * @param definitions
         *        Returns a list of Definition objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder definitions(Collection<Definition> definitions);

        /**
         * <p>
         * Returns a list of Definition objects.
         * </p>
         * 
         * @param definitions
         *        Returns a list of Definition objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder definitions(Definition... definitions);

        /**
         * <p>
         * Returns a list of Definition objects.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemakeredge.model.Definition.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.sagemakeredge.model.Definition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemakeredge.model.Definition.Builder#build()} is called immediately
         * and its result is passed to {@link #definitions(List<Definition>)}.
         * 
         * @param definitions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemakeredge.model.Definition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #definitions(java.util.Collection<Definition>)
         */
        Builder definitions(Consumer<Definition.Builder>... definitions);
    }

    static final class BuilderImpl implements Builder {
        private String deploymentName;

        private String type;

        private String failureHandlingPolicy;

        private List<Definition> definitions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EdgeDeployment model) {
            deploymentName(model.deploymentName);
            type(model.type);
            failureHandlingPolicy(model.failureHandlingPolicy);
            definitions(model.definitions);
        }

        public final String getDeploymentName() {
            return deploymentName;
        }

        public final void setDeploymentName(String deploymentName) {
            this.deploymentName = deploymentName;
        }

        @Override
        public final Builder deploymentName(String deploymentName) {
            this.deploymentName = deploymentName;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(DeploymentType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getFailureHandlingPolicy() {
            return failureHandlingPolicy;
        }

        public final void setFailureHandlingPolicy(String failureHandlingPolicy) {
            this.failureHandlingPolicy = failureHandlingPolicy;
        }

        @Override
        public final Builder failureHandlingPolicy(String failureHandlingPolicy) {
            this.failureHandlingPolicy = failureHandlingPolicy;
            return this;
        }

        @Override
        public final Builder failureHandlingPolicy(FailureHandlingPolicy failureHandlingPolicy) {
            this.failureHandlingPolicy(failureHandlingPolicy == null ? null : failureHandlingPolicy.toString());
            return this;
        }

        public final List<Definition.Builder> getDefinitions() {
            List<Definition.Builder> result = DefinitionsCopier.copyToBuilder(this.definitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDefinitions(Collection<Definition.BuilderImpl> definitions) {
            this.definitions = DefinitionsCopier.copyFromBuilder(definitions);
        }

        @Override
        public final Builder definitions(Collection<Definition> definitions) {
            this.definitions = DefinitionsCopier.copy(definitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder definitions(Definition... definitions) {
            definitions(Arrays.asList(definitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder definitions(Consumer<Definition.Builder>... definitions) {
            definitions(Stream.of(definitions).map(c -> Definition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public EdgeDeployment build() {
            return new EdgeDeployment(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
