/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemakeredge.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemakeredge.model.DeploymentStatus;
import software.amazon.awssdk.services.sagemakeredge.model.ModelState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeploymentModel
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DeploymentModel> {
    private static final SdkField<String> MODEL_HANDLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelHandle").getter(DeploymentModel.getter(DeploymentModel::modelHandle)).setter(DeploymentModel.setter(Builder::modelHandle)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelHandle").build()}).build();
    private static final SdkField<String> MODEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelName").getter(DeploymentModel.getter(DeploymentModel::modelName)).setter(DeploymentModel.setter(Builder::modelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelName").build()}).build();
    private static final SdkField<String> MODEL_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelVersion").getter(DeploymentModel.getter(DeploymentModel::modelVersion)).setter(DeploymentModel.setter(Builder::modelVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelVersion").build()}).build();
    private static final SdkField<String> DESIRED_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DesiredState").getter(DeploymentModel.getter(DeploymentModel::desiredStateAsString)).setter(DeploymentModel.setter(Builder::desiredState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredState").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(DeploymentModel.getter(DeploymentModel::stateAsString)).setter(DeploymentModel.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DeploymentModel.getter(DeploymentModel::statusAsString)).setter(DeploymentModel.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusReason").getter(DeploymentModel.getter(DeploymentModel::statusReason)).setter(DeploymentModel.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusReason").build()}).build();
    private static final SdkField<String> ROLLBACK_FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RollbackFailureReason").getter(DeploymentModel.getter(DeploymentModel::rollbackFailureReason)).setter(DeploymentModel.setter(Builder::rollbackFailureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RollbackFailureReason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_HANDLE_FIELD, MODEL_NAME_FIELD, MODEL_VERSION_FIELD, DESIRED_STATE_FIELD, STATE_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, ROLLBACK_FAILURE_REASON_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ModelHandle", MODEL_HANDLE_FIELD);
            this.put("ModelName", MODEL_NAME_FIELD);
            this.put("ModelVersion", MODEL_VERSION_FIELD);
            this.put("DesiredState", DESIRED_STATE_FIELD);
            this.put("State", STATE_FIELD);
            this.put("Status", STATUS_FIELD);
            this.put("StatusReason", STATUS_REASON_FIELD);
            this.put("RollbackFailureReason", ROLLBACK_FAILURE_REASON_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String modelHandle;
    private final String modelName;
    private final String modelVersion;
    private final String desiredState;
    private final String state;
    private final String status;
    private final String statusReason;
    private final String rollbackFailureReason;

    private DeploymentModel(BuilderImpl builder) {
        this.modelHandle = builder.modelHandle;
        this.modelName = builder.modelName;
        this.modelVersion = builder.modelVersion;
        this.desiredState = builder.desiredState;
        this.state = builder.state;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.rollbackFailureReason = builder.rollbackFailureReason;
    }

    public final String modelHandle() {
        return this.modelHandle;
    }

    public final String modelName() {
        return this.modelName;
    }

    public final String modelVersion() {
        return this.modelVersion;
    }

    public final ModelState desiredState() {
        return ModelState.fromValue(this.desiredState);
    }

    public final String desiredStateAsString() {
        return this.desiredState;
    }

    public final ModelState state() {
        return ModelState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final DeploymentStatus status() {
        return DeploymentStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusReason() {
        return this.statusReason;
    }

    public final String rollbackFailureReason() {
        return this.rollbackFailureReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.modelHandle());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.desiredStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.rollbackFailureReason());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeploymentModel)) {
            return false;
        }
        DeploymentModel other = (DeploymentModel)obj;
        return Objects.equals(this.modelHandle(), other.modelHandle()) && Objects.equals(this.modelName(), other.modelName()) && Objects.equals(this.modelVersion(), other.modelVersion()) && Objects.equals(this.desiredStateAsString(), other.desiredStateAsString()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusReason(), other.statusReason()) && Objects.equals(this.rollbackFailureReason(), other.rollbackFailureReason());
    }

    public final String toString() {
        return ToString.builder((String)"DeploymentModel").add("ModelHandle", (Object)this.modelHandle()).add("ModelName", (Object)this.modelName()).add("ModelVersion", (Object)this.modelVersion()).add("DesiredState", (Object)this.desiredStateAsString()).add("State", (Object)this.stateAsString()).add("Status", (Object)this.statusAsString()).add("StatusReason", (Object)this.statusReason()).add("RollbackFailureReason", (Object)this.rollbackFailureReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ModelHandle": {
                return Optional.ofNullable(clazz.cast(this.modelHandle()));
            }
            case "ModelName": {
                return Optional.ofNullable(clazz.cast(this.modelName()));
            }
            case "ModelVersion": {
                return Optional.ofNullable(clazz.cast(this.modelVersion()));
            }
            case "DesiredState": {
                return Optional.ofNullable(clazz.cast(this.desiredStateAsString()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
            case "RollbackFailureReason": {
                return Optional.ofNullable(clazz.cast(this.rollbackFailureReason()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DeploymentModel, T> g) {
        return obj -> g.apply((DeploymentModel)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String modelHandle;
        private String modelName;
        private String modelVersion;
        private String desiredState;
        private String state;
        private String status;
        private String statusReason;
        private String rollbackFailureReason;

        private BuilderImpl() {
        }

        private BuilderImpl(DeploymentModel model) {
            this.modelHandle(model.modelHandle);
            this.modelName(model.modelName);
            this.modelVersion(model.modelVersion);
            this.desiredState(model.desiredState);
            this.state(model.state);
            this.status(model.status);
            this.statusReason(model.statusReason);
            this.rollbackFailureReason(model.rollbackFailureReason);
        }

        public final String getModelHandle() {
            return this.modelHandle;
        }

        public final void setModelHandle(String modelHandle) {
            this.modelHandle = modelHandle;
        }

        @Override
        public final Builder modelHandle(String modelHandle) {
            this.modelHandle = modelHandle;
            return this;
        }

        public final String getModelName() {
            return this.modelName;
        }

        public final void setModelName(String modelName) {
            this.modelName = modelName;
        }

        @Override
        public final Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public final String getModelVersion() {
            return this.modelVersion;
        }

        public final void setModelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
        }

        @Override
        public final Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            return this;
        }

        public final String getDesiredState() {
            return this.desiredState;
        }

        public final void setDesiredState(String desiredState) {
            this.desiredState = desiredState;
        }

        @Override
        public final Builder desiredState(String desiredState) {
            this.desiredState = desiredState;
            return this;
        }

        @Override
        public final Builder desiredState(ModelState desiredState) {
            this.desiredState(desiredState == null ? null : desiredState.toString());
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ModelState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DeploymentStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final String getRollbackFailureReason() {
            return this.rollbackFailureReason;
        }

        public final void setRollbackFailureReason(String rollbackFailureReason) {
            this.rollbackFailureReason = rollbackFailureReason;
        }

        @Override
        public final Builder rollbackFailureReason(String rollbackFailureReason) {
            this.rollbackFailureReason = rollbackFailureReason;
            return this;
        }

        public DeploymentModel build() {
            return new DeploymentModel(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DeploymentModel> {
        public Builder modelHandle(String var1);

        public Builder modelName(String var1);

        public Builder modelVersion(String var1);

        public Builder desiredState(String var1);

        public Builder desiredState(ModelState var1);

        public Builder state(String var1);

        public Builder state(ModelState var1);

        public Builder status(String var1);

        public Builder status(DeploymentStatus var1);

        public Builder statusReason(String var1);

        public Builder rollbackFailureReason(String var1);
    }
}

