/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemakeredge.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the result of a deployment on an edge device that is registered with SageMaker Edge Manager.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeploymentResult implements SdkPojo, Serializable,
        ToCopyableBuilder<DeploymentResult.Builder, DeploymentResult> {
    private static final SdkField<String> DEPLOYMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeploymentName").getter(getter(DeploymentResult::deploymentName))
            .setter(setter(Builder::deploymentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentName").build()).build();

    private static final SdkField<String> DEPLOYMENT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeploymentStatus").getter(getter(DeploymentResult::deploymentStatus))
            .setter(setter(Builder::deploymentStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentStatus").build()).build();

    private static final SdkField<String> DEPLOYMENT_STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeploymentStatusMessage").getter(getter(DeploymentResult::deploymentStatusMessage))
            .setter(setter(Builder::deploymentStatusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentStatusMessage").build())
            .build();

    private static final SdkField<Instant> DEPLOYMENT_START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("DeploymentStartTime").getter(getter(DeploymentResult::deploymentStartTime))
            .setter(setter(Builder::deploymentStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentStartTime").build())
            .build();

    private static final SdkField<Instant> DEPLOYMENT_END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("DeploymentEndTime").getter(getter(DeploymentResult::deploymentEndTime))
            .setter(setter(Builder::deploymentEndTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentEndTime").build()).build();

    private static final SdkField<List<DeploymentModel>> DEPLOYMENT_MODELS_FIELD = SdkField
            .<List<DeploymentModel>> builder(MarshallingType.LIST)
            .memberName("DeploymentModels")
            .getter(getter(DeploymentResult::deploymentModels))
            .setter(setter(Builder::deploymentModels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentModels").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DeploymentModel> builder(MarshallingType.SDK_POJO)
                                            .constructor(DeploymentModel::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPLOYMENT_NAME_FIELD,
            DEPLOYMENT_STATUS_FIELD, DEPLOYMENT_STATUS_MESSAGE_FIELD, DEPLOYMENT_START_TIME_FIELD, DEPLOYMENT_END_TIME_FIELD,
            DEPLOYMENT_MODELS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String deploymentName;

    private final String deploymentStatus;

    private final String deploymentStatusMessage;

    private final Instant deploymentStartTime;

    private final Instant deploymentEndTime;

    private final List<DeploymentModel> deploymentModels;

    private DeploymentResult(BuilderImpl builder) {
        this.deploymentName = builder.deploymentName;
        this.deploymentStatus = builder.deploymentStatus;
        this.deploymentStatusMessage = builder.deploymentStatusMessage;
        this.deploymentStartTime = builder.deploymentStartTime;
        this.deploymentEndTime = builder.deploymentEndTime;
        this.deploymentModels = builder.deploymentModels;
    }

    /**
     * <p>
     * The name and unique ID of the deployment.
     * </p>
     * 
     * @return The name and unique ID of the deployment.
     */
    public final String deploymentName() {
        return deploymentName;
    }

    /**
     * <p>
     * Returns the bucket error code.
     * </p>
     * 
     * @return Returns the bucket error code.
     */
    public final String deploymentStatus() {
        return deploymentStatus;
    }

    /**
     * <p>
     * Returns the detailed error message.
     * </p>
     * 
     * @return Returns the detailed error message.
     */
    public final String deploymentStatusMessage() {
        return deploymentStatusMessage;
    }

    /**
     * <p>
     * The timestamp of when the deployment was started on the agent.
     * </p>
     * 
     * @return The timestamp of when the deployment was started on the agent.
     */
    public final Instant deploymentStartTime() {
        return deploymentStartTime;
    }

    /**
     * <p>
     * The timestamp of when the deployment was ended, and the agent got the deployment results.
     * </p>
     * 
     * @return The timestamp of when the deployment was ended, and the agent got the deployment results.
     */
    public final Instant deploymentEndTime() {
        return deploymentEndTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the DeploymentModels property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDeploymentModels() {
        return deploymentModels != null && !(deploymentModels instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Returns a list of models deployed on the agent.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDeploymentModels} method.
     * </p>
     * 
     * @return Returns a list of models deployed on the agent.
     */
    public final List<DeploymentModel> deploymentModels() {
        return deploymentModels;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deploymentName());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentStatus());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentStatusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasDeploymentModels() ? deploymentModels() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeploymentResult)) {
            return false;
        }
        DeploymentResult other = (DeploymentResult) obj;
        return Objects.equals(deploymentName(), other.deploymentName())
                && Objects.equals(deploymentStatus(), other.deploymentStatus())
                && Objects.equals(deploymentStatusMessage(), other.deploymentStatusMessage())
                && Objects.equals(deploymentStartTime(), other.deploymentStartTime())
                && Objects.equals(deploymentEndTime(), other.deploymentEndTime())
                && hasDeploymentModels() == other.hasDeploymentModels()
                && Objects.equals(deploymentModels(), other.deploymentModels());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeploymentResult").add("DeploymentName", deploymentName())
                .add("DeploymentStatus", deploymentStatus()).add("DeploymentStatusMessage", deploymentStatusMessage())
                .add("DeploymentStartTime", deploymentStartTime()).add("DeploymentEndTime", deploymentEndTime())
                .add("DeploymentModels", hasDeploymentModels() ? deploymentModels() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeploymentName":
            return Optional.ofNullable(clazz.cast(deploymentName()));
        case "DeploymentStatus":
            return Optional.ofNullable(clazz.cast(deploymentStatus()));
        case "DeploymentStatusMessage":
            return Optional.ofNullable(clazz.cast(deploymentStatusMessage()));
        case "DeploymentStartTime":
            return Optional.ofNullable(clazz.cast(deploymentStartTime()));
        case "DeploymentEndTime":
            return Optional.ofNullable(clazz.cast(deploymentEndTime()));
        case "DeploymentModels":
            return Optional.ofNullable(clazz.cast(deploymentModels()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DeploymentName", DEPLOYMENT_NAME_FIELD);
        map.put("DeploymentStatus", DEPLOYMENT_STATUS_FIELD);
        map.put("DeploymentStatusMessage", DEPLOYMENT_STATUS_MESSAGE_FIELD);
        map.put("DeploymentStartTime", DEPLOYMENT_START_TIME_FIELD);
        map.put("DeploymentEndTime", DEPLOYMENT_END_TIME_FIELD);
        map.put("DeploymentModels", DEPLOYMENT_MODELS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeploymentResult, T> g) {
        return obj -> g.apply((DeploymentResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeploymentResult> {
        /**
         * <p>
         * The name and unique ID of the deployment.
         * </p>
         * 
         * @param deploymentName
         *        The name and unique ID of the deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentName(String deploymentName);

        /**
         * <p>
         * Returns the bucket error code.
         * </p>
         * 
         * @param deploymentStatus
         *        Returns the bucket error code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentStatus(String deploymentStatus);

        /**
         * <p>
         * Returns the detailed error message.
         * </p>
         * 
         * @param deploymentStatusMessage
         *        Returns the detailed error message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentStatusMessage(String deploymentStatusMessage);

        /**
         * <p>
         * The timestamp of when the deployment was started on the agent.
         * </p>
         * 
         * @param deploymentStartTime
         *        The timestamp of when the deployment was started on the agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentStartTime(Instant deploymentStartTime);

        /**
         * <p>
         * The timestamp of when the deployment was ended, and the agent got the deployment results.
         * </p>
         * 
         * @param deploymentEndTime
         *        The timestamp of when the deployment was ended, and the agent got the deployment results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentEndTime(Instant deploymentEndTime);

        /**
         * <p>
         * Returns a list of models deployed on the agent.
         * </p>
         * 
         * @param deploymentModels
         *        Returns a list of models deployed on the agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentModels(Collection<DeploymentModel> deploymentModels);

        /**
         * <p>
         * Returns a list of models deployed on the agent.
         * </p>
         * 
         * @param deploymentModels
         *        Returns a list of models deployed on the agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentModels(DeploymentModel... deploymentModels);

        /**
         * <p>
         * Returns a list of models deployed on the agent.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemakeredge.model.DeploymentModel.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.sagemakeredge.model.DeploymentModel#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemakeredge.model.DeploymentModel.Builder#build()} is called
         * immediately and its result is passed to {@link #deploymentModels(List<DeploymentModel>)}.
         * 
         * @param deploymentModels
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemakeredge.model.DeploymentModel.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deploymentModels(java.util.Collection<DeploymentModel>)
         */
        Builder deploymentModels(Consumer<DeploymentModel.Builder>... deploymentModels);
    }

    static final class BuilderImpl implements Builder {
        private String deploymentName;

        private String deploymentStatus;

        private String deploymentStatusMessage;

        private Instant deploymentStartTime;

        private Instant deploymentEndTime;

        private List<DeploymentModel> deploymentModels = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeploymentResult model) {
            deploymentName(model.deploymentName);
            deploymentStatus(model.deploymentStatus);
            deploymentStatusMessage(model.deploymentStatusMessage);
            deploymentStartTime(model.deploymentStartTime);
            deploymentEndTime(model.deploymentEndTime);
            deploymentModels(model.deploymentModels);
        }

        public final String getDeploymentName() {
            return deploymentName;
        }

        public final void setDeploymentName(String deploymentName) {
            this.deploymentName = deploymentName;
        }

        @Override
        public final Builder deploymentName(String deploymentName) {
            this.deploymentName = deploymentName;
            return this;
        }

        public final String getDeploymentStatus() {
            return deploymentStatus;
        }

        public final void setDeploymentStatus(String deploymentStatus) {
            this.deploymentStatus = deploymentStatus;
        }

        @Override
        public final Builder deploymentStatus(String deploymentStatus) {
            this.deploymentStatus = deploymentStatus;
            return this;
        }

        public final String getDeploymentStatusMessage() {
            return deploymentStatusMessage;
        }

        public final void setDeploymentStatusMessage(String deploymentStatusMessage) {
            this.deploymentStatusMessage = deploymentStatusMessage;
        }

        @Override
        public final Builder deploymentStatusMessage(String deploymentStatusMessage) {
            this.deploymentStatusMessage = deploymentStatusMessage;
            return this;
        }

        public final Instant getDeploymentStartTime() {
            return deploymentStartTime;
        }

        public final void setDeploymentStartTime(Instant deploymentStartTime) {
            this.deploymentStartTime = deploymentStartTime;
        }

        @Override
        public final Builder deploymentStartTime(Instant deploymentStartTime) {
            this.deploymentStartTime = deploymentStartTime;
            return this;
        }

        public final Instant getDeploymentEndTime() {
            return deploymentEndTime;
        }

        public final void setDeploymentEndTime(Instant deploymentEndTime) {
            this.deploymentEndTime = deploymentEndTime;
        }

        @Override
        public final Builder deploymentEndTime(Instant deploymentEndTime) {
            this.deploymentEndTime = deploymentEndTime;
            return this;
        }

        public final List<DeploymentModel.Builder> getDeploymentModels() {
            List<DeploymentModel.Builder> result = DeploymentModelsCopier.copyToBuilder(this.deploymentModels);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDeploymentModels(Collection<DeploymentModel.BuilderImpl> deploymentModels) {
            this.deploymentModels = DeploymentModelsCopier.copyFromBuilder(deploymentModels);
        }

        @Override
        public final Builder deploymentModels(Collection<DeploymentModel> deploymentModels) {
            this.deploymentModels = DeploymentModelsCopier.copy(deploymentModels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deploymentModels(DeploymentModel... deploymentModels) {
            deploymentModels(Arrays.asList(deploymentModels));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deploymentModels(Consumer<DeploymentModel.Builder>... deploymentModels) {
            deploymentModels(Stream.of(deploymentModels).map(c -> DeploymentModel.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DeploymentResult build() {
            return new DeploymentResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
