/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemakeredge.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information required for edge device metrics.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EdgeMetric implements SdkPojo, Serializable, ToCopyableBuilder<EdgeMetric.Builder, EdgeMetric> {
    private static final SdkField<String> DIMENSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Dimension").getter(getter(EdgeMetric::dimension)).setter(setter(Builder::dimension))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dimension").build()).build();

    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MetricName").getter(getter(EdgeMetric::metricName)).setter(setter(Builder::metricName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricName").build()).build();

    private static final SdkField<Double> VALUE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("Value")
            .getter(getter(EdgeMetric::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("Timestamp").getter(getter(EdgeMetric::timestamp)).setter(setter(Builder::timestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timestamp").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIMENSION_FIELD,
            METRIC_NAME_FIELD, VALUE_FIELD, TIMESTAMP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String dimension;

    private final String metricName;

    private final Double value;

    private final Instant timestamp;

    private EdgeMetric(BuilderImpl builder) {
        this.dimension = builder.dimension;
        this.metricName = builder.metricName;
        this.value = builder.value;
        this.timestamp = builder.timestamp;
    }

    /**
     * <p>
     * The dimension of metrics published.
     * </p>
     * 
     * @return The dimension of metrics published.
     */
    public final String dimension() {
        return dimension;
    }

    /**
     * <p>
     * Returns the name of the metric.
     * </p>
     * 
     * @return Returns the name of the metric.
     */
    public final String metricName() {
        return metricName;
    }

    /**
     * <p>
     * Returns the value of the metric.
     * </p>
     * 
     * @return Returns the value of the metric.
     */
    public final Double value() {
        return value;
    }

    /**
     * <p>
     * Timestamp of when the metric was requested.
     * </p>
     * 
     * @return Timestamp of when the metric was requested.
     */
    public final Instant timestamp() {
        return timestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dimension());
        hashCode = 31 * hashCode + Objects.hashCode(metricName());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(timestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EdgeMetric)) {
            return false;
        }
        EdgeMetric other = (EdgeMetric) obj;
        return Objects.equals(dimension(), other.dimension()) && Objects.equals(metricName(), other.metricName())
                && Objects.equals(value(), other.value()) && Objects.equals(timestamp(), other.timestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EdgeMetric").add("Dimension", dimension()).add("MetricName", metricName()).add("Value", value())
                .add("Timestamp", timestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Dimension":
            return Optional.ofNullable(clazz.cast(dimension()));
        case "MetricName":
            return Optional.ofNullable(clazz.cast(metricName()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        case "Timestamp":
            return Optional.ofNullable(clazz.cast(timestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Dimension", DIMENSION_FIELD);
        map.put("MetricName", METRIC_NAME_FIELD);
        map.put("Value", VALUE_FIELD);
        map.put("Timestamp", TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EdgeMetric, T> g) {
        return obj -> g.apply((EdgeMetric) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EdgeMetric> {
        /**
         * <p>
         * The dimension of metrics published.
         * </p>
         * 
         * @param dimension
         *        The dimension of metrics published.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimension(String dimension);

        /**
         * <p>
         * Returns the name of the metric.
         * </p>
         * 
         * @param metricName
         *        Returns the name of the metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricName(String metricName);

        /**
         * <p>
         * Returns the value of the metric.
         * </p>
         * 
         * @param value
         *        Returns the value of the metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(Double value);

        /**
         * <p>
         * Timestamp of when the metric was requested.
         * </p>
         * 
         * @param timestamp
         *        Timestamp of when the metric was requested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(Instant timestamp);
    }

    static final class BuilderImpl implements Builder {
        private String dimension;

        private String metricName;

        private Double value;

        private Instant timestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(EdgeMetric model) {
            dimension(model.dimension);
            metricName(model.metricName);
            value(model.value);
            timestamp(model.timestamp);
        }

        public final String getDimension() {
            return dimension;
        }

        public final void setDimension(String dimension) {
            this.dimension = dimension;
        }

        @Override
        public final Builder dimension(String dimension) {
            this.dimension = dimension;
            return this;
        }

        public final String getMetricName() {
            return metricName;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final Double getValue() {
            return value;
        }

        public final void setValue(Double value) {
            this.value = value;
        }

        @Override
        public final Builder value(Double value) {
            this.value = value;
            return this;
        }

        public final Instant getTimestamp() {
            return timestamp;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @Override
        public EdgeMetric build() {
            return new EdgeMetric(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
