/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteRecordRequest extends SageMakerFeatureStoreRuntimeRequest implements
        ToCopyableBuilder<DeleteRecordRequest.Builder, DeleteRecordRequest> {
    private static final SdkField<String> FEATURE_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FeatureGroupName").getter(getter(DeleteRecordRequest::featureGroupName))
            .setter(setter(Builder::featureGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("FeatureGroupName").build()).build();

    private static final SdkField<String> RECORD_IDENTIFIER_VALUE_AS_STRING_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RecordIdentifierValueAsString")
            .getter(getter(DeleteRecordRequest::recordIdentifierValueAsString))
            .setter(setter(Builder::recordIdentifierValueAsString))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("RecordIdentifierValueAsString")
                    .build()).build();

    private static final SdkField<String> EVENT_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EventTime").getter(getter(DeleteRecordRequest::eventTime)).setter(setter(Builder::eventTime))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("EventTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FEATURE_GROUP_NAME_FIELD,
            RECORD_IDENTIFIER_VALUE_AS_STRING_FIELD, EVENT_TIME_FIELD));

    private final String featureGroupName;

    private final String recordIdentifierValueAsString;

    private final String eventTime;

    private DeleteRecordRequest(BuilderImpl builder) {
        super(builder);
        this.featureGroupName = builder.featureGroupName;
        this.recordIdentifierValueAsString = builder.recordIdentifierValueAsString;
        this.eventTime = builder.eventTime;
    }

    /**
     * <p>
     * The name of the feature group to delete the record from.
     * </p>
     * 
     * @return The name of the feature group to delete the record from.
     */
    public String featureGroupName() {
        return featureGroupName;
    }

    /**
     * <p>
     * The value for the <code>RecordIdentifier</code> that uniquely identifies the record, in string format.
     * </p>
     * 
     * @return The value for the <code>RecordIdentifier</code> that uniquely identifies the record, in string format.
     */
    public String recordIdentifierValueAsString() {
        return recordIdentifierValueAsString;
    }

    /**
     * <p>
     * Timestamp indicating when the deletion event occurred. <code>EventTime</code> can be used to query data at a
     * certain point in time.
     * </p>
     * 
     * @return Timestamp indicating when the deletion event occurred. <code>EventTime</code> can be used to query data
     *         at a certain point in time.
     */
    public String eventTime() {
        return eventTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(featureGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(recordIdentifierValueAsString());
        hashCode = 31 * hashCode + Objects.hashCode(eventTime());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteRecordRequest)) {
            return false;
        }
        DeleteRecordRequest other = (DeleteRecordRequest) obj;
        return Objects.equals(featureGroupName(), other.featureGroupName())
                && Objects.equals(recordIdentifierValueAsString(), other.recordIdentifierValueAsString())
                && Objects.equals(eventTime(), other.eventTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeleteRecordRequest").add("FeatureGroupName", featureGroupName())
                .add("RecordIdentifierValueAsString", recordIdentifierValueAsString()).add("EventTime", eventTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FeatureGroupName":
            return Optional.ofNullable(clazz.cast(featureGroupName()));
        case "RecordIdentifierValueAsString":
            return Optional.ofNullable(clazz.cast(recordIdentifierValueAsString()));
        case "EventTime":
            return Optional.ofNullable(clazz.cast(eventTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteRecordRequest, T> g) {
        return obj -> g.apply((DeleteRecordRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerFeatureStoreRuntimeRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteRecordRequest> {
        /**
         * <p>
         * The name of the feature group to delete the record from.
         * </p>
         * 
         * @param featureGroupName
         *        The name of the feature group to delete the record from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder featureGroupName(String featureGroupName);

        /**
         * <p>
         * The value for the <code>RecordIdentifier</code> that uniquely identifies the record, in string format.
         * </p>
         * 
         * @param recordIdentifierValueAsString
         *        The value for the <code>RecordIdentifier</code> that uniquely identifies the record, in string format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordIdentifierValueAsString(String recordIdentifierValueAsString);

        /**
         * <p>
         * Timestamp indicating when the deletion event occurred. <code>EventTime</code> can be used to query data at a
         * certain point in time.
         * </p>
         * 
         * @param eventTime
         *        Timestamp indicating when the deletion event occurred. <code>EventTime</code> can be used to query
         *        data at a certain point in time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventTime(String eventTime);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerFeatureStoreRuntimeRequest.BuilderImpl implements Builder {
        private String featureGroupName;

        private String recordIdentifierValueAsString;

        private String eventTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteRecordRequest model) {
            super(model);
            featureGroupName(model.featureGroupName);
            recordIdentifierValueAsString(model.recordIdentifierValueAsString);
            eventTime(model.eventTime);
        }

        public final String getFeatureGroupName() {
            return featureGroupName;
        }

        @Override
        public final Builder featureGroupName(String featureGroupName) {
            this.featureGroupName = featureGroupName;
            return this;
        }

        public final void setFeatureGroupName(String featureGroupName) {
            this.featureGroupName = featureGroupName;
        }

        public final String getRecordIdentifierValueAsString() {
            return recordIdentifierValueAsString;
        }

        @Override
        public final Builder recordIdentifierValueAsString(String recordIdentifierValueAsString) {
            this.recordIdentifierValueAsString = recordIdentifierValueAsString;
            return this;
        }

        public final void setRecordIdentifierValueAsString(String recordIdentifierValueAsString) {
            this.recordIdentifierValueAsString = recordIdentifierValueAsString;
        }

        public final String getEventTime() {
            return eventTime;
        }

        @Override
        public final Builder eventTime(String eventTime) {
            this.eventTime = eventTime;
            return this;
        }

        public final void setEventTime(String eventTime) {
            this.eventTime = eventTime;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteRecordRequest build() {
            return new DeleteRecordRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
