/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutRecordRequest extends SageMakerFeatureStoreRuntimeRequest implements
        ToCopyableBuilder<PutRecordRequest.Builder, PutRecordRequest> {
    private static final SdkField<String> FEATURE_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FeatureGroupName").getter(getter(PutRecordRequest::featureGroupName))
            .setter(setter(Builder::featureGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("FeatureGroupName").build()).build();

    private static final SdkField<List<FeatureValue>> RECORD_FIELD = SdkField
            .<List<FeatureValue>> builder(MarshallingType.LIST)
            .memberName("Record")
            .getter(getter(PutRecordRequest::record))
            .setter(setter(Builder::record))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Record").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FeatureValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(FeatureValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FEATURE_GROUP_NAME_FIELD,
            RECORD_FIELD));

    private final String featureGroupName;

    private final List<FeatureValue> record;

    private PutRecordRequest(BuilderImpl builder) {
        super(builder);
        this.featureGroupName = builder.featureGroupName;
        this.record = builder.record;
    }

    /**
     * <p>
     * The name of the feature group that you want to insert the record into.
     * </p>
     * 
     * @return The name of the feature group that you want to insert the record into.
     */
    public String featureGroupName() {
        return featureGroupName;
    }

    /**
     * Returns true if the Record property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasRecord() {
        return record != null && !(record instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of FeatureValues to be inserted. This will be a full over-write. If you only want to update few of the
     * feature values, do the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use <code>GetRecord</code> to retrieve the latest record.
     * </p>
     * </li>
     * <li>
     * <p>
     * Update the record returned from <code>GetRecord</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use <code>PutRecord</code> to update feature values.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRecord()} to see if a value was sent in this field.
     * </p>
     * 
     * @return List of FeatureValues to be inserted. This will be a full over-write. If you only want to update few of
     *         the feature values, do the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Use <code>GetRecord</code> to retrieve the latest record.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Update the record returned from <code>GetRecord</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Use <code>PutRecord</code> to update feature values.
     *         </p>
     *         </li>
     */
    public List<FeatureValue> record() {
        return record;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(featureGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(hasRecord() ? record() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutRecordRequest)) {
            return false;
        }
        PutRecordRequest other = (PutRecordRequest) obj;
        return Objects.equals(featureGroupName(), other.featureGroupName()) && hasRecord() == other.hasRecord()
                && Objects.equals(record(), other.record());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PutRecordRequest").add("FeatureGroupName", featureGroupName())
                .add("Record", hasRecord() ? record() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FeatureGroupName":
            return Optional.ofNullable(clazz.cast(featureGroupName()));
        case "Record":
            return Optional.ofNullable(clazz.cast(record()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutRecordRequest, T> g) {
        return obj -> g.apply((PutRecordRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerFeatureStoreRuntimeRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, PutRecordRequest> {
        /**
         * <p>
         * The name of the feature group that you want to insert the record into.
         * </p>
         * 
         * @param featureGroupName
         *        The name of the feature group that you want to insert the record into.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder featureGroupName(String featureGroupName);

        /**
         * <p>
         * List of FeatureValues to be inserted. This will be a full over-write. If you only want to update few of the
         * feature values, do the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Use <code>GetRecord</code> to retrieve the latest record.
         * </p>
         * </li>
         * <li>
         * <p>
         * Update the record returned from <code>GetRecord</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Use <code>PutRecord</code> to update feature values.
         * </p>
         * </li>
         * </ul>
         * 
         * @param record
         *        List of FeatureValues to be inserted. This will be a full over-write. If you only want to update few
         *        of the feature values, do the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Use <code>GetRecord</code> to retrieve the latest record.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Update the record returned from <code>GetRecord</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Use <code>PutRecord</code> to update feature values.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder record(Collection<FeatureValue> record);

        /**
         * <p>
         * List of FeatureValues to be inserted. This will be a full over-write. If you only want to update few of the
         * feature values, do the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Use <code>GetRecord</code> to retrieve the latest record.
         * </p>
         * </li>
         * <li>
         * <p>
         * Update the record returned from <code>GetRecord</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Use <code>PutRecord</code> to update feature values.
         * </p>
         * </li>
         * </ul>
         * 
         * @param record
         *        List of FeatureValues to be inserted. This will be a full over-write. If you only want to update few
         *        of the feature values, do the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Use <code>GetRecord</code> to retrieve the latest record.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Update the record returned from <code>GetRecord</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Use <code>PutRecord</code> to update feature values.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder record(FeatureValue... record);

        /**
         * <p>
         * List of FeatureValues to be inserted. This will be a full over-write. If you only want to update few of the
         * feature values, do the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Use <code>GetRecord</code> to retrieve the latest record.
         * </p>
         * </li>
         * <li>
         * <p>
         * Update the record returned from <code>GetRecord</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Use <code>PutRecord</code> to update feature values.
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link List<FeatureValue>.Builder} avoiding the need to
         * create one manually via {@link List<FeatureValue>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<FeatureValue>.Builder#build()} is called immediately and its
         * result is passed to {@link #record(List<FeatureValue>)}.
         * 
         * @param record
         *        a consumer that will call methods on {@link List<FeatureValue>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #record(List<FeatureValue>)
         */
        Builder record(Consumer<FeatureValue.Builder>... record);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerFeatureStoreRuntimeRequest.BuilderImpl implements Builder {
        private String featureGroupName;

        private List<FeatureValue> record = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutRecordRequest model) {
            super(model);
            featureGroupName(model.featureGroupName);
            record(model.record);
        }

        public final String getFeatureGroupName() {
            return featureGroupName;
        }

        @Override
        public final Builder featureGroupName(String featureGroupName) {
            this.featureGroupName = featureGroupName;
            return this;
        }

        public final void setFeatureGroupName(String featureGroupName) {
            this.featureGroupName = featureGroupName;
        }

        public final Collection<FeatureValue.Builder> getRecord() {
            if (record instanceof SdkAutoConstructList) {
                return null;
            }
            return record != null ? record.stream().map(FeatureValue::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder record(Collection<FeatureValue> record) {
            this.record = RecordCopier.copy(record);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder record(FeatureValue... record) {
            record(Arrays.asList(record));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder record(Consumer<FeatureValue.Builder>... record) {
            record(Stream.of(record).map(c -> FeatureValue.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRecord(Collection<FeatureValue.BuilderImpl> record) {
            this.record = RecordCopier.copyFromBuilder(record);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutRecordRequest build() {
            return new PutRecordRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
