/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemakerfeaturestoreruntime;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.DeleteRecordRequest;
import software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.DeleteRecordResponse;
import software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.GetRecordRequest;
import software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.GetRecordResponse;
import software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.PutRecordRequest;
import software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.PutRecordResponse;

/**
 * Service client for accessing Amazon SageMaker Feature Store Runtime asynchronously. This can be created using the
 * static {@link #builder()} method.
 *
 * <p>
 * Contains all data plane API operations and data types for the Amazon SageMaker Feature Store. Use this API to put,
 * delete, and retrieve (get) features from a feature store.
 * </p>
 * <p>
 * Use the following operations to configure your <code>OnlineStore</code> and <code>OfflineStore</code> features, and
 * to create and manage feature groups:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a
 * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateFeatureGroup.html">CreateFeatureGroup</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a
 * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DeleteFeatureGroup.html">DeleteFeatureGroup</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a
 * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeFeatureGroup.html">DescribeFeatureGroup
 * </a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListFeatureGroups.html">ListFeatureGroups</a>
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface SageMakerFeatureStoreRuntimeAsyncClient extends SdkClient {
    String SERVICE_NAME = "sagemaker";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "featurestore-runtime.sagemaker";

    /**
     * Create a {@link SageMakerFeatureStoreRuntimeAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static SageMakerFeatureStoreRuntimeAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link SageMakerFeatureStoreRuntimeAsyncClient}.
     */
    static SageMakerFeatureStoreRuntimeAsyncClientBuilder builder() {
        return new DefaultSageMakerFeatureStoreRuntimeAsyncClientBuilder();
    }

    /**
     * <p>
     * Deletes a <code>Record</code> from a <code>FeatureGroup</code>. A new record will show up in the
     * <code>OfflineStore</code> when the <code>DeleteRecord</code> API is called. This record will have a value of
     * <code>True</code> in the <code>is_deleted</code> column.
     * </p>
     *
     * @param deleteRecordRequest
     * @return A Java Future containing the result of the DeleteRecord operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationErrorException There was an error validating your request.</li>
     *         <li>InternalFailureException An internal failure occurred. Try your request again. If the problem
     *         persists, contact AWS customer support.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>AccessForbiddenException You do not have permission to perform an action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerFeatureStoreRuntimeException Base class for all service exceptions. Unknown exceptions will
     *         be thrown as an instance of this type.</li>
     *         </ul>
     * @sample SageMakerFeatureStoreRuntimeAsyncClient.DeleteRecord
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-featurestore-runtime-2020-07-01/DeleteRecord"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteRecordResponse> deleteRecord(DeleteRecordRequest deleteRecordRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a <code>Record</code> from a <code>FeatureGroup</code>. A new record will show up in the
     * <code>OfflineStore</code> when the <code>DeleteRecord</code> API is called. This record will have a value of
     * <code>True</code> in the <code>is_deleted</code> column.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRecordRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteRecordRequest#builder()}
     * </p>
     *
     * @param deleteRecordRequest
     *        A {@link Consumer} that will call methods on {@link DeleteRecordRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteRecord operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationErrorException There was an error validating your request.</li>
     *         <li>InternalFailureException An internal failure occurred. Try your request again. If the problem
     *         persists, contact AWS customer support.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>AccessForbiddenException You do not have permission to perform an action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerFeatureStoreRuntimeException Base class for all service exceptions. Unknown exceptions will
     *         be thrown as an instance of this type.</li>
     *         </ul>
     * @sample SageMakerFeatureStoreRuntimeAsyncClient.DeleteRecord
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-featurestore-runtime-2020-07-01/DeleteRecord"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteRecordResponse> deleteRecord(Consumer<DeleteRecordRequest.Builder> deleteRecordRequest) {
        return deleteRecord(DeleteRecordRequest.builder().applyMutation(deleteRecordRequest).build());
    }

    /**
     * <p>
     * Use for <code>OnlineStore</code> serving from a <code>FeatureStore</code>. Only the latest records stored in the
     * <code>OnlineStore</code> can be retrieved. If no Record with <code>RecordIdentifierValue</code> is found, then an
     * empty result is returned.
     * </p>
     *
     * @param getRecordRequest
     * @return A Java Future containing the result of the GetRecord operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationErrorException There was an error validating your request.</li>
     *         <li>ResourceNotFoundException A resource that is required to perform an action was not found.</li>
     *         <li>InternalFailureException An internal failure occurred. Try your request again. If the problem
     *         persists, contact AWS customer support.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>AccessForbiddenException You do not have permission to perform an action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerFeatureStoreRuntimeException Base class for all service exceptions. Unknown exceptions will
     *         be thrown as an instance of this type.</li>
     *         </ul>
     * @sample SageMakerFeatureStoreRuntimeAsyncClient.GetRecord
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-featurestore-runtime-2020-07-01/GetRecord"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetRecordResponse> getRecord(GetRecordRequest getRecordRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Use for <code>OnlineStore</code> serving from a <code>FeatureStore</code>. Only the latest records stored in the
     * <code>OnlineStore</code> can be retrieved. If no Record with <code>RecordIdentifierValue</code> is found, then an
     * empty result is returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRecordRequest.Builder} avoiding the need to
     * create one manually via {@link GetRecordRequest#builder()}
     * </p>
     *
     * @param getRecordRequest
     *        A {@link Consumer} that will call methods on {@link GetRecordRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetRecord operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationErrorException There was an error validating your request.</li>
     *         <li>ResourceNotFoundException A resource that is required to perform an action was not found.</li>
     *         <li>InternalFailureException An internal failure occurred. Try your request again. If the problem
     *         persists, contact AWS customer support.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>AccessForbiddenException You do not have permission to perform an action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerFeatureStoreRuntimeException Base class for all service exceptions. Unknown exceptions will
     *         be thrown as an instance of this type.</li>
     *         </ul>
     * @sample SageMakerFeatureStoreRuntimeAsyncClient.GetRecord
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-featurestore-runtime-2020-07-01/GetRecord"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetRecordResponse> getRecord(Consumer<GetRecordRequest.Builder> getRecordRequest) {
        return getRecord(GetRecordRequest.builder().applyMutation(getRecordRequest).build());
    }

    /**
     * <p>
     * Used for data ingestion into the <code>FeatureStore</code>. The <code>PutRecord</code> API writes to both the
     * <code>OnlineStore</code> and <code>OfflineStore</code>. If the record is the latest record for the
     * <code>recordIdentifier</code>, the record is written to both the <code>OnlineStore</code> and
     * <code>OfflineStore</code>. If the record is a historic record, it is written only to the
     * <code>OfflineStore</code>.
     * </p>
     *
     * @param putRecordRequest
     * @return A Java Future containing the result of the PutRecord operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationErrorException There was an error validating your request.</li>
     *         <li>InternalFailureException An internal failure occurred. Try your request again. If the problem
     *         persists, contact AWS customer support.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>AccessForbiddenException You do not have permission to perform an action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerFeatureStoreRuntimeException Base class for all service exceptions. Unknown exceptions will
     *         be thrown as an instance of this type.</li>
     *         </ul>
     * @sample SageMakerFeatureStoreRuntimeAsyncClient.PutRecord
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-featurestore-runtime-2020-07-01/PutRecord"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutRecordResponse> putRecord(PutRecordRequest putRecordRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Used for data ingestion into the <code>FeatureStore</code>. The <code>PutRecord</code> API writes to both the
     * <code>OnlineStore</code> and <code>OfflineStore</code>. If the record is the latest record for the
     * <code>recordIdentifier</code>, the record is written to both the <code>OnlineStore</code> and
     * <code>OfflineStore</code>. If the record is a historic record, it is written only to the
     * <code>OfflineStore</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutRecordRequest.Builder} avoiding the need to
     * create one manually via {@link PutRecordRequest#builder()}
     * </p>
     *
     * @param putRecordRequest
     *        A {@link Consumer} that will call methods on {@link PutRecordRequest.Builder} to create a request.
     * @return A Java Future containing the result of the PutRecord operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationErrorException There was an error validating your request.</li>
     *         <li>InternalFailureException An internal failure occurred. Try your request again. If the problem
     *         persists, contact AWS customer support.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>AccessForbiddenException You do not have permission to perform an action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerFeatureStoreRuntimeException Base class for all service exceptions. Unknown exceptions will
     *         be thrown as an instance of this type.</li>
     *         </ul>
     * @sample SageMakerFeatureStoreRuntimeAsyncClient.PutRecord
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-featurestore-runtime-2020-07-01/PutRecord"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutRecordResponse> putRecord(Consumer<PutRecordRequest.Builder> putRecordRequest) {
        return putRecord(PutRecordRequest.builder().applyMutation(putRecordRequest).build());
    }
}
